/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;

public class BizDataMessageHelper {
    private static final String VERTICAL_URL = "/index.html?formId=hpdi_bizdatalist";
    private static final String HORIZONTAL_URL = "/index.html?formId=hpdi_bizdataherizonlist";
    private static final Log LOGGER = LogFactory.getLog(BizDataMessageHelper.class);

    public static void sendMessageOfRejectOrDiscard(String bizDataStatus, String type, Map<Long, Set<String>> infoMap, Long bizItemGroupId) {
        String actionName;
        if (infoMap == null || infoMap.isEmpty()) {
            return;
        }
        if (BizDataStatusEnum.SALARY_REJECT.getCode().equals(bizDataStatus)) {
            actionName = HPDIResMgrBusiness.getMsgOfReject();
        } else if (BizDataStatusEnum.HSAS_DISABLED.getCode().equals(bizDataStatus)) {
            actionName = HPDIResMgrBusiness.getMsgOfDiscard();
        } else {
            return;
        }
        String clientUrl = UrlService.getDomainContextUrl();
        String url = "horizontal".equals(type) ? clientUrl + HORIZONTAL_URL + "&bizitemgroup=" + bizItemGroupId : clientUrl + VERTICAL_URL + "&tab=" + type;
        url = url + "&bizdatastatus=" + bizDataStatus;
        ArrayList<MessageInfo> messages = new ArrayList<MessageInfo>(infoMap.size());
        for (Map.Entry<Long, Set<String>> entry : infoMap.entrySet()) {
            messages.add(BizDataMessageHelper.assembleMessageInfo(url, actionName, entry.getKey(), entry.getValue()));
        }
        Map map = MessageCenterServiceHelper.batchSendMessages(messages);
    }

    private static MessageInfo assembleMessageInfo(String url, String actionName, Long receiverId, Set<String> bizItemGroupNames) {
        MessageInfo messageInfo = new MessageInfo();
        String msgTitle = HPDIResMgrBusiness.getTitleOfWithdrawOrReject();
        String msgContent = HPDIResMgrBusiness.getMsgOfWithdrawOrReject();
        msgTitle = MessageFormat.format(msgTitle, actionName);
        msgContent = MessageFormat.format(msgContent, bizItemGroupNames.stream().collect(Collectors.joining("\uff1b")), actionName);
        LocaleString title = new LocaleString();
        title.setLocaleValue(msgTitle);
        LocaleString content = new LocaleString();
        content.setLocaleValue(msgContent);
        ArrayList<Long> receivers = new ArrayList<Long>(1);
        receivers.add(receiverId);
        LocaleString tag = new LocaleString();
        tag.setLocaleValue(HPDIResMgrBusiness.getMsgOfHsasBizData());
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)content);
        messageInfo.setUserIds(receivers);
        messageInfo.setType("message");
        messageInfo.setMessageTag((ILocaleString)tag);
        messageInfo.setEntityNumber("hpdi_bizdata");
        HashMap param = new HashMap(16);
        messageInfo.setParams(param);
        messageInfo.setSenderName(HPDIResMgrBusiness.getMsgOfSystemSending());
        messageInfo.setBizDataId(Long.valueOf(-1L));
        messageInfo.setNestAppid("hpdi");
        messageInfo.setContentUrl(url);
        return messageInfo;
    }
}

