/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;

public class BizDataRelationHelper {
    private static Log logger = LogFactory.getLog(BizDataRelationHelper.class);
    private static final String[] EXCLUDE_BIZ_DATA_STATUS_ARR = new String[]{"5", "6", "8"};

    public static void getEmpRelsAndItems(List<DynamicObject> bizDataBillEntries, Set<Long> empRelIds, Set<Long> itemIds) {
        for (DynamicObject bizData : bizDataBillEntries) {
            empRelIds.add(bizData.getLong("empposorgrel.id"));
            DynamicObjectCollection bizDataDetails = bizData.getDynamicObjectCollection("entryentity");
            for (DynamicObject bizDataDetail : bizDataDetails) {
                itemIds.add(bizDataDetail.getLong("bizitem.id"));
            }
        }
    }

    public static Map<String, List<DynamicObject>> getSubmitBizData(Set<Long> empRelIds, Set<Long> itemIds, Set<Long> calperiodIds, Set<String> bizDataCodes, boolean onlyQueryCycle) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("empposorgrel", "in", empRelIds));
        list.add(new QFilter("bizitem", "in", itemIds));
        list.add(new QFilter("bizdatastatus", "not in", (Object)EXCLUDE_BIZ_DATA_STATUS_ARR));
        list.add(new QFilter("billtype", "=", (Object)"1"));
        QFilter calperiodFilterCycle = new QFilter("bizitem.cycle", "=", (Object)Boolean.TRUE);
        if (onlyQueryCycle) {
            list.add(calperiodFilterCycle);
        } else {
            QFilter calperiodFilterNoCycle = new QFilter("bizitem.cycle", "=", (Object)Boolean.FALSE);
            calperiodFilterNoCycle.and("calperiod", "in", (Object)(calperiodIds != null ? calperiodIds : new HashSet(1)));
            QFilter calperiodFilter = calperiodFilterCycle.or(calperiodFilterNoCycle);
            list.add(calperiodFilter);
        }
        DynamicObject[] bizDatas = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("empposorgrel,bizdatacode,bizitem,effectivedate,expirydate,bizdatastatus,calperiod", list.toArray(new QFilter[list.size()]), "effectivedate desc");
        List filterList = Arrays.stream(bizDatas).filter(dy -> !bizDataCodes.contains(dy.getString("bizdatacode"))).collect(Collectors.toList());
        HashMap<String, List<DynamicObject>> submitBizDataMap = new HashMap<String, List<DynamicObject>>(16);
        if (bizDatas != null) {
            for (DynamicObject bizData : filterList) {
                String empPosId = bizData.getString("empposorgrel.id");
                String bizitemId = bizData.getString("bizitem.id");
                String empItemKey = empPosId + bizitemId;
                BizDataRelationHelper.putValueToListValueMap(submitBizDataMap, bizData, empItemKey);
            }
        }
        return submitBizDataMap;
    }

    public static Map<String, List<DynamicObject>> getSubmitBizDataByDim(Set<Long> personIds, Set<Long> payrollGrpIds, Set<Long> bizItemIds, Set<String> bizDataCodes) {
        QFilter filter = new QFilter("empposorgrel.person.id", "in", personIds);
        filter.and("bizdatadim.payrollgroup.id", "in", payrollGrpIds);
        filter.and("bizitem", "in", bizItemIds);
        filter.and("billtype", "=", (Object)"1");
        filter.and("bizdatastatus", "not in", (Object)EXCLUDE_BIZ_DATA_STATUS_ARR);
        DynamicObject[] bizDataArr = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("empposorgrel,bizdatacode,bizitem,effectivedate,expirydate,bizdatastatus,calperiod,bizdatadim", new QFilter[]{filter}, "effectivedate desc");
        List filterList = Arrays.stream(bizDataArr).filter(dy -> !bizDataCodes.contains(dy.getString("bizdatacode"))).collect(Collectors.toList());
        HashMap<String, List<DynamicObject>> submitBizDataMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject bizData : filterList) {
            String personId = bizData.getString("empposorgrel.person.id");
            String payrollGrpId = bizData.getString("bizdatadim.payrollgroup.id");
            String bizItemId = bizData.getString("bizitem.id");
            String key = personId + payrollGrpId + bizItemId;
            BizDataRelationHelper.putValueToListValueMap(submitBizDataMap, bizData, key);
        }
        return submitBizDataMap;
    }

    private static void putValueToListValueMap(Map<String, List<DynamicObject>> map, DynamicObject value, String mKey) {
        List<DynamicObject> valueList = map.get(mKey);
        if (valueList == null) {
            valueList = new ArrayList<DynamicObject>(10);
            map.put(mKey, valueList);
        }
        valueList.add(value);
    }

    public static DynamicObject setRelationShip(Map<String, Object> queryMap, DynamicObject lastBizData, DynamicObject excelObj) {
        if (lastBizData != null && excelObj != null) {
            DynamicObject detail = (DynamicObject)excelObj.getDynamicObjectCollection("entryentity").get(0);
            Date excelEffectDate = detail.getDate("effectivedate");
            Date excelExpiryDate = detail.getDate("expirydate");
            Date transSalaryDate = lastBizData.getDate("effectivedate");
            Date transSalaryExpiryDate = lastBizData.getDate("expirydate");
            if (excelEffectDate != null && transSalaryDate != null) {
                if (excelEffectDate.after(transSalaryDate)) {
                    if (transSalaryExpiryDate == null && excelExpiryDate == null) {
                        excelObj.set("relationdata", (Object)"A");
                        logger.info("setRelationShip...bizdatacode={}", (Object)excelObj.getString("bizdatacode"));
                        return BizDataRelationHelper.saveRelationObj(queryMap, excelObj, lastBizData, "B");
                    }
                    if (transSalaryExpiryDate != null && excelExpiryDate == null && !excelEffectDate.after(transSalaryExpiryDate)) {
                        excelObj.set("relationdata", (Object)"A");
                        return BizDataRelationHelper.saveRelationObj(queryMap, excelObj, lastBizData, "B");
                    }
                    if (transSalaryExpiryDate != null && excelExpiryDate != null && !excelEffectDate.after(transSalaryExpiryDate) && !excelExpiryDate.before(transSalaryExpiryDate)) {
                        excelObj.set("relationdata", (Object)"A");
                        return BizDataRelationHelper.saveRelationObj(queryMap, excelObj, lastBizData, "B");
                    }
                } else if (excelEffectDate.before(transSalaryDate) || excelEffectDate.compareTo(transSalaryDate) == 0) {
                    excelObj.set("relationdata", (Object)"C");
                    return BizDataRelationHelper.saveRelationObj(queryMap, excelObj, lastBizData, "A");
                }
            }
        }
        return null;
    }

    public static DynamicObject saveRelationObj(Map<String, Object> queryMap, DynamicObject excelObj, DynamicObject lastBizData, String isConflict) {
        DynamicObject relationObj = HPDIDataServiceHelper.HPDI_BIZDATARELATION_HELPER.generateEmptyDynamicObject();
        relationObj.set("dataobtaintime", (Object)new Date());
        relationObj.set("isconfilct", (Object)isConflict);
        relationObj.set("billno", queryMap == null ? "" : queryMap.get("billno"));
        relationObj.set("bizdatacode", (Object)excelObj.getString("bizdatacode"));
        relationObj.set("relationbizdatacode", (Object)lastBizData.getString("bizdatacode"));
        logger.info("setRelationShip...saveRelationObj...bizdatacode={}", (Object)excelObj.getString("bizdatacode"));
        return relationObj;
    }
}

