/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.bizdata.filter.BizDataCODFilter;
import kd.swc.hpdi.business.bizdata.filter.BizDataFilterChain;
import kd.swc.hpdi.business.bizdata.filter.BizDataOperateFilter;
import kd.swc.hpdi.business.bizdata.filter.BizDataUpdateCODFilter;
import kd.swc.hpdi.business.bizdata.filter.PeriodDateFilter;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataUpdateHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hpdi.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class BizDataRollBackHelper {
    private static final Log LOGGER = LogFactory.getLog(BizDataRollBackHelper.class);
    private static final String CURRENT_BIZDATACODE = "currentbizdatacode";
    private static Set<String> rollbackOpTypes = new HashSet<String>(16);

    public static DynamicObject[] getOperateRecordData(DynamicObject[] bizData) {
        Object[] bizDataIds = Arrays.stream(bizData).map(dy -> dy.getLong("id")).toArray();
        DynamicObject[] currentDys = HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.query(CURRENT_BIZDATACODE, new QFilter[]{new QFilter("bizdata.id", "in", (Object)bizDataIds)});
        Object[] finalBizDataCodes = Arrays.stream(currentDys).map(dy -> dy.getString(CURRENT_BIZDATACODE)).toArray();
        QFilter[] finalFilters = new QFilter[]{new QFilter(CURRENT_BIZDATACODE, "in", (Object)finalBizDataCodes)};
        return HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.query("bizdata.id,bizdata.billtype,bizdata.bizdatastatus,currentbizdatacode,operatetime,operatetype,afterupdatedate,beforupdatedate,operatebizdatacode", finalFilters);
    }

    public static Map<String, List<DynamicObject>> getGroupRollBackMap(List<DynamicObject> rollBackDataList) {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject rollBackData : rollBackDataList) {
            StringBuilder keyStringBuilder = new StringBuilder();
            Long greId = rollBackData.getLong("empposorgrel.id");
            Long itemId = rollBackData.getLong("bizitem.id");
            keyStringBuilder.append(greId).append('_').append(itemId);
            String key = keyStringBuilder.toString();
            if (SWCListUtils.isEmpty((List)((List)result.get(key)))) {
                ArrayList<DynamicObject> tmpList = new ArrayList<DynamicObject>(10);
                tmpList.add(rollBackData);
                result.put(key, tmpList);
                continue;
            }
            List tempList = (List)result.get(key);
            tempList.add(rollBackData);
        }
        return result;
    }

    public static boolean isContainLasteAddTypeData(DynamicObject[] bizDataList) {
        boolean result = true;
        Map<String, List<DynamicObject>> groupRollBackMap = BizDataRollBackHelper.getGroupRollBackMap(Arrays.asList(bizDataList));
        for (DynamicObject tmpData : bizDataList) {
            List<DynamicObject> groupList;
            Date effectiveDate;
            if (!"1".equals(tmpData.getString("billtype"))) continue;
            Long greId = tmpData.getLong("empposorgrel.id");
            Long itemId = tmpData.getLong("bizitem.id");
            DynamicObject[] lastObjs = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("bizdatacode", new QFilter[]{new QFilter("bizitem", "=", (Object)itemId), new QFilter("empposorgrel", "=", (Object)greId), new QFilter("bizdatastatus", "=", (Object)"3"), new QFilter("effectivedate", ">=", (Object)(effectiveDate = tmpData.getDate("effectivedate"))), new QFilter("billtype", "=", (Object)"1")}, "effectivedate desc");
            if (lastObjs == null || lastObjs.length <= 0 || (groupList = groupRollBackMap.get(greId + "_" + itemId)) == null) continue;
            ArrayList groupIdList = new ArrayList(10);
            groupList.stream().forEach(gl -> groupIdList.add(gl.getLong("id")));
            for (DynamicObject lastObj : lastObjs) {
                if (groupIdList.contains(lastObj.getLong("id"))) continue;
                result = false;
                return result;
            }
        }
        return result;
    }

    public static Map<String, List<Long>> getExecuteRecordMap(DynamicObject[] bizDataList, List<Object> bizDataIdList, DynamicObject[] recordDys) {
        if (!BizDataRollBackHelper.isContainLasteAddTypeData(bizDataList)) {
            return new HashMap<String, List<Long>>(0);
        }
        Map<String, List<DynamicObject>> groupBizData = Arrays.stream(bizDataList).collect(Collectors.groupingBy(dy -> dy.getString("bizdatacode")));
        Map<String, List<DynamicObject>> groupRecords = Arrays.stream(recordDys).collect(Collectors.groupingBy(dy -> dy.getString(CURRENT_BIZDATACODE)));
        Map<String, String> codeMapping = Arrays.stream(recordDys).collect(Collectors.toMap(dy -> dy.getString("operatebizdatacode"), dy -> dy.getString(CURRENT_BIZDATACODE), (k1, k2) -> k1));
        QFilter bizDataCodeFilter = new QFilter("bizdatacode", "in", groupRecords.keySet());
        QFilter typeFilter = new QFilter("billtype", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{bizDataCodeFilter, typeFilter};
        DynamicObject[] sourceDys = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("bizdatacode", filters);
        Map<String, Long> sourceIdMap = Arrays.stream(sourceDys).collect(Collectors.toMap(dy -> dy.getString("bizdatacode"), dy -> dy.getLong("id"), (key1, key2) -> key1));
        HashMap executeRecords = Maps.newHashMapWithExpectedSize((int)groupRecords.size());
        for (Map.Entry<String, List<DynamicObject>> entry : groupRecords.entrySet()) {
            String code2 = entry.getKey();
            List<DynamicObject> dys = entry.getValue();
            List rollBackRecords = dys.stream().filter(dy -> "2".equals(dy.getString("operatetype"))).map(dy -> dy.getLong("bizdata.id")).collect(Collectors.toList());
            List operateRecords = dys.stream().filter(dy -> !"2".equals(dy.getString("operatetype"))).filter(dy -> !"7".equals(dy.getString("bizdata.bizdatastatus"))).filter(dy -> !"1".equals(dy.getString("bizdata.bizdatastatus"))).filter(dy -> !"5".equals(dy.getString("bizdata.bizdatastatus"))).filter(dy -> !"6".equals(dy.getString("bizdata.bizdatastatus"))).filter(dy -> !"8".equals(dy.getString("bizdata.bizdatastatus"))).sorted(Comparator.comparing(dy -> dy.getDate("operatetime"), Comparator.reverseOrder())).map(dy -> dy.getLong("bizdata.id")).collect(Collectors.toList());
            operateRecords.add(sourceIdMap.get(code2));
            LOGGER.info(MessageFormat.format("All operateRecords size is {0} ", operateRecords.size()));
            operateRecords.removeAll(rollBackRecords);
            LOGGER.info(MessageFormat.format("BizDataRollBackHelper rollback_bizdatacode is {0},rollback operateRecords is {1}", code2, operateRecords.toString()));
            if (operateRecords.isEmpty()) {
                return new HashMap<String, List<Long>>(0);
            }
            if (!bizDataIdList.contains(operateRecords.get(0))) {
                if (bizDataIdList.contains(BizDataRollBackHelper.getUpdateTypeData((Long)operateRecords.get(0)))) continue;
                return new HashMap<String, List<Long>>(0);
            }
            executeRecords.put(code2, operateRecords);
        }
        groupBizData.forEach((code, list) -> {
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((Collection)executeRecords.get(codeMapping.get(code)))) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((Collection)executeRecords.get(code)))) {
                executeRecords.put(code, list.stream().map(single -> single.getLong("id")).collect(Collectors.toList()));
            }
        });
        LOGGER.info(MessageFormat.format("BizDataRollBackHelper getExecuteRecordMap executeRecords is:{0}", JSON.toJSONString((Object)executeRecords)));
        return executeRecords;
    }

    private static Long getUpdateTypeData(Long bizDataId) {
        DynamicObject updateTypeObj;
        Long result = 0L;
        DynamicObject bizObj = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.queryOne("bizdatacode", (Object)bizDataId);
        if (bizObj != null && (updateTypeObj = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.queryOne("id", new QFilter[]{new QFilter("bizdatacode", "=", (Object)bizObj.getString("bizdatacode")), new QFilter("billtype", "=", (Object)"2"), new QFilter("bizdatastatus", "=", (Object)"3")}, "effectivedate desc")) != null) {
            result = updateTypeObj.getLong("id");
        }
        return result;
    }

    public static Map<String, String> doRollBackForCircle(Map<String, Object> param, DynamicObject[] bizDataArr) {
        HashMap<String, String> errorMap = new HashMap<String, String>(16);
        if (SWCArrayUtils.isEmpty((Object[])bizDataArr)) {
            return errorMap;
        }
        ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(10);
        ArrayList<DynamicObject> rollBackDataList = new ArrayList<DynamicObject>(Arrays.asList(bizDataArr));
        BizDataRollBackHelper.sortByEffectiveDateAndCalSalaryDate(rollBackDataList);
        Map<String, List<DynamicObject>> typeMap = rollBackDataList.stream().collect(Collectors.groupingBy(dy -> dy.getString("billtype")));
        BizDataRollBackHelper.executeRollBackForUpdateType(param, typeMap.get("2"), errorMap, appLogInfos);
        BizDataRollBackHelper.executeRollBackForAddType(param, typeMap.get("1"), errorMap, appLogInfos);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(appLogInfos)) {
            LogServiceHelper.addBatchLog(appLogInfos);
        }
        return errorMap;
    }

    public static Map<String, String> doRollBackForNoCircle(Map<String, Object> param, DynamicObject[] bizDataArray, boolean isHorizontal) {
        List resultDelList;
        Map<String, Object> delResponse;
        HashMap<String, String> errorMap = new HashMap<String, String>(16);
        ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(10);
        HashMap<String, Object> queryMap = new HashMap<String, Object>(16);
        queryMap.put("billtype", "1");
        PeriodDateFilter periodDateFilter = new PeriodDateFilter();
        ArrayList<DynamicObject> bizDataList = new ArrayList<DynamicObject>(bizDataArray.length);
        Collections.addAll(bizDataList, bizDataArray);
        queryMap.putAll(periodDateFilter.getQueryMap(bizDataList));
        ArrayList<DynamicObject> copyBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
        copyBizDataList.addAll(bizDataList);
        HashMap<String, Map<String, Object>> responses = new HashMap<String, Map<String, Object>>(16);
        BizDataFilterChain filterChain = new BizDataFilterChain();
        filterChain.addFilter(new BizDataCODFilter());
        filterChain.addFilter(periodDateFilter);
        filterChain.addFilter(new BizDataOperateFilter());
        filterChain.doFilter(queryMap, copyBizDataList, filterChain, responses);
        ArrayList<DynamicObject> toBeDeleteBizDataList = new ArrayList<DynamicObject>(10);
        HashSet<String> recordedCodes = new HashSet<String>(16);
        if (!responses.isEmpty()) {
            for (DynamicObject bizData : bizDataList) {
                String originBizDataCode = bizData.getString("bizdatacode");
                Map responseMap = (Map)responses.get(originBizDataCode);
                if (MapUtils.isNotEmpty((Map)responseMap) && !SWCObjectUtils.isEmpty(responseMap.get("key_result_error_msg"))) {
                    if (!recordedCodes.contains(originBizDataCode)) {
                        errorMap.put(bizData.getString("bizdatacode"), (String)responseMap.get("key_result_error_msg"));
                        appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, originBizDataCode, Boolean.FALSE));
                    }
                    recordedCodes.add(originBizDataCode);
                    continue;
                }
                toBeDeleteBizDataList.add(bizData);
            }
        } else {
            toBeDeleteBizDataList.addAll(bizDataList);
        }
        if (!SWCListUtils.isEmpty(toBeDeleteBizDataList) && MapUtils.isNotEmpty(delResponse = BizDataRollBackHelper.invokeDeleteBizDataApi(toBeDeleteBizDataList)) && delResponse.get("success") != null && ((Boolean)delResponse.get("success")).booleanValue() && !CollectionUtils.isEmpty((Collection)(resultDelList = (List)delResponse.get("result")))) {
            Map<String, Map> bizDataCodeResultMap = resultDelList.stream().collect(Collectors.toMap(map -> (String)map.get("bizdatacode"), map -> map, (k1, k2) -> k1));
            HashSet<Long> bizDataRecordIds = new HashSet<Long>(16);
            ArrayList<DynamicObject> waitSaveBizDatas = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> waitSaveOperateLogs = new ArrayList<DynamicObject>(bizDataList.size());
            HashBasedTable statusTable = HashBasedTable.create();
            for (DynamicObject bizData : toBeDeleteBizDataList) {
                String bizDataCode = bizData.getString("bizdatacode");
                String status = (String)bizDataCodeResultMap.get(bizDataCode).get("status");
                if (SWCStringUtils.equals((String)status, (String)"1")) {
                    bizData.set("bizdatastatus", (Object)BizDataStatusEnum.WITHDRAWN.getCode());
                    waitSaveBizDatas.add(bizData);
                    Long bizDataRecordId = bizData.getLong("bizdatarecord.id");
                    if (!isHorizontal || isHorizontal && !bizDataRecordIds.contains(bizDataRecordId)) {
                        waitSaveOperateLogs.add(BizDataRollBackHelper.assembleOperateLogForStatus(bizData, isHorizontal, BizDataStatusEnum.PUSHED_SALARY.getDesc(), BizDataStatusEnum.WITHDRAWN.getDesc(), BizDataOperateEnum.OPERATE_ROLLBACK_ADD.getCode()));
                    }
                    if (!SWCObjectUtils.isEmpty((Object)bizDataRecordId) && 0L != bizDataRecordId) {
                        bizDataRecordIds.add(bizDataRecordId);
                    }
                    if (!"1".equals(bizData.getString("submission"))) continue;
                    statusTable.put((Object)bizData.getString("bizdatacode"), (Object)bizData.getString("applyno"), (Object)bizData.getString("bizdatastatus"));
                    continue;
                }
                if (!recordedCodes.contains(bizDataCode)) {
                    appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizDataCode, Boolean.FALSE));
                    String errorMsg = BizDataFailStatusEnum.getDesc((String)((String)bizDataCodeResultMap.get(bizDataCode).get("errorcode")));
                    errorMap.put(bizData.getString("bizdatacode"), errorMsg);
                }
                recordedCodes.add(bizDataCode);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(waitSaveBizDatas)) {
                HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.update(waitSaveBizDatas.toArray(new DynamicObject[0]));
                HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.save(waitSaveOperateLogs.toArray(new DynamicObject[0]));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(bizDataRecordIds)) {
                DynamicObject[] bizDataRecordArray;
                SWCDataServiceHelper bizDataRecordHelper = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER;
                QFilter qFilter = new QFilter("id", "in", bizDataRecordIds);
                for (DynamicObject bizDataRecord : bizDataRecordArray = bizDataRecordHelper.query("id, bizdatastatus", qFilter.toArray())) {
                    bizDataRecord.set("bizdatastatus", (Object)"7");
                }
                bizDataRecordHelper.update(bizDataRecordArray);
            }
            BizDataBillEntryHelper.updateTransSalaryStatus((Table<String, String, String>)statusTable);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(appLogInfos)) {
            LogServiceHelper.addBatchLog(appLogInfos);
        }
        return errorMap;
    }

    public static AppLogInfo assembleRollBackLog(Map<String, Object> param, String code, Boolean isSuccess) {
        AppInfo appInfo;
        String rollBack = HPDIResMgrBusiness.getMsgOfRollback();
        AppLogInfo appLogInfo = new AppLogInfo();
        String appNumber = (String)param.get("appNumber");
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        appLogInfo.setBizAppID(appId);
        appLogInfo.setBizObjID((String)param.get("billFormId"));
        appLogInfo.setOpName(rollBack);
        if (isSuccess.booleanValue()) {
            String successMsg = HPDIResMgrBusiness.getMsgOfRollbackSuccessAssign(code);
            appLogInfo.setOpDescription(successMsg);
        } else {
            String errorMsg = HPDIResMgrBusiness.getMsgOfRollbackFailureAssign(code);
            appLogInfo.setOpDescription(errorMsg);
        }
        return appLogInfo;
    }

    public static Map<String, Object> invokeDeleteBizDataApi(List<DynamicObject> bizDataList) {
        HashMap<String, Object> deleteParam = new HashMap<String, Object>(16);
        deleteParam.put("opsystem", "hpdi");
        deleteParam.put("operate", "LD");
        ArrayList subList = new ArrayList(bizDataList.size());
        for (DynamicObject bizData : bizDataList) {
            HashMap<String, Object> subMap = new HashMap<String, Object>(4);
            subMap.put("bizdatacode", bizData.getString("bizdatacode"));
            subMap.put("bizitemid", bizData.getLong("bizitem.id"));
            subList.add(subMap);
        }
        deleteParam.put("data", subList);
        Map<String, Object> delResp = HPDIServiceUtils.deleteBizData(deleteParam);
        return delResp;
    }

    public static Map<String, Object> invokeDeleteBizDataApiForCircle(List<DynamicObject> bizDataList) {
        HashMap<String, Object> deleteParam = new HashMap<String, Object>(16);
        deleteParam.put("opsystem", "hpdi");
        deleteParam.put("operate", "LD");
        ArrayList subList = new ArrayList(bizDataList.size());
        for (DynamicObject bizData : bizDataList) {
            HashMap<String, Object> subMap = new HashMap<String, Object>(4);
            subMap.put("bizdatacode", bizData.getString("bizdatacode"));
            subMap.put("bizitemid", bizData.getLong("bizitem.id"));
            subList.add(subMap);
        }
        deleteParam.put("data", subList);
        Map<String, Object> delResp = HPDIServiceUtils.deleteBizDataForCircle(deleteParam);
        return delResp;
    }

    private static void executeRollBackForUpdateType(Map<String, Object> param, List<DynamicObject> bizDataList, Map<String, String> errorMap, List<AppLogInfo> appLogInfos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(bizDataList)) {
            return;
        }
        BizDataRollBackHelper.validateLatestRecord(param, bizDataList, errorMap, appLogInfos);
        BizDataRollBackHelper.doFilterChangeForUpdateType(param, bizDataList, errorMap, appLogInfos);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(bizDataList)) {
            return;
        }
        try {
            Map<String, Object> resp = BizDataRollBackHelper.batchUpdateBlsed(param, bizDataList);
            BizDataRollBackHelper.dealUpdateBlsedResult(param, bizDataList, errorMap, appLogInfos, resp);
        }
        catch (Exception exp) {
            LOGGER.error("...BizDataRollBackHelper.executeRollBackForUpdateType error: ", (Throwable)exp);
            for (DynamicObject bizData : bizDataList) {
                appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizData.getString("bizdatacode"), Boolean.FALSE));
                String key = bizData.getString("bizdatacode") + "_" + bizData.getString("id");
                errorMap.put(key, exp.getMessage());
            }
        }
    }

    private static void executeRollBackForAddType(Map<String, Object> param, List<DynamicObject> bizDataList, Map<String, String> errorMap, List<AppLogInfo> appLogInfos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(bizDataList)) {
            return;
        }
        BizDataRollBackHelper.doFilterChangeForAddType(param, bizDataList, errorMap, appLogInfos);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(bizDataList)) {
            return;
        }
        try {
            Map<String, Object> delResp = BizDataRollBackHelper.invokeDeleteBizDataApiForCircle(bizDataList);
            BizDataRollBackHelper.dealDeleteBizDataResult(param, bizDataList, errorMap, appLogInfos, delResp);
        }
        catch (Exception exp) {
            LOGGER.error("...BizDataRollBackHelper.executeRollBackForAddType error: ", (Throwable)exp);
            for (DynamicObject bizData : bizDataList) {
                appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizData.getString("bizdatacode"), Boolean.FALSE));
                errorMap.put(bizData.getString("bizdatacode"), exp.getMessage());
            }
        }
    }

    private static void dealUpdateBlsedResult(Map<String, Object> param, List<DynamicObject> bizDataList, Map<String, String> errorMap, List<AppLogInfo> appLogInfos, Map<String, Object> resp) {
        Boolean success = (Boolean)resp.get("success");
        String errorMsg = (String)resp.get("message");
        if (success.booleanValue()) {
            List paramList = (List)resp.get("result");
            Map bizDataCodeMap = paramList.stream().collect(Collectors.toMap(map -> (String)map.get("bizdatacode"), Function.identity(), (k1, k2) -> k1));
            List bizDataCodes = bizDataList.stream().map(dy -> dy.getString("bizdatacode")).collect(Collectors.toList());
            QFilter bizDataCodeFilter = new QFilter("bizdatacode", "in", bizDataCodes);
            QFilter typeFilter = new QFilter("billtype", "=", (Object)"1");
            DynamicObject[] originBizDataList = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("expirydate, bizdatacode", new QFilter[]{bizDataCodeFilter, typeFilter});
            Map originMap = Arrays.stream(originBizDataList).collect(Collectors.toMap(dy -> dy.getString("bizdatacode"), Function.identity(), (k1, k2) -> k1));
            Map hisMap = (Map)param.get("operateHisMap");
            ArrayList<DynamicObject> waitUpdateBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
            ArrayList<DynamicObject> waitUpdateOriginBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
            ArrayList<DynamicObject> waitSaveOperateHiss = new ArrayList<DynamicObject>(bizDataList.size());
            ArrayList<DynamicObject> waitSaveOperateLogs = new ArrayList<DynamicObject>(bizDataList.size());
            HashBasedTable statusTable = HashBasedTable.create();
            for (DynamicObject bizData2 : bizDataList) {
                String bizDataCode = bizData2.getString("bizdatacode");
                Map bizDataMap = (Map)bizDataCodeMap.get(bizDataCode);
                if (null == bizDataMap || bizDataMap.isEmpty()) {
                    LOGGER.info(MessageFormat.format("{0}\uff1areturn param is null!", bizDataCode));
                    continue;
                }
                String status = (String)bizDataMap.get("status");
                if ("1".equals(status)) {
                    bizData2.set("bizdatastatus", (Object)BizDataStatusEnum.WITHDRAWN.getCode());
                    DynamicObject operateHis = (DynamicObject)((List)hisMap.get(bizDataCode)).get(0);
                    DynamicObject originBizData = (DynamicObject)originMap.get(bizDataCode);
                    originBizData.set("expirydate", (Object)operateHis.getDate("beforupdatedate"));
                    waitUpdateBizDataList.add(bizData2);
                    waitUpdateOriginBizDataList.add(originBizData);
                    waitSaveOperateHiss.add(BizDataRollBackHelper.assembleOperateHis(operateHis, bizData2, BizDataOperateEnum.OPERATE_ROLLBACK_UPDATE.getCode()));
                    waitSaveOperateLogs.add(BizDataRollBackHelper.assembleOperateLog(operateHis, bizData2, BizDataUpdateFieldEnum.FIELD_BIZDATASTATUS.getCode()));
                    waitSaveOperateLogs.add(BizDataRollBackHelper.assembleOperateLog(operateHis, bizData2, BizDataUpdateFieldEnum.FIELD_EXPIRYDATE.getCode()));
                    appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizDataCode, Boolean.TRUE));
                    if (!"1".equals(bizData2.getString("submission"))) continue;
                    statusTable.put((Object)bizData2.getString("bizdatacode"), (Object)bizData2.getString("applyno"), (Object)bizData2.getString("bizdatastatus"));
                    continue;
                }
                String errorCode = String.valueOf(bizDataMap.get("errorcode"));
                appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizDataCode, Boolean.FALSE));
                String key = bizDataCode + "_" + bizData2.getString("id");
                errorMap.put(key, BizDataFailStatusEnum.getDesc((String)errorCode));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(waitUpdateBizDataList)) {
                HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.update(waitUpdateBizDataList.toArray(new DynamicObject[0]));
                HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.update(waitUpdateOriginBizDataList.toArray(new DynamicObject[0]));
                HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.save(waitSaveOperateHiss.toArray(new DynamicObject[0]));
                HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.save(waitSaveOperateLogs.toArray(new DynamicObject[0]));
                BizDataBillEntryHelper.updateTransSalaryStatus((Table<String, String, String>)statusTable);
            }
        } else {
            LOGGER.info(" ...BizDataRollBackHelper.dealUpdateBlsedResult\uff1a All of bizData is rollback fail!");
            bizDataList.forEach(bizData -> {
                String bizDataCode = bizData.getString("bizdatacode");
                appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizDataCode, Boolean.FALSE));
                String key = bizDataCode + "_" + bizData.getString("id");
                errorMap.put(key, errorMsg);
            });
        }
    }

    private static void dealDeleteBizDataResult(Map<String, Object> param, List<DynamicObject> bizDataList, Map<String, String> errorMap, List<AppLogInfo> appLogInfos, Map<String, Object> resp) {
        Boolean success = (Boolean)resp.get("success");
        String errorMsg = (String)resp.get("message");
        if (success.booleanValue()) {
            List calHPDIBizDataList;
            List paramList = (List)resp.get("result");
            Map bizDataCodeMap = paramList.stream().collect(Collectors.toMap(map -> (String)map.get("bizdatacode"), Function.identity(), (k1, k2) -> k1));
            ArrayList<DynamicObject> waitUpdateBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
            ArrayList<DynamicObject> waitSaveOperateLogs = new ArrayList<DynamicObject>(bizDataList.size());
            HashBasedTable statusTable = HashBasedTable.create();
            for (DynamicObject bizData2 : bizDataList) {
                String bizDataCode = bizData2.getString("bizdatacode");
                Map bizDataMap = (Map)bizDataCodeMap.get(bizDataCode);
                if (null == bizDataMap || bizDataMap.isEmpty()) {
                    LOGGER.info(MessageFormat.format("{0}\uff1areturn param is null!", bizDataCode));
                    continue;
                }
                String status = (String)bizDataMap.get("status");
                if ("1".equals(status)) {
                    bizData2.set("bizdatastatus", (Object)BizDataStatusEnum.WITHDRAWN.getCode());
                    waitUpdateBizDataList.add(bizData2);
                    waitSaveOperateLogs.add(BizDataRollBackHelper.assembleOperateLogForStatus(bizData2, false, BizDataStatusEnum.PUSHED_SALARY.getDesc(), BizDataStatusEnum.WITHDRAWN.getDesc(), BizDataOperateEnum.OPERATE_ROLLBACK_ADD.getCode()));
                    appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizDataCode, Boolean.TRUE));
                    if (!"1".equals(bizData2.getString("submission"))) continue;
                    statusTable.put((Object)bizData2.getString("bizdatacode"), (Object)bizData2.getString("applyno"), (Object)bizData2.getString("bizdatastatus"));
                    continue;
                }
                String errorCode = String.valueOf(bizDataMap.get("errorcode"));
                appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizDataCode, Boolean.FALSE));
                errorMap.put(bizDataCode, BizDataFailStatusEnum.getDesc((String)errorCode));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(waitUpdateBizDataList)) {
                HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.update(waitUpdateBizDataList.toArray(new DynamicObject[0]));
                HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.save(waitSaveOperateLogs.toArray(new DynamicObject[0]));
                List bizDataCodes = waitUpdateBizDataList.stream().map(dy -> dy.getString("bizdatacode")).collect(Collectors.toList());
                QFilter filter = new QFilter("bizdatacode", "in", bizDataCodes);
                filter.and("bizdatastatus", "=", (Object)BizDataStatusEnum.PUSHED_SALARY.getCode());
                filter.and("billtype", "=", (Object)"2");
                Object[] bizDataArr = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("id, bizdatastatus, bizdatacode, submission, applyno", new QFilter[]{filter});
                if (!SWCArrayUtils.isEmpty((Object[])bizDataArr)) {
                    for (Object bizData3 : bizDataArr) {
                        bizData3.set("bizdatastatus", (Object)BizDataStatusEnum.WITHDRAWN.getCode());
                        if (!"1".equals(bizData3.getString("submission"))) continue;
                        statusTable.put((Object)bizData3.getString("bizdatacode"), (Object)bizData3.getString("applyno"), (Object)bizData3.getString("bizdatastatus"));
                    }
                    HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.update((DynamicObject[])bizDataArr);
                }
                BizDataBillEntryHelper.updateTransSalaryStatus((Table<String, String, String>)statusTable);
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(calHPDIBizDataList = (List)resp.get("calHPDIBizDataList")))) {
                BizDataUpdateHelper bizDataUpdateHelper = new BizDataUpdateHelper();
                bizDataUpdateHelper.updateBizData(calHPDIBizDataList);
            }
        } else {
            LOGGER.info(" ...BizDataRollBackHelper.dealDeleteBizDataResult\uff1a All of bizData is rollback fail!");
            bizDataList.forEach(bizData -> {
                String bizDataCode = bizData.getString("bizdatacode");
                appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizDataCode, Boolean.FALSE));
                errorMap.put(bizDataCode, errorMsg);
            });
        }
    }

    private static Map<String, Object> batchUpdateBlsed(Map<String, Object> param, List<DynamicObject> bizDataList) {
        Map hisMap = (Map)param.get("operateHisMap");
        if (null == hisMap) {
            return null;
        }
        HashMap reqMap = Maps.newHashMapWithExpectedSize((int)2);
        reqMap.put("opsystem", "hpdi");
        ArrayList paramList = new ArrayList(bizDataList.size());
        for (DynamicObject bizData : bizDataList) {
            String bizDataCode = bizData.getString("bizdatacode");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("bizdatacode", bizDataCode);
            paramMap.put("bizitemid", bizData.getLong("bizitem.id"));
            paramMap.put("operate", "1");
            List operateHiss = (List)hisMap.get(bizDataCode);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)operateHiss)) continue;
            paramMap.put("bsled", ((DynamicObject)operateHiss.get(0)).getDate("beforupdatedate"));
            paramList.add(paramMap);
        }
        reqMap.put("data", paramList);
        Map<String, Object> resp = HPDIServiceUtils.updateBlsed(reqMap);
        LOGGER.info(MessageFormat.format("batchUpdateBlsed is: {0}", JSON.toJSONString(resp)));
        return resp;
    }

    private static void doFilterChangeForAddType(Map<String, Object> param, List<DynamicObject> bizDataList, Map<String, String> errorMap, List<AppLogInfo> appLogInfos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(bizDataList)) {
            return;
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>(4);
        queryMap.put("billtype", "1");
        PeriodDateFilter periodDateFilter = new PeriodDateFilter();
        queryMap.putAll(periodDateFilter.getQueryMap(bizDataList));
        ArrayList<DynamicObject> copyBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
        copyBizDataList.addAll(bizDataList);
        HashMap<String, Map<String, Object>> responses = new HashMap<String, Map<String, Object>>(4);
        BizDataFilterChain filterChain = new BizDataFilterChain();
        filterChain.addFilter(new BizDataCODFilter());
        filterChain.addFilter(periodDateFilter);
        filterChain.doFilter(queryMap, copyBizDataList, filterChain, responses);
        if (MapUtils.isNotEmpty(responses)) {
            Iterator<DynamicObject> it = bizDataList.iterator();
            while (it.hasNext()) {
                DynamicObject bizData = it.next();
                String bizDataCode = bizData.getString("bizdatacode");
                Map responseMap = (Map)responses.get(bizDataCode);
                if (SWCObjectUtils.isEmpty(responseMap.get("key_result_error_msg"))) continue;
                appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizDataCode, Boolean.FALSE));
                errorMap.put(bizDataCode, String.valueOf(responseMap.get("key_result_error_msg")));
                it.remove();
            }
        }
    }

    private static void validateLatestRecord(Map<String, Object> param, List<DynamicObject> bizDataList, Map<String, String> errorMap, List<AppLogInfo> appLogInfos) {
        List bizDataCodes = bizDataList.stream().map(bizData -> bizData.getString("bizdatacode")).collect(Collectors.toList());
        QFilter[] filters = new QFilter[]{new QFilter(CURRENT_BIZDATACODE, "in", bizDataCodes)};
        Object[] operateHiss = HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.query("bizdata.id, currentbizdatacode, operatetime, operatetype, afterupdatedate, beforupdatedate", filters, "operatetime desc");
        if (SWCArrayUtils.isEmpty((Object[])operateHiss)) {
            return;
        }
        Set rollbackIds = Arrays.stream(operateHiss).filter(his -> rollbackOpTypes.contains(his.getString("operatetype"))).map(his -> his.getLong("bizdata.id")).collect(Collectors.toSet());
        Map<String, List<DynamicObject>> opHisMap = Arrays.stream(operateHiss).filter(his -> !rollbackIds.contains(his.getLong("bizdata.id"))).collect(Collectors.groupingBy(his -> his.getString(CURRENT_BIZDATACODE)));
        param.put("operateHisMap", opHisMap);
        Iterator<DynamicObject> it = bizDataList.iterator();
        while (it.hasNext()) {
            DynamicObject bizData2 = it.next();
            String bizDataCode = bizData2.getString("bizdatacode");
            List<DynamicObject> subHiss = opHisMap.get(bizDataCode);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(subHiss)) continue;
            DynamicObject latestHis = subHiss.get(0);
            if (bizData2.getLong("id") == latestHis.getLong("bizdata.id")) continue;
            appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizDataCode, Boolean.FALSE));
            String key = bizDataCode + "_" + bizData2.getString("id");
            errorMap.put(key, HPDIResMgrBusiness.getMsgOfExpiryDateHasChanged());
            it.remove();
        }
    }

    private static void doFilterChangeForUpdateType(Map<String, Object> param, List<DynamicObject> bizDataList, Map<String, String> errorMap, List<AppLogInfo> appLogInfos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(bizDataList)) {
            return;
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>(16);
        queryMap.put("billtype", "2");
        PeriodDateFilter periodDateFilter = new PeriodDateFilter();
        queryMap.putAll(periodDateFilter.getQueryMap(bizDataList));
        ArrayList<DynamicObject> copyBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
        copyBizDataList.addAll(bizDataList);
        HashMap<String, Map<String, Object>> responses = new HashMap<String, Map<String, Object>>(4);
        BizDataFilterChain filterChain = new BizDataFilterChain();
        filterChain.addFilter(new BizDataUpdateCODFilter());
        filterChain.addFilter(new BizDataOperateFilter());
        filterChain.doFilter(queryMap, copyBizDataList, filterChain, responses);
        if (MapUtils.isNotEmpty(responses)) {
            Iterator<DynamicObject> it = bizDataList.iterator();
            while (it.hasNext()) {
                DynamicObject bizData = it.next();
                String bizDataCode = bizData.getString("bizdatacode");
                Map responseMap = (Map)responses.get(bizDataCode);
                if (SWCObjectUtils.isEmpty(responseMap.get("key_result_error_msg"))) continue;
                appLogInfos.add(BizDataRollBackHelper.assembleRollBackLog(param, bizDataCode, Boolean.FALSE));
                String key = bizDataCode + "_" + bizData.getString("id");
                errorMap.put(key, String.valueOf(responseMap.get("key_result_error_msg")));
                it.remove();
            }
        }
    }

    private static DynamicObject assembleOperateHis(DynamicObject recordDy, DynamicObject bizData, String operateType) {
        DynamicObject bizDataHis = HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.generateEmptyDynamicObject();
        bizDataHis.set("bizdata", (Object)bizData.getLong("id"));
        bizDataHis.set("empposorgrel", bizData.getDynamicObject("empposorgrel").getPkValue());
        bizDataHis.set("bizitem", bizData.getDynamicObject("bizitem").getPkValue());
        bizDataHis.set("afterupdatedate", (Object)recordDy.getDate("beforupdatedate"));
        bizDataHis.set(CURRENT_BIZDATACODE, (Object)recordDy.getString(CURRENT_BIZDATACODE));
        bizDataHis.set("operatebizdatacode", (Object)recordDy.getString(CURRENT_BIZDATACODE));
        bizDataHis.set("beforupdatedate", (Object)bizData.getDate("expirydate"));
        bizDataHis.set("operatetype", (Object)operateType);
        bizDataHis.set("operater", (Object)RequestContext.get().getCurrUserId());
        bizDataHis.set("operatetime", (Object)new Date());
        return bizDataHis;
    }

    private static DynamicObject assembleOperateLog(DynamicObject recordDy, DynamicObject bizData, String updateField) {
        DynamicObject operateLog = HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.generateEmptyDynamicObject();
        operateLog.set("dataid", (Object)bizData.getLong("id"));
        operateLog.set("modeltype", (Object)"1");
        operateLog.set("empposorgrel", (Object)bizData.getDynamicObject("empposorgrel"));
        operateLog.set("salaryfile", (Object)bizData.getDynamicObject("salaryfile"));
        operateLog.set("adminorg", (Object)bizData.getDynamicObject("empposorgrel.adminorg"));
        operateLog.set("bizitemgroup", (Object)bizData.getDynamicObject("bizitemgroup"));
        operateLog.set("bizdatacode", (Object)bizData.getString("bizdatacode"));
        operateLog.set("bizitem", (Object)bizData.getDynamicObject("bizitem"));
        operateLog.set("bizdatadim", (Object)bizData.getDynamicObject("bizdatadim"));
        operateLog.set("operatetype", (Object)BizDataOperateEnum.OPERATE_ROLLBACK_UPDATE.getCode());
        operateLog.set("updatefield", (Object)updateField);
        if (BizDataUpdateFieldEnum.FIELD_EXPIRYDATE.getCode().equals(updateField)) {
            String beforeUpdate = null;
            String afterUpdate = null;
            beforeUpdate = null == bizData.getDate("expirydate") ? null : SWCDateTimeUtils.formatDate((Date)bizData.getDate("expirydate"));
            afterUpdate = null == recordDy.getDate("beforupdatedate") ? null : SWCDateTimeUtils.formatDate((Date)recordDy.getDate("beforupdatedate"));
            operateLog.set("beforeupdate", (Object)beforeUpdate);
            operateLog.set("afterupdate", (Object)afterUpdate);
        } else {
            operateLog.set("beforeupdate", (Object)BizDataStatusEnum.PUSHED_SALARY.getDesc());
            operateLog.set("afterupdate", (Object)BizDataStatusEnum.WITHDRAWN.getDesc());
        }
        return operateLog;
    }

    public static DynamicObject assembleOperateLogForStatus(DynamicObject bizData, boolean isHorizontal, String beforeUpdate, String afterUpdate, String operateType) {
        DynamicObject operateLog = HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.generateEmptyDynamicObject();
        operateLog.set("dataid", (Object)bizData.getLong("id"));
        String modelType = isHorizontal ? "2" : "1";
        operateLog.set("modeltype", (Object)modelType);
        operateLog.set("empposorgrel", (Object)bizData.getDynamicObject("empposorgrel"));
        operateLog.set("salaryfile", (Object)bizData.getDynamicObject("salaryfile"));
        operateLog.set("adminorg", (Object)bizData.getDynamicObject("empposorgrel.adminorg"));
        operateLog.set("bizitemgroup", (Object)bizData.getDynamicObject("bizitemgroup"));
        operateLog.set("bizdatacode", (Object)bizData.getString("bizdatacode"));
        if (!isHorizontal) {
            operateLog.set("bizitem", (Object)bizData.getDynamicObject("bizitem"));
        }
        operateLog.set("bizdatadim", (Object)bizData.getDynamicObject("bizdatadim"));
        operateLog.set("operatetype", (Object)operateType);
        operateLog.set("updatefield", (Object)BizDataUpdateFieldEnum.FIELD_BIZDATASTATUS.getCode());
        operateLog.set("beforeupdate", (Object)beforeUpdate);
        operateLog.set("afterupdate", (Object)afterUpdate);
        return operateLog;
    }

    private static void sortByEffectiveDateAndCalSalaryDate(List<DynamicObject> bizDataList) {
        bizDataList.sort((bizData1, bizData2) -> {
            Date effectiveDate2;
            if (SWCObjectUtils.isEmpty((Object)bizData1) || SWCObjectUtils.isEmpty((Object)bizData2)) {
                return 1;
            }
            Date effectiveDate1 = bizData1.getDate("effectivedate");
            int ret = BizDataRollBackHelper.compareDate(effectiveDate1, effectiveDate2 = bizData2.getDate("effectivedate"));
            if (0 == ret) {
                Date calSalaryDate1 = bizData1.getDate("calsalarydate");
                Date calSalaryDate2 = bizData2.getDate("calsalarydate");
                ret = BizDataRollBackHelper.compareDate(calSalaryDate1, calSalaryDate2);
            }
            return ret;
        });
    }

    private static int compareDate(Date date1, Date date2) {
        int ret = null == date1 && null != date2 ? -1 : (null != date1 && null == date2 ? 1 : (null == date1 && null == date2 ? 0 : date2.compareTo(date1)));
        return ret;
    }

    static {
        rollbackOpTypes.add(BizDataOperateEnum.OPERATE_ROLLBACK_ADD.getCode());
        rollbackOpTypes.add(BizDataOperateEnum.OPERATE_ROLLBACK_UPDATE.getCode());
    }
}

