/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class BizDataSaveHelper {
    private static final Log LOG = LogFactory.getLog(BizDataSaveHelper.class);
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MSG = "message";
    private static final String KEY_ERRORCODE = "errorcode";
    private static final String KEY_DATA = "data";
    private static final int BATCH_SIZE_MAX = 10000;
    private static final int BATCH_SIZE = 500;

    public Map<String, Object> saveBizData(Map<String, Object> params) {
        HashMap<String, Object> result;
        block2: {
            result = new HashMap<String, Object>();
            try {
                Map<String, Object> resultData = this.dealSaveBizData(params);
                this.clearResultData(resultData);
                LOG.info("call...saveBizData...batchnum={}...", params.get("batchnum"));
                result.put(KEY_SUCCESS, true);
                result.put(KEY_DATA, resultData);
            }
            catch (Exception ex) {
                LOG.error("BizDataSaveHelper...saveBizData...runerror...", (Throwable)ex);
                result.put(KEY_SUCCESS, Boolean.FALSE);
                result.put(KEY_MSG, BizDataFailStatusEnum.FAILSTATUS_0.getDesc());
                if (!String.valueOf(params.get("batchnum")).contains("msg")) break block2;
                result.put(KEY_MSG, ex.getMessage());
            }
        }
        return result;
    }

    private void clearResultData(Map<String, Object> resultData) {
        boolean isReturnErrorMsg = false;
        if (String.valueOf(resultData.get("batchnum")).contains("msg")) {
            isReturnErrorMsg = true;
        }
        if (isReturnErrorMsg && SWCStringUtils.isNotEmpty((String)((String)resultData.get(KEY_ERRORCODE)))) {
            String desc = BizDataFailStatusEnum.getDesc((String)((String)resultData.get(KEY_ERRORCODE)));
            if (desc == null) {
                desc = (String)resultData.get(KEY_ERRORCODE);
            }
            resultData.put(KEY_MSG, desc);
        }
        HashSet<String> propSet = new HashSet<String>(1);
        propSet.add("bizdatacode");
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)"hpdi_bizdata").getFields();
        for (Map.Entry prop : fieldProps.entrySet()) {
            if (propSet.contains(prop.getKey())) continue;
            resultData.remove(prop.getKey());
            resultData.remove((String)prop.getKey() + "id");
        }
        List paramRights = (List)resultData.get(KEY_DATA);
        for (Map re : paramRights) {
            re.remove("bizDataDy");
            for (Map.Entry prop : fieldProps.entrySet()) {
                if (propSet.contains(prop.getKey())) continue;
                re.remove(prop.getKey());
                re.remove((String)prop.getKey() + "id");
            }
            if (!isReturnErrorMsg || !SWCStringUtils.isNotEmpty((String)((String)re.get(KEY_ERRORCODE)))) continue;
            String[] codes = ((String)re.get(KEY_ERRORCODE)).split(";");
            StringBuilder sb = new StringBuilder();
            for (String code : codes) {
                String desc = BizDataFailStatusEnum.getDesc((String)code);
                if (desc == null) {
                    desc = (String)re.get(KEY_ERRORCODE);
                }
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(desc);
            }
            re.put(KEY_MSG, sb.toString());
        }
    }

    private Map<String, Object> dealSaveBizData(Map<String, Object> param) {
        LOG.info("call...dealSaveBizData...batchnum={}...bgein...", param.get("batchnum"));
        List<Map<String, Object>> paramRights = (List<Map<String, Object>>)param.get(KEY_DATA);
        if (paramRights == null) {
            LOG.info("call...dealSaveBizData...batchnum={}...execing...paramRights is null", param.get("batchnum"));
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_0.getCode());
            return param;
        }
        LOG.info("call...dealSaveBizData...batchnum={}...execing...paramRights.size={}...", param.get("batchnum"), (Object)paramRights.size());
        if (paramRights.size() > 10000) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_0.getCode());
            return param;
        }
        if (paramRights.size() <= 30) {
            LOG.info("call...dealSaveBizData...batchnum={}...execing...param={}...", param.get("batchnum"), (Object)SerializationUtils.toJsonString(param));
        }
        this.validateOneParams(param);
        if (param.get(KEY_SUCCESS) != null && !((Boolean)param.get(KEY_SUCCESS)).booleanValue()) {
            return param;
        }
        this.validateParams(paramRights);
        paramRights = this.filterRights(paramRights);
        this.convertToBizDataDy(paramRights, param);
        this.completeBizDataDy(paramRights);
        this.validateBeforeSave(paramRights);
        paramRights = this.filterRights(paramRights);
        Map<Integer, List<Map<String, Object>>> splitParamRights = this.splitParamsByEmpid(paramRights);
        for (Map.Entry<Integer, List<Map<String, Object>>> entry : splitParamRights.entrySet()) {
            ArrayList tmpList = new ArrayList(entry.getValue().size());
            tmpList.addAll(entry.getValue());
            List tmpListSplit = Lists.partition(tmpList, (int)500);
            for (List minList : tmpListSplit) {
                this.dealSaveSalaryFile(minList);
            }
        }
        LOG.info("call...dealSaveBizData...batchnum={}...end......paramRights.size={}...", param.get("batchnum"), (Object)paramRights.size());
        return param;
    }

    private void validateBeforeSave(List<Map<String, Object>> paramRights) {
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)"hpdi_bizdata").getFields();
        DynamicObject bizDataDy = null;
        for (int i = 0; i < paramRights.size(); ++i) {
            Map<String, Object> paramTmp = paramRights.get(i);
            bizDataDy = (DynamicObject)paramTmp.get("bizDataDy");
            for (Map.Entry prop : fieldProps.entrySet()) {
                String pkey = (String)prop.getKey();
                IDataEntityProperty propval = (IDataEntityProperty)prop.getValue();
                Object pValue = bizDataDy.get(pkey);
                if (pValue == null || !(propval instanceof TextProp) || String.valueOf(pValue) == null || String.valueOf(pValue).length() <= 255) continue;
                paramTmp.put(KEY_SUCCESS, Boolean.FALSE);
                paramTmp.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4102.getCode());
            }
        }
    }

    private void dealSaveSalaryFile(List<Map<String, Object>> paramRights) {
        this.executeOp("save", paramRights);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOp(String opName, List<Map<String, Object>> waitParams) {
        if (waitParams == null || waitParams.size() == 0) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            ArrayList<DynamicObject> waitDys = new ArrayList<DynamicObject>(10);
            String isReturnErrorCode = "true";
            HashMap<Long, Map<String, Object>> waitMap = new HashMap<Long, Map<String, Object>>(16);
            for (Map<String, Object> param : waitParams) {
                DynamicObject bizDataDy = (DynamicObject)param.get("bizDataDy");
                waitDys.add(bizDataDy);
                waitMap.put(bizDataDy.getLong("id"), param);
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("OPERATE_SRC", "BizDataSaveHelper.executeOp");
            operateOption.setVariableValue("ishasright", "true");
            operateOption.setVariableValue("skipCheckDataPermission", "true");
            operateOption.setVariableValue("return_error_code", isReturnErrorCode);
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperationResult operationResult = opImpl.localInvokeOperation(opName, waitDys.toArray(new DynamicObject[0]), operateOption);
            this.dealOperationResult(opName, operationResult, waitMap);
            txHandle.commit();
        }
    }

    private void dealOperationResult(String opName, OperationResult operationResult, Map<Long, Map<String, Object>> waitMap) {
        for (Object pkId : operationResult.getSuccessPkIds()) {
            Map<String, Object> param = waitMap.get(Long.parseLong(String.valueOf(pkId)));
            param.put(KEY_SUCCESS, Boolean.TRUE);
            param.put(KEY_ERRORCODE, "");
        }
        List operateInfos = operationResult.getAllErrorOrValidateInfo();
        for (IOperateInfo operateInfo : operateInfos) {
            Long pkId = Long.parseLong(String.valueOf(operateInfo.getPkValue()));
            Map<String, Object> param = waitMap.get(Long.parseLong(String.valueOf(pkId)));
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, (param.get(KEY_ERRORCODE) == null ? "" : param.get(KEY_ERRORCODE) + ";") + operateInfo.getMessage());
        }
        String sucessMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BizDataSaveHelper_0", (String)"swc-hpdi-business", (Object[])new Object[0]);
        String cancelMsg = ResManager.loadKDString((String)"\u53d6\u6d88\u4e86\u64cd\u4f5c", (String)"PersonImportDataTask_12", (String)"swc-hsas-business", (Object[])new Object[0]);
        String validateMsg = ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"EntityOperateService_11", (String)"bos-mservice-operation", (Object[])new Object[0]);
        String msg = operationResult.getMessage();
        if (StringUtils.isNotEmpty((CharSequence)msg) && !msg.contains(sucessMsg) && !msg.contains(cancelMsg) && !msg.contains(validateMsg)) {
            LOG.error("BizDataSaveHelper.executeOp...runerror...msg\uff1a", (Object)msg);
            for (Map<String, Object> param : waitMap.values()) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_0.getCode());
            }
        }
    }

    private Map<Integer, List<Map<String, Object>>> splitParamsByEmpid(List<Map<String, Object>> paramRights) {
        paramRights.sort((o1, o2) -> {
            if (o1 != null && o2 != null && o1.get("effectivedate") != null && o2.get("effectivedate") != null) {
                return ((Date)o1.get("effectivedate")).compareTo((Date)o2.get("effectivedate"));
            }
            return 0;
        });
        HashMap<Integer, List<Map<String, Object>>> batchDyMap = new HashMap<Integer, List<Map<String, Object>>>(16);
        HashMap<String, Integer> batchRls = new HashMap<String, Integer>(16);
        for (Map<String, Object> dy : paramRights) {
            DynamicObject bizDataDy = (DynamicObject)dy.get("bizDataDy");
            String employeeId = bizDataDy.getString("empposorgrel.id") + "|" + bizDataDy.getString("bizitem.id");
            Integer batch = (Integer)batchRls.get(employeeId);
            if (batch == null) {
                batch = -1;
            }
            Integer n = batch;
            Integer n2 = batch = Integer.valueOf(batch + 1);
            batchRls.put(employeeId, batch);
            ArrayList<Map<String, Object>> dys = (ArrayList<Map<String, Object>>)batchDyMap.get(batch);
            if (dys == null) {
                dys = new ArrayList<Map<String, Object>>(10);
            }
            dys.add(dy);
            batchDyMap.put(batch, dys);
        }
        return batchDyMap;
    }

    private void completeBizDataDy(List<Map<String, Object>> params) {
        long[] ids = DB.genLongIds((String)"hpdi_bizdata", (int)params.size());
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject bizDataDy = null;
        for (int i = 0; i < params.size(); ++i) {
            Map<String, Object> param = params.get(i);
            bizDataDy = (DynamicObject)param.get("bizDataDy");
            bizDataDy.set("id", (Object)ids[i]);
            bizDataDy.set("submission", (Object)"2");
            bizDataDy.set("billtype", (Object)"1");
            bizDataDy.set("bizdatastatus", (Object)"1");
            bizDataDy.set("relationrecord", (Object)"B");
            bizDataDy.set("submitdate", (Object)new Date());
            bizDataDy.set("adminorg", (Object)bizDataDy.getLong("empposorgrel.adminorg.id"));
            bizDataDy.set("creator", (Object)userId);
            bizDataDy.set("modifier", (Object)userId);
        }
    }

    private void convertToBizDataDy(List<Map<String, Object>> params, Map<String, Object> paramOne) {
        Object pValue;
        IDataEntityProperty propval;
        String pkey;
        Map<String, Object> param;
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hpdi_bizdata");
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)"hpdi_bizdata").getFields();
        HashMap bdValue = new HashMap(16);
        HashMap<String, Map<Long, DynamicObject>> bdValueDB = new HashMap<String, Map<Long, DynamicObject>>(16);
        DynamicObject bizDataDy = null;
        for (int i = 0; i < params.size(); ++i) {
            param = params.get(i);
            bizDataDy = fileHelper.generateEmptyDynamicObject();
            param.put("bizDataDy", bizDataDy);
            for (Map.Entry prop : fieldProps.entrySet()) {
                pkey = (String)prop.getKey();
                propval = (IDataEntityProperty)prop.getValue();
                pValue = param.get(pkey);
                if (propval instanceof BasedataProp) {
                    HashSet<Long> values = (HashSet<Long>)bdValue.get(propval);
                    if (values == null) {
                        values = new HashSet<Long>(16);
                        bdValue.put((BasedataProp)propval, values);
                    }
                    if ((pValue = param.get(pkey + "id")) == null) continue;
                    Long pValueLong = Long.parseLong(String.valueOf(pValue));
                    values.add(pValueLong);
                    param.put(pkey + "id", pValueLong);
                    bizDataDy.set(pkey, (Object)pValueLong);
                    continue;
                }
                if (propval instanceof DateProp) {
                    this.dealDateValue(bizDataDy, param, pkey, pValue);
                    continue;
                }
                bizDataDy.set(pkey, pValue);
            }
        }
        for (Map.Entry bdProp : bdValue.entrySet()) {
            BasedataProp prop = (BasedataProp)bdProp.getKey();
            SWCDataServiceHelper helper = new SWCDataServiceHelper(prop.getBaseEntityId());
            QFilter filter = new QFilter("id", "in", bdProp.getValue());
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)helper.getEntityName());
            Set fieldSet = mainEntityType.getFields().keySet();
            if (fieldSet.contains("enable")) {
                filter.and("enable", "=", (Object)"1");
            }
            if (fieldSet.contains("status")) {
                filter.and("status", "=", (Object)"C");
            }
            DynamicObject[] dys = helper.query(SWCHisBaseDataHelper.getSelectProperties((String)prop.getBaseEntityId()), new QFilter[]{filter});
            Map<Long, DynamicObject> dysIdMap = Arrays.asList(dys).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (t1, t2) -> t1));
            bdValueDB.put(prop.getName(), dysIdMap);
        }
        for (int i = 0; i < params.size(); ++i) {
            param = params.get(i);
            bizDataDy = (DynamicObject)param.get("bizDataDy");
            bizDataDy.set("overdue", paramOne.get("overdue"));
            for (Map.Entry prop : fieldProps.entrySet()) {
                pkey = (String)prop.getKey();
                propval = (IDataEntityProperty)prop.getValue();
                pValue = paramOne.get(pkey);
                if (pValue != null) {
                    bizDataDy.set(pkey, pValue);
                    continue;
                }
                if (!(propval instanceof BasedataProp)) continue;
                pValue = param.get(pkey + "id");
                if (pValue instanceof Long) {
                    DynamicObject bdValueTmp = (DynamicObject)((Map)bdValueDB.get(pkey)).get(pValue);
                    if (bdValueTmp != null) {
                        bizDataDy.set(pkey, (Object)bdValueTmp);
                        continue;
                    }
                    param.put(KEY_SUCCESS, Boolean.FALSE);
                    param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4107.getCode());
                    continue;
                }
                if (pValue == null) continue;
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4107.getCode());
            }
        }
    }

    private void dealDateValue(DynamicObject bizDataDy, Map<String, Object> param, String pkey, Object pValue) {
        if (pValue == null) {
            return;
        }
        if (pValue instanceof String) {
            try {
                pValue = SWCDateTimeUtils.parseDate((String)String.valueOf(pValue), (String)"yyyy-MM-dd");
            }
            catch (ParseException var3) {
                LOG.error("BizDataSaveHelper.convertToBizDataDy.parseDateValue error...1...", (Throwable)var3);
                try {
                    pValue = SWCDateTimeUtils.parseDate((String)String.valueOf(pValue), (String)"yyyy/MM/dd");
                }
                catch (ParseException var4) {
                    LOG.error("BizDataSaveHelper.convertToBizDataDy.parseDateValue error...2...", (Throwable)var4);
                    param.put(KEY_SUCCESS, Boolean.FALSE);
                    param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4108.getCode());
                    pValue = null;
                }
            }
        }
        if (pValue instanceof Date) {
            Calendar ca = Calendar.getInstance();
            ca.setTime((Date)pValue);
            if (ca.get(1) > 2999) {
                pValue = null;
                LOG.error("BizDataSaveHelper.convertToBizDataDy.parseDateValue error...3...{}", (Object)SWCDateTimeUtils.format((Date)((Date)pValue)));
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4108.getCode());
            }
            ca.set(10, 0);
            ca.set(12, 0);
            ca.set(13, 0);
            ca.set(14, 0);
            pValue = ca.getTime();
        }
        bizDataDy.set(pkey, pValue);
    }

    private void validateOneParams(Map<String, Object> param) {
        String batchNum = (String)param.get("batchnum");
        if (SWCStringUtils.isEmpty((String)batchNum)) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4000.getCode());
            return;
        }
        Long bizItemGroupId = (Long)param.get("bizitemgroupid");
        if (bizItemGroupId == null) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4001.getCode());
            return;
        }
        Long calperiodId = (Long)param.get("calperiodid");
        if (calperiodId == null) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4002.getCode());
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hpdi_bizdata");
        QFilter filter = new QFilter("batchnum", "=", (Object)batchNum);
        boolean isExists = helper.isExists(new QFilter[]{filter});
        if (isExists) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4101.getCode());
            return;
        }
        SWCDataServiceHelper ghelper = new SWCDataServiceHelper("hsbs_bizitemgroup");
        QFilter gfilter = new QFilter("id", "=", (Object)bizItemGroupId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject groupDy = ghelper.queryOne("createorg, modeltype, calperiodtype.entryentity.id, entryentity, entryentity.bizitem, entryentity.bizitem.cycle", new QFilter[]{gfilter, enableFilter, statusFilter});
        if (groupDy == null) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4104.getCode());
            return;
        }
        param.put("bizitemgroup", groupDy);
        DynamicObjectCollection bizitems = groupDy.getDynamicObjectCollection("entryentity");
        if (!"1".equals(groupDy.getString("modeltype")) || !"1".equals(((DynamicObject)bizitems.get(0)).getString("bizitem.cycle"))) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4104.getCode());
            return;
        }
        SWCDataServiceHelper peroidTypeHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        QFilter periodTypeFilter = new QFilter("entryentity.id", "=", (Object)calperiodId);
        DynamicObject peroidTypeDy = peroidTypeHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)peroidTypeHelper.getEntityName()), new QFilter[]{periodTypeFilter, enableFilter, statusFilter});
        SWCDataServiceHelper peroidHelper = new SWCDataServiceHelper("hsbs_calperiod");
        QFilter periodFilter = new QFilter("id", "=", (Object)calperiodId);
        DynamicObject peroidDy = peroidHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)peroidHelper.getEntityName()), new QFilter[]{periodFilter, enableFilter, statusFilter});
        if (peroidDy == null || peroidTypeDy == null) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4103.getCode());
            return;
        }
        param.put("calperiod", peroidDy);
        DynamicObjectCollection periods = groupDy.getDynamicObjectCollection("calperiodtype.entryentity");
        boolean isFindPeriod = false;
        for (DynamicObject period : periods) {
            if (period.getLong("id") != calperiodId.longValue()) continue;
            isFindPeriod = true;
            break;
        }
        if (!isFindPeriod) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4105.getCode());
            return;
        }
        this.adjustIsOverTimeSubmit(param, groupDy, peroidDy);
    }

    private void adjustIsOverTimeSubmit(Map<String, Object> param, DynamicObject groupDy, DynamicObject peroidDy) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(7);
        paramMap.put("calperiodtype", groupDy.get("calperiodtype.id"));
        paramMap.put("bizitemgroupid", groupDy.getLong("id"));
        paramMap.put("periodnumber", peroidDy.getString("number"));
        paramMap.put("orgId", groupDy.getLong("createorg.id"));
        Map<String, Object> nodeTime = HPDIServiceUtils.queryPayNodeTime(paramMap);
        Date endTime = (Date)nodeTime.get("endtime");
        if (endTime != null && new Date().after(endTime)) {
            param.put("overdue", "A");
        } else {
            param.put("overdue", " ");
        }
    }

    private void validateParams(List<Map<String, Object>> params) {
        Set empids = params.stream().map(param -> Long.parseLong(String.valueOf(param.get("depempid") == null ? Long.valueOf(0L) : param.get("depempid")))).collect(Collectors.toSet());
        SWCDataServiceHelper empPosOrgRelHr = new SWCDataServiceHelper("hrpi_empposorgrel");
        QFilter depEmpIdFilter = new QFilter("depemp.id", "in", empids);
        depEmpIdFilter.and(BaseDataHisHelper.getHisCurrFilter());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)empPosOrgRelHr.getEntityName());
        String allFilelds = String.join((CharSequence)",", SWCHisBaseDataHelper.getFields((MainEntityType)mainEntityType));
        DynamicObject[] empPosOrgs = HPDIServiceUtils.listFieldsFilterInfo(allFilelds, depEmpIdFilter, "hrpi_empposorgrel");
        Map<Long, List<DynamicObject>> maps = Arrays.stream(empPosOrgs).collect(Collectors.groupingBy(bizData -> bizData.getLong("depemp.id")));
        for (Map<String, Object> param2 : params) {
            if (param2.get("depempid") == null) {
                param2.put(KEY_SUCCESS, Boolean.FALSE);
                param2.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4003.getCode());
            } else {
                Long depempid = Long.parseLong(String.valueOf(param2.get("depempid")));
                List<DynamicObject> rels = maps.get(depempid);
                if (rels != null && rels.size() == 1) {
                    param2.put("empposorgrelid", rels.get(0).getLong("id"));
                } else {
                    param2.put(KEY_SUCCESS, Boolean.FALSE);
                    param2.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4106.getCode());
                }
            }
            if (param2.get("bizitemid") == null) {
                param2.put(KEY_SUCCESS, Boolean.FALSE);
                param2.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4004.getCode());
            }
            if (param2.get("effectivedate") == null) {
                param2.put(KEY_SUCCESS, Boolean.FALSE);
                param2.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4005.getCode());
            }
            if (SWCStringUtils.isEmpty((String)((String)param2.get("value")))) {
                param2.put(KEY_SUCCESS, Boolean.FALSE);
                param2.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4006.getCode());
            }
            if (!SWCStringUtils.isEmpty((String)((String)param2.get("bizdatacode")))) continue;
            param2.put(KEY_SUCCESS, Boolean.FALSE);
            param2.put(KEY_ERRORCODE, BizDataFailStatusEnum.FAILSTATUS_4007.getCode());
        }
    }

    private List<Map<String, Object>> filterRights(List<Map<String, Object>> params) {
        return params.stream().filter(o1 -> o1.get(KEY_SUCCESS) == null || (Boolean)o1.get(KEY_SUCCESS) != false).collect(Collectors.toList());
    }
}

