/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.helper.BizDataSubmitMultiTask;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;

public class BizDataSubmitMultiService {
    protected static final Log logger = LogFactory.getLog(BizDataSubmitMultiService.class);

    public static BizDataSubmitMultiService getInstance() {
        return BizDataSubmitMultiServiceHolder.SERVICE;
    }

    public Map<String, Object> packageBizData(List<DynamicObject> waitEntitys, DynamicObject bizDataBill) {
        int batchSize = 3000;
        List waitEntitySplit = Lists.partition(waitEntitys, (int)batchSize);
        CountDownLatch latch = new CountDownLatch(waitEntitySplit.size());
        ArrayList<Future> futureList = new ArrayList<Future>(waitEntitySplit.size());
        for (int i = 0; i < waitEntitySplit.size(); ++i) {
            BizDataSubmitMultiTask task = new BizDataSubmitMultiTask((List)waitEntitySplit.get(i), bizDataBill, latch);
            Future future = SWCThreadPoolFactory.getBizdataTransferThreadpool().submit((Callable)task);
            futureList.add(future);
        }
        ArrayList bizDatas = new ArrayList();
        DynamicObjectCollection bizDataRecords = new DynamicObjectCollection();
        HashMap<String, Object> bizDataMap = new HashMap<String, Object>(16);
        bizDataMap.put("bizDatas", bizDatas);
        bizDataMap.put("bizDataRecords", bizDataRecords);
        try {
            boolean flag = latch.await(10L, TimeUnit.MINUTES);
            if (!flag) {
                return bizDataMap;
            }
            for (Future future : futureList) {
                Map bizDataMapBatch = (Map)future.get();
                Object errormsg = bizDataMapBatch.get("errormsg");
                if (errormsg != null) {
                    throw new Exception(String.valueOf(errormsg));
                }
                bizDatas.addAll((Collection)bizDataMapBatch.get("bizDatas"));
                bizDataRecords.addAll((Collection)bizDataMapBatch.get("bizDataRecords"));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new RuntimeException("Failed to exec BizDataSubmitMultiTask ", e);
        }
        return bizDataMap;
    }

    private static class BizDataSubmitMultiServiceHolder {
        private static final BizDataSubmitMultiService SERVICE = new BizDataSubmitMultiService();

        private BizDataSubmitMultiServiceHolder() {
        }
    }
}

