/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.helper.BizDataHelper;

public class BizDataSubmitMultiTask
implements Callable<Map> {
    protected static final Log logger = LogFactory.getLog(BizDataSubmitMultiTask.class);
    private final List<DynamicObject> waitEntitys;
    private final DynamicObject bizDataBill;
    private final CountDownLatch latch;

    public BizDataSubmitMultiTask(List<DynamicObject> waitEntitys, DynamicObject bizDataBill, CountDownLatch latch) {
        this.waitEntitys = waitEntitys;
        this.bizDataBill = bizDataBill;
        this.latch = latch;
    }

    @Override
    public Map call() throws Exception {
        Map<Object, Object> bizDataMap = new HashMap(16);
        try {
            bizDataMap = BizDataHelper.packageBizData(this.waitEntitys, this.bizDataBill);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            bizDataMap.put("errormsg", e.getMessage());
        }
        finally {
            this.latch.countDown();
        }
        return bizDataMap;
    }
}

