/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.common.constants.BizDataTransSalaryStatusEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataTransSalaryStatusHelper {
    private static final Log logger = LogFactory.getLog(BizDataTransSalaryStatusHelper.class);
    private static Map<String, String> statusMap = new HashMap<String, String>(16);

    public static void refreshBizDataBillTransStatus(List<Long> bizDataBillIdList) {
        Object[] bizDataBillArr = BizDataTransSalaryStatusHelper.getStatusHasChangedBills(bizDataBillIdList);
        if (SWCArrayUtils.isEmpty((Object[])bizDataBillArr)) {
            logger.info("No bizDataBill to be refreshed!");
            return;
        }
        logger.info("Number of bizDataBill to be refreshed is : {}", (Object)bizDataBillArr.length);
        ArrayList<Object> bizDataBills = new ArrayList<Object>(Arrays.asList(bizDataBillArr));
        List partitionList = Lists.partition(bizDataBills, (int)500);
        for (List subList : partitionList) {
            BizDataTransSalaryStatusHelper.updateBizDataBillTransStatus(subList);
        }
    }

    private static void updateBizDataBillTransStatus(List<DynamicObject> bizDataBills) {
        for (DynamicObject bizDataBill : bizDataBills) {
            BizDataTransSalaryStatusHelper.summaryTransSalaryStatus(bizDataBill);
        }
        HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.update(bizDataBills.toArray(new DynamicObject[0]));
    }

    private static void summaryTransSalaryStatus(DynamicObject bizDataBill) {
        if (SWCObjectUtils.isEmpty((Object)bizDataBill)) {
            return;
        }
        QFilter filter = new QFilter("bizdatabillid", "=", (Object)bizDataBill.getLong("id"));
        Object[] bizDataBillEntArr = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query("enttranssalarystatus", new QFilter[]{filter});
        if (SWCArrayUtils.isEmpty((Object[])bizDataBillEntArr)) {
            return;
        }
        HashSet<String> statusSet = new HashSet<String>(16);
        String transSalaryStatus = null;
        for (Object ent : bizDataBillEntArr) {
            String entStatus = ent.getString("enttranssalarystatus");
            if (SWCStringUtils.isEmpty((String)entStatus)) continue;
            statusSet.add(entStatus);
            if (statusSet.size() <= 1 || !statusSet.contains(BizDataStatusEnum.TO_BE_PUSH_SALARY.getCode())) continue;
            transSalaryStatus = BizDataTransSalaryStatusEnum.SUB_TO_BE_PUSH.getCode();
            break;
        }
        if (statusSet.isEmpty()) {
            return;
        }
        if (SWCStringUtils.isEmpty(transSalaryStatus)) {
            boolean onlyOneState;
            boolean bl = onlyOneState = 1 == statusSet.size();
            if (onlyOneState) {
                transSalaryStatus = statusMap.get(statusSet.iterator().next());
            } else if (statusSet.contains(BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode())) {
                transSalaryStatus = BizDataTransSalaryStatusEnum.SUB_PUSHED_FAIL.getCode();
            } else if (statusSet.contains(BizDataStatusEnum.SALARY_REJECT.getCode())) {
                transSalaryStatus = BizDataTransSalaryStatusEnum.SUB_HSAS_REJECT.getCode();
            } else if (statusSet.contains(BizDataStatusEnum.WITHDRAWN.getCode())) {
                transSalaryStatus = BizDataTransSalaryStatusEnum.SUB_ROLLBACK.getCode();
            } else if (statusSet.contains(BizDataStatusEnum.DISABLED.getCode())) {
                transSalaryStatus = BizDataTransSalaryStatusEnum.SUB_ABANDON.getCode();
            } else if (statusSet.contains(BizDataStatusEnum.HSAS_DISABLED.getCode())) {
                transSalaryStatus = BizDataTransSalaryStatusEnum.SUB_HSAS_ABANDON.getCode();
            }
        }
        logger.info("...{} transSalaryStatus is : {}", (Object)bizDataBill.getString("billno"), transSalaryStatus);
        bizDataBill.set("transsalarystatus", transSalaryStatus);
        bizDataBill.set("ischange", (Object)"0");
    }

    private static DynamicObject[] getStatusHasChangedBills(List<Long> bizDataBillIdList) {
        QFilter filter = new QFilter("ischange", "=", (Object)"1");
        if (!CollectionUtils.isEmpty(bizDataBillIdList)) {
            filter.and("id", "in", bizDataBillIdList);
        }
        return HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.query("id, billno, transsalarystatus, ischange", new QFilter[]{filter});
    }

    static {
        statusMap.put(BizDataStatusEnum.TO_BE_PUSH_SALARY.getCode(), BizDataTransSalaryStatusEnum.ALL_TO_BE_PUSH.getCode());
        statusMap.put(BizDataStatusEnum.PUSHED_SALARY.getCode(), BizDataTransSalaryStatusEnum.ALL_PUSHED.getCode());
        statusMap.put(BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode(), BizDataTransSalaryStatusEnum.ALL_PUSHED_FAIL.getCode());
        statusMap.put(BizDataStatusEnum.DISABLED.getCode(), BizDataTransSalaryStatusEnum.ALL_ABANDON.getCode());
        statusMap.put(BizDataStatusEnum.SALARY_REJECT.getCode(), BizDataTransSalaryStatusEnum.ALL_HSAS_REJECT.getCode());
        statusMap.put(BizDataStatusEnum.WITHDRAWN.getCode(), BizDataTransSalaryStatusEnum.ALL_ROLLBACK.getCode());
        statusMap.put(BizDataStatusEnum.HSAS_DISABLED.getCode(), BizDataTransSalaryStatusEnum.ALL_HSAS_ABANDON.getCode());
    }
}

