/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataMessageHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class BizDataUpdateHelper {
    private static final Log LOGGER = LogFactory.getLog(BizDataUpdateHelper.class);
    private static final int BATCH_SIZE_MAX = 10000;
    private static final int UPDATE_BATCH_SIZE_MAX = 5000;
    private static final Set<String> RESERVED_FIELD = new HashSet<String>(16);

    public static String getKey(Object ... params) {
        StringBuilder buf = new StringBuilder();
        for (Object param : params) {
            if (buf.length() > 0) {
                buf.append('_');
            }
            buf.append(param);
        }
        return buf.toString();
    }

    public Map<String, Object> changeDepemp(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map<String, Object> returnData = this.processData(param);
            this.clearResultNoNeedField(returnData);
            result.put("success", Boolean.TRUE);
            result.put("data", returnData);
        }
        catch (Exception exc) {
            LOGGER.error("... BizDataHelper.changeDepemp execute exception ...", (Throwable)exc);
            result.put("success", Boolean.FALSE);
            result.put("message", BizDataFailStatusEnum.FAILSTATUS_0.getDesc());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> processData(Map<String, Object> param) {
        LOGGER.info("... Processing params begin. Data batchnum: {} ...", param.get("batchnum"));
        List data = (List)param.get("data");
        if (CollectionUtils.isEmpty((Collection)data)) {
            LOGGER.info("... Processing data is empty! Data batchnum: {} ...", param.get("batchnum"));
            param.put("success", Boolean.FALSE);
            param.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_0.getCode());
            return param;
        }
        if (data.size() > 10000) {
            LOGGER.info("... Processing data size more than 10000! Data batchnum: {} ...", param.get("batchnum"));
            param.put("success", Boolean.FALSE);
            param.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_0.getCode());
            return param;
        }
        if (SWCStringUtils.isEmpty((String)((String)param.get("batchnum")))) {
            LOGGER.info("... Processing data is empty! Data batchnum: {} ...", param.get("batchnum"));
            param.put("success", Boolean.FALSE);
            param.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_4000.getCode());
            return param;
        }
        DLock lock = DLock.create((String)("changedepemplock" + param.get("batchnum")));
        try {
            if (lock.tryLock()) {
                this.doValidateAndSave(data);
            } else {
                LOGGER.info("... Acquire Lock fail. Input param is processing ...");
            }
        }
        finally {
            lock.unlock();
            lock.close();
        }
        LOGGER.info("... Processing params end. Data batchnum: {} ...", param.get("batchnum"));
        return param;
    }

    private void clearResultNoNeedField(Map<String, Object> result) {
        List data = (List)result.get("data");
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        for (Map record : data) {
            record.keySet().removeIf(key -> !RESERVED_FIELD.contains(key));
        }
    }

    private void doValidateAndSave(List<Map<String, Object>> data) {
        this.validateParamData(data);
        List<Map<String, Object>> checkPassData = data.stream().filter(rec -> rec.getOrDefault("success", Boolean.TRUE)).collect(Collectors.toList());
        this.handleBizDataDepemp(checkPassData);
    }

    private void validateParamData(List<Map<String, Object>> data) {
        HashSet<String> bizDataCodes = new HashSet<String>(data.size());
        HashSet<Long> employeeIds = new HashSet<Long>(data.size());
        HashSet<Long> depempIds = new HashSet<Long>(data.size());
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(data.size());
        for (Map<String, Object> record : data) {
            if (SWCObjectUtils.isEmpty((Object)record.get("bizdatacode"))) {
                record.put("success", Boolean.FALSE);
                record.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_4007.getCode());
                record.put("message", BizDataFailStatusEnum.FAILSTATUS_4007.getDesc());
                continue;
            }
            if (SWCObjectUtils.isEmpty((Object)record.get("employeeid"))) {
                record.put("success", Boolean.FALSE);
                record.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_4211.getCode());
                record.put("message", BizDataFailStatusEnum.FAILSTATUS_4211.getDesc());
                continue;
            }
            if (SWCObjectUtils.isEmpty((Object)record.get("depempid"))) {
                record.put("success", Boolean.FALSE);
                record.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_4212.getCode());
                record.put("message", BizDataFailStatusEnum.FAILSTATUS_4212.getDesc());
                continue;
            }
            bizDataCodes.add((String)record.get("bizdatacode"));
            employeeIds.add(MapUtils.getLong(record, (Object)"employeeid"));
            depempIds.add(MapUtils.getLong(record, (Object)"depempid"));
            successList.add(record);
        }
        if (CollectionUtils.isEmpty(successList)) {
            return;
        }
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter bizDataFilter = new QFilter("bizdatacode", "in", bizDataCodes);
        bizDataFilter.and("depemp.employee.id", "in", employeeIds);
        DynamicObject[] bizDataArr = bizDataHelper.query("bizdatacode,bizdatastatus,depemp.employee.id,bizdatarecord.id", new QFilter[]{bizDataFilter});
        Map<String, List<DynamicObject>> bizDataMap = Arrays.stream(bizDataArr).collect(Collectors.groupingBy(dy -> BizDataUpdateHelper.getKey(dy.get("bizdatacode"), dy.get("depemp.employee.id"))));
        SWCDataServiceHelper depempHelper = new SWCDataServiceHelper("hrpi_depemp");
        QFilter depempFilter = new QFilter("id", "in", depempIds);
        DynamicObject[] depempArr = depempHelper.query("employee.id", new QFilter[]{depempFilter});
        Map<Long, DynamicObject> depempMap = Arrays.stream(depempArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        HashSet<String> existsCheckPassCodes = new HashSet<String>(successList.size());
        for (Map map : successList) {
            String bizDataCode = (String)map.get("bizdatacode");
            Long employeeId = MapUtils.getLong((Map)map, (Object)"employeeid");
            Long depempId = MapUtils.getLong((Map)map, (Object)"depempid");
            if (CollectionUtils.isEmpty((Collection)bizDataMap.get(BizDataUpdateHelper.getKey(bizDataCode, employeeId)))) {
                map.put("success", Boolean.FALSE);
                map.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_4210.getCode());
                map.put("message", BizDataFailStatusEnum.FAILSTATUS_4210.getDesc());
                continue;
            }
            String bizDataStatus = bizDataMap.get(BizDataUpdateHelper.getKey(bizDataCode, employeeId)).get(0).getString("bizdatastatus");
            if (!("1".equals(bizDataStatus) || "4".equals(bizDataStatus) || "7".equals(bizDataStatus))) {
                map.put("success", Boolean.FALSE);
                map.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_4215.getCode());
                map.put("message", BizDataFailStatusEnum.FAILSTATUS_4215.getDesc());
                continue;
            }
            if (SWCObjectUtils.isEmpty((Object)depempMap.get(depempId))) {
                map.put("success", Boolean.FALSE);
                map.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_4213.getCode());
                map.put("message", BizDataFailStatusEnum.FAILSTATUS_4213.getDesc());
                continue;
            }
            if (!employeeId.equals(depempMap.get(depempId).getLong("employee.id"))) {
                map.put("success", Boolean.FALSE);
                map.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_4214.getCode());
                map.put("message", BizDataFailStatusEnum.FAILSTATUS_4214.getDesc());
                continue;
            }
            if (existsCheckPassCodes.contains(bizDataCode)) {
                map.put("success", Boolean.FALSE);
                map.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_4216.getCode());
                map.put("message", BizDataFailStatusEnum.FAILSTATUS_4216.getDesc());
                continue;
            }
            existsCheckPassCodes.add(bizDataCode);
        }
    }

    private void handleBizDataDepemp(List<Map<String, Object>> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        List partitionList = Lists.partition(data, (int)500);
        for (List subList : partitionList) {
            this.updateBizDataDepemp(subList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBizDataDepemp(List<Map<String, Object>> data) {
        try (TXHandle txHandle = TX.requiresNew();){
            ArrayList bizDataCodes = new ArrayList(data.size());
            HashMap dataMap = new HashMap(data.size());
            data.forEach(param -> {
                bizDataCodes.add(MapUtils.getString((Map)param, (Object)"bizdatacode"));
                dataMap.put(MapUtils.getString((Map)param, (Object)"bizdatacode"), MapUtils.getLong((Map)param, (Object)"depempid"));
            });
            SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
            QFilter filter = new QFilter("bizdatacode", "in", bizDataCodes);
            DynamicObject[] bizDataArr = bizDataHelper.query("bizdatacode,depemp.id,bizdatarecord.id", new QFilter[]{filter});
            HashSet<Long> bizDataRecordIds = new HashSet<Long>(16);
            for (DynamicObject bizData : bizDataArr) {
                bizData.set("depemp", dataMap.get(bizData.getString("bizdatacode")));
                if (0L == bizData.getLong("bizdatarecord.id")) continue;
                bizDataRecordIds.add(bizData.getLong("bizdatarecord.id"));
            }
            bizDataHelper.update(bizDataArr);
            if (!CollectionUtils.isEmpty(bizDataRecordIds)) {
                DynamicObject[] bizDataRecordArr;
                SWCDataServiceHelper bizDataRecordHelper = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER;
                QFilter recordFilter = new QFilter("id", "in", bizDataRecordIds);
                for (DynamicObject bizDataRecord : bizDataRecordArr = bizDataRecordHelper.query("bizdatacode, depemp.id", new QFilter[]{recordFilter})) {
                    bizDataRecord.set("depemp", dataMap.get(bizDataRecord.getString("bizdatacode")));
                }
                bizDataRecordHelper.update(bizDataRecordArr);
            }
            txHandle.commit();
        }
    }

    public Map<String, Object> updateBizData(List<Map<String, Object>> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", Boolean.FALSE);
        result.put("data", params);
        if (CollectionUtils.isEmpty(params)) {
            LOGGER.info("Processing data is empty!");
            result.put("message", BizDataFailStatusEnum.FAILSTATUS_0.getDesc());
            return result;
        }
        if (params.size() > 5000) {
            LOGGER.info("Processing data max size is: {}", (Object)5000);
            result.put("message", BizDataFailStatusEnum.FAILSTATUS_0.getDesc());
            return result;
        }
        try {
            this.execute(params);
            result.put("success", Boolean.TRUE);
        }
        catch (Exception exc) {
            LOGGER.error("... BizDataHelper.updateBizData execute exception ...", (Throwable)exc);
            result.put("success", Boolean.FALSE);
            result.put("message", BizDataFailStatusEnum.FAILSTATUS_0.getDesc());
        }
        return result;
    }

    private void execute(List<Map<String, Object>> params) {
        List<Map<String, Object>> successList = this.getVerifyPassData(params);
        List partionList = Lists.partition(successList, (int)500);
        for (List subList : partionList) {
            this.dealBizDataList(subList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealBizDataList(List<Map<String, Object>> params) {
        ArrayList bizDataCodes = new ArrayList(params.size());
        ArrayList hBizDataCodes = new ArrayList(10);
        ArrayList salaryFileIds = new ArrayList(params.size());
        params.forEach(param -> {
            bizDataCodes.add(MapUtils.getString((Map)param, (Object)"bizdatacode"));
            bizDataCodes.add(MapUtils.getString((Map)param, (Object)"operatebizdatacode"));
            if ("2".equals(MapUtils.getString((Map)param, (Object)"modeltype"))) {
                hBizDataCodes.add(MapUtils.getString((Map)param, (Object)"bizdatacode"));
                hBizDataCodes.add(MapUtils.getString((Map)param, (Object)"operatebizdatacode"));
            }
            salaryFileIds.add(MapUtils.getLong((Map)param, (Object)"salaryfile"));
        });
        QFilter filter = new QFilter("bizdatacode", "in", bizDataCodes);
        filter.and("bizdatastatus", "=", (Object)BizDataStatusEnum.PUSHED_SALARY.getCode());
        Object[] bizDataArr = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("id, bizdatacode, bizdatastatus, expirydate, empposorgrel, empposorgrel.adminorg, bizitemgroup, bizdatadim, billtype, applyno, submission, salaryfile, payrollgrp, bizitem.cycle, modifytime, modifier", new QFilter[]{filter});
        if (SWCArrayUtils.isEmpty((Object[])bizDataArr)) {
            return;
        }
        Map<String, List<DynamicObject>> vMap = Arrays.stream(bizDataArr).collect(Collectors.groupingBy(dy -> dy.getString("bizdatacode")));
        QFilter hFilter = new QFilter("bizdatacode", "in", hBizDataCodes);
        DynamicObject[] bizDataRecordArr = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.query("id, bizdatacode, bizdatastatus, expirydate, empposorgrel, empposorgrel.adminorg, bizitemgroup, bizdatadim, applyno, submission, salaryfile, payrollgrp, modifytime, modifier", new QFilter[]{hFilter});
        Map<String, DynamicObject> hMap = Arrays.stream(bizDataRecordArr).collect(Collectors.toMap(dy -> dy.getString("bizdatacode"), dy -> dy, (k1, k2) -> k1));
        QFilter sfFilter = new QFilter("id", "in", salaryFileIds);
        DynamicObject[] salaryFileArr = HPDIDataServiceHelper.HSAS_SALARYFILE_HELPER.query("id,number, payrollgroup", new QFilter[]{sfFilter});
        Map<Long, DynamicObject> sfMap = Arrays.stream(salaryFileArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        ArrayList<DynamicObject> operateLogs = new ArrayList<DynamicObject>(params.size());
        ArrayList<DynamicObject> operateHiss = new ArrayList<DynamicObject>(params.size());
        HashBasedTable statusTable = HashBasedTable.create();
        for (Map<String, Object> param2 : params) {
            this.dealBizData(param2, vMap, hMap, operateLogs, operateHiss, (Table<String, String, String>)statusTable, sfMap);
        }
        LOGGER.info(MessageFormat.format("... operateLogs size: {0}......operateHiss size: {1} ...", operateLogs.size(), operateHiss));
        try (TXHandle txHandle = TX.requiresNew();){
            HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.update((DynamicObject[])bizDataArr);
            HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.update(bizDataRecordArr);
            HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.save(operateLogs.toArray(new DynamicObject[operateLogs.size()]));
            HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.save(operateHiss.toArray(new DynamicObject[operateHiss.size()]));
            BizDataBillEntryHelper.updateTransSalaryStatus((Table<String, String, String>)statusTable);
            this.sendNotificationMessage(MapUtils.getString(params.get(0), (Object)"modeltype"), (Table<String, String, String>)statusTable, bizDataArr[0].getBoolean("bizitem.cycle"));
            txHandle.commit();
        }
    }

    private void dealBizData(Map<String, Object> param, Map<String, List<DynamicObject>> vMap, Map<String, DynamicObject> hMap, List<DynamicObject> operateLogs, List<DynamicObject> operateHiss, Table<String, String, String> statusTable, Map<Long, DynamicObject> sfMap) {
        String modelType = MapUtils.getString(param, (Object)"modeltype");
        String bizDataCode = MapUtils.getString(param, (Object)"bizdatacode");
        String operateBizDataCode = MapUtils.getString(param, (Object)"operatebizdatacode");
        operateBizDataCode = SWCStringUtils.isEmpty((String)operateBizDataCode) ? bizDataCode : operateBizDataCode;
        String bizDataStatus = MapUtils.getString(param, (Object)"status");
        DynamicObject salaryFile = sfMap.get(MapUtils.getLong(param, (Object)"salaryfile"));
        if ("2".equals(modelType)) {
            this.dealBizDataForHorizontal(param, vMap, hMap, operateLogs, statusTable, salaryFile, operateBizDataCode, bizDataStatus);
        } else {
            this.dealBizDataForVertical(param, vMap, operateLogs, operateHiss, statusTable, salaryFile, bizDataCode, operateBizDataCode, bizDataStatus);
        }
    }

    private void dealBizDataForHorizontal(Map<String, Object> param, Map<String, List<DynamicObject>> vMap, Map<String, DynamicObject> hMap, List<DynamicObject> operateLogs, Table<String, String, String> statusTable, DynamicObject salaryFile, String operateBizDataCode, String bizDataStatus) {
        DynamicObject bizDataRecord = hMap.get(operateBizDataCode);
        if (SWCObjectUtils.isEmpty((Object)bizDataRecord)) {
            param.put("success", Boolean.FALSE);
            param.put("message", BizDataFailStatusEnum.FAILSTATUS_0.getDesc());
            LOGGER.error(MessageFormat.format("{0} is not exists!", MapUtils.getString(param, (Object)"bizdatacode")));
            return;
        }
        if (SWCStringUtils.isNotEmpty((String)bizDataStatus) && !bizDataRecord.getString("bizdatastatus").equals(bizDataStatus)) {
            operateLogs.add(this.initBizDataOperateLog(param, bizDataRecord, BizDataUpdateFieldEnum.FIELD_BIZDATASTATUS.getCode(), salaryFile));
            bizDataRecord.set("bizdatastatus", (Object)bizDataStatus);
            List<DynamicObject> bizDatas = vMap.get(operateBizDataCode);
            if (!CollectionUtils.isEmpty(bizDatas)) {
                bizDatas.forEach(dy -> dy.set("bizdatastatus", (Object)bizDataStatus));
            }
            if ("1".equals(bizDataRecord.getString("submission"))) {
                statusTable.put((Object)bizDataRecord.getString("bizdatacode"), (Object)bizDataRecord.getString("applyno"), (Object)bizDataRecord.getString("bizdatastatus"));
            }
        }
        Long salaryFileId = bizDataRecord.getLong("salaryfile.id");
        Long syncSalaryFileId = MapUtils.getLong(param, (Object)"salaryfile");
        if (BizDataOperateEnum.OPERATE_TRANS_SALARYFILE.getCode().equals(MapUtils.getString(param, (Object)"operate")) && !SWCObjectUtils.equals((Object)salaryFileId, (Object)syncSalaryFileId)) {
            operateLogs.add(this.initBizDataOperateLog(param, bizDataRecord, BizDataUpdateFieldEnum.FIELD_SALARYFILE.getCode(), salaryFile));
            DynamicObject payrollGrp = salaryFile.getDynamicObject("payrollgroup");
            bizDataRecord.set("salaryfile", (Object)syncSalaryFileId);
            bizDataRecord.set("payrollgrp", (Object)payrollGrp);
            List<DynamicObject> bizDatas = vMap.get(operateBizDataCode);
            if (!CollectionUtils.isEmpty(bizDatas)) {
                bizDatas.forEach(bizData -> {
                    bizData.set("salaryfile", (Object)syncSalaryFileId);
                    bizData.set("payrollgrp", (Object)payrollGrp);
                });
            }
        }
    }

    private void dealBizDataForVertical(Map<String, Object> param, Map<String, List<DynamicObject>> vMap, List<DynamicObject> operateLogs, List<DynamicObject> operateHiss, Table<String, String, String> statusTable, DynamicObject salaryFile, String bizDataCode, String operateBizDataCode, String bizDataStatus) {
        Date newExpireDate;
        Date oldExpireDate;
        List<DynamicObject> bizDatas = vMap.get(bizDataCode);
        if (CollectionUtils.isEmpty(bizDatas)) {
            param.put("success", Boolean.FALSE);
            param.put("message", BizDataFailStatusEnum.FAILSTATUS_0.getDesc());
            LOGGER.error(MessageFormat.format("{0} is not exists!", MapUtils.getString(param, (Object)"bizdatacode")));
            return;
        }
        param.put("success", Boolean.TRUE);
        List<DynamicObject> stuBizDatas = vMap.get(operateBizDataCode);
        if (!CollectionUtils.isEmpty(stuBizDatas)) {
            for (DynamicObject bizData : stuBizDatas) {
                if (SWCStringUtils.isNotEmpty((String)bizDataStatus) && !bizData.getString("bizdatastatus").equals(bizDataStatus)) {
                    if ("1".equals(bizData.getString("billtype"))) {
                        operateLogs.add(this.initBizDataOperateLog(param, bizData, BizDataUpdateFieldEnum.FIELD_BIZDATASTATUS.getCode(), salaryFile));
                    }
                    bizData.set("bizdatastatus", (Object)bizDataStatus);
                    if ("1".equals(bizData.getString("submission"))) {
                        statusTable.put((Object)bizData.getString("bizdatacode"), (Object)bizData.getString("applyno"), (Object)bizData.getString("bizdatastatus"));
                    }
                }
                Long salaryFileId = bizData.getLong("salaryfile.id");
                Long syncSalaryFileId = MapUtils.getLong(param, (Object)"salaryfile");
                if (!BizDataOperateEnum.OPERATE_TRANS_SALARYFILE.getCode().equals(MapUtils.getString(param, (Object)"operate")) || SWCObjectUtils.equals((Object)salaryFileId, (Object)syncSalaryFileId)) continue;
                if ("1".equals(bizData.getString("billtype"))) {
                    operateLogs.add(this.initBizDataOperateLog(param, bizData, BizDataUpdateFieldEnum.FIELD_SALARYFILE.getCode(), salaryFile));
                }
                DynamicObject payrollGrp = salaryFile.getDynamicObject("payrollgroup");
                bizData.set("salaryfile", (Object)syncSalaryFileId);
                bizData.set("payrollgrp", (Object)payrollGrp);
            }
        }
        DynamicObject bizDataAdd = null;
        for (DynamicObject bizData : bizDatas) {
            if (!"1".equals(bizData.getString("billtype"))) continue;
            bizDataAdd = bizData;
            break;
        }
        if (null != bizDataAdd && !SWCObjectUtils.isEmpty(bizDataAdd) && param.containsKey("bsled") && !SWCDateTimeUtils.dayEqualsWithoutTime((Date)(oldExpireDate = bizDataAdd.getDate("expirydate")), (Date)(newExpireDate = (Date)param.get("bsled")))) {
            operateLogs.add(this.initBizDataOperateLog(param, bizDataAdd, BizDataUpdateFieldEnum.FIELD_EXPIRYDATE.getCode(), salaryFile));
            operateHiss.add(this.initBizDataOperateHis(param, bizDataAdd));
            bizDataAdd.set("expirydate", (Object)newExpireDate);
        }
    }

    private List<Map<String, Object>> getVerifyPassData(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(params.size());
        for (Map<String, Object> param : params) {
            if (!this.checkMustInput(param)) continue;
            successList.add(param);
        }
        return successList;
    }

    private boolean checkMustInput(Map<String, Object> param) {
        String modelType;
        boolean success = true;
        ArrayList<String> messages = new ArrayList<String>(10);
        if (SWCStringUtils.isEmpty((String)MapUtils.getString(param, (Object)"bizdatacode"))) {
            success = false;
            messages.add(BizDataFailStatusEnum.FAILSTATUS_4007.getDesc());
            LOGGER.error("parameter bizdatacode is null");
        }
        if (SWCObjectUtils.isEmpty((Object)param.get("salaryfile"))) {
            success = false;
            messages.add(BizDataFailStatusEnum.FAILSTATUS_0.getDesc());
            LOGGER.error(MessageFormat.format("{0}: parameter salaryfile is null", MapUtils.getString(param, (Object)"bizdatacode")));
        }
        if (SWCStringUtils.isEmpty((String)(modelType = MapUtils.getString(param, (Object)"modeltype")))) {
            success = false;
            messages.add(BizDataFailStatusEnum.FAILSTATUS_0.getDesc());
            LOGGER.error(MessageFormat.format("{0}: parameter modeltype is null", MapUtils.getString(param, (Object)"bizdatacode")));
        }
        if ("1".equals(modelType) && SWCObjectUtils.isEmpty((Object)param.get("bizitem"))) {
            success = false;
            messages.add(BizDataFailStatusEnum.FAILSTATUS_4004.getDesc());
            LOGGER.error(MessageFormat.format("{0}: parameter bizitem is null", MapUtils.getString(param, (Object)"bizdatacode")));
        }
        if (SWCStringUtils.isEmpty((String)MapUtils.getString(param, (Object)"operate"))) {
            success = false;
            messages.add(BizDataFailStatusEnum.FAILSTATUS_0.getDesc());
            LOGGER.error(MessageFormat.format("{0}: parameter operate is null", MapUtils.getString(param, (Object)"bizdatacode")));
        }
        if (!success) {
            param.put("success", Boolean.FALSE);
            param.put("message", messages.stream().collect(Collectors.joining("\uff1b")));
        }
        return success;
    }

    private DynamicObject initBizDataOperateLog(Map<String, Object> param, DynamicObject bizData, String updateField, DynamicObject salaryFile) {
        String modelType = MapUtils.getString(param, (Object)"modeltype");
        DynamicObject operateLog = HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.generateEmptyDynamicObject();
        operateLog.set("dataid", (Object)bizData.getLong("id"));
        operateLog.set("modeltype", (Object)modelType);
        operateLog.set("empposorgrel", (Object)bizData.getDynamicObject("empposorgrel"));
        operateLog.set("salaryfile", (Object)MapUtils.getLong(param, (Object)"salaryfile"));
        operateLog.set("adminorg", (Object)bizData.getDynamicObject("empposorgrel.adminorg"));
        operateLog.set("bizitemgroup", (Object)bizData.getDynamicObject("bizitemgroup"));
        if ("1".equals(modelType)) {
            operateLog.set("bizitem", (Object)MapUtils.getLong(param, (Object)"bizitem"));
        }
        operateLog.set("bizdatadim", (Object)bizData.getDynamicObject("bizdatadim"));
        operateLog.set("operatetype", (Object)MapUtils.getString(param, (Object)"operate"));
        operateLog.set("description", (Object)MapUtils.getString(param, (Object)"description"));
        operateLog.set("updatefield", (Object)updateField);
        String beforeUpdate = null;
        String afterUpdate = null;
        if (BizDataUpdateFieldEnum.FIELD_BIZDATASTATUS.getCode().equals(updateField)) {
            beforeUpdate = BizDataStatusEnum.getDesc((String)bizData.getString("bizdatastatus"));
            afterUpdate = BizDataStatusEnum.getDesc((String)MapUtils.getString(param, (Object)"status"));
            operateLog.set("bizdatacode", (Object)bizData.getString("bizdatacode"));
        } else if (BizDataUpdateFieldEnum.FIELD_EXPIRYDATE.getCode().equals(updateField)) {
            beforeUpdate = null == bizData.getDate("expirydate") ? null : SWCDateTimeUtils.formatDate((Date)bizData.getDate("expirydate"));
            afterUpdate = null == param.get("bsled") ? null : SWCDateTimeUtils.formatDate((Date)((Date)param.get("bsled")));
            operateLog.set("bizdatacode", (Object)MapUtils.getString(param, (Object)"bizdatacode"));
            operateLog.set("operatebizdatacode", (Object)MapUtils.getString(param, (Object)"operatebizdatacode"));
        } else if (BizDataUpdateFieldEnum.FIELD_SALARYFILE.getCode().equals(updateField)) {
            beforeUpdate = bizData.getString("salaryfile.number");
            afterUpdate = salaryFile.getString("number");
            operateLog.set("bizdatacode", (Object)bizData.getString("bizdatacode"));
        }
        operateLog.set("beforeupdate", (Object)beforeUpdate);
        operateLog.set("afterupdate", (Object)afterUpdate);
        Object modifier = param.getOrDefault("modifier", RequestContext.get().getCurrUserId());
        operateLog.set("modifier", modifier);
        return operateLog;
    }

    private DynamicObject initBizDataOperateHis(Map<String, Object> param, DynamicObject bizData) {
        DynamicObject operateHis = HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.generateEmptyDynamicObject();
        operateHis.set("empposorgrel", (Object)bizData.getDynamicObject("empposorgrel"));
        operateHis.set("bizitem", (Object)MapUtils.getLong(param, (Object)"bizitem"));
        operateHis.set("currentbizdatacode", (Object)MapUtils.getString(param, (Object)"bizdatacode"));
        operateHis.set("operatebizdatacode", (Object)MapUtils.getString(param, (Object)"operatebizdatacode"));
        operateHis.set("beforupdatedate", (Object)bizData.getDate("expirydate"));
        Date afterUpdateDate = (Date)param.get("bsled");
        operateHis.set("afterupdatedate", (Object)afterUpdateDate);
        operateHis.set("operatetype", (Object)MapUtils.getString(param, (Object)"operate"));
        operateHis.set("operater", param.getOrDefault("modifier", RequestContext.get().getCurrUserId()));
        operateHis.set("operatetime", (Object)new Date());
        operateHis.set("bizdata", (Object)bizData.getLong("id"));
        return operateHis;
    }

    private void sendNotificationMessage(String modelType, Table<String, String, String> statusTable, boolean isCycle) {
        if (statusTable.isEmpty()) {
            return;
        }
        Collection statusList = statusTable.values();
        String status = statusList.stream().findFirst().orElse("");
        if (!BizDataStatusEnum.SALARY_REJECT.getCode().equals(status) && !BizDataStatusEnum.HSAS_DISABLED.getCode().equals(status)) {
            return;
        }
        String type = "2".equals(modelType) ? "horizontal" : (isCycle ? "circlepage" : "notcirclepage");
        Set billNoSet = statusTable.columnKeySet();
        QFilter filter = new QFilter("billno", "in", (Object)billNoSet);
        Object[] bizDataBillArr = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.query("bizitemgroup, creator", new QFilter[]{filter});
        if (SWCArrayUtils.isEmpty((Object[])bizDataBillArr)) {
            return;
        }
        HashMap<Long, Set<String>> infoMap = new HashMap<Long, Set<String>>(16);
        for (Object dy : bizDataBillArr) {
            HashSet<String> bizItemGroupNames = (HashSet<String>)infoMap.get(dy.getLong("creator.id"));
            if (null == bizItemGroupNames) {
                bizItemGroupNames = new HashSet<String>(16);
                infoMap.put(dy.getLong("creator.id"), bizItemGroupNames);
            }
            bizItemGroupNames.add(dy.getString("bizitemgroup.name"));
        }
        Long bizItemGroupId = bizDataBillArr[0].getLong("bizitemgroup.id");
        BizDataMessageHelper.sendMessageOfRejectOrDiscard(status, type, infoMap, bizItemGroupId);
    }

    static {
        RESERVED_FIELD.add("success");
        RESERVED_FIELD.add("errorcode");
        RESERVED_FIELD.add("message");
        RESERVED_FIELD.add("bizdatacode");
    }
}

