/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.DataSyncHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CloudCollaMultiBizAppUpdateHelper {
    private static final int batchSize = 5000;

    public static CloudCollaMultiBizAppUpdateHelper getInstance() {
        return Load.INSTANCE;
    }

    private CloudCollaMultiBizAppUpdateHelper() {
    }

    public void execute() {
        this.updateTaskCollaApp();
        CloudCollaMultiBizAppUpdateHelper.updateVerifyTask();
    }

    private static void updateVerifyTask() {
        DataSyncHelper.build().add(new DataSyncHelper.SourceSetting(DBRoute.of((String)"hpdi")).selectFields("fpkid, fid, fbasedataid").querySQL("select 0 as fpkid,t.fid as fid,t.ftaskcenterid as fbasedataid from t_hpdi_summaryvbill t where ftaskcenterid  != 0").afterQuery(maps -> {
            long[] ids = DB.genLongIds((String)"t_hpdi_vermultaskcenter", (int)maps.size());
            for (int i = 0; i < maps.size(); ++i) {
                ((Map)maps.get(i)).put("fpkid", ids[i]);
            }
            return maps;
        }), new DataSyncHelper.TargetSetting(DBRoute.of((String)"hpdi")).insertFields("fpkid, fid, fbasedataid").fromTable("t_hpdi_vermultaskcenter").diffMode("fid, fbasedataid")).add(new DataSyncHelper.SourceSetting(DBRoute.of((String)"hpdi")).selectFields("fpkid, fid, fbasedataid").querySQL("select 0 as fpkid, t.fid as fid,t.fcollataskid as fbasedataid from t_hpdi_summaryvbill t where fcollataskid != 0").afterQuery(maps -> {
            long[] ids = DB.genLongIds((String)"t_hpdi_vermulcollatask", (int)maps.size());
            for (int i = 0; i < maps.size(); ++i) {
                ((Map)maps.get(i)).put("fpkid", ids[i]);
            }
            return maps;
        }), new DataSyncHelper.TargetSetting(DBRoute.of((String)"hpdi")).insertFields("fpkid, fid, fbasedataid").fromTable("t_hpdi_vermulcollatask").diffMode("fid, fbasedataid")).execute();
    }

    private void updateTaskCollaApp() {
        Map tplAppMap = (Map)DB.query((DBRoute)DBRoute.of((String)"swc"), (String)"SELECT FID,FBIZAPPID FROM T_HSBS_PAYROLLACTGTPL", resultSet -> {
            HashMap<Long, String> result = new HashMap<Long, String>(16);
            while (resultSet.next()) {
                long tplId = resultSet.getLong("FID");
                String bizAppId = resultSet.getString("FBIZAPPID");
                if (SWCStringUtils.isEmpty((String)bizAppId)) continue;
                result.put(tplId, bizAppId);
            }
            return result;
        });
        HashBasedTable tplShowTable = HashBasedTable.create();
        ImmutableList configList = ImmutableList.of((Object)ImmutableMap.of((Object)"hpdi_collarulesal", (Object)"t_hpdi_collarulesal"), (Object)ImmutableMap.of((Object)"hpdi_collarulecdm", (Object)"t_hpdi_collarulecdm"), (Object)ImmutableMap.of((Object)"hpdi_collaruletax", (Object)"t_hpdi_collaruletax"), (Object)ImmutableMap.of((Object)"hpdi_collarulecsi", (Object)"t_hpdi_collarulecsi"));
        for (Map config : configList) {
            Optional any = config.entrySet().stream().findAny();
            any.ifPresent(arg_0 -> this.lambda$updateTaskCollaApp$3((Table)tplShowTable, tplAppMap, arg_0));
        }
        this.updateTaskApp((Table<Long, String, String>)tplShowTable, "T_HPDI_COLLATASK", "T_HPDI_COLLATASKENT", "T_HPDI_COLLATASKAPP");
        this.updateTaskApp((Table<Long, String, String>)tplShowTable, "T_HPDI_TASKCENTER", "T_HPDI_TASKCENTERENT", "T_HPDI_TASKCENTERAPP");
        this.addVerifyApp((Table<Long, String, String>)tplShowTable);
    }

    private void addVerifyApp(Table<Long, String, String> tplShowTable) {
        DB.query((DBRoute)DBRoute.of((String)"hpdi"), (String)"SELECT t.FID,ent.FCOLLARULEVCLASS,ent.FCOLLARULEVID FROM T_HPDI_SUMMARYVBILL t LEFT JOIN T_HPDI_SUMVBCRENT ent on t.FID = ent.FID WHERE ent.FID IS NOT NULL", resultSet -> {
            LinkedHashMap<Long, Set<String>> tempParam = new LinkedHashMap<Long, Set<String>>(16);
            int count = 0;
            while (resultSet.next()) {
                long taskId = resultSet.getLong("FID");
                String crClass = resultSet.getString("FCOLLARULEVCLASS");
                long crId = resultSet.getLong("FCOLLARULEVID");
                if (crId == 0L) continue;
                String bizApp = (String)tplShowTable.get((Object)crId, (Object)crClass);
                if (SWCStringUtils.isEmpty((String)crClass) || SWCStringUtils.isEmpty((String)bizApp)) continue;
                Set tmpSet = tempParam.computeIfAbsent(taskId, item -> new HashSet(16));
                tmpSet.add(bizApp);
                if (++count < 5000) continue;
                this.insertVerifyAppData(tempParam);
                tempParam.clear();
                count = 0;
            }
            this.insertVerifyAppData(tempParam);
            return null;
        });
    }

    private void insertVerifyAppData(Map<Long, Set<String>> tempParam) {
        if (CollectionUtils.isEmpty(tempParam)) {
            return;
        }
        String idStr = tempParam.keySet().stream().map(String::valueOf).collect(Collectors.joining(","));
        String sql = String.format(Locale.ROOT, "SELECT t.FID,t.FBASEDATAID from T_HPDI_SUMVBILLAPP t WHERE t.FID IN (%s);", idStr);
        Set queryKey = (Set)DB.query((DBRoute)DBRoute.of((String)"hpdi"), (String)sql, resultSet -> {
            HashSet<String> keySet = new HashSet<String>(tempParam.size() * 2);
            while (resultSet.next()) {
                long fid = resultSet.getLong("FID");
                String baseDataId = resultSet.getString("FBASEDATAID");
                keySet.add(fid + "#" + baseDataId);
            }
            return keySet;
        });
        ArrayList param = new ArrayList(10);
        long[] ids = DB.genLongIds((String)"T_HPDI_COLLATASKAPP", (int)5000);
        AtomicInteger index = new AtomicInteger(0);
        tempParam.forEach((key, valueSet) -> {
            for (String value : valueSet) {
                if (queryKey.contains(key + "#" + value)) continue;
                param.add(new Object[]{ids[index.getAndIncrement()], key, value});
            }
        });
        if (CollectionUtils.isEmpty(param)) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"hpdi"), (String)"INSERT INTO T_HPDI_SUMVBILLAPP(FPKID,FID,FBASEDATAID) VALUES (?,?,?)", param);
    }

    private void updateTaskApp(Table<Long, String, String> tplShowTable, String tableName, String entTableName, String appTableName) {
        DB.query((DBRoute)DBRoute.of((String)"hpdi"), (String)String.format("SELECT t.FID,ent.FCOLLARULECLASS,ent.FCOLLARULEVID,ent.FCOLLARULEID from %s t left join %s ent on t.FID = ent.FID;", tableName, entTableName), resultSet -> {
            LinkedHashMap<Long, Set<String>> tempParam = new LinkedHashMap<Long, Set<String>>(16);
            int count = 0;
            while (resultSet.next()) {
                long taskId = resultSet.getLong("FID");
                String crClass = resultSet.getString("FCOLLARULECLASS");
                long crId = resultSet.getLong("FCOLLARULEVID");
                if (crId == 0L) {
                    crId = resultSet.getLong("FCOLLARULEID");
                }
                String bizApp = (String)tplShowTable.get((Object)crId, (Object)crClass);
                if (SWCStringUtils.isEmpty((String)crClass) || SWCStringUtils.isEmpty((String)bizApp)) continue;
                Set tmpSet = tempParam.computeIfAbsent(taskId, item -> new HashSet(16));
                tmpSet.add(bizApp);
                if (++count < 5000) continue;
                this.insertData(tempParam, appTableName);
                tempParam.clear();
                count = 0;
            }
            this.insertData(tempParam, appTableName);
            return null;
        });
    }

    private void insertData(Map<Long, Set<String>> insertParam, String appTableName) {
        if (CollectionUtils.isEmpty(insertParam)) {
            return;
        }
        String idStr = insertParam.keySet().stream().map(String::valueOf).collect(Collectors.joining(","));
        String sql = String.format("SELECT t.FID,t.FBASEDATAID from %s t WHERE t.FID IN (%s);", appTableName, idStr);
        Set queryKey = (Set)DB.query((DBRoute)DBRoute.of((String)"hpdi"), (String)sql, resultSet -> {
            HashSet<String> keySet = new HashSet<String>(insertParam.size() * 2);
            while (resultSet.next()) {
                long fid = resultSet.getLong("FID");
                String baseDataId = resultSet.getString("FBASEDATAID");
                keySet.add(fid + "#" + baseDataId);
            }
            return keySet;
        });
        ArrayList param = new ArrayList(10);
        long[] ids = DB.genLongIds((String)"T_HPDI_COLLATASKAPP", (int)5000);
        AtomicInteger index = new AtomicInteger(0);
        insertParam.forEach((key, valueSet) -> {
            for (String value : valueSet) {
                if (queryKey.contains(key + "#" + value)) continue;
                param.add(new Object[]{ids[index.getAndIncrement()], key, value});
            }
        });
        if (CollectionUtils.isEmpty(param)) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"hpdi"), (String)String.format(Locale.ROOT, "insert into %s(fpkid,fid,fbasedataid) values (?,?,?)", appTableName), param);
    }

    private Table<Long, String, String> queryCollaRule(String crClass, String table, Map<Long, String> tplAppMap) {
        String formatSql = String.format(Locale.ROOT, "SELECT t.FID, t.FPAYROLLACTGTPLID FROM %s t;", table);
        return (Table)DB.query((DBRoute)DBRoute.of((String)"hpdi"), (String)formatSql, resultSet -> {
            HashBasedTable tempTable = HashBasedTable.create();
            while (resultSet.next()) {
                long fid = resultSet.getLong("FID");
                long tplId = resultSet.getLong("FPAYROLLACTGTPLID");
                String bizAppId = (String)tplAppMap.get(tplId);
                if (!SWCStringUtils.isNotEmpty((String)bizAppId)) continue;
                tempTable.put((Object)fid, (Object)crClass, (Object)bizAppId);
            }
            return tempTable;
        });
    }

    private /* synthetic */ void lambda$updateTaskCollaApp$3(Table tplShowTable, Map tplAppMap, Map.Entry item) {
        tplShowTable.putAll(this.queryCollaRule((String)item.getKey(), (String)item.getValue(), tplAppMap));
    }

    static class Load {
        private static final CloudCollaMultiBizAppUpdateHelper INSTANCE = new CloudCollaMultiBizAppUpdateHelper();

        Load() {
        }
    }
}

