/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import java.sql.ResultSetMetaData;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DataSyncHelper {
    private static final Log LOGGER = LogFactory.getLog(DataSyncHelper.class);
    private List<SettingGroup> settingGroups;

    private DataSyncHelper() {
    }

    private DataSyncHelper(List<SettingGroup> settingGroup) {
        this.settingGroups = settingGroup;
    }

    public static DataSyncHelper build() {
        ArrayList<SettingGroup> settingGroups = new ArrayList<SettingGroup>(10);
        return new DataSyncHelper(settingGroups);
    }

    public DataSyncHelper add(@NotNull SourceSetting sourceSetting, @NotNull TargetSetting targetSetting) {
        this.settingGroups.add(new SettingGroup(sourceSetting, targetSetting));
        return this;
    }

    private DataSyncHelper query() {
        for (SettingGroup settingGroup : this.settingGroups) {
            SourceSetting sourceSetting = settingGroup.getSourceSetting();
            DataSyncEntity entity = settingGroup.getEntity();
            List sourceData = (List)SWCDbUtil.query((DBRoute)sourceSetting.getDbRoute(), (String)sourceSetting.buildSQL(), null, resultSet -> {
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columnCount = metaData.getColumnCount();
                ArrayList<String> nameSet = new ArrayList<String>(16);
                for (int i = 1; i <= columnCount; ++i) {
                    nameSet.add(metaData.getColumnName(i).toLowerCase(Locale.ROOT));
                }
                ArrayList result = new ArrayList(10);
                while (resultSet.next()) {
                    LinkedHashMap<String, Object> tempMap = new LinkedHashMap<String, Object>(columnCount * 2);
                    for (String name : nameSet) {
                        tempMap.put(name, resultSet.getObject(name));
                    }
                    result.add(tempMap);
                }
                return result;
            });
            entity.setQueryResult(sourceData);
        }
        return this;
    }

    private DataSyncHelper afterQuery() {
        for (SettingGroup settingGroup : this.settingGroups) {
            SourceSetting sourceSetting = settingGroup.getSourceSetting();
            DataSyncEntity entity = settingGroup.getEntity();
            Function afterQueryFunction = sourceSetting.getAfterQueryFunction();
            List afterQuery = afterQueryFunction == null ? entity.getQueryResult() : (List)afterQueryFunction.apply(entity.getQueryResult());
            entity.setAfterQueryResult(afterQuery);
        }
        return this;
    }

    public void execute() {
        this.validate();
        this.query().afterQuery().insert();
    }

    private void validate() {
        Assert.notEmpty(this.settingGroups, (String)"settingGroups can not bu null.");
        for (int i = 0; i < this.settingGroups.size(); ++i) {
            SettingGroup settingGroup = this.settingGroups.get(i);
            SourceSetting sourceSetting = settingGroup.getSourceSetting();
            TargetSetting targetSetting = settingGroup.getTargetSetting();
            Assert.notNull((Object)sourceSetting, (String)("settingGroups " + i + " element sourceSetting can not be null."));
            Assert.notNull((Object)targetSetting, (String)("settingGroups " + i + " element targetSetting can not be null."));
            sourceSetting.validate();
            targetSetting.validate();
        }
    }

    private List<Object[]> beforeInsert(TargetSetting targetSetting, List<Object[]> insertParams) {
        BiFunction<List, List, List> beforeInsertFunction = targetSetting.getBeforeInsertFunction();
        if (beforeInsertFunction == null) {
            beforeInsertFunction = (fields, maps) -> maps;
        }
        return beforeInsertFunction.apply(targetSetting.getInsertFields(), insertParams);
    }

    private void insert() {
        try (TXHandle required = TX.required();){
            try {
                for (SettingGroup settingGroup : this.settingGroups) {
                    TargetSetting targetSetting = settingGroup.getTargetSetting();
                    List insertParams = settingGroup.getEntity().getInsertParams(targetSetting);
                    if (CollectionUtils.isEmpty((Collection)insertParams)) continue;
                    List<Object[]> objects = this.beforeInsert(targetSetting, insertParams);
                    SWCDbUtil.executeBatch((DBRoute)targetSetting.getDbRoute(), (String)targetSetting.buildSQL(), objects);
                }
            }
            catch (Exception ex) {
                LOGGER.info("insert data error.", (Object)ex);
                required.markRollback();
                throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
            }
        }
    }

    public static class TargetSetting {
        private DBRoute dbRoute;
        private String table;
        private List<String> insertFields;
        private BiFunction<List<String>, List<Object[]>, List<Object[]>> beforeInsertFunction;
        private String insertType = "all";
        private List<String> uniqueIndex;

        private String getInsertType() {
            return this.insertType;
        }

        private List<String> getUniqueIndex() {
            return this.uniqueIndex;
        }

        private TargetSetting() {
        }

        public TargetSetting(DBRoute route) {
            this.dbRoute = route;
        }

        private DBRoute getDbRoute() {
            return this.dbRoute;
        }

        public TargetSetting beforeInsert(BiFunction<List<String>, List<Object[]>, List<Object[]>> beforeInsertFunction) {
            this.beforeInsertFunction = beforeInsertFunction;
            return this;
        }

        private String getTable() {
            return this.table;
        }

        private List<String> getInsertFields() {
            return this.insertFields;
        }

        public TargetSetting fromTable(String table) {
            this.table = table;
            return this;
        }

        public TargetSetting route(DBRoute dbRoute) {
            this.dbRoute = dbRoute;
            return this;
        }

        public TargetSetting diffMode(String uniqueIndex) {
            Assert.notNull((Object)uniqueIndex);
            String[] split = uniqueIndex.trim().split(",");
            this.uniqueIndex = Arrays.stream(split).filter(SWCStringUtils::isNotEmpty).map(item -> item.trim().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
            this.insertType = "diff";
            return this;
        }

        private String buildSQL() {
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO ").append(this.table).append("(").append(this.insertFields.stream().collect(Collectors.joining(","))).append(")").append("VALUES(").append(this.insertFields.stream().map(item -> "?").collect(Collectors.joining(","))).append(");");
            return sql.toString();
        }

        public TargetSetting insertFields(String selectFields) {
            Assert.isTrue((!SWCStringUtils.isEmpty((String)selectFields) ? 1 : 0) != 0, (String)"selectFields can not be null.");
            this.insertFields = Arrays.stream(selectFields.trim().split(",")).map(item -> item.trim().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
            return this;
        }

        private BiFunction<List<String>, List<Object[]>, List<Object[]>> getBeforeInsertFunction() {
            return this.beforeInsertFunction;
        }

        private void validate() {
            Assert.notNull((Object)this.dbRoute, (String)"TargetSetting dbRoute can not be null.");
            Assert.notNull((Object)this.table, (String)"TargetSetting table can not be null.");
            Assert.notEmpty(this.insertFields, (String)"TargetSetting insertFields can not be null.");
            if ("diff".equalsIgnoreCase(this.insertType)) {
                Assert.isTrue((!CollectionUtils.isEmpty(this.uniqueIndex) ? 1 : 0) != 0, (String)"insertType is diff, the TargetSetting uniqueIndex can not be empty.");
            }
        }
    }

    public static class SourceSetting {
        private DBRoute dbRoute;
        private String table;
        private List<String> selectFields;
        private String condition = "1 = 1";
        private String querySQL;
        private Function<List<Map<String, Object>>, List<Map<String, Object>>> afterQueryFunction;

        private DBRoute getDbRoute() {
            return this.dbRoute;
        }

        private String getTable() {
            return this.table;
        }

        private List<String> getSelectFields() {
            return this.selectFields;
        }

        private String getCondition() {
            return this.condition;
        }

        public SourceSetting fromTable(String table) {
            this.table = table;
            return this;
        }

        public SourceSetting querySQL(String querySQL) {
            this.querySQL = querySQL;
            return this;
        }

        public SourceSetting where(String condition) {
            this.condition = condition;
            return this;
        }

        public SourceSetting route(DBRoute dbRoute) {
            this.dbRoute = dbRoute;
            return this;
        }

        public SourceSetting selectFields(String selectFields) {
            if (SWCStringUtils.isEmpty((String)selectFields)) {
                throw new NullPointerException("selectFields can not be null.");
            }
            this.selectFields = Arrays.stream(selectFields.trim().split(",")).map(item -> item.trim().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
            return this;
        }

        public SourceSetting afterQuery(Function<List<Map<String, Object>>, List<Map<String, Object>>> afterQueryFunction) {
            this.afterQueryFunction = afterQueryFunction;
            return this;
        }

        private String buildSQL() {
            if (!SWCStringUtils.isEmpty((String)this.querySQL)) {
                return this.querySQL;
            }
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ").append(this.selectFields.stream().collect(Collectors.joining(","))).append(" FROM ").append(this.table).append(" WHERE ").append(this.condition);
            return sql.toString();
        }

        private void validate() {
            Assert.notNull((Object)this.dbRoute, (String)"SourceSetting dbRoute can not be null.");
            if (SWCStringUtils.isEmpty((String)this.querySQL)) {
                Assert.notNull((Object)this.table, (String)"SourceSetting table can not be null.");
                Assert.notEmpty(this.selectFields, (String)"SourceSetting selectFields can not be null.");
            }
        }

        private SourceSetting() {
        }

        public SourceSetting(DBRoute route) {
            this.dbRoute = route;
        }

        private Function<List<Map<String, Object>>, List<Map<String, Object>>> getAfterQueryFunction() {
            return this.afterQueryFunction;
        }
    }

    public static class SettingGroup {
        private DataSyncEntity entity;
        private SourceSetting sourceSetting;
        private TargetSetting targetSetting;

        private SourceSetting getSourceSetting() {
            return this.sourceSetting;
        }

        private void setSourceSetting(SourceSetting sourceSetting) {
            this.sourceSetting = sourceSetting;
        }

        private TargetSetting getTargetSetting() {
            return this.targetSetting;
        }

        private void setTargetSetting(TargetSetting targetSetting) {
            this.targetSetting = targetSetting;
        }

        private void setEntity(DataSyncEntity entity) {
            this.entity = entity;
        }

        private DataSyncEntity getEntity() {
            return this.entity;
        }

        private SettingGroup() {
        }

        private SettingGroup(SourceSetting sourceSetting, TargetSetting targetSetting) {
            this.sourceSetting = sourceSetting;
            this.targetSetting = targetSetting;
            this.entity = new DataSyncEntity();
        }
    }

    private static class DataSyncEntity {
        private List<Map<String, Object>> queryResult;
        private List<Map<String, Object>> afterQueryResult;

        DataSyncEntity() {
        }

        private List<Map<String, Object>> getQueryResult() {
            return this.queryResult;
        }

        private void setQueryResult(List<Map<String, Object>> queryResult) {
            this.queryResult = queryResult;
        }

        private List<Object[]> getInsertParams(TargetSetting targetSetting) {
            String insertType = targetSetting.getInsertType();
            Set diffKeySet = Collections.emptySet();
            List uniqueIndex = targetSetting.getUniqueIndex();
            if ("diff".equalsIgnoreCase(insertType)) {
                diffKeySet = (Set)SWCDbUtil.query((DBRoute)targetSetting.getDbRoute(), (String)MessageFormat.format("SELECT {0} FROM {1}", String.join((CharSequence)",", uniqueIndex), targetSetting.getTable()), null, resultSet -> {
                    HashSet<String> result = new HashSet<String>(16);
                    while (resultSet.next()) {
                        ArrayList<String> tempKey = new ArrayList<String>(10);
                        for (String index : uniqueIndex) {
                            tempKey.add(resultSet.getString(index));
                        }
                        if (CollectionUtils.isEmpty(tempKey)) continue;
                        result.add(String.join((CharSequence)"_", tempKey));
                    }
                    return result;
                });
            }
            List insertFields = targetSetting.getInsertFields();
            List<Map<String, Object>> queryResult = this.getAfterQueryResult();
            ArrayList<Object[]> result = new ArrayList<Object[]>(queryResult.size() * 2);
            for (Map<String, Object> objectMap : queryResult) {
                String tempKey = uniqueIndex.stream().map(item -> String.valueOf(objectMap.get(item))).collect(Collectors.joining("_"));
                if (!diffKeySet.add(tempKey)) continue;
                result.add(insertFields.stream().map(objectMap::get).toArray());
            }
            return result;
        }

        private List<Map<String, Object>> getAfterQueryResult() {
            return this.afterQueryResult;
        }

        private void setAfterQueryResult(List<Map<String, Object>> afterQueryResult) {
            this.afterQueryResult = afterQueryResult;
        }
    }
}

