/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.InteTimeZone;
import kd.hr.hbp.business.openservicehelper.hrpi.HRPIReviseLogServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.swc.hpdi.business.service.IEmpInfoReviseTask;
import kd.swc.hpdi.business.service.impl.EmpInfoReviseExtImpl;
import kd.swc.hpdi.business.service.impl.EmpInfoReviseSyncPersonImpl;
import kd.swc.hpdi.business.service.impl.EmpInfoReviseTaxFileTaskImpl;
import kd.swc.hpdi.common.entity.ResponseDTO;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class EmpInfoReviseHelper {
    private static final Log LOGGER = LogFactory.getLog(EmpInfoReviseHelper.class);

    public static EmpInfoReviseHelper getInstance() {
        return Load.INSTANCE;
    }

    private EmpInfoReviseHelper() {
    }

    public HRMServiceResult consumerSaveMsg(DynamicObject msgCenter) {
        String msgContent = msgCenter.getString("msgcontent");
        long msgCenterId = msgCenter.getLong("msgcenterbo");
        try {
            EmpInfoReviseHelper.getInstance().parseAndSaveMsg(msgContent, this.calReviseLogObject(msgCenterId));
        }
        catch (Exception ex) {
            LOGGER.info("[revise] consumerSaveMsg error.", (Object)ex);
            return HRMServiceResult.fail((String)ex.getMessage());
        }
        RequestContext requestContext = RequestContext.get();
        SWCThreadPoolFactory.getTaskCenterCreateThreadPool().execute(() -> {
            RequestContext.copyAndSet((RequestContext)requestContext);
            this.runEmpInfoReviseTask(msgCenterId);
        });
        return HRMServiceResult.success();
    }

    private void runEmpInfoReviseTask(long reviseLogId) {
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper("hpdi_empreviselog");
        DynamicObject logObject = logHelper.queryOne("id,msgtype,person,employee.empnumber,errormsg,msgconsumestatus", (Object)reviseLogId);
        if (logObject == null) {
            LOGGER.info("[revise] runEmpInfoReviseTask query, logObject is null.");
            return;
        }
        Map<Long, Map<String, Object>> longMapMap = this.queryReviseFieldDetailMapByLogId(reviseLogId);
        ArrayList<String> errorList = new ArrayList<String>(10);
        List<IEmpInfoReviseTask> taskList = this.getTaskList();
        boolean isSuccess = true;
        String msgType = logObject.getString("msgtype");
        ImmutableMap param = ImmutableMap.of((Object)"reviseLogId", (Object)logObject.getLong("id"), (Object)"personId", (Object)logObject.getLong("person.id"), (Object)"employeeId", (Object)logObject.getLong("employee.id"), (Object)"empNumber", (Object)logObject.getString("employee.empnumber"), (Object)"reviseDetails", this.convertDetails(longMapMap));
        for (IEmpInfoReviseTask task : taskList) {
            try {
                ResponseDTO<String> execute = task.execute(msgType, (Map<String, Object>)param);
                if (execute.isSuccess()) continue;
                errorList.add(execute.getErrorMsg());
                isSuccess = false;
            }
            catch (Exception ex) {
                LOGGER.info("[revise] run {} error.", (Object)task.getClass().getName());
                errorList.add(ex.getMessage());
                isSuccess = false;
            }
        }
        if (!isSuccess) {
            logObject.set("errormsg", (Object)errorList.stream().collect(Collectors.joining(System.lineSeparator())));
        }
        logObject.set("msgconsumestatus", (Object)(isSuccess ? "B" : "A"));
        logHelper.saveOne(logObject);
    }

    private List<Map<String, Object>> convertDetails(Map<Long, Map<String, Object>> sourceDetails) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isEmpty(sourceDetails)) {
            return result;
        }
        sourceDetails.forEach((boId, dataMap) -> {
            HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
            tempMap.put("reviseType", MapUtils.getString((Map)dataMap, (Object)"_$revisetype"));
            tempMap.put("reviseBeforeId", MapUtils.getLong((Map)dataMap, (Object)"_$revisebeforeid"));
            tempMap.put("reviseBoId", MapUtils.getLong((Map)dataMap, (Object)"_$reviseboid"));
            tempMap.put("reviseAfterId", MapUtils.getLong((Map)dataMap, (Object)"_$reviseafterid"));
            tempMap.put("entityNumber", MapUtils.getString((Map)dataMap, (Object)"_$entitynumber"));
            result.add(tempMap);
        });
        return result;
    }

    private List<IEmpInfoReviseTask> getTaskList() {
        return ImmutableList.of((Object)new EmpInfoReviseSyncPersonImpl(), (Object)new EmpInfoReviseTaxFileTaskImpl(), (Object)new EmpInfoReviseExtImpl());
    }

    private Function<List<DynamicObject>, List<DynamicObject>> calReviseLogObject(Long msgCenterId) {
        return inputs -> {
            if (CollectionUtils.isEmpty((Collection)inputs)) {
                return Collections.emptyList();
            }
            HashMap<Long, DynamicObject> tempMap = new HashMap<Long, DynamicObject>(16);
            SWCDataServiceHelper logHelper = new SWCDataServiceHelper("hpdi_empreviselog");
            ArrayList<Long> employeeIds = new ArrayList<Long>(10);
            Date receiveTime = new Date();
            for (DynamicObject dynamicObject : inputs) {
                if (msgCenterId == null || msgCenterId == 0L) {
                    LOGGER.info("[revise] calReviseLogObject msgcenter.id is null, revisebo ={}", dynamicObject.get("revisebo"));
                    continue;
                }
                dynamicObject.set("msgcenter", (Object)msgCenterId);
                if (tempMap.containsKey(msgCenterId)) continue;
                Long personId = (Long)this.getObjectId(dynamicObject, "person");
                Long employeeId = (Long)this.getObjectId(dynamicObject, "employee");
                DynamicObject logObject = logHelper.generateEmptyDynamicObject();
                logObject.set("msgcenter", (Object)msgCenterId);
                logObject.set("msgtype", (Object)dynamicObject.getString("revisenumber"));
                logObject.set("employee", (Object)employeeId);
                logObject.set("person", (Object)personId);
                logObject.set("receivetime", (Object)receiveTime);
                logObject.set("processstatus", (Object)"A");
                logObject.set("id", (Object)msgCenterId);
                tempMap.put(msgCenterId, logObject);
                employeeIds.add(employeeId);
            }
            Map<Long, Long> adminOrgMap = EmpInfoReviseHelper.getInstance().queryAdminOrg(employeeIds);
            tempMap.forEach((mcId, object) -> object.set("adminorg", (Object)MapUtils.getLong((Map)adminOrgMap, (Object)object.getLong("employee"))));
            return new ArrayList(tempMap.values());
        };
    }

    private void parseAndSaveMsg(String msgContent, Function<List<DynamicObject>, List<DynamicObject>> dataMethod) {
        if (SWCStringUtils.isEmpty((String)msgContent)) {
            return;
        }
        Map msgMap = (Map)SerializationUtils.deSerializeFromBase64((String)msgContent);
        String entityNumber = MapUtils.getString((Map)msgMap, (Object)"entityNumber");
        List reviseList = (List)MapUtils.getObject((Map)msgMap, (Object)"reviserecordList", Collections.emptyList());
        LOGGER.info("[revise] parseAndSaveMsg entityNumber ={},reviseList={} ", (Object)entityNumber, (Object)reviseList);
        Map<String, Object> reviseResult = this.queryAndCompareReviseLog(entityNumber, reviseList);
        LOGGER.info("[revise] parseAndSaveMsg IReviseRecordService.queryAndCompareReviseLog result ={}", (Object)JSON.toJSONString(reviseResult));
        if (!MapUtils.getBoolean(reviseResult, (Object)"success", (Boolean)Boolean.FALSE).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4fee\u8ba2\u8be6\u60c5\u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{0}\u3002", (String)"EmpInfoReviseHelper_0", (String)"swc-hpdi-business", (Object[])new Object[]{MapUtils.getString(reviseResult, (Object)"message")}));
        }
        Map data = (Map)MapUtils.getObject(reviseResult, (Object)"data");
        List detObjects = HRPIReviseLogServiceHelper.generateReviseLogDynList((String)"hpdi_emprevisedet", (Map)data);
        List<DynamicObject> saveObjects = dataMethod.apply(detObjects);
        LOGGER.info("[revise] before saveReviseLogDyn saveObjects.size ={}", (Object)saveObjects.size());
        try (TXHandle txHandle = TX.requiresNew();){
            HRPIReviseLogServiceHelper.saveReviseLogDyn((List)detObjects);
            new SWCDataServiceHelper("hpdi_empreviselog").save(saveObjects.toArray(new DynamicObject[0]));
        }
    }

    private Map<String, Object> queryAndCompareReviseLog(String entityNumber, List<Long> reviseList) {
        return (Map)SWCMServiceUtils.invokeHRService((String)"hspm", (String)"IReviseRecordService", (String)"queryAndCompareReviseLog", (Object[])new Object[]{entityNumber, reviseList});
    }

    public long queryPendingCount() {
        List auth = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_empreviselog", (String)"47150e89000000ac");
        if (auth == null) {
            return 0L;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hpdi_empreviselog");
        QFilter qFilter = new QFilter("processstatus", "=", (Object)"A");
        if (!CollectionUtils.isEmpty((Collection)auth)) {
            auth.add(qFilter);
            return helper.count(auth.toArray(new QFilter[0]));
        }
        return helper.count(new QFilter[]{qFilter});
    }

    private Map<Long, Long> queryAdminOrg(List<Long> employeeIds) {
        if (CollectionUtils.isEmpty(employeeIds)) {
            return Collections.emptyMap();
        }
        DynamicObject[] empPosOrgRels = this.queryEmpPosOrgRel(employeeIds);
        HashMap<Long, DynamicObject> tempMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject empPosOrgRel : empPosOrgRels) {
            long employeeId = empPosOrgRel.getLong("employee.id");
            tempMap.compute(employeeId, (key, exist) -> {
                if (exist == null) {
                    return empPosOrgRel;
                }
                String newBizStatus = empPosOrgRel.getString("businessstatus");
                String existBuzStatus = exist.getString("businessstatus");
                Date startdate = empPosOrgRel.getDate("startdate");
                Date existStartDate = exist.getDate("startdate");
                String newIsPrimary = empPosOrgRel.getString("isprimary");
                String existIsPrimary = exist.getString("isprimary");
                if (!"1".equals(newIsPrimary) && "1".equals(existIsPrimary)) {
                    return exist;
                }
                if ("1".equals(newIsPrimary) && !"1".equals(existIsPrimary)) {
                    return empPosOrgRel;
                }
                if ("1".equals(newBizStatus) && !"1".equals(existBuzStatus)) {
                    return empPosOrgRel;
                }
                if (!"1".equals(newBizStatus) && "1".equals(existBuzStatus)) {
                    return exist;
                }
                return SWCDateTimeUtils.dayAfter((Date)startdate, (Date)existStartDate) ? empPosOrgRel : exist;
            });
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        tempMap.forEach((empId, empPosOrgObject) -> result.put((Long)empId, empPosOrgObject.getLong("adminorg.id")));
        return result;
    }

    private DynamicObject[] queryEmpPosOrgRel(List<Long> employeeIdList) {
        SWCDataServiceHelper empPosOrgRel = new SWCDataServiceHelper("hrpi_empposorgrel");
        return empPosOrgRel.query("id,boid,islatestrecord,businessstatus,adminorg,isprimary,employee.id,startdate,enddate,datastatus,description", new QFilter[]{new QFilter("employee.id", "in", employeeIdList), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1"), new QFilter("initstatus", "=", (Object)"2")});
    }

    private <T> T getObjectId(DynamicObject object, String fieldName) {
        if (object == null) {
            throw new IllegalArgumentException("param object is null");
        }
        Object value = object.get(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof DynamicObject) {
            return (T)((DynamicObject)value).get("id");
        }
        return (T)value;
    }

    public DynamicObject queryReviseLogByLogId(Long id) {
        SWCDataServiceHelper detHelper = new SWCDataServiceHelper("hpdi_empreviselog");
        return detHelper.queryOriginalOne("id,msgtype,msgcenter.id,msgcenter.params,employee.id", (Object)id);
    }

    public DynamicObject[] queryReviseDetByLogId(List<Long> idList) {
        SWCDataServiceHelper detHelper = new SWCDataServiceHelper("hpdi_emprevisedet");
        return detHelper.queryOriginalArray("id,revisetype,revisenumber,msgcenter.id,revisebo,revisebefore,reviseafter", new QFilter[]{new QFilter("msgcenter.id", "in", idList)});
    }

    public Map<Long, String> generateAbstract(List<Long> logIdList) {
        DynamicObject[] detObjects = this.queryReviseDetByLogId(logIdList);
        if (detObjects == null || detObjects.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, List> empPosOrgRelMap = new HashMap<Long, List>(16);
        ArrayList<Long> otherIdList = new ArrayList<Long>(10);
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(16);
        for (DynamicObject detObject : detObjects) {
            String reviseNumebr = detObject.getString("revisenumber");
            long ctId = detObject.getLong("msgcenter.id");
            long detId2 = detObject.getLong("id");
            if ("hrpi_empposorgrel".equalsIgnoreCase(reviseNumebr)) {
                List tempList = empPosOrgRelMap.computeIfAbsent(ctId, item -> new ArrayList(10));
                tempList.add(detObject);
                continue;
            }
            otherIdList.add(detId2);
            idMap.put(detId2, ctId);
        }
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        Map queryResult = HRPIReviseLogServiceHelper.queryAbstractByIdList((String)"hpdi_emprevisedet", otherIdList);
        if (!CollectionUtils.isEmpty((Map)queryResult)) {
            queryResult.forEach((detId, msg) -> {
                Long logId = (Long)idMap.get(detId);
                result.put(logId, (String)msg);
            });
        }
        if (CollectionUtils.isEmpty(empPosOrgRelMap)) {
            return result;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hpdi_emprevisedet");
        ComboProp property = (ComboProp)dataEntityType.getProperty("revisetype");
        List comboItems = property.getComboItems();
        HashMap<String, String> comboNameMap = new HashMap<String, String>(16);
        for (ValueMapItem comboItem : comboItems) {
            String value = comboItem.getValue();
            String name = comboItem.getName().getLocaleValue();
            comboNameMap.put(value, name);
        }
        empPosOrgRelMap.forEach((id, objectList) -> {
            if (CollectionUtils.isEmpty((Collection)objectList)) {
                return;
            }
            HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
            for (DynamicObject tempObj : objectList) {
                String type2 = tempObj.getString("revisetype");
                countMap.compute(type2, (key, exist) -> {
                    if (exist == null) {
                        return 1;
                    }
                    exist = exist + 1;
                    return exist;
                });
            }
            if (CollectionUtils.isEmpty(countMap)) {
                return;
            }
            ArrayList reviseMsg = new ArrayList(10);
            countMap.forEach((type, count) -> reviseMsg.add(ResManager.loadKDString((String)"{0}\u4efb\u804c\u7ecf\u5386 {1}", (String)"EmpInfoReviseHelper_1", (String)"swc-hpdi-business", (Object[])new Object[]{comboNameMap.get(type), count})));
            result.put((Long)id, reviseMsg.stream().collect(Collectors.joining(System.lineSeparator())));
        });
        return result;
    }

    public Map<Long, Map<String, Object>> queryReviseFieldDetailMapByLogId(Long reviseLogId) {
        DynamicObject dynamicObject = this.queryReviseLogByLogId(reviseLogId);
        if (dynamicObject == null) {
            return Collections.emptyMap();
        }
        String msgContent = dynamicObject.getString("msgcenter.params");
        return this.queryReviseFieldDetailMapByMsgContent(msgContent);
    }

    private Map<Long, Map<String, Object>> queryReviseFieldDetailMapByMsgContent(String msgContent) {
        if (SWCStringUtils.isEmpty((String)msgContent)) {
            return Collections.emptyMap();
        }
        Map msgMap = (Map)SerializationUtils.deSerializeFromBase64((String)msgContent);
        String entityNumber = MapUtils.getString((Map)msgMap, (Object)"entityNumber");
        List reviseList = (List)MapUtils.getObject((Map)msgMap, (Object)"reviserecordList", Collections.emptyList());
        ResponseDTO<Map<String, Object>> mapResponseDTO = this.queryReviseFieldDetail(entityNumber, reviseList);
        return this.getReviseDetailMap((Map)mapResponseDTO.getResult());
    }

    public Set<String> queryHrReviseFieldsByLogId(Long reviseLogId) {
        Map<Long, Map<String, Object>> result = this.queryReviseFieldDetailMapByLogId(reviseLogId);
        return this.getAllReviseFields(result);
    }

    public Set<String> queryHrReviseFieldsByDetId(Long reviseDetId) {
        Map<Long, Map<String, Object>> result = this.queryReviseFieldDetailMapByDetId(reviseDetId);
        return this.getAllReviseFields(result);
    }

    public Set<String> getAllReviseFields(Map<Long, Map<String, Object>> result) {
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptySet();
        }
        HashSet<String> fields = new HashSet<String>(16);
        result.forEach((boId, dataMap) -> fields.addAll((Set)MapUtils.getObject((Map)dataMap, (Object)"reviseFields", Collections.emptySet())));
        return fields;
    }

    public Map<Long, Map<String, Object>> queryReviseFieldDetailMapByDetId(Long reviseDetId) {
        SWCDataServiceHelper detHelper = new SWCDataServiceHelper("hpdi_emprevisedet");
        DynamicObject detObject = detHelper.queryOriginalOne("id,msgcenter.params", (Object)reviseDetId);
        if (detObject == null) {
            return Collections.emptyMap();
        }
        String msgContent = detObject.getString("msgcenter.params");
        return this.queryReviseFieldDetailMapByMsgContent(msgContent);
    }

    private ResponseDTO<Map<String, Object>> queryReviseFieldDetail(String entityNumber, List<Long> idList) {
        try {
            Map<String, Object> result = this.queryAndCompareReviseLog(entityNumber, idList);
            return new ResponseDTO("200", (Object)MapUtils.getMap(result, (Object)"data", Collections.emptyMap()), null);
        }
        catch (Exception ex) {
            LOGGER.info("[revise] queryReviseFieldDetail error.", (Object)ex);
            return new ResponseDTO("500", null, ex.getMessage());
        }
    }

    public Object getObjectValue(DynamicObject object, IDataEntityProperty property) {
        Object value = property.getValue((Object)object);
        if (value == null) {
            return null;
        }
        if (property instanceof BasedataProp) {
            return ((DynamicObject)value).getString("id");
        }
        return this.getDisplayValueByProp(object, property);
    }

    public Map<Long, Long> queryReviseDetMap(long reviseId) {
        DynamicObject[] dynamicObjects = this.queryReviseDetByLogId(Collections.singletonList(reviseId));
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long detId = dynamicObject.getLong("id");
            long boId = dynamicObject.getLong("revisebo");
            result.put(boId, detId);
        }
        return result;
    }

    private Map<Long, Map<String, Object>> getReviseDetailMap(Map<String, Object> reviseResult) {
        if (CollectionUtils.isEmpty(reviseResult)) {
            return Collections.emptyMap();
        }
        List reviseBoList = (List)MapUtils.getObject(reviseResult, (Object)"reviseBoList");
        if (CollectionUtils.isEmpty((Collection)reviseBoList)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(16);
        String entityNumber = MapUtils.getString(reviseResult, (Object)"entityNumber");
        for (Map reviseBoMap : reviseBoList) {
            List reviseLogList = (List)MapUtils.getObject((Map)reviseBoMap, (Object)"reviseLogList");
            if (CollectionUtils.isEmpty((Collection)reviseLogList)) continue;
            Long reviseBo = MapUtils.getLong((Map)reviseBoMap, (Object)"reviseBo");
            Map tempResult = result.computeIfAbsent(reviseBo, item -> new HashMap());
            List reviseDescList = (List)tempResult.computeIfAbsent("reviseDesc", item -> new ArrayList(10));
            List reviseReasonList = (List)tempResult.computeIfAbsent("reviseReason", item -> new ArrayList(10));
            Set reviseFields = (Set)tempResult.computeIfAbsent("reviseFields", item -> new HashSet(16));
            Table reviseShowValueTable = (Table)tempResult.computeIfAbsent("reviseShowValue", item -> HashBasedTable.create());
            for (Map reviseLog : reviseLogList) {
                tempResult.put("_$revisetype", MapUtils.getString((Map)reviseLog, (Object)"reviseType"));
                tempResult.put("_$revisebeforeid", MapUtils.getLong((Map)reviseLog, (Object)"reviseBefore"));
                tempResult.put("_$reviseboid", MapUtils.getLong((Map)reviseLog, (Object)"reviseBo"));
                tempResult.put("_$reviseafterid", MapUtils.getLong((Map)reviseLog, (Object)"reviseAfter"));
                tempResult.put("_$entitynumber", entityNumber);
                reviseDescList.addAll(this.getReviseDesc(reviseLog));
                reviseReasonList.addAll(this.getReviseReason(reviseLog));
                reviseFields.addAll(this.getReviseField(reviseLog));
                reviseShowValueTable.putAll(this.getReviseShowName(reviseLog));
            }
        }
        return result;
    }

    private Table<String, String, String> getReviseShowName(Map<String, Object> reviseLog) {
        HashBasedTable result = HashBasedTable.create();
        if (CollectionUtils.isEmpty(reviseLog)) {
            return result;
        }
        List reviseCompareLogList = (List)MapUtils.getObject(reviseLog, (Object)"reviseCompareLogList", Collections.emptyList());
        if (CollectionUtils.isEmpty((Collection)reviseCompareLogList)) {
            return result;
        }
        for (Map dataMap : reviseCompareLogList) {
            String reviseField = MapUtils.getString((Map)dataMap, (Object)"reviseField");
            if (SWCStringUtils.isEmpty((String)reviseField)) continue;
            result.put((Object)reviseField, (Object)"reviseBefore", (Object)MapUtils.getString((Map)dataMap, (Object)"reviseValBefore", (String)""));
            result.put((Object)reviseField, (Object)"reviseAfter", (Object)MapUtils.getString((Map)dataMap, (Object)"reviseValAfter", (String)""));
        }
        return result;
    }

    private List<String> getReviseField(Map<String, Object> reviseLog) {
        List reviseCompareLogList = (List)MapUtils.getObject(reviseLog, (Object)"reviseCompareLogList", Collections.emptyList());
        return reviseCompareLogList.stream().map(item -> MapUtils.getString((Map)item, (Object)"reviseField")).filter(item -> SWCStringUtils.isNotEmpty((String)item)).collect(Collectors.toList());
    }

    private List<String> getReviseReason(Map<String, Object> reviseLog) {
        List reviseReasonList = (List)MapUtils.getObject(reviseLog, (Object)"reviseReason", Collections.emptyList());
        return reviseReasonList.stream().map(item -> MapUtils.getString((Map)item, (Object)"name")).collect(Collectors.toList());
    }

    private List<String> getReviseDesc(Map<String, Object> reviseLog) {
        return (List)MapUtils.getObject(reviseLog, (Object)"reviseDesc", Collections.emptyList());
    }

    public String getDisplayValueByProp(DynamicObject dyn, IDataEntityProperty prop) {
        if (prop == null) {
            return null;
        }
        String propName = prop.getName();
        if (prop instanceof MuliLangTextProp) {
            ILocaleString val = dyn.getLocaleString(propName);
            return val.getLocaleValue();
        }
        if (prop instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)prop;
            if (dyn != null) {
                return comboProp.getItemByName(dyn.getString(propName));
            }
        } else if (prop instanceof BasedataProp) {
            DynamicObject propValue;
            BasedataProp basedataProp = (BasedataProp)prop;
            if (dyn != null && (propValue = dyn.getDynamicObject(propName)) != null) {
                return propValue.getString(basedataProp.getDisplayProp());
            }
        } else {
            if (prop instanceof MulBasedataProp) {
                return dyn.getDynamicObjectCollection(prop).stream().map(dy -> dy.getString("fbasedataid.name")).collect(Collectors.joining(","));
            }
            if (prop instanceof DateProp) {
                if (dyn != null) {
                    if (dyn.getDate(propName) == null) {
                        return null;
                    }
                    String mask = ((DateTimeProp)prop).getMask();
                    if (SWCStringUtils.isEmpty((String)mask)) {
                        mask = "yyyy-MM-dd";
                    }
                    return SWCDateTimeUtils.format((Date)dyn.getDate(propName), (String)mask);
                }
            } else if (prop instanceof DateTimeProp) {
                if (dyn != null) {
                    if (dyn.getDate(propName) == null) {
                        return null;
                    }
                    String mask = ((DateTimeProp)prop).getMask();
                    InteTimeZone timeZone = ((DateTimeProp)prop).getTimeZone(null);
                    return SWCDateTimeUtils.format((Date)dyn.getDate(propName), (String)mask, (TimeZone)timeZone.getTimeZone());
                }
            } else if (prop instanceof IntegerProp) {
                if (dyn != null) {
                    return dyn.getString(propName);
                }
            } else {
                if (prop instanceof DecimalProp) {
                    return dyn.getString(propName).substring(0, dyn.getString(propName).lastIndexOf(46) + 2);
                }
                if (prop instanceof BooleanProp) {
                    Boolean value = (Boolean)prop.getValue((Object)dyn);
                    if (value.booleanValue()) {
                        return ResManager.loadKDString((String)"\u662f", (String)"EmpInfoReviseHelper_2", (String)"swc-hpdi-business", (Object[])new Object[0]);
                    }
                    return ResManager.loadKDString((String)"\u5426", (String)"EmpInfoReviseHelper_3", (String)"swc-hpdi-business", (Object[])new Object[0]);
                }
            }
        }
        if (dyn != null) {
            return dyn.getString(propName);
        }
        return null;
    }

    static class Load {
        private static final EmpInfoReviseHelper INSTANCE = new EmpInfoReviseHelper();

        Load() {
        }
    }
}

