/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hpdi.business.helper.DataSyncHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class FieldRuleUpdateHelper {
    private static final Log LOGGER = LogFactory.getLog(FieldRuleUpdateHelper.class);
    private static final DBRoute ROUTE_SWC = DBRoute.of((String)"swc");
    private static final DBRoute ROUTE_HPDI = DBRoute.of((String)"hpdi");
    private static final String FIELD_RULE = "fid,fnumber,fsceneid,forgid, fname,fpayrollactid,ftriggercollaid,fpolicyid,fentrytype,ffieldkey,ffieldname,fstatus,fenable,fctrlstrategy,fcreateorgid,fuseorgid,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fdisablerid,fdisabledate,fmasterid";
    private static final String FIELD_RULE_QUERY_SQL = "select distinct t.fnumber,t.fsceneid,t.forgid, t.fname,rd.fpolicyid  as fid,rd.fpolicyid, tr.fentityobjectid, t.fcreatetime,t.fmodifytime,t.fdisabledate,rd.fpolicyid as fmasterid,rd.fpayrollactid,rd.ftriggercollaid,tr.fentityobjectid,rd.fpolicyid, rd.ffieldkey,'C' as fstatus,'1' as fenable,t.fctrlstrategy,t.fcreateorgid,t.fuseorgid, '1' as fentrytype from t_hsas_payrollactg t \nleft join t_hsas_payrollactgent ent on t.fid = ent.fid \nleft join t_hsas_actgfruledetail rd on rd.fentryid = ent.fentryid \nleft join t_hsas_triggercolla tr on rd.ftriggercollaid = tr.fid\nleft join t_hsas_actgfmapdetail md on md.fentryid = ent.fentryid\nwhere rd.fdetailid is not null and rd.fpolicyid is not null";
    private static final String FIELD_RULE_U = "fdataid,fcreateorgid,fuseorgid";
    private static final String FIELD_RULE_U_QUERY_SQL = "select distinct rd.fpolicyid as fdataid, u.fcreateorgid,u.fuseorgid from t_hsas_payrollactg t \nleft join t_hsas_payrollactgent ent on t.fid = ent.fid \nleft join t_hsas_payrollactg_u u on t.fboid = u.fdataid\nleft join t_hsas_actgfruledetail rd on rd.fentryid = ent.fentryid\nwhere rd.fdetailid is not null and rd.fpolicyid is not null and u.fuseorgid is not null";
    private static final String FIELD_RULE_L = "fpkid,fid,flocaleid,fname,fsimplename,fdescription,ffieldname";
    private static final String FIELD_RULE_L_QUERY_SQL = "select fid,'zh_CN' as flocaleid,fname ,fsimplename ,fdescription,ffieldname from t_hpdi_fieldrule";
    private static final String FIELD_RULE_REG_FIELDS = "fuseorgid, fdataid, fcreateorgid, fadminorgid, fctrlstrategy, fisassign, fassignorgid, fmasterid";
    private static final String FIELD_RULE_REG_QUERY_SQL = "select distinct u.fuseorgid,rd.fpolicyid as fdataid,u.fcreateorgid,u.fadminorgid ,u.fctrlstrategy ,u.fisassign ,u.fassignorgid ,u.fmasterid  from t_hsas_payrollactg t \nleft join t_hsas_payrollactgent ent on t.fid = ent.fid \nleft join t_hsas_payrollactgusereg u on t.fboid = u.fdataid\nleft join t_hsas_actgfruledetail rd on rd.fentryid = ent.fentryid\nwhere rd.fdetailid is not null and rd.fpolicyid is not null and u.fuseorgid is not null";

    public void update() {
        this.initFieldRule();
    }

    private void initFieldRule() {
        DataSyncHelper.build().add(new DataSyncHelper.SourceSetting(ROUTE_SWC).querySQL(FIELD_RULE_QUERY_SQL).afterQuery(this.afterFieldRuleQuery()), new DataSyncHelper.TargetSetting(ROUTE_HPDI).insertFields(FIELD_RULE).fromTable("t_hpdi_fieldrule").beforeInsert(this.beforeInsertFieldRule()).diffMode("fid")).add(new DataSyncHelper.SourceSetting(ROUTE_SWC).selectFields(FIELD_RULE_U).fromTable("t_hsas_payrollactg_u").querySQL(FIELD_RULE_U_QUERY_SQL), new DataSyncHelper.TargetSetting(ROUTE_HPDI).insertFields(FIELD_RULE_U).fromTable("t_hpdi_fieldrule_u").diffMode("fdataid,fuseorgid")).add(new DataSyncHelper.SourceSetting(ROUTE_SWC).selectFields(FIELD_RULE_REG_FIELDS).fromTable("t_hsas_payrollactgusereg").querySQL(FIELD_RULE_REG_QUERY_SQL), new DataSyncHelper.TargetSetting(ROUTE_HPDI).insertFields(FIELD_RULE_REG_FIELDS).fromTable("t_hpdi_fieldruleusereg").diffMode("fdataid,fuseorgid")).execute();
        DataSyncHelper.build().add(new DataSyncHelper.SourceSetting(ROUTE_HPDI).querySQL(FIELD_RULE_L_QUERY_SQL).afterQuery(this.afterQueryFieldRuleL()), new DataSyncHelper.TargetSetting(ROUTE_HPDI).insertFields(FIELD_RULE_L).fromTable("t_hpdi_fieldrule_l").diffMode("fid,flocaleid")).execute();
    }

    private Function<List<Map<String, Object>>, List<Map<String, Object>>> afterFieldRuleQuery() {
        return maps -> {
            ArrayList tempList = new ArrayList(10);
            Set<Long> enabledPolicyId = this.getAllEnabledPolicyIdSet();
            Map<String, String> triggerExeParamNameMap = this.getTriggerExeParamNameMap();
            Map<String, String> triggerObjectNameMap = this.getTriggerObjectNameMap();
            for (Map map : maps) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
                tempMap.putAll(map);
                Long policyId = MapUtils.getLong((Map)map, (Object)"fpolicyid");
                tempMap.put("fenable", enabledPolicyId.contains(policyId));
                String name = MapUtils.getString((Map)map, (Object)"fname");
                String number = MapUtils.getString((Map)map, (Object)"fnumber");
                if (number == null || name == null) continue;
                String fieldKey = MapUtils.getString((Map)map, (Object)"ffieldkey");
                String entityObjectId = MapUtils.getString((Map)map, (Object)"fentityobjectid");
                String nameKey = String.join((CharSequence)".", entityObjectId, fieldKey);
                String objectFieldName = triggerObjectNameMap.get(nameKey);
                String exeParamName = triggerExeParamNameMap.get(nameKey);
                String fieldName = null;
                tempMap.put("fentrytype", "1");
                if (SWCStringUtils.isNotEmpty((String)exeParamName)) {
                    fieldName = exeParamName;
                    tempMap.put("fentrytype", "2");
                }
                if (SWCStringUtils.isNotEmpty((String)objectFieldName)) {
                    fieldName = objectFieldName;
                }
                tempMap.put("ffieldname", SWCStringUtils.isEmpty((String)fieldName) ? fieldKey : fieldName);
                tempMap.put("fnumber", number);
                tempMap.put("fname", name);
                tempMap.put("fcreatorid", 1L);
                tempMap.put("fmodifierid", 1L);
                tempMap.put("fdisablerid", 1L);
                tempList.add(tempMap);
            }
            return tempList;
        };
    }

    private BiFunction<List<String>, List<Object[]>, List<Object[]>> beforeInsertFieldRule() {
        return (fields, items) -> {
            int nameInd = fields.indexOf("fname");
            int numberInd = fields.indexOf("fnumber");
            String[] index = PayRollActGrpHelper.newFieldRuleNumbers("hpdi_collarulesal", "$INIT$", items.size());
            for (int i = 0; i < items.size(); ++i) {
                Object[] item = (Object[])items.get(i);
                String newNumber = item[numberInd] + "_I" + index[i];
                String newName = item[nameInd] + "_I" + index[i];
                item[numberInd] = newNumber.length() > 59 ? UUID.randomUUID() : newNumber;
                item[nameInd] = newName.length() > 99 ? UUID.randomUUID() : newName;
            }
            return items;
        };
    }

    private Function<List<Map<String, Object>>, List<Map<String, Object>>> afterQueryFieldRuleL() {
        return maps -> {
            String[] ids = DB.genStringIds((String)"t_hpdi_fieldrule_l", (int)maps.size());
            for (int i = 0; i < maps.size(); ++i) {
                ((Map)maps.get(i)).put("fpkid", ids[i]);
            }
            return maps;
        };
    }

    private Map<String, String> getTriggerExeParamNameMap() {
        String exeParamSQL = "select distinct t.fentityobjectid,ent.fpfieldkey,ent.fpfieldname from t_hsas_triggercolla t \nleft join t_hsas_colexeparament ent on t.fid = ent.fid\nwhere ent.fpfieldkey is not null and t.fentityobjectid is not null and t.fismustfieldmapping != '1'";
        return (Map)SWCDbUtil.query((DBRoute)ROUTE_SWC, (String)exeParamSQL, null, resultSet -> {
            HashMap<String, String> result = new HashMap<String, String>(16);
            while (resultSet.next()) {
                String objectNumber = resultSet.getString("fentityobjectid");
                String fieldKey = resultSet.getString("fpfieldkey");
                String fieldName = resultSet.getString("fpfieldname");
                result.put(String.join((CharSequence)".", objectNumber, fieldKey), fieldName);
            }
            return result;
        });
    }

    private Map<String, String> getTriggerObjectNameMap() {
        String paramSQL = "select distinct t.fentityobjectid,ent.ffieldkey from t_hsas_triggercolla t \nleft join t_hsbs_collaparament ent on t.fid = ent.fid\nwhere ent.ffieldkey is not null and t.fentityobjectid is not null and t.fismustfieldmapping != '1' order by t.fentityobjectid DESC";
        HashMap typeMap = new HashMap(16);
        return (Map)SWCDbUtil.query((DBRoute)ROUTE_SWC, (String)paramSQL, null, resultSet -> {
            HashMap<String, String> result = new HashMap<String, String>(16);
            while (resultSet.next()) {
                String objectNumber = resultSet.getString("fentityobjectid");
                String fieldKey = resultSet.getString("ffieldkey");
                MainEntityType mainEntityType = typeMap.computeIfAbsent(objectNumber, item -> EntityMetadataCache.getDataEntityType((String)objectNumber));
                DynamicProperty property = mainEntityType.getProperty(fieldKey);
                String fieldName = property.getDisplayName().getLocaleValue();
                result.put(String.join((CharSequence)".", objectNumber, fieldKey), fieldName);
            }
            return result;
        });
    }

    private Set<Long> getAllEnabledPolicyIdSet() {
        String querySQL = "select distinct rd.fpolicyid \nfrom t_hsas_payrollactg t \nleft join t_hsas_payrollactgent ent on t.fid = ent.fid \nleft join t_hsas_actgfruledetail rd on rd.fentryid = ent.fentryid \nwhere rd.fpolicyid is not null and rd.fdetailid is not null and t.fiscurrentversion  = '1' and t.fenable  = '1' and t.fstatus = 'C'";
        return (Set)SWCDbUtil.query((DBRoute)ROUTE_SWC, (String)querySQL, null, resultSet -> {
            HashSet<Long> result = new HashSet<Long>(16);
            while (resultSet.next()) {
                result.add(resultSet.getLong("fpolicyid"));
            }
            return result;
        });
    }
}

