/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class TaskRuleUpdateSceneHelper {
    public static TaskRuleUpdateSceneHelper getInstance() {
        return Load.INSTANCE;
    }

    private TaskRuleUpdateSceneHelper() {
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) {
        SWCDataServiceHelper orm = new SWCDataServiceHelper("hpdi_taskrule");
        DynamicObject[] query = orm.query("id,scene.id,payrollactg.id", new QFilter[]{new QFilter("scene.id", "=", (Object)0L)});
        if (query == null || (long)query.length == 0L) {
            return;
        }
        ArrayList<Long> payRollActGIdList = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : query) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            for (DynamicObject entry : entryEntity) {
                long payRollActGId = entry.getLong("payrollactg.id");
                if (payRollActGId == 0L) continue;
                payRollActGIdList.add(payRollActGId);
            }
        }
        SWCDataServiceHelper actgOrm = new SWCDataServiceHelper("hsas_payrollactg");
        DynamicObject[] payRollActObject = actgOrm.query("id,scene.id", new QFilter[]{new QFilter("id", "in", payRollActGIdList)});
        if (payRollActObject == null || (long)payRollActObject.length == 0L) {
            return;
        }
        Map<Long, Long> actSceneIdMap = Arrays.stream(payRollActObject).collect(Collectors.toMap(key -> key.getLong("id"), value -> value.getLong("scene.id"), (first, second) -> second));
        ArrayList<DynamicObject> saveObject = new ArrayList<DynamicObject>(10);
        block2: for (DynamicObject dynamicObject : query) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            for (DynamicObject entry : entryEntity) {
                Long sceneId;
                long payRollActGId = entry.getLong("payrollactg.id");
                if (payRollActGId == 0L || (sceneId = actSceneIdMap.get(payRollActGId)) == null || sceneId == 0L) continue;
                dynamicObject.set("scene", (Object)sceneId);
                saveObject.add(dynamicObject);
                continue block2;
            }
        }
        orm.save(saveObject.toArray(new DynamicObject[0]));
    }

    static class Load {
        private static TaskRuleUpdateSceneHelper INSTANCE = new TaskRuleUpdateSceneHelper();

        Load() {
        }
    }
}

