/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.msgreceive;

import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.swc.hpdi.business.basedata.SubApiSettingHelper;
import kd.swc.hpdi.business.basedata.TaskRuleHelper;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.factory.DataTransformServiceFactory;
import kd.swc.hpdi.business.msgreceive.DataSyncMsgHelper;
import kd.swc.hpdi.business.msgreceive.HPDICollaMsgServiceHelper;
import kd.swc.hpdi.business.msgreceive.TaskCenterCreateAsyncHelper;
import kd.swc.hpdi.business.service.DynamicObjectDataConvertService;
import kd.swc.hpdi.business.service.IDataConvertService;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.CollaResultEntity;
import kd.swc.hpdi.common.entity.CoreHRMessageContentEntity;
import kd.swc.hsbp.business.cloudcolla.verify.VerifyBillDataService;
import kd.swc.hsbp.business.cloudcolla.verify.event.IVerifyBillListener;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class CollaMsgVerifyBillHelper {
    private static final Log LOGGER = LogFactory.getLog(CollaMsgVerifyBillHelper.class);

    private CollaMsgVerifyBillHelper() {
    }

    public static CollaMsgVerifyBillHelper getInstance() {
        return Load.INSTANCE;
    }

    @Deprecated
    public boolean isNeedVerified(DynamicObject taskRule) {
        Assert.notNull((Object)taskRule);
        DynamicObjectCollection entryEntity = taskRule.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return true;
        }
        for (DynamicObject entry : entryEntity) {
            if (!entry.getBoolean("ismanualverify")) continue;
            return true;
        }
        return false;
    }

    public Map<Long, String> getTaskVerifyConfig(DynamicObject taskRule) {
        Assert.notNull((Object)taskRule);
        DynamicObjectCollection entryEntity = taskRule.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        for (DynamicObject entry : entryEntity) {
            if (!entry.getBoolean("ismanualverify")) continue;
            String verifyNumber = entry.getString("verifynumber");
            long crId = entry.getLong("collarule.id");
            if (SWCStringUtils.isEmpty((String)verifyNumber)) {
                verifyNumber = "$default";
            }
            result.put(crId, verifyNumber);
        }
        return result;
    }

    public Map<String, Object> generateVerifyBill(DynamicObject taskRule, DynamicObject msgReceiveObject, CoreHRMessageContentEntity msgEntity, DynamicObject bu, int executeSeq) {
        Assert.notNull((Object)taskRule);
        Assert.notNull((Object)msgReceiveObject);
        Assert.notNull((Object)bu);
        String buNumber = bu.getString("number");
        String msgSubNo = msgReceiveObject.getString("msgsubno");
        Map<String, Object> paramMapByMsgSubNo = SubApiSettingHelper.getInstance().getParamMapByMsgSubNo(msgSubNo);
        HPDICollaMsgServiceHelper collaHelper = HPDICollaMsgServiceHelper.getInstance();
        Map<String, List<Map<String, Object>>> apiResultData = collaHelper.getSubMsgApiData(msgSubNo, msgEntity, paramMapByMsgSubNo);
        Map<String, Object> convertedApiResultData = collaHelper.apiResultProcessing(collaHelper.convertResultData(apiResultData, paramMapByMsgSubNo), msgEntity, paramMapByMsgSubNo.getOrDefault("apiIdNumberMap", Collections.emptyMap()));
        HashMap<String, Object> paramMap = CollaMsgVerifyBillHelper.getRequestParam(msgEntity, buNumber);
        Map<String, Object> ruleEngineResult = collaHelper.callCollaRule(convertedApiResultData, paramMap, this.getVerifyCollaRuleIds(taskRule));
        Map<String, Object> taskRuleVerifyRangeResult = collaHelper.getTaskRuleVerifyRangeResult(convertedApiResultData, paramMap, taskRule);
        Map<String, Object> calVerifyResult = TaskRuleHelper.getInstance().isAllVerifyAndExePreError(taskRule, ruleEngineResult, taskRuleVerifyRangeResult);
        Boolean success = (Boolean)calVerifyResult.get("success");
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (!success.booleanValue()) {
            result.put("success", Boolean.FALSE);
            result.put("msg", calVerifyResult.get("msg"));
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("executeSeq", executeSeq);
        param.put("apiResultData", apiResultData);
        param.put("apiIdNumberMap", paramMapByMsgSubNo.get("apiIdNumberMap"));
        param.put("calVerifyResult", calVerifyResult.get("data"));
        List<DynamicObject> verifyBills = this.convertToVerifyBillData(taskRule, msgReceiveObject, msgEntity, bu, param);
        ArrayList resultDatas = new ArrayList(10);
        Set calVerifyResultData = (Set)calVerifyResult.get("data");
        for (DynamicObject verifyBill : verifyBills) {
            HashMap<String, Object> resultData = new HashMap<String, Object>(16);
            resultData.put("verifyBill", verifyBill);
            resultData.put("ruleEngineData", this.calRuleEnginResultData((Map)ruleEngineResult.get("data"), calVerifyResultData));
            resultDatas.add(resultData);
        }
        result.put("data", resultDatas);
        String resultCode = (String)calVerifyResult.get("code");
        result.put("code", resultCode);
        result.put("success", Boolean.TRUE);
        return result;
    }

    private Map<String, Object> calRuleEnginResultData(Map<String, Object> data, Set<String> calVerifyResultData) {
        LOGGER.info("[colla] calRuleEnginResultData data={},calVerifyResultData={}", data, calVerifyResultData);
        if (CollectionUtils.isEmpty(data)) {
            return data;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        data.forEach((key, value) -> {
            if (calVerifyResultData.contains(key)) {
                result.put((String)key, value);
            }
        });
        LOGGER.info("[colla] calRuleEnginResultData result={}", result);
        return result;
    }

    private static HashMap<String, Object> getRequestParam(CoreHRMessageContentEntity msgEntity, String buNumber) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("isInbound", msgEntity.getInbound());
        paramMap.put("flowType", msgEntity.getFlowType());
        paramMap.put("buNumber", buNumber);
        paramMap.put("effectTime", msgEntity.getEffectTime());
        paramMap.put("msgEntity", msgEntity.toMap());
        return paramMap;
    }

    private List<Map<String, Object>> getVerifyCollaRuleIds(DynamicObject taskRule) {
        if (taskRule == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection entryEntity = taskRule.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return Collections.emptyList();
        }
        return entryEntity.stream().filter(item -> item.getBoolean("ismanualverify")).map(item -> {
            long crId = item.getLong("collarule.id");
            String crClass = item.getString("collaruletype");
            HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
            if (SWCStringUtils.isEmpty((String)crClass) || crId == 0L) {
                return tempMap;
            }
            tempMap.put("collaRuleId", crId);
            tempMap.put("collaRuleClass", crClass);
            return tempMap;
        }).collect(Collectors.toList());
    }

    private static DynamicObjectCollection getPayRollActgV(DynamicObject taskRule, DynamicObject summaryVerifyBill, Set<String> verifyIds) {
        DynamicObjectCollection payRollActgV = summaryVerifyBill.getDynamicObjectCollection("collaruleventry");
        if (CollectionUtils.isEmpty(verifyIds)) {
            return payRollActgV;
        }
        List collect = taskRule.getDynamicObjectCollection("entryentity").stream().filter(item -> verifyIds.contains(item.getString("collaruletype") + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + item.getLong("collarule.id"))).map(item -> item.getDynamicObject("collarule")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return payRollActgV;
        }
        for (DynamicObject dynamicObject : collect) {
            DynamicObject entry = new SWCDataServiceHelper(summaryVerifyBill.getDynamicObjectType().getName()).generateEmptyEntryDynamicObject(summaryVerifyBill, "collaruleventry");
            entry.set("collarulevclass", (Object)dynamicObject.getDataEntityType().getName());
            entry.set("collarulev", (Object)dynamicObject);
            payRollActgV.add((Object)entry);
        }
        return payRollActgV;
    }

    private List<DynamicObject> convertToVerifyBillData(DynamicObject taskRule, DynamicObject msgReceiveObject, CoreHRMessageContentEntity msgEntity, DynamicObject bu, Map<String, Object> param) {
        Integer executeSeq = (Integer)param.get("executeSeq");
        Map apiIdNumberMap = (Map)param.get("apiIdNumberMap");
        Map apiResultData = (Map)param.get("apiResultData");
        HPDICollaMsgServiceHelper instance = HPDICollaMsgServiceHelper.getInstance();
        Map<String, Object> person = instance.getPerson(msgEntity.getPersonId(), apiResultData, apiIdNumberMap);
        Map<String, Object> depEmp = instance.getDepemp(msgEntity.getDepempId(), apiResultData, apiIdNumberMap);
        if (CollectionUtils.isEmpty(person) || CollectionUtils.isEmpty(depEmp)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u6838\u5b9a\u5355\u65f6\uff0c\u672a\u67e5\u627e\u5230\u5173\u8054\u7684\u81ea\u7136\u4eba\u3001\u7ec4\u7ec7\u4eba\u6570\u636e\u3002", (String)"CollaMsgVerifyBillHelper_1", (String)"swc-hpdi-business", (Object[])new Object[0]));
        }
        HPDICloudCollaHelper collaHelper = HPDICloudCollaHelper.getInstance();
        Set calVerifyResult = (Set)MapUtils.getObject(param, (Object)"calVerifyResult", Collections.emptySet());
        List<Map<String, Object>> verifyAppConfigs = this.calVerifyAppConfig(taskRule, calVerifyResult);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        String taskRuleClass = taskRule.getDataEntityType().getName();
        String taskArrangeClass = taskRule.getDataEntityType().getName();
        long sourceVid = taskRule.getLong("sourcevid");
        for (Map<String, Object> verifyAppConfig : verifyAppConfigs) {
            SWCDataServiceHelper orm = new SWCDataServiceHelper("hpdi_summaryvbill");
            DynamicObject summaryVerifyBill = orm.generateEmptyDynamicObject();
            summaryVerifyBill.set("id", (Object)ORM.create().genLongId("hpdi_summaryvbill"));
            summaryVerifyBill.set("auditstatus", (Object)"A");
            summaryVerifyBill.set("name", (Object)ResManager.loadKDString((String)"{0}\u6838\u5b9a\u5355", (String)"CollaMsgVerifyBillHelper_2", (String)"swc-hpdi-business", (Object[])new Object[]{msgReceiveObject.getString("name")}));
            summaryVerifyBill.set("personname", person.get("name"));
            summaryVerifyBill.set("empno", person.get("number"));
            summaryVerifyBill.set("billstatus", (Object)"A");
            summaryVerifyBill.set("orgteam", depEmp.get("adminorg_id"));
            summaryVerifyBill.set("dutyworkrole", depEmp.get("dutyworkroles_id"));
            summaryVerifyBill.set("changetime", (Object)msgEntity.getEffectTime());
            summaryVerifyBill.set("flowtype", (Object)msgEntity.getFlowType());
            summaryVerifyBill.set("orgmsgrecvcenter", msgReceiveObject.getPkValue());
            if ("hpdi_taskrule".equalsIgnoreCase(taskArrangeClass)) {
                summaryVerifyBill.set("org", (Object)bu);
            } else {
                summaryVerifyBill.set("morg", (Object)bu);
            }
            summaryVerifyBill.set("taskarrangeclass", (Object)taskArrangeClass);
            summaryVerifyBill.set("taskarrange", (Object)taskRule);
            summaryVerifyBill.set("taskarrangev", (Object)sourceVid);
            Set collaRuleSet = (Set)MapUtils.getObject(verifyAppConfig, (Object)"collaRuleSet", Collections.emptySet());
            summaryVerifyBill.set("collaruleventry", (Object)CollaMsgVerifyBillHelper.getPayRollActgV(taskRule, summaryVerifyBill, collaRuleSet));
            summaryVerifyBill.set("action", msgReceiveObject.get("msgaction"));
            List bizAppObjectList = (List)MapUtils.getObject(verifyAppConfig, (Object)"bizAppObjectList", Collections.emptyList());
            List<DynamicObject> bizAppList = collaHelper.getBizAppList(summaryVerifyBill.getString("flowtype"), summaryVerifyBill.getLong("action.actiontype.id"), bizAppObjectList);
            if (CollectionUtils.isEmpty(bizAppList)) continue;
            this.setVerifyApp(summaryVerifyBill, bizAppList);
            summaryVerifyBill.set("collataskclass", (Object)HPDICloudCollaHelper.getInstance().matchCollaTaskNumber(taskRuleClass));
            summaryVerifyBill.set("person", (Object)msgEntity.getPersonVId());
            summaryVerifyBill.set("employee", (Object)msgEntity.getEmployeeVId());
            summaryVerifyBill.set("depemp", (Object)msgEntity.getDepempVId());
            summaryVerifyBill.set("cmpemp", (Object)msgEntity.getComempVId());
            summaryVerifyBill.set("executeseq", (Object)executeSeq);
            summaryVerifyBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            result.add(summaryVerifyBill);
        }
        return result;
    }

    private void setVerifyApp(DynamicObject summaryVerifyBill, List<DynamicObject> bizAppObjectList) {
        if (summaryVerifyBill == null || CollectionUtils.isEmpty(bizAppObjectList)) {
            return;
        }
        DynamicObjectCollection collaApp = summaryVerifyBill.getDynamicObjectCollection("verifyapp");
        HashSet<String> appSet = new HashSet<String>(16);
        for (DynamicObject bizApp : bizAppObjectList) {
            if (!appSet.add(bizApp.getString("number"))) continue;
            DynamicObjectType dynamicObjectType = collaApp.getDynamicObjectType();
            DynamicObject subObject = new DynamicObject(dynamicObjectType);
            subObject.set("fbasedataid", (Object)bizApp);
            collaApp.add((Object)subObject);
        }
    }

    private List<Map<String, Object>> calVerifyAppConfig(DynamicObject taskRule, Set<String> calVerifyResult) {
        if (taskRule == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection entryEntity = taskRule.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return Collections.emptyList();
        }
        HashMap<String, Set<Long>> param = new HashMap<String, Set<Long>>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            String crClass = dynamicObject.getString("collaruletype");
            long crId = dynamicObject.getLong("collarule.id");
            if (SWCStringUtils.isEmpty((String)crClass) || crId == 0L) continue;
            Set tempIds = param.computeIfAbsent(crClass, item -> new HashSet(16));
            tempIds.add(crId);
        }
        Table<String, Long, DynamicObject> crObjectTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(param);
        String ctClass = taskRule.getDynamicObjectType().getName();
        HashMap<String, Map> result = new HashMap<String, Map>(16);
        for (DynamicObject entry : entryEntity) {
            long crId;
            String crClass;
            DynamicObject cr;
            if (!entry.getBoolean("ismanualverify") || (cr = (DynamicObject)crObjectTable.get((Object)(crClass = entry.getString("collaruletype")), (Object)(crId = entry.getLong("collarule.id")))) == null || !calVerifyResult.contains(crClass + "#" + crId)) continue;
            String bizAppId = cr.getString("payrollactgtpl.bizapp.id");
            DynamicObject bizApp = cr.getDynamicObject("payrollactgtpl.bizapp");
            String verifyNumber = entry.getString("verifynumber");
            if (SWCStringUtils.isEmpty((String)verifyNumber)) {
                verifyNumber = "$default";
            }
            Map tempMap = result.computeIfAbsent(verifyNumber, item -> new HashMap(16));
            List bizAppObjectList = (List)tempMap.computeIfAbsent("bizAppObjectList", item -> new ArrayList(10));
            bizAppObjectList.add(bizApp);
            Set collaRuleList = (Set)tempMap.computeIfAbsent("collaRuleSet", item -> new HashSet(10));
            collaRuleList.add(crClass + "#" + crId);
        }
        return result.entrySet().stream().map(item -> {
            Map value = (Map)item.getValue();
            value.put("verifyNumber", item.getKey());
            return value;
        }).collect(Collectors.toList());
    }

    private OperationResult invokeVerifyBillSaveOp(List<DynamicObject> verifyBills, Map<Long, Map<String, Map<String, Object>>> ruleEngineResults) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ruleEngineResults", SerializationUtils.serializeToBase64(ruleEngineResults));
        return OperationServiceHelper.executeOperate((String)"save", (String)"hpdi_summaryvbill", (DynamicObject[])verifyBills.toArray(new DynamicObject[0]), (OperateOption)operateOption);
    }

    public void saveSummaryVerifyBills(List<Map<String, Object>> verifyBills) {
        try {
            LOGGER.info("[colla] saveSummaryVerifyBills verifyBills = {}", (Object)SWCJSONUtils.toString(verifyBills));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (CollectionUtils.isEmpty(verifyBills)) {
            return;
        }
        HashMap<Long, Map<String, Map<String, Object>>> opData = new HashMap<Long, Map<String, Map<String, Object>>>(verifyBills.size());
        ArrayList<DynamicObject> verifyBillList = new ArrayList<DynamicObject>(verifyBills.size());
        long[] ids = ORM.create().genLongIds("hpdi_summaryvbill", verifyBills.size());
        for (int i = 0; i < verifyBills.size(); ++i) {
            Map<String, Object> verifyBillMap = verifyBills.get(i);
            DynamicObject tempBill = (DynamicObject)verifyBillMap.get("verifyBill");
            Set appSet = tempBill.getDynamicObjectCollection("verifyapp").stream().map(item -> item.getString("fbasedataid.id")).collect(Collectors.toSet());
            long billId = tempBill.getLong("id");
            if (billId == 0L) {
                tempBill.set("id", (Object)ids[i]);
            }
            Map ruleEngineData = (Map)verifyBillMap.get("ruleEngineData");
            opData.put(billId, ruleEngineData);
            verifyBillList.add(tempBill);
        }
        OperationResult operationResult = this.invokeVerifyBillSaveOp(verifyBillList, opData);
        if (operationResult.isSuccess()) {
            return;
        }
        List errorInfo = operationResult.getAllErrorOrValidateInfo();
        String message = operationResult.getMessage();
        StringBuilder msg = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)errorInfo) && SWCStringUtils.isEmpty((String)message)) {
            msg.append(errorInfo.parallelStream().map(IOperateInfo::getMessage).collect(Collectors.joining(System.lineSeparator())));
        }
        if (SWCStringUtils.isNotEmpty((String)message)) {
            if (SWCStringUtils.isNotEmpty((String)msg.toString())) {
                msg.append(System.lineSeparator());
            }
            msg.append(message);
        }
        throw new KDBizException(msg.toString());
    }

    public CollaResultEntity<String> createCollaTaskFromVerifyBill(DynamicObject[] sumVerifyBills) {
        if (sumVerifyBills == null || sumVerifyBills.length == 0) {
            return new CollaResultEntity().success(null);
        }
        HashMap<String, Set<Long>> taskArrangeIdMap = new HashMap<String, Set<Long>>(16);
        for (DynamicObject sumVerifyBill : sumVerifyBills) {
            long id;
            String ruleClass = sumVerifyBill.getString("taskarrangeclass");
            if (SWCStringUtils.isEmpty((String)ruleClass)) continue;
            long vid = sumVerifyBill.getLong("taskarrangev.id");
            if (vid != 0L) {
                Set ids = taskArrangeIdMap.computeIfAbsent(ruleClass, item -> new HashSet(16));
                ids.add(vid);
            }
            if ((id = sumVerifyBill.getLong("taskarrange.id")) == 0L) continue;
            Set ids = taskArrangeIdMap.computeIfAbsent(ruleClass, item -> new HashSet(16));
            ids.add(id);
        }
        Table<String, Long, DynamicObject> crTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(taskArrangeIdMap);
        TaskCenterCreateAsyncHelper taskCenterCreateAsyncHelper = TaskCenterCreateAsyncHelper.getInstance();
        ArrayList<DynamicObject> taskCenters = new ArrayList<DynamicObject>(sumVerifyBills.length);
        Map<Long, Set<String>> blackAppNumberSetMap = this.getExistAppMap(sumVerifyBills);
        for (int i = 0; i < sumVerifyBills.length; ++i) {
            DynamicObject taskArrange;
            long taskArrangeId;
            DynamicObject bill = sumVerifyBills[i];
            String taskArrangeClass = bill.getString("taskarrangeclass");
            if (SWCStringUtils.isEmpty((String)taskArrangeClass) || (taskArrangeId = bill.getLong("taskarrange.id")) == 0L || (taskArrange = (DynamicObject)crTable.get((Object)taskArrangeClass, (Object)taskArrangeId)) == null) continue;
            HashMap<String, Object> fieldDataMap = new HashMap<String, Object>(16);
            fieldDataMap.put("executeType", "auto");
            fieldDataMap.put("executeSeq", bill.getInt("executeseq"));
            fieldDataMap.put("changeTime", bill.getDate("changetime"));
            fieldDataMap.put("flowType", bill.get("flowtype"));
            fieldDataMap.put("orgTeam", bill.get("orgteam"));
            fieldDataMap.put("dutyWorkRole", bill.get("dutyworkrole"));
            long taskArrangeVid = bill.getLong("taskarrangev.id");
            fieldDataMap.put("employeeId", bill.getLong("employee.boid"));
            fieldDataMap.put("personId", bill.getLong("person.boid"));
            fieldDataMap.put("depempId", bill.getLong("depemp.boid"));
            fieldDataMap.put("cmpempId", bill.getLong("cmpemp.boid"));
            fieldDataMap.put("taskArrange", taskArrange);
            fieldDataMap.put("taskArrangeV", taskArrangeVid == 0L ? taskArrange : crTable.get((Object)taskArrangeClass, (Object)taskArrangeVid));
            fieldDataMap.put("msgReceiveLog", bill.get("orgmsgrecvcenter"));
            fieldDataMap.put("bu", taskArrange.get("createorg"));
            fieldDataMap.put("verifyBill", bill);
            Set appNumberSet = bill.getDynamicObjectCollection("verifyapp").stream().map(item -> item.getString("fbasedataid.number")).collect(Collectors.toSet());
            fieldDataMap.put("appNumberSet", appNumberSet);
            fieldDataMap.put("blackAppNumberSet", MapUtils.getObject(blackAppNumberSetMap, (Object)bill.getLong("id"), Collections.emptySet()));
            List<DynamicObject> taskCenter = taskCenterCreateAsyncHelper.generateTaskCenter(fieldDataMap);
            taskCenters.addAll(taskCenter);
        }
        if (CollectionUtils.isEmpty(taskCenters)) {
            return new CollaResultEntity().success(null);
        }
        return taskCenterCreateAsyncHelper.saveTaskManagement(taskCenters);
    }

    private Map<Long, Set<String>> getExistAppMap(DynamicObject[] sumVerifyBills) {
        HashMap<String, Set<Long>> ctClassIdMap = new HashMap<String, Set<Long>>(16);
        DynamicObject[] dynamicObjectArray = sumVerifyBills;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dataEntity;
            String ctClass = (dataEntity = dynamicObjectArray[i]).getString("collataskclass");
            DynamicObjectCollection ctObjectList = dataEntity.getDynamicObjectCollection("hpdi_collatask".equalsIgnoreCase(ctClass) ? "mulcollatask" : "multaskcenter");
            if (CollectionUtils.isEmpty((Collection)ctObjectList)) continue;
            Set idSet = ctClassIdMap.computeIfAbsent(ctClass, item -> new HashSet(16));
            idSet.addAll(ctObjectList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet()));
        }
        Table<String, Long, DynamicObject> ctTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(ctClassIdMap);
        HashMap<Long, Set<String>> existTaskAppMap = new HashMap<Long, Set<String>>(16);
        for (DynamicObject dataEntity : sumVerifyBills) {
            DynamicObjectCollection verifyApps = dataEntity.getDynamicObjectCollection("verifyapp");
            Set currentVerifyAppSet = verifyApps.stream().map(item -> item.getString("fbasedataid.number")).collect(Collectors.toSet());
            String ctClass = dataEntity.getString("collataskclass");
            DynamicObjectCollection ctObjectList = dataEntity.getDynamicObjectCollection("hpdi_collatask".equalsIgnoreCase(ctClass) ? "mulcollatask" : "multaskcenter");
            if (CollectionUtils.isEmpty((Collection)ctObjectList)) continue;
            HashSet existTaskAppSet = new HashSet(16);
            for (DynamicObject collaTask : ctObjectList) {
                long crId = collaTask.getLong("fbasedataid.id");
                DynamicObject taskCenter = (DynamicObject)ctTable.get((Object)ctClass, (Object)crId);
                if (taskCenter == null || !"1".equalsIgnoreCase(taskCenter.getString("enable"))) continue;
                existTaskAppSet.addAll(taskCenter.getDynamicObjectCollection("collaapp").stream().map(item -> item.getString("fbasedataid.number")).collect(Collectors.toSet()));
            }
            existTaskAppMap.put(dataEntity.getLong("id"), existTaskAppSet);
        }
        return existTaskAppMap;
    }

    public Map<String, Object> getAllVerifyBillDataForTaskExecute(long taskCenterId) {
        Map allRelVerifyBillData = VerifyBillDataService.getInstance().getAllRelVerifyBillByTaskId(Long.valueOf(taskCenterId));
        if (CollectionUtils.isEmpty((Map)allRelVerifyBillData)) {
            return null;
        }
        Map<Long, DynamicObject> triggers = CollaMsgVerifyBillHelper.getTriggers(allRelVerifyBillData);
        if (triggers == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        allRelVerifyBillData.forEach((app, data) -> {
            String formId = (String)data.get("formId");
            if ("hpdi_summaryvbill".equalsIgnoreCase(formId)) {
                return;
            }
            DynamicObject verifyBill = (DynamicObject)data.get("dataObject");
            if (verifyBill == null) {
                return;
            }
            DynamicObjectCollection entryEntity = verifyBill.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                return;
            }
            for (DynamicObject entry : entryEntity) {
                long trigger = entry.getLong("triggercolla.id");
                String bizObject = entry.getString("bizobject.id");
                if (SWCStringUtils.isEmpty((String)bizObject)) continue;
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObject);
                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                DynamicObject triggerObject = (DynamicObject)triggers.get(trigger);
                DynamicObjectCollection subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
                SWCDataServiceHelper orm = new SWCDataServiceHelper(bizObject);
                DynamicObject ruleObject = orm.generateEmptyDynamicObject();
                ArrayList<DynamicObject> reuleObjects = (ArrayList<DynamicObject>)result.get(bizObject);
                if (reuleObjects == null) {
                    reuleObjects = new ArrayList<DynamicObject>();
                    result.put(bizObject, reuleObjects);
                }
                reuleObjects.add(ruleObject);
                if (CollectionUtils.isEmpty((Collection)subEntryEntity)) continue;
                for (DynamicObject subEntry : subEntryEntity) {
                    String fieldNumber = subEntry.getString("fieldnumber");
                    String fieldValue = subEntry.getString("fieldvalue");
                    IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldNumber);
                    if (property == null) {
                        result.put(fieldNumber.startsWith(bizObject) ? fieldNumber : bizObject + "_" + fieldNumber, fieldValue);
                        continue;
                    }
                    if (!properties.containsKey((Object)fieldNumber)) continue;
                    IDataConvertService service = DataTransformServiceFactory.getService(property.getPropertyType().getTypeName());
                    DynamicProperty prop = dataEntityType.getProperty(fieldNumber);
                    if (service instanceof DynamicObjectDataConvertService && prop instanceof BasedataProp) {
                        ruleObject.set(fieldNumber, service.convert(((BasedataProp)prop).getBaseEntityId(), fieldValue));
                        continue;
                    }
                    if (service == null) {
                        ruleObject.set(fieldNumber, (Object)fieldValue);
                        continue;
                    }
                    ruleObject.set(fieldNumber, service.convert(fieldValue));
                }
            }
        });
        return result;
    }

    private static Map<Long, DynamicObject> getTriggers(Map<String, Map<String, Object>> allRelVerifyBillData) {
        ArrayList<Long> allTrigger = new ArrayList<Long>(16);
        allRelVerifyBillData.forEach((app, data) -> {
            DynamicObject dataObject = (DynamicObject)data.get("dataObject");
            if (dataObject == null) {
                return;
            }
            List tempTriggerIds = dataObject.getDynamicObjectCollection("entryentity").stream().map(item -> item.getLong("triggercolla.id")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(tempTriggerIds)) {
                allTrigger.addAll(tempTriggerIds);
            }
        });
        List<DynamicObject> triggerDataList = DataSyncMsgHelper.getInstance().queryCollaTriggerData(allTrigger);
        if (CollectionUtils.isEmpty(triggerDataList)) {
            return null;
        }
        return triggerDataList.stream().collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
    }

    public Map<Long, Map<Long, Map<String, Object>>> getBillFieldValues(Map<Long, Map<String, Object>> ruleEngineResults) {
        if (CollectionUtils.isEmpty(ruleEngineResults)) {
            return Collections.emptyMap();
        }
        ArrayList<String> collaRuleIds = new ArrayList<String>(10);
        ruleEngineResults.forEach((billId, ruleEngineDataList) -> {
            if (CollectionUtils.isEmpty((Map)ruleEngineDataList)) {
                return;
            }
            ruleEngineDataList.forEach((collaRuleId, ruleResult) -> collaRuleIds.add((String)collaRuleId));
        });
        if (CollectionUtils.isEmpty(collaRuleIds)) {
            return Collections.emptyMap();
        }
        List<DynamicObject> collaRules = DataSyncMsgHelper.getInstance().queryCollaRuleData(collaRuleIds);
        if (CollectionUtils.isEmpty(collaRules)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u7684\u534f\u4f5c\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u534f\u4f5c\u89c4\u5219\u914d\u7f6e\u3002", (String)"CollaMsgVerifyBillHelper_5", (String)"swc-hpdi-business", (Object[])new Object[0]));
        }
        Map<Long, Set<Long>> triggerIds = collaRules.stream().collect(Collectors.toMap(collRule -> collRule.getLong("id"), collRule -> collRule.getDynamicObjectCollection("entryentity").stream().map(item -> item.getDynamicObject("payrollact")).flatMap(item -> item.getDynamicObjectCollection("entryentity").stream()).map(item -> item.getLong("triggercolla.id")).filter(triggerId -> triggerId != 0L).collect(Collectors.toSet()), (k1, k2) -> k1));
        ArrayList<Long> allTrigger = new ArrayList<Long>(16);
        triggerIds.forEach((key, value) -> {
            if (!CollectionUtils.isEmpty((Collection)value)) {
                allTrigger.addAll((Collection<Long>)value);
            }
        });
        Map<String, Object> triggerResult = HPDICloudCollaHelper.getInstance().queryCollaDataByIds("hsbs_triggercolla", allTrigger, Boolean.FALSE);
        if (!((Boolean)triggerResult.get("success")).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u7684\u534f\u4f5c\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u534f\u4f5c\u89c4\u5219\u914d\u7f6e\u3002", (String)"CollaMsgVerifyBillHelper_4", (String)"swc-hpdi-business", (Object[])new Object[0]));
        }
        List triggerDataList = (List)triggerResult.get("data");
        Map<Long, DynamicObject> mustFieldMapData = triggerDataList.stream().filter(item -> !item.getBoolean("ismustfieldmapping")).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
        Map<Long, Map<Long, Map<String, Object>>> finalDataMap = this.getFinalDataMap(ruleEngineResults, triggerIds, mustFieldMapData);
        return finalDataMap;
    }

    private Map<Long, Map<Long, Map<String, Object>>> getFinalDataMap(Map<Long, Map<String, Object>> ruleEngineResults, Map<Long, Set<Long>> triggerIds, Map<Long, DynamicObject> mustFieldMapData) {
        if (CollectionUtils.isEmpty(ruleEngineResults)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<Long, Map<String, Object>>> finalDataMap = new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        ruleEngineResults.forEach((billId, collaRuleResult) -> {
            if (CollectionUtils.isEmpty((Map)collaRuleResult)) {
                return;
            }
            collaRuleResult.forEach((collaRuleStringId, ruleEngineData) -> {
                Long collaRuleId = MapUtils.getLong(HPDICloudCollaHelper.getInstance().parseCollaRule((String)collaRuleStringId), (Object)"collaRuleId", (Long)0L);
                Map ruleEngineDataMap = MapUtils.getMap((Map)((Map)ruleEngineData), (Object)"data", Collections.emptyMap());
                Set triggerIdSet = (Set)triggerIds.get(collaRuleId);
                if (CollectionUtils.isEmpty((Collection)triggerIdSet)) {
                    return;
                }
                HashMap fieldMap = new HashMap(16);
                for (Long triggerId : triggerIdSet) {
                    DynamicObject trigger = (DynamicObject)mustFieldMapData.get(triggerId);
                    if (trigger == null) continue;
                    String entityObjectNumber = trigger.getString("entityobject.number");
                    String bizAppNumber = trigger.getString("bizapp.number");
                    DynamicObjectCollection paramEntryEntity = trigger.getDynamicObjectCollection("paramentryentity");
                    DynamicObjectCollection exeParamEntryEntity = trigger.getDynamicObjectCollection("exeparamentryentity");
                    HashMap<String, Object> tempMap = new HashMap<String, Object>(paramEntryEntity.size() + exeParamEntryEntity.size());
                    if (!CollectionUtils.isEmpty((Collection)paramEntryEntity)) {
                        DynamicObject dynamicObject = (DynamicObject)ruleEngineDataMap.get(entityObjectNumber);
                        tempMap.put("objectValues", paramEntryEntity.stream().map(item -> {
                            String fieldKey = item.getString("fieldkey");
                            HashMap<String, String> filedNameValueMap = new HashMap<String, String>(2);
                            filedNameValueMap.put("fieldNumber", fieldKey);
                            filedNameValueMap.put("fieldValue", Optional.ofNullable(dynamicObject).map(object -> object.get(fieldKey)).orElse(null));
                            return filedNameValueMap;
                        }).collect(Collectors.toList()));
                    }
                    if (!CollectionUtils.isEmpty((Collection)exeParamEntryEntity)) {
                        tempMap.put("exeParams", exeParamEntryEntity.stream().map(item -> {
                            String fieldKey = entityObjectNumber + '_' + item.getString("pfieldkey");
                            Object value = ruleEngineDataMap.get(fieldKey);
                            HashMap<String, String> filedNameValueMap = new HashMap<String, String>(2);
                            filedNameValueMap.put("fieldNumber", fieldKey);
                            filedNameValueMap.put("fieldValue", (String)value);
                            return filedNameValueMap;
                        }).collect(Collectors.toList()));
                    }
                    tempMap.put("cardType", "1");
                    tempMap.put("objectNumber", entityObjectNumber);
                    tempMap.put("appNumber", bizAppNumber);
                    fieldMap.put(triggerId, tempMap);
                }
                Map dataMap = (Map)finalDataMap.get(billId);
                if (CollectionUtils.isEmpty((Map)dataMap)) {
                    finalDataMap.put((Long)billId, fieldMap);
                } else {
                    dataMap.putAll(fieldMap);
                }
            });
        });
        return finalDataMap;
    }

    public DynamicObject getExistSalaryFile(Long depEmpId, Date changeDate) {
        ArrayList params = new ArrayList(10);
        HashMap<String, Object> firstParam = new HashMap<String, Object>();
        firstParam.put("depEmpId", depEmpId);
        firstParam.put("endDate", changeDate);
        firstParam.put("status", Arrays.asList("A", "B", "C"));
        params.add(firstParam);
        List result = (List)SWCMServiceUtils.invokeSWCService((String)"hsas", (String)"ISalaryFileService", (String)"matchSalaryFile", (Object[])new Object[]{params});
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        Map objectMap = (Map)result.get(0);
        Integer queryRowCount = (Integer)objectMap.get("queryRowCount");
        if (queryRowCount == 0) {
            return null;
        }
        List objects = (List)objectMap.get("matchSalaryFileVers");
        return (DynamicObject)objects.get(0);
    }

    public Map<String, DynamicObject> getExistSalaryFile(List<Map<String, Object>> condition) {
        if (CollectionUtils.isEmpty(condition)) {
            return Collections.emptyMap();
        }
        List queryResult = (List)SWCMServiceUtils.invokeSWCService((String)"hsas", (String)"ISalaryFileService", (String)"matchSalaryFile", (Object[])new Object[]{condition});
        if (CollectionUtils.isEmpty((Collection)queryResult)) {
            return Collections.emptyMap();
        }
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        for (Map objectMap : queryResult) {
            List objects;
            Integer queryRowCount = (Integer)objectMap.get("queryRowCount");
            if (queryRowCount == 0 || CollectionUtils.isEmpty((Collection)(objects = (List)objectMap.get("matchSalaryFileVers")))) continue;
            Long depEmpId = (Long)objectMap.get("depEmpId");
            Date endData = (Date)objectMap.get("endDate");
            DynamicObject object = (DynamicObject)objects.get(0);
            result.put(depEmpId + "#" + endData.getTime(), object);
        }
        return result;
    }

    public List<IVerifyBillListener> queryListenerByGroupConfig(String groupName) {
        if (SWCStringUtils.isEmpty((String)groupName)) {
            return Collections.emptyList();
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hpdi_verifybillconfig");
        DynamicObject[] groups = helper.queryOriginalArray("group,formid,cloudnumber,appnumber,verifyapp,servicename", new QFilter[]{new QFilter("group", "=", (Object)groupName)});
        if (groups == null || groups.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IVerifyBillListener> result = new ArrayList<IVerifyBillListener>(10);
        try {
            for (DynamicObject group : groups) {
                String serviceName = group.getString("servicename");
                if (SWCStringUtils.isEmpty((String)serviceName)) continue;
                IVerifyBillListener plugin = (IVerifyBillListener)Class.forName(serviceName.trim()).newInstance();
                result.add(plugin);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOGGER.info("[colla] queryListenerByGroupConfig error.", (Object)ex);
            return Collections.emptyList();
        }
        return result;
    }

    public Long parseToLong(Object data) {
        if (data == null) {
            return 0L;
        }
        String temp = data.toString();
        if (SWCStringUtils.isEmpty((String)temp)) {
            return 0L;
        }
        try {
            return Long.valueOf(temp.trim());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String getErrorTips() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"CollaMsgVerifyBillHelper_3", (String)"swc-hpdi-business", (Object[])new Object[0]);
    }

    private static class Load {
        private static final CollaMsgVerifyBillHelper INSTANCE = new CollaMsgVerifyBillHelper();

        private Load() {
        }
    }
}

