/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.msgreceive;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.msgreceive.HPDICollaMsgServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class DataSyncMsgHelper {
    private static final Log LOGGER = LogFactory.getLog(HPDICollaMsgServiceHelper.class);
    @Deprecated
    private static final Map<String, String> ENTITYMAP = new HashMap<String, String>();

    private DataSyncMsgHelper() {
    }

    public static final DataSyncMsgHelper getInstance() {
        return Load.INSTANCE;
    }

    public void syncData(Map<String, Object> msg) {
        List data = (List)msg.get("data");
        if (data == null || data.isEmpty()) {
            return;
        }
        HashMap<String, List<DynamicObject>> syncData = new HashMap<String, List<DynamicObject>>(4);
        for (Map entityIdMap : data) {
            List ids;
            String entityNumber = (String)entityIdMap.get("entityNumber");
            List<DynamicObject> syncSourceData = this.getSyncTargetData(entityNumber, ids = (List)entityIdMap.get("ids"));
            if (syncSourceData == null) continue;
            syncData.put(ENTITYMAP.get(entityNumber), syncSourceData);
        }
        this.saveSyncDataWithTransaction(syncData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSyncDataWithTransaction(Map<String, List<DynamicObject>> syncData) {
        if (syncData == null || syncData.isEmpty()) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            syncData.forEach((entityNumber, datas) -> {
                SWCDataServiceHelper dataOrm = new SWCDataServiceHelper(entityNumber);
                List<Long> ids = datas.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
                dataOrm.delete((Object[])ids.toArray(new Long[0]));
                dataOrm.save(datas.toArray(new DynamicObject[0]));
            });
        }
    }

    private List<DynamicObject> getSyncTargetData(String entityNumber, List<Long> ids) {
        Map result = (Map)SWCMServiceUtils.invokeBizService((String)"swc", (String)"hsas", (String)"IHSASService", (String)"queryCollaDataByIds", (Object[])new Object[]{entityNumber, ids});
        Boolean isSuccess = (Boolean)result.get("success");
        if (!isSuccess.booleanValue()) {
            LOGGER.info("[sync]:getSyncSourceData error,{}", result.get("message"));
            return null;
        }
        List data = (List)result.get("data");
        return this.transformToHpdiData(ENTITYMAP.get(entityNumber), data);
    }

    private List<DynamicObject> transformToHpdiData(String entityNumber, List<DynamicObject> datas) {
        if (SWCStringUtils.isEmpty((String)entityNumber) || CollectionUtils.isEmpty(datas)) {
            return null;
        }
        SWCDataServiceHelper targetOrm = new SWCDataServiceHelper(entityNumber);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(datas.size());
        for (DynamicObject data : datas) {
            DynamicObject dynamicObject = targetOrm.generateEmptyDynamicObject();
            this.copy(data, dynamicObject, null, null);
            dynamicObject.set("id", (Object)data.getLong("id"));
            result.add(dynamicObject);
        }
        return result;
    }

    public void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (fromPros == null || fromPros.size() == 0) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (toPros == null || toPros.size() == 0) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : fromPros) {
            fromPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        for (IDataEntityProperty pro : fromPros) {
            String toProName;
            String fromProName = toProName = pro.getName();
            if (transKeyMap != null && Objects.nonNull(transKeyMap.get(fromProName))) {
                toProName = transKeyMap.get(fromProName);
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
            this.addEntity(fromObj, toObj, ignoreKeys, transKeyMap, toProName, fromProName);
        }
    }

    private Object addEntity(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap, String toProName, String fromProName) {
        Object value = fromObj.get(fromProName);
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
            DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
            if (toEntity != null) {
                toEntity.clear();
                DynamicObjectType entityType = toEntity.getDynamicObjectType();
                for (DynamicObject baseEntry : formEntity) {
                    DynamicObject newEntry = new DynamicObject(entityType);
                    this.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
                    toEntity.add((Object)newEntry);
                }
            }
            toObj.set(toProName, (Object)toEntity);
        } else {
            toObj.set(toProName, value);
        }
        return value;
    }

    public List<DynamicObject> queryCollaRuleData(List<String> comboIds) {
        return this.queryCollaRuleData(comboIds, null);
    }

    public List<DynamicObject> queryCollaRuleData(List<String> comboIds, String properties) {
        if (CollectionUtils.isEmpty(comboIds)) {
            return Collections.emptyList();
        }
        HashMap<String, Set<Long>> param = new HashMap<String, Set<Long>>(16);
        for (String collaRuleId : comboIds) {
            Map<String, Object> objectMap = HPDICloudCollaHelper.getInstance().parseCollaRule(collaRuleId);
            if (CollectionUtils.isEmpty(objectMap)) continue;
            Set tempIds = param.computeIfAbsent(MapUtils.getString(objectMap, (Object)"collaRuleClass"), item -> new HashSet(16));
            tempIds.add(MapUtils.getLong(objectMap, (Object)"collaRuleId"));
        }
        Table<String, Long, DynamicObject> result = HPDICloudCollaHelper.getInstance().queryMultiClassObject(param, properties);
        return new ArrayList<DynamicObject>(result.values());
    }

    public List<DynamicObject> queryPayRollActGroupTplData(List<Long> ids) {
        return this.queryDataListById("hsbs_payrollactgtpl", ids);
    }

    public List<DynamicObject> queryCollaTriggerData(List<Long> ids) {
        return this.queryDataListById("hsbs_triggercolla", ids);
    }

    public List<DynamicObject> queryPayRollActData(List<Long> ids) {
        return this.queryDataListById("hsbs_payrollact", ids);
    }

    private List<DynamicObject> queryDataListById(String entityNumber, List<Long> ids) {
        if (CollectionUtils.isEmpty(ids) || SWCStringUtils.isEmpty((String)entityNumber)) {
            return Collections.emptyList();
        }
        Map<String, Object> result = HPDICloudCollaHelper.getInstance().queryCollaDataByIds(entityNumber, ids, Boolean.FALSE);
        Boolean isSuccess = (Boolean)result.get("success");
        if (!isSuccess.booleanValue()) {
            LOGGER.info("[sync]:queryDataListById error,{}", result.get("message"));
            return Collections.emptyList();
        }
        return result.getOrDefault("data", Collections.emptyList());
    }

    static {
        ENTITYMAP.put("hsas_payrollactg", "hpdi_payrollactg");
        ENTITYMAP.put("hsas_payrollact", "hpdi_payrollact");
        ENTITYMAP.put("hsas_triggercolla", "hpdi_triggercolla");
        ENTITYMAP.put("hsas_payrollactgtpl", "hpdi_payrollactgtpl");
    }

    private static class Load {
        private static final DataSyncMsgHelper INSTANCE = new DataSyncMsgHelper();

        private Load() {
        }
    }
}

