/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.msgreceive;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.SessionIdUtils;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.sdk.swc.hpdi.business.msgreceive.ICollaMsgReceiveExtService;
import kd.sdk.swc.hpdi.common.events.msgreceive.AfterParseMsgContentEvent;
import kd.sdk.swc.hpdi.common.events.msgreceive.AfterSaveReceiveMsgEvent;
import kd.swc.hpdi.business.basedata.SubApiSettingHelper;
import kd.swc.hpdi.business.basedata.TaskRuleHelper;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.factory.DataTransformServiceFactory;
import kd.swc.hpdi.business.factory.ReceiveMsgParseServiceFactory;
import kd.swc.hpdi.business.helper.DefaultCollaMsgReceiveExtServiceImpl;
import kd.swc.hpdi.business.msgreceive.TaskCenterCreateAsyncHelper;
import kd.swc.hpdi.business.msgreceive.TaskCenterDataHelper;
import kd.swc.hpdi.business.service.IApiResultHandler;
import kd.swc.hpdi.business.service.IDataConvertService;
import kd.swc.hpdi.business.service.IReceiveMsgParseService;
import kd.swc.hpdi.business.service.JobLevelApiResultHandler;
import kd.swc.hpdi.business.service.LaborRelRecordApiResultHandler;
import kd.swc.hpdi.business.service.PerEduExpApiResultHandler;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.CoreHRMessageContentEntity;
import kd.swc.hpdi.common.entity.HPDIMsResultEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.constants.VerifyBillConstants;
import kd.swc.hsbp.common.util.ReflectUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class HPDICollaMsgServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HPDICollaMsgServiceHelper.class);
    private static final Character SEPARATOR = Character.valueOf('#');
    private static final Set<String> RETRY_STATUS_SET;

    private HPDICollaMsgServiceHelper() {
    }

    public static HPDICollaMsgServiceHelper getInstance() {
        return Load.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HRMServiceResult consumerSaveMsg(DynamicObject msg) {
        boolean exists;
        DynamicObject temp = null;
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hpdi_msgreceive");
        try {
            String number = msg.getString("number");
            Object tempMsgBusinessType = msg.get("msgbusinesstype");
            Long msgBusinessTypeId = null;
            if (tempMsgBusinessType instanceof DynamicObject) {
                msgBusinessTypeId = ((DynamicObject)tempMsgBusinessType).getLong("id");
            } else if (tempMsgBusinessType instanceof Long) {
                msgBusinessTypeId = (Long)tempMsgBusinessType;
            }
            Object tempMsgAction = msg.get("msgaction");
            Long msgAction = null;
            if (tempMsgAction instanceof DynamicObject) {
                msgAction = ((DynamicObject)tempMsgAction).getLong("id");
            } else if (tempMsgAction instanceof Long) {
                msgAction = (Long)tempMsgAction;
            }
            Object tempMsgApp = msg.get("msgapp");
            String msgAppId = "";
            if (tempMsgApp instanceof DynamicObject) {
                msgAppId = ((DynamicObject)tempMsgApp).getString("id");
            } else if (tempMsgApp instanceof String) {
                msgAppId = (String)tempMsgApp;
            }
            String key = number + SEPARATOR + msgBusinessTypeId + SEPARATOR + msgAction + SEPARATOR + msgAppId;
            DLock lock = DLock.create((String)("consumerSaveMsg_" + key));
            try {
                if (!lock.tryLock(10000L)) {
                    DLock.forceUnlock((String[])new String[]{key});
                    lock.lock();
                }
                LOGGER.info("[colla]:recieve hrmp message ,msg: {}", (Object)SWCJSONUtils.toString((Object)msg));
                DynamicObject dyobj = serviceHelper.generateEmptyDynamicObject();
                QFilter numberFilter = new QFilter("number", "=", (Object)number);
                QFilter msgBusinessTypeFilter = new QFilter("msgbusinesstype.id", "=", (Object)msgBusinessTypeId);
                QFilter msgActionFilter = new QFilter("msgaction.id", "=", (Object)msgAction);
                QFilter msgAppFilter = new QFilter("msgapp.id", "=", (Object)msgAppId);
                HRDynamicObjectUtils.copy((DynamicObject)msg, (DynamicObject)dyobj);
                exists = serviceHelper.isExists(new QFilter[]{numberFilter, msgBusinessTypeFilter, msgActionFilter, msgAppFilter});
                if (exists) {
                    dyobj.set("msgreceivedate", (Object)new Date());
                    dyobj.set("taskcreatestatus", (Object)"B");
                    dyobj.set("description", (Object)ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5b8c\u5168\u76f8\u540c\u7684\u4e1a\u52a1\u4e8b\u4ef6\u65e5\u5fd7\uff08\u201c\u6240\u5c5e\u5e94\u7528\u201d\u3001\u201c\u6240\u5c5e\u4e1a\u52a1\u7c7b\u578b\u201d\u3001\u201c\u4e1a\u52a1\u64cd\u4f5c\u201d\u4ee5\u53ca\u201c\u7f16\u7801\u201d\uff09\uff0c\u6b64\u4e1a\u52a1\u4e8b\u4ef6\u65e5\u5fd7\u7684\u201c\u534f\u4f5c\u4efb\u52a1\u521b\u5efa\u201d\u6b65\u9aa4\u5df2\u8df3\u8fc7\u3002", (String)"HPDICollaMsgServiceHelper_0", (String)"swc-hpdi-business", (Object[])new Object[0]));
                } else {
                    dyobj.set("msgreceivedate", (Object)new Date());
                    dyobj.set("taskcreatestatus", (Object)"A");
                }
                temp = (DynamicObject)serviceHelper.saveOne(dyobj);
                temp = serviceHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)"hpdi_msgreceive"), temp.getPkValue());
            }
            finally {
                lock.unlock();
                lock.close();
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            return HRMServiceResult.fail((String)ex.getMessage());
        }
        try {
            if (!exists && this.invokeAfterSaveReceiveMsgExt(temp)) {
                this.createRequestContext();
                TaskCenterCreateAsyncHelper.getInstance().createTaskByMsg(temp);
            }
        }
        catch (Exception ex) {
            temp.set("taskcreatestatus", (Object)"C");
            String message = ex.getMessage();
            if (message.length() > 250) {
                message = message.substring(0, 250);
            }
            temp.set("errormsg", (Object)message);
            serviceHelper.saveOne(temp);
        }
        return HRMServiceResult.success();
    }

    public boolean invokeAfterSaveReceiveMsgExt(DynamicObject object) {
        if (object == null) {
            return true;
        }
        AfterSaveReceiveMsgEvent event = new AfterSaveReceiveMsgEvent();
        event.setMsgReceiveId(Long.valueOf(object.getLong("id")));
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new DefaultCollaMsgReceiveExtServiceImpl(), ICollaMsgReceiveExtService.class, (String)"kd.sdk.swc.hpdi.business.msgreceive.IHPDICollaMsgReceiveExtService#afterSaveReceiveMsg", null);
        proxy.callReplaceIfPresent(ext -> {
            ext.afterSaveReceiveMsg(event);
            return null;
        });
        return event.getResult();
    }

    private void createRequestContext() {
        RequestContext lastRc = RequestContext.get();
        String tenantId = lastRc.getTenantId();
        String accountId = lastRc.getAccountId();
        String userId = "1";
        String traceId = TraceIdUtil.getCurrentTraceIdString();
        String userAgent = lastRc.getUserAgent();
        String client = lastRc.getClient();
        long orgId = lastRc.getOrgId();
        Lang lang = lastRc.getLang();
        RequestContext rc = RequestContext.create((boolean)true);
        rc.setUserAgent(userAgent);
        rc.setClient(client);
        rc.setTraceId(traceId);
        rc.setTenantId(tenantId);
        rc.setTenantCode(tenantId);
        rc.setAccountId(accountId);
        rc.setUserId(userId);
        rc.setOrgId(orgId);
        rc.setLang(lang);
        rc.setGlobalSessionId(SessionIdUtils.newSessionId());
        RequestContextThreadBinder.bind((RequestContext)rc);
    }

    public List<Map<String, Object>> getAPIInfoByMsgSubNo(String msgSubNo) {
        return (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"getAPIInfoByMsgSubNo", (Object[])new Object[]{msgSubNo});
    }

    public List<Map<String, Object>> getSubApiSettingByMsgSubNo(String msgSubNo) {
        return SubApiSettingHelper.getInstance().getSubApiSettingApiInfos(msgSubNo);
    }

    public void callBackHrmpMsgCenter(DynamicObject taskCenter, String msg) {
        Long msgRecvLogId = taskCenter.getLong("orgmsgrecvcenter.id");
        SWCDataServiceHelper msgRecvCenterOrm = new SWCDataServiceHelper("hpdi_msgreceive");
        DynamicObject msgRecvCenter = msgRecvCenterOrm.queryOne("id,msgcenterbo,msgbusinesstype,msgsubno", (Object)msgRecvLogId);
        long msgCenterId = msgRecvCenter.getLong("msgcenterbo.id");
        String msgSubNo = msgRecvCenter.getString("msgsubno");
        SWCDataServiceHelper taskCenterOrm = new SWCDataServiceHelper("hpdi_taskcenter");
        DynamicObject[] taskCenters = taskCenterOrm.query("taskexecutestatus", new QFilter[]{new QFilter("orgmsgrecvcenter.id", "=", (Object)msgRecvLogId)});
        if (taskCenters == null || taskCenters.length == 0) {
            return;
        }
        String status = "2";
        int successCount = 0;
        int failureCount = 0;
        for (int i = 0; i < taskCenters.length; ++i) {
            DynamicObject data = taskCenters[i];
            String tempStatus = data.getString("taskexecutestatus");
            if ("D".equals(tempStatus)) {
                ++successCount;
                continue;
            }
            ++failureCount;
        }
        int length = taskCenters.length;
        if (successCount == length) {
            status = "1";
        }
        if (failureCount > 0 && failureCount < length) {
            status = "2";
        }
        if (failureCount == length) {
            status = "3";
        }
        this.callBackHrmpMsgCenter(status, msg, msgCenterId, msgSubNo);
    }

    public void callBackHrmpMsgCenter(String status, String msg, Long msgCenterId, String msgSubNo) {
        LOGGER.info("[colla] callBackHrmpMsgCenter msg = {} ,msgCenterId = {},msgSubNo = {}", new Object[]{msg, msgCenterId, msgSubNo});
        if (msgCenterId == null || msgCenterId <= 0L) {
            return;
        }
        if (SWCStringUtils.isEmpty((String)msgSubNo)) {
            return;
        }
        if (msg.length() > 255) {
            msg = msg.substring(0, 255);
        }
        try {
            HashMap<String, Object> resultData = new HashMap<String, Object>(5);
            resultData.put("msgCenterId", msgCenterId);
            resultData.put("msgSubNo", msgSubNo);
            resultData.put("handleStatus", status);
            LOGGER.info("[colla]: callback hrmp service ,msgCenterId = {},msgSubNo = {}, handleStatus = {}", new Object[]{msgCenterId, msgSubNo, msg});
            SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"updateConsumeMsgInfo", (Object[])new Object[]{resultData});
        }
        catch (Exception e) {
            LOGGER.error("[colla]: callback hrmp service IHRCSMsgService.updateConsumeMsgInfo error.", (Throwable)e);
        }
    }

    public Map<String, List<Map<String, Object>>> getSubMsgApiData(String msgSubNo, CoreHRMessageContentEntity msgEntity, Map<String, Object> paramMapByMsgSubNo) {
        ConcurrentHashMap<String, List<Map<String, Object>>> apiDataCombo = new ConcurrentHashMap<String, List<Map<String, Object>>>(16);
        if (SWCStringUtils.isEmpty((String)msgSubNo) || CollectionUtils.isEmpty(paramMapByMsgSubNo)) {
            return apiDataCombo;
        }
        List<Map<String, Object>> apiInfos = HPDICollaMsgServiceHelper.getInstance().getSubApiSettingByMsgSubNo(msgSubNo);
        Map apiDatas = (Map)paramMapByMsgSubNo.get("apiData");
        if (null != apiInfos) {
            apiInfos.stream().forEach(apiInfo -> {
                LOGGER.info("[colla]: begin to request Api {}, msgEntity = {}", apiInfo.get("number"), (Object)msgEntity);
                Map paramDatas = (Map)apiDatas.get((String)apiInfo.get("number"));
                List<Map<String, Object>> resultMapList = HPDICollaMsgServiceHelper.getInstance().executeApiByApiInfo(msgEntity, (Map<String, Object>)apiInfo, paramDatas);
                if (null != resultMapList && !resultMapList.isEmpty()) {
                    String apiNumber = String.valueOf(apiInfo.get("number"));
                    LOGGER.info("[colla]:get api data success, apiNumber = {}", (Object)apiNumber);
                    apiDataCombo.put(apiNumber, resultMapList);
                }
            });
        }
        return apiDataCombo;
    }

    public List<Map<String, Object>> executeApiByApiInfo(CoreHRMessageContentEntity msgEntity, Map<String, Object> apiInfo, Map<String, Object> paramDatas) {
        if (CollectionUtils.isEmpty(paramDatas)) {
            return null;
        }
        String apiType = (String)apiInfo.get("apitype");
        Map inputParam = (Map)paramDatas.get("inputParam");
        if ("1".equals(apiType)) {
            return this.getCommonPersonAPIData(apiInfo, msgEntity, paramDatas);
        }
        try {
            Object[] params = this.getParams(apiInfo, msgEntity, inputParam);
            LOGGER.info("[colla] invokeBizService,params={}", (Object)SWCJSONUtils.toString((Object)params));
            Object result = this.getInvokedBizService(apiInfo, params);
            List resultMapList = HPDIMsResultEntity.build((Object)result).getResultEntity();
            return resultMapList;
        }
        catch (Exception e) {
            LOGGER.info("[colla] request api:{}.{} error.", new Object[]{apiInfo.get("service"), apiInfo.get("method"), e});
            throw new KDBizException((Throwable)e, new ErrorCode("", apiInfo.get("service") + (String)apiInfo.get("method") + e.getMessage()), new Object[0]);
        }
    }

    private Object getInvokedBizService(Map<String, Object> apiInfo, Object[] params) {
        String isvId = (String)apiInfo.get("isvid");
        if (SWCStringUtils.isEmpty((String)isvId)) {
            isvId = "kingdee";
        }
        String cloudId = String.valueOf(apiInfo.get("bizcloud")).toLowerCase();
        String appId = String.valueOf(apiInfo.get("bizapp")).toLowerCase();
        String serviceName = String.valueOf(apiInfo.get("service"));
        String methodName = String.valueOf(apiInfo.get("method"));
        if ("kingdee".equalsIgnoreCase(isvId)) {
            return SWCMServiceUtils.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])params);
        }
        return DispatchServiceHelper.invokeService((String)String.format(Locale.ROOT, "%s.%s.%s", isvId, cloudId, appId), (String)appId, (String)serviceName, (String)methodName, (Object[])params);
    }

    public <T> Map<String, Object> convertResultData(Map<String, T> resultMapList, Map<String, Object> apiParamMap) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty(resultMapList)) {
            return Collections.emptyMap();
        }
        Map apiDataMap = (Map)apiParamMap.get("apiData");
        if (CollectionUtils.isEmpty((Map)apiDataMap)) {
            return resultMapList;
        }
        resultMapList.forEach((apiNumber, apiDatas) -> {
            Boolean isConvertObject;
            List tempApiData = (List)apiDatas;
            if (CollectionUtils.isEmpty((Collection)tempApiData)) {
                return;
            }
            Map singleApiParamMap = (Map)apiDataMap.get(apiNumber);
            Map outputParam = null;
            if (!CollectionUtils.isEmpty((Map)singleApiParamMap)) {
                outputParam = (Map)singleApiParamMap.get("outputParam");
            }
            if ((isConvertObject = (Boolean)singleApiParamMap.get("isConvertObject")) != null && isConvertObject.booleanValue()) {
                String targetObject = (String)singleApiParamMap.get("targetObject");
                List<DynamicObject> datas = this.mapSingleApiResultToObject(tempApiData, outputParam, targetObject);
                result.put((String)apiNumber, datas);
            } else {
                List<Map<String, Object>> datas = this.convertSingleApiResult(tempApiData, outputParam);
                result.put((String)apiNumber, datas);
            }
        });
        return result;
    }

    private List<DynamicObject> mapSingleApiResultToObject(List<Map<String, Object>> apiDatas, Map<String, Object> outputParam, String targetObjectName) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        if (CollectionUtils.isEmpty(apiDatas) || CollectionUtils.isEmpty(outputParam) || SWCStringUtils.isEmpty((String)targetObjectName)) {
            LOGGER.info("[colla]: mapSingleApiResultToObject data [{}] is null.map data fail.", (Object)targetObjectName);
            return result;
        }
        SWCDataServiceHelper targetOrm = new SWCDataServiceHelper(targetObjectName);
        for (Map<String, Object> apiData : apiDatas) {
            DynamicObject targetObject = targetOrm.generateEmptyDynamicObject();
            DynamicObjectType dyobjType = targetObject.getDynamicObjectType();
            DataEntityPropertyCollection properties = targetObject.getDataEntityType().getProperties();
            for (Map.Entry<String, Object> fieldMapEntry : outputParam.entrySet()) {
                String fieldKey = fieldMapEntry.getKey();
                Map fieldValueMap = (Map)fieldMapEntry.getValue();
                String mapFieldKey = (String)fieldValueMap.get("mapFieldKey");
                Object fieldVal = apiData.get(fieldKey);
                if (null == fieldVal || !properties.containsKey((Object)mapFieldKey)) continue;
                DynamicProperty dynamicProp = dyobjType.getProperty(mapFieldKey);
                if (dynamicProp instanceof BasedataProp) {
                    if (fieldVal instanceof Long && (Long)fieldVal == 0L) {
                        targetObject.set(mapFieldKey, null);
                        continue;
                    }
                    String baseDataEntityId = ((BasedataProp)dynamicProp).getBaseEntityId();
                    SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseDataEntityId);
                    DynamicObject emptyDyobj = serviceHelper.generateEmptyDynamicObject();
                    emptyDyobj.set("id", fieldVal);
                    targetObject.set(mapFieldKey, (Object)emptyDyobj);
                    continue;
                }
                targetObject.set(mapFieldKey, fieldVal);
            }
            result.add(targetObject);
        }
        return result;
    }

    private List<Map<String, Object>> convertSingleApiResult(List<Map<String, Object>> apiDatas, Map<String, Object> singleApiParamMap) {
        if (CollectionUtils.isEmpty(apiDatas)) {
            return null;
        }
        if (CollectionUtils.isEmpty(singleApiParamMap)) {
            return apiDatas;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(apiDatas.size());
        for (Map<String, Object> apiData : apiDatas) {
            result.add(this.convertSingleDataResult(apiData, singleApiParamMap));
        }
        return result;
    }

    private Map<String, Object> convertSingleDataResult(Map<String, Object> apiData, Map<String, Object> singleApiParamMap) {
        if (CollectionUtils.isEmpty(apiData)) {
            return null;
        }
        if (CollectionUtils.isEmpty(singleApiParamMap)) {
            return apiData;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(singleApiParamMap.size());
        apiData.forEach((fieldKey, fieldValue) -> {
            String mapFieldKey;
            String apiFieldType;
            Map keyMap = (Map)singleApiParamMap.get(fieldKey);
            if (CollectionUtils.isEmpty((Map)keyMap)) {
                result.put((String)fieldKey, fieldValue);
                return;
            }
            Object value = fieldValue;
            String mapBasedata = (String)keyMap.get("mapBasedata");
            if (!SWCStringUtils.isEmpty((String)mapBasedata)) {
                SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper(mapBasedata);
                DynamicObject dynamicObject = swcDataServiceHelper.generateEmptyDynamicObject();
                dynamicObject.set("id", value);
                value = dynamicObject;
            }
            if ("java.util.Date".equalsIgnoreCase(apiFieldType = (String)keyMap.get("apiFieldType"))) {
                if (value != null) {
                    LOGGER.info("[colla] date value type = {}", (Object)value.getClass().getName());
                }
                if (value instanceof Timestamp) {
                    value = new Date(((Timestamp)value).getTime());
                }
            }
            if (SWCStringUtils.isEmpty((String)(mapFieldKey = (String)keyMap.get("mapFieldKey")))) {
                result.put((String)fieldKey, value);
                return;
            }
            result.put(mapFieldKey, value);
        });
        return result;
    }

    private List<Map<String, Object>> getCommonPersonAPIData(Map<String, Object> apiInfo, CoreHRMessageContentEntity msgEntity, Map<String, Object> paramDatas) {
        QFilter commonPersonFilter = this.getCommonPersonFilter(apiInfo, msgEntity, paramDatas);
        if (commonPersonFilter == null) {
            return null;
        }
        Object result = SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hrcs", (String)String.valueOf(apiInfo.get("service")), (String)String.valueOf(apiInfo.get("method")), (Object[])new Object[]{Long.valueOf(String.valueOf(apiInfo.get("id"))), commonPersonFilter, "id"});
        return HPDIMsResultEntity.build((Object)result).getResultEntity();
    }

    private QFilter getCommonPersonFilter(Map<String, Object> apiInfo, CoreHRMessageContentEntity msgEntity, Map<String, Object> paramDatas) {
        if (CollectionUtils.isEmpty(paramDatas)) {
            return null;
        }
        Map inputParam = (Map)paramDatas.get("inputParam");
        if (CollectionUtils.isEmpty((Map)inputParam)) {
            return null;
        }
        String paramJsonString = (String)apiInfo.get("params");
        if (SWCStringUtils.isEmpty((String)paramJsonString)) {
            return null;
        }
        Map params = null;
        try {
            params = (Map)SWCJSONUtils.cast((String)paramJsonString, Map.class);
        }
        catch (IOException e) {
            LOGGER.error("parse params string error.", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Map)params)) {
            return null;
        }
        ArrayList qFilters = new ArrayList(params.size());
        params.forEach((fieldKey, fieldValue) -> {
            Map inputParamMap = (Map)inputParam.get(fieldKey);
            if (CollectionUtils.isEmpty((Map)inputParamMap)) {
                return;
            }
            String fieldSource = (String)inputParamMap.get("fieldSource");
            if (SWCStringUtils.isEmpty((String)fieldSource)) {
                return;
            }
            Object value = this.getMapValue(fieldSource, msgEntity);
            if (value == null) {
                return;
            }
            qFilters.add(new QFilter(fieldKey, "=", value));
        });
        if (CollectionUtils.isEmpty(qFilters)) {
            return null;
        }
        QFilter qFilter = (QFilter)qFilters.get(0);
        for (int i = 1; i < qFilters.size(); ++i) {
            qFilter.and((QFilter)qFilters.get(i));
        }
        return qFilter;
    }

    private Object getMapValue(String fieldSource, CoreHRMessageContentEntity msgEntity) {
        return ReflectUtils.getFieldValue((String)fieldSource, (Object)msgEntity);
    }

    private Object[] getParams(Map<String, Object> apiInfo, CoreHRMessageContentEntity msgEntity, Map<String, Object> keyMap) {
        String paramJsonString = (String)apiInfo.get("inputparam");
        List params = null;
        try {
            params = (List)SWCJSONUtils.cast((String)paramJsonString, List.class, (Class[])new Class[]{Map.class});
        }
        catch (IOException e) {
            LOGGER.error("parse params string error.", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(10);
        for (Map map : params) {
            result.add(this.getParamObject(map, msgEntity, keyMap));
        }
        return result.toArray();
    }

    private Object getParamObject(Map<String, String> map, CoreHRMessageContentEntity msgEntity, Map<String, Object> inputParams) {
        try {
            LOGGER.info("[colla] getParamObject,map={}, msgEntity={}, inputParams = {}", new Object[]{SWCJSONUtils.toString(map), SWCJSONUtils.toString((Object)msgEntity), SWCJSONUtils.toString(inputParams)});
        }
        catch (IOException ex) {
            LOGGER.error((Throwable)ex);
        }
        String key = map.get("key");
        if (null == key || inputParams == null || inputParams.isEmpty()) {
            return this.getDefault(map);
        }
        try {
            Map keyData = (Map)inputParams.get(key);
            if (CollectionUtils.isEmpty((Map)keyData)) {
                LOGGER.info("[colla] getParamObject getDefault, keyData is Empty");
                return this.getDefault(map);
            }
            String fieldSource = (String)keyData.get("fieldSource");
            if (SWCStringUtils.isEmpty((String)fieldSource)) {
                LOGGER.info("[colla] getParamObject getDefault, fieldSource is Empty");
                return this.getDefault(map);
            }
            Object object = ReflectUtils.getFieldValue((String)fieldSource, (Object)msgEntity);
            if (object == null) {
                LOGGER.info("[colla] getParamObject getDefault, getFieldValue is null");
                return this.getDefault(map);
            }
            return object;
        }
        catch (IllegalArgumentException | SecurityException ex) {
            LOGGER.error((Throwable)ex);
            return this.getDefault(map);
        }
    }

    private Object getDefault(Map<String, String> map) {
        String type = map.get("type");
        String defaultValue = map.get("default");
        if (SWCStringUtils.isEmpty((String)defaultValue)) {
            return null;
        }
        IDataConvertService convertService = DataTransformServiceFactory.getService(type);
        if (convertService == null) {
            return defaultValue;
        }
        return convertService.convert(defaultValue);
    }

    public List<CoreHRMessageContentEntity> splitMsgReceiveLog(DynamicObject msgReceiveLog) {
        long msgReceiveLogId = msgReceiveLog.getLong("id");
        DynamicObject dataBaseObject = new SWCDataServiceHelper("hpdi_msgreceive").queryOne((Object)msgReceiveLogId);
        long actionTypeId = dataBaseObject.getLong("msgaction.actiontype.id");
        IReceiveMsgParseService service = ReceiveMsgParseServiceFactory.getService(actionTypeId);
        List<CoreHRMessageContentEntity> coreHrEntities = service.parse(dataBaseObject);
        return this.loadThirdExtendPoint(coreHrEntities);
    }

    private List<CoreHRMessageContentEntity> loadThirdExtendPoint(List<CoreHRMessageContentEntity> coreHrEntities) {
        if (CollectionUtils.isEmpty(coreHrEntities)) {
            return coreHrEntities;
        }
        ArrayList<Map> param = new ArrayList<Map>(coreHrEntities.size());
        try {
            for (CoreHRMessageContentEntity coreHrEntity : coreHrEntities) {
                Map temp = SWCJSONUtils.convertObjectToMap((Object)coreHrEntity);
                param.add(temp);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AfterParseMsgContentEvent event = new AfterParseMsgContentEvent();
        event.setMsgContentList(param);
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new DefaultCollaMsgReceiveExtServiceImpl(), ICollaMsgReceiveExtService.class, (String)"kd.sdk.swc.hpdi.business.msgreceive.IHPDICollaMsgReceiveExtService#afterParseMsgContent", null);
        proxy.callReplaceIfPresent(ext -> {
            ext.afterParseMsgContent(event);
            return null;
        });
        List eventResult = event.getResult();
        if (CollectionUtils.isEmpty((Collection)eventResult)) {
            return Collections.emptyList();
        }
        return eventResult.stream().map(item -> (CoreHRMessageContentEntity)SWCJSONUtils.map2Bean((Map)item, CoreHRMessageContentEntity.class)).collect(Collectors.toList());
    }

    public Map<String, Object> callCollaRule(Map<String, Object> convertedApiResultData, Map<String, Object> paramMap, List<Map<String, Object>> collaRules) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty(collaRules)) {
            result.put("success", Boolean.TRUE);
            return result;
        }
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("convertedApiResult", convertedApiResultData);
            param.put("paramMap", paramMap);
            param.put("collaRuleMap", collaRules);
            return HPDICloudCollaHelper.getInstance().callCollaRule(param);
        }
        catch (Exception ex) {
            LOGGER.info("[colla] call hsas collarule error.", (Object)ex);
            result.put("success", Boolean.FALSE);
            result.put("msg", ResManager.loadKDString((String)"\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u670d\u52a1\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"HPDICollaMsgServiceHelper_1", (String)"swc-hpdi-business", (Object[])new Object[0]));
            return result;
        }
    }

    private Map<String, Object> getCurrentData(List<Map<String, Object>> result) {
        if (result == null) {
            return null;
        }
        Map<String, Object> currentObject = null;
        for (Map<String, Object> object : result) {
            Boolean isCurrentVersion = MapUtils.getBoolean(object, (Object)"iscurrentversion", (Boolean)Boolean.FALSE);
            if (!isCurrentVersion.booleanValue()) continue;
            currentObject = object;
            break;
        }
        return currentObject;
    }

    private List<Map<String, Object>> queryPersonData(Long apiId, Map<String, List<Map<String, Object>>> apiResultData, Map<Long, String> apiIdNumberMap, Object[] params) {
        List<Map<String, Object>> maps;
        String apiNumber;
        if (!CollectionUtils.isEmpty(apiResultData) && !CollectionUtils.isEmpty(apiIdNumberMap) && SWCStringUtils.isNotEmpty((String)(apiNumber = apiIdNumberMap.get(apiId))) && !CollectionUtils.isEmpty(maps = apiResultData.get(apiNumber))) {
            return maps;
        }
        if (params == null || params.length != 4) {
            return null;
        }
        List result = (List)SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listInfo", (Object[])params);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        return result;
    }

    public Map<String, Object> getDepemp(Long depEmpId, Map<String, List<Map<String, Object>>> apiResultData, Map<Long, String> apiIdNumberMap) {
        List<Map<String, Object>> maps = this.queryPersonData(VerifyBillConstants.DEPEMP_API_NUMBER, apiResultData, apiIdNumberMap, new Object[]{"hrpi_depemp", depEmpId, null, null});
        return this.getCurrentData(maps);
    }

    public Map<String, Object> getPerson(Long personId, Map<String, List<Map<String, Object>>> apiResultData, Map<Long, String> apiIdNumberMap) {
        List<Map<String, Object>> maps = this.queryPersonData(VerifyBillConstants.PERSON_API_NUMBER, apiResultData, apiIdNumberMap, new Object[]{"hrpi_person", personId, null, null});
        return this.getCurrentData(maps);
    }

    public Map<String, Object> getEmpPosRel(Long depEmpId, Map<String, List<Map<String, Object>>> apiResultData, Map<Long, String> apiIdNumberMap) {
        List<Map<String, Object>> maps = this.queryPersonData(VerifyBillConstants.EMP_POS_REL_API_NUMBER, apiResultData, apiIdNumberMap, new Object[]{"hrpi_empposorgrel", null, null, depEmpId});
        return this.getCurrentData(maps);
    }

    public void executeOtherFlowInTasks(DynamicObject[] executeTaskCenter) {
        if (executeTaskCenter == null || executeTaskCenter.length == 0) {
            return;
        }
        List<Long> msgReceiveIds = Arrays.stream(executeTaskCenter).map(item -> item.getLong("orgmsgrecvcenter.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(msgReceiveIds)) {
            return;
        }
        String taskCenterEntityCode = executeTaskCenter[0].getDataEntityType().getName();
        DynamicObject[] taskCenters = new TaskCenterDataHelper(taskCenterEntityCode).getTaskCenterByMsgReceiveIds(SWCHisBaseDataHelper.getSelectProperties((String)taskCenterEntityCode), msgReceiveIds);
        if (taskCenters == null || taskCenters.length == 0) {
            return;
        }
        List<DynamicObject> mustExecuteTask = this.filterMustExecuteTask(taskCenters, executeTaskCenter);
        if (!CollectionUtils.isEmpty(mustExecuteTask)) {
            this.invokeOperate(mustExecuteTask);
        }
    }

    private List<DynamicObject> filterMustExecuteTask(DynamicObject[] queryTask, DynamicObject[] lastTask) {
        HashMap<String, Set<Long>> taskArrangeQueryMap = new HashMap<String, Set<Long>>(16);
        HashSet<Long> currentTaskIdSet = new HashSet<Long>(16);
        HashMap<Long, String> currentMsgExecuteStatus = new HashMap<Long, String>(16);
        HashMap<Long, String> currentMsgMinKey = new HashMap<Long, String>(16);
        HashMap<Long, List> taskMap = new HashMap<Long, List>(16);
        TaskCenterDataHelper taskHelper = new TaskCenterDataHelper();
        for (DynamicObject tempTask : lastTask) {
            long msgId2 = tempTask.getLong("orgmsgrecvcenter.id");
            DynamicObject taskRule = tempTask.getDynamicObject("taskrule");
            String trClass = taskRule.getDynamicObjectType().getName();
            long trId = tempTask.getLong("taskrule.id");
            Set idSet = taskArrangeQueryMap.computeIfAbsent(trClass, item -> new HashSet(16));
            idSet.add(trId);
            currentTaskIdSet.add(tempTask.getLong("id"));
            currentMsgExecuteStatus.put(msgId2, tempTask.getString("taskexecutestatus"));
            currentMsgMinKey.put(msgId2, taskHelper.generateKey(tempTask));
            List maps = taskMap.computeIfAbsent(msgId2, item -> new ArrayList(10));
            maps.add(ImmutableMap.of((Object)"executeStatus", (Object)tempTask.getString("taskexecutestatus"), (Object)"taskKey", (Object)taskHelper.generateKey(tempTask), (Object)"executeCount", (Object)tempTask.getInt("taskexecutenum"), (Object)"flowType", (Object)tempTask.getString("flowtype"), (Object)"collaApp", tempTask.getDynamicObjectCollection("collaapp").stream().map(app -> app.getString("fbasedataid.number")).collect(Collectors.toSet())));
        }
        Table<String, Long, Boolean> isStopWhenError = TaskRuleHelper.queryMergeIsStopWhenError(taskArrangeQueryMap);
        TaskCenterDataHelper taskCenterDataHelper = new TaskCenterDataHelper();
        Map<Long, List<DynamicObject>> nextTaskMap = Arrays.stream(queryTask).collect(Collectors.groupingBy(item -> item.getLong("orgmsgrecvcenter.id")));
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        nextTaskMap.forEach((msgId, tasks) -> {
            DynamicObject tempResult = null;
            if (CollectionUtils.isEmpty((Collection)tasks)) {
                return;
            }
            for (DynamicObject item : tasks) {
                String minKey;
                String executeStatus;
                long id = item.getLong("id");
                if (currentTaskIdSet.contains(id) || !RETRY_STATUS_SET.contains(executeStatus = item.getString("taskexecutestatus"))) continue;
                List lastTaskList = (List)MapUtils.getObject((Map)taskMap, (Object)msgId, Collections.emptyList());
                String flowType = item.getString("flowtype");
                if ("1".equalsIgnoreCase(flowType) && this.isFlowOutTask(item, lastTaskList)) {
                    result.add(item);
                    continue;
                }
                if (item.getInt("taskexecutenum") != 0 || SWCStringUtils.isEmpty((String)(minKey = MapUtils.getString((Map)currentMsgMinKey, (Object)msgId))) || taskHelper.generateKey(item).compareTo(minKey) <= 0) continue;
                DynamicObject taskRule = item.getDynamicObject("taskrule");
                String trClass = taskRule.getDynamicObjectType().getName();
                long trId = item.getLong("taskrule.id");
                Boolean isStop = (Boolean)Optional.ofNullable(isStopWhenError.get((Object)trClass, (Object)trId)).orElse(Boolean.FALSE);
                String currentStatus = MapUtils.getString((Map)currentMsgExecuteStatus, (Object)msgId, (String)"D");
                if (!"D".equals(currentStatus) && isStop.booleanValue()) continue;
                if (tempResult == null) {
                    tempResult = item;
                }
                tempResult = taskCenterDataHelper.generateKey(tempResult).compareToIgnoreCase(taskCenterDataHelper.generateKey(item)) < 0 ? tempResult : item;
            }
            if (tempResult != null) {
                result.add(tempResult);
            }
        });
        return result;
    }

    private boolean isFlowOutTask(DynamicObject item, List<Map<String, Object>> taskMapList) {
        if (CollectionUtils.isEmpty(taskMapList)) {
            return false;
        }
        Set taskAppSet = item.getDynamicObjectCollection("collaapp").stream().map(app -> app.getString("fbasedataid.number")).collect(Collectors.toSet());
        for (Map<String, Object> taskMap : taskMapList) {
            Set verifyApp;
            String flowType = MapUtils.getString(taskMap, (Object)"flowType");
            if (!"2".equals(flowType) || !"D".equalsIgnoreCase(MapUtils.getString(taskMap, (Object)"executeStatus")) || !(verifyApp = (Set)MapUtils.getObject(taskMap, (Object)"collaApp", Collections.emptySet())).containsAll(taskAppSet)) continue;
            return true;
        }
        return false;
    }

    private Set<Long> getIgnoredMsgReceiveIds(DynamicObject[] taskCenters) {
        HashSet<Long> ignoredMsgReceiveIds = new HashSet<Long>(16);
        for (DynamicObject task : taskCenters) {
            long msgReceiveId = task.getLong("orgmsgrecvcenter.id");
            String taskExecuteStatus = task.getString("taskexecutestatus");
            String flowType = task.getString("flowtype");
            if (!"2".equals(flowType) || "D".equalsIgnoreCase(taskExecuteStatus)) continue;
            ignoredMsgReceiveIds.add(msgReceiveId);
        }
        return ignoredMsgReceiveIds;
    }

    private void invokeOperate(List<DynamicObject> delayExecuteTaskList) {
        if (CollectionUtils.isEmpty(delayExecuteTaskList)) {
            return;
        }
        String taskCenterClass = delayExecuteTaskList.stream().findFirst().map(item -> item.getDynamicObjectType().getName()).orElse("hpdi_taskcenter");
        OperateOption opOption = OperateOption.create();
        opOption.setVariableValue("cloudcolla", "true");
        opOption.setVariableValue("ishasright", "true");
        opOption.setVariableValue("skipCheckDataPermission", Boolean.toString(true));
        opOption.setVariableValue("taskexecmanner", "auto");
        OperationServiceHelper.executeOperate((String)"executetask", (String)taskCenterClass, (DynamicObject[])delayExecuteTaskList.toArray(new DynamicObject[0]), (OperateOption)opOption);
        this.executeOtherFlowInTasks(delayExecuteTaskList.toArray(new DynamicObject[0]));
    }

    public Map<String, Object> getTaskRuleVerifyRangeResult(Map<String, Object> convertedApiResultData, Map<String, Object> paramMap, DynamicObject taskRule) {
        String sceneNumber = taskRule.getString("scene.number");
        if (SWCStringUtils.isEmpty((String)sceneNumber)) {
            return this.success(this.noSceneVerifyAll(taskRule));
        }
        Map<String, Object> param = this.getRequestParam(convertedApiResultData, paramMap, taskRule);
        Map ruleResult = (Map)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{param});
        SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult((Map)ruleResult);
        if (!"200".equalsIgnoreCase(sceneResult.getResponseCode())) {
            return this.error(sceneResult.getErrorMsg(), null);
        }
        Map<Long, Map<Long, Boolean>> objectMap = this.parseRuleResult(sceneResult);
        return this.success(this.addPolicyData(objectMap, taskRule));
    }

    private Map<String, Object> noSceneVerifyAll(DynamicObject taskRule) {
        DynamicObjectCollection entryEntity = taskRule.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            long collaRuleId = dynamicObject.getLong("collarule.id");
            String collaRuleClass = dynamicObject.getString("collaruletype");
            if (!dynamicObject.getBoolean("ismanualverify")) continue;
            result.put(collaRuleClass + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + collaRuleId, "VERIFY_PASSED");
        }
        return result;
    }

    private Map<String, Object> addPolicyData(Map<Long, Map<Long, Boolean>> objectMap, DynamicObject taskRule) {
        long policyId = taskRule.getLong("policy.id");
        DynamicObjectCollection entryEntity = taskRule.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return Collections.emptyMap();
        }
        Map<Long, Boolean> ruleResult = objectMap.get(policyId);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            long ruleId = dynamicObject.getLong("ruledesign.id");
            long collaRuleId = dynamicObject.getLong("collarule.id");
            String collaRuleClass = dynamicObject.getString("collaruletype");
            if (!dynamicObject.getBoolean("ismanualverify")) {
                result.put(collaRuleClass + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + collaRuleId, "DO_NOT_VERIFY");
                continue;
            }
            if (ruleId == 0L) {
                result.put(collaRuleClass + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + collaRuleId, "VERIFY_ALL");
                continue;
            }
            LOGGER.info("[colla] HPDICollaMsgServiceHelper.addPolicyData ruleResult = {},ruleId = {}", ruleResult, (Object)ruleId);
            Boolean isVerify = ruleResult != null && ruleResult.getOrDefault(ruleId, Boolean.FALSE) != false;
            result.put(collaRuleClass + PayRollActGrpConstants.COLLA_RULE_ID_SEPERATOR + collaRuleId, isVerify != false ? "VERIFY_PASSED" : "VERIFY_NOT_PASS");
        }
        return result;
    }

    private Map<Long, Map<Long, Boolean>> parseRuleResult(SceneResult ruleResultMap) {
        List policyResults = ruleResultMap.getPolicyResults();
        if (CollectionUtils.isEmpty((Collection)policyResults)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<Long, Boolean>> result = new HashMap<Long, Map<Long, Boolean>>(16);
        for (PolicyResult policyResult : policyResults) {
            Long policyId = policyResult.getPolicyId();
            String policyNumber = policyResult.getPolicyNumber();
            List ruleResults = policyResult.getRuleResults();
            if (CollectionUtils.isEmpty((Collection)ruleResults)) continue;
            for (RuleResult ruleResult : ruleResults) {
                Long ruleDesignId = ruleResult.getRuleDesignId();
                String ruleNumber = ruleResult.getRuleNumber();
                Map matchResults = ruleResult.getMatchResults();
                if (CollectionUtils.isEmpty((Map)matchResults)) continue;
                String value = (String)matchResults.get("result_str");
                Map policyData = result.computeIfAbsent(policyId, key -> new HashMap(16));
                policyData.put(ruleDesignId, "success".equalsIgnoreCase(value));
            }
        }
        return result;
    }

    private Map<String, Object> success(Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.TRUE);
        result.put("data", data);
        return result;
    }

    private Map<String, Object> error(String msg, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.FALSE);
        result.put("data", data);
        result.put("msg", msg);
        return result;
    }

    private Map<String, Object> getRequestParam(Map<String, Object> convertedApiResultData, Map<String, Object> paramMap, DynamicObject taskRule) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("tenantId", "");
        requestMap.put("cloudId", "/U+QDTL900//");
        requestMap.put("bizApp", taskRule.getString("scene.bizappid.number"));
        requestMap.put("sceneNumber", taskRule.getString("scene.number"));
        requestMap.put("buNumber", paramMap.get("buNumber"));
        requestMap.put("inputParams", this.getRuleEngineInputParams(convertedApiResultData, paramMap));
        requestMap.put("executePolicyIds", Collections.singletonList(taskRule.getLong("policy.id")));
        return requestMap;
    }

    private Map<String, Object> getRuleEngineInputParams(Map<String, Object> convertedApiDatas, Map<String, Object> paramMap) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty(convertedApiDatas)) {
            return result;
        }
        convertedApiDatas.forEach((key, dataList) -> {
            Object tempResult = this.pickRuleEngineDataFromList((List)dataList);
            if (tempResult instanceof Map) {
                ((Map)tempResult).forEach((resultKey, resultValue) -> result.put(resultKey.replaceAll("\\.", "_"), resultValue));
                return;
            }
            if (tempResult instanceof DynamicObject) {
                result.put(((DynamicObject)tempResult).getDataEntityType().getName(), tempResult);
                return;
            }
            result.put((String)key, tempResult);
        });
        result.put("isInbound", paramMap.get("isInbound"));
        result.put("flowType", paramMap.get("flowType"));
        Map<String, Object> msgEntity = paramMap.getOrDefault("msgEntity", Collections.emptyMap());
        msgEntity.forEach((key, value) -> result.putIfAbsent((String)key, value));
        return result;
    }

    private Object pickRuleEngineDataFromList(List<Object> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return null;
        }
        Object firstData = dataList.get(0);
        if (firstData instanceof Map) {
            return firstData;
        }
        if (firstData instanceof DynamicObject) {
            IDataEntityType dataEntityType = ((DynamicObject)firstData).getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            boolean isContainCurrentVersion = properties.containsKey((Object)"iscurrentversion");
            if (!isContainCurrentVersion) {
                return firstData;
            }
            for (Object data : dataList) {
                DynamicObject tempData = (DynamicObject)data;
                if (!tempData.getBoolean("iscurrentversion")) continue;
                return tempData;
            }
        }
        return firstData;
    }

    public Map<String, Object> validateMsgEntity(CoreHRMessageContentEntity entity) {
        Long depempId = entity.getDepempId();
        Long personId = entity.getPersonId();
        Long employeeId = entity.getEmployeeId();
        ArrayList<String> msgList = new ArrayList<String>(10);
        Boolean isSuccess = Boolean.TRUE;
        if (personId == null || personId == 0L) {
            isSuccess = Boolean.FALSE;
            msgList.add(ResManager.loadKDString((String)"\u81ea\u7136\u4eba\u6570\u636e\u5f02\u5e38\uff0chrpi_person = {0}\u3002", (String)"HPDICollaMsgServiceHelper_2", (String)"swc-hpdi-business", (Object[])new Object[]{personId}));
        }
        if (employeeId == null || employeeId == 0L) {
            isSuccess = Boolean.FALSE;
            msgList.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u4eba\u6570\u636e\u5f02\u5e38\uff0chrpi_employee = {0}\u3002", (String)"HPDICollaMsgServiceHelper_3", (String)"swc-hpdi-business", (Object[])new Object[]{employeeId}));
        }
        if (depempId == null || depempId == 0L) {
            isSuccess = Boolean.FALSE;
            msgList.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4eba\u6570\u636e\u5f02\u5e38\uff0chrpi_depemp = {0}\u3002", (String)"HPDICollaMsgServiceHelper_4", (String)"swc-hpdi-business", (Object[])new Object[]{depempId}));
        }
        if (isSuccess.booleanValue()) {
            return this.success(entity);
        }
        msgList.add(0, ResManager.loadKDString((String)"\u5355\u636e\u201c{0}\u201d\u7684\u4e8b\u7269\u53d8\u52a8\u8bb0\u5f55\u6570\u636e\u6821\u9a8c\u9519\u8bef\uff1a", (String)"HPDICollaMsgServiceHelper_5", (String)"swc-hpdi-business", (Object[])new Object[]{entity.getBillNo()}));
        return this.error(msgList.stream().collect(Collectors.joining(System.lineSeparator())), entity);
    }

    public Map<String, Object> apiResultProcessing(Map<String, Object> apiConvertedResultData, CoreHRMessageContentEntity msgEntity, Map<Long, String> apiIdNumberMap) {
        Long recordId = msgEntity.getRecordId();
        if (CollectionUtils.isEmpty(apiConvertedResultData) || recordId == null || recordId == 0L || CollectionUtils.isEmpty(apiIdNumberMap)) {
            return apiConvertedResultData;
        }
        Map<String, Long> apiNumberIdMap = apiIdNumberMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, Object> newValueMap = this.extracted(apiConvertedResultData, msgEntity);
        if (CollectionUtils.isEmpty(newValueMap)) {
            return apiConvertedResultData;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(apiConvertedResultData.size());
        result.putAll(apiConvertedResultData);
        result.putAll(newValueMap);
        return result;
    }

    private Map<String, Object> extracted(Map<String, Object> apiConvertedResultData, CoreHRMessageContentEntity msgEntity) {
        Long recordId = msgEntity.getRecordId();
        HashMap<String, Object> newValueMap = new HashMap<String, Object>(16);
        Map<String, List<Map<String, Object>>> chgRecordDetails = this.convertChangeRecordDetailResult(this.queryChgRecordDetail(recordId));
        List<IApiResultHandler> iApiResultHandlers = this.registryHandler();
        apiConvertedResultData.forEach((apiNumber, apiDataList) -> {
            if (!(apiDataList instanceof List)) {
                return;
            }
            List tempList = (List)apiDataList;
            if (CollectionUtils.isEmpty((Collection)tempList)) {
                return;
            }
            Object firstObject = tempList.get(0);
            if (!(firstObject instanceof DynamicObject)) {
                return;
            }
            String entityName = ((DynamicObject)firstObject).getDynamicObjectType().getName();
            List<DynamicObject> tempResult = new ArrayList<DynamicObject>(tempList.size());
            for (Object tempObject : tempList) {
                if (!(tempObject instanceof DynamicObject)) continue;
                tempResult.add((DynamicObject)tempObject);
            }
            for (IApiResultHandler handler : iApiResultHandlers) {
                if (SWCStringUtils.isEmpty((String)entityName) || !handler.getEntityNameSet().contains(entityName.toLowerCase(Locale.ROOT))) continue;
                List chgRecordDetail = chgRecordDetails.getOrDefault(entityName, new ArrayList(10));
                if (!handler.getEntityNameSet().contains(entityName.toLowerCase(Locale.ROOT))) continue;
                tempResult = handler.execute(tempResult, chgRecordDetail, msgEntity);
                newValueMap.put((String)apiNumber, tempResult);
            }
        });
        return newValueMap;
    }

    private List<IApiResultHandler> registryHandler() {
        ArrayList<IApiResultHandler> iApiResultHandlers = new ArrayList<IApiResultHandler>(10);
        iApiResultHandlers.add(new JobLevelApiResultHandler());
        iApiResultHandlers.add(new LaborRelRecordApiResultHandler());
        iApiResultHandlers.add(new PerEduExpApiResultHandler());
        return iApiResultHandlers;
    }

    private Map<String, List<Map<String, Object>>> convertChangeRecordDetailResult(Map<String, Object> queryResult) {
        if (CollectionUtils.isEmpty(queryResult)) {
            return Collections.emptyMap();
        }
        Boolean success = MapUtils.getBoolean(queryResult, (Object)"success");
        if (success == null || !success.booleanValue()) {
            return Collections.emptyMap();
        }
        Map data = (Map)queryResult.get("data");
        if (CollectionUtils.isEmpty((Map)data)) {
            return Collections.emptyMap();
        }
        List dataMap = (List)data.get("data");
        if (CollectionUtils.isEmpty((Collection)dataMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(16);
        for (Map objectMap : dataMap) {
            String entity = MapUtils.getString((Map)objectMap, (Object)"entity");
            if (SWCStringUtils.isEmpty((String)entity)) continue;
            List mapList = result.computeIfAbsent(entity, item -> new ArrayList(10));
            mapList.add(objectMap);
        }
        return result;
    }

    private Map<String, Object> queryChgRecordDetail(Long recordId) {
        if (recordId == null || recordId == 0L) {
            return Collections.emptyMap();
        }
        return (Map)SWCMServiceUtils.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoDetailByRecordId", (Object[])new Object[]{recordId});
    }

    public Map<String, List<Map<String, Object>>> queryHrpfChgRecordDetail(Long recordId) {
        Map<String, Object> result = this.queryChgRecordDetail(recordId);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyMap();
        }
        Boolean isSuccess = MapUtils.getBoolean(result, (Object)"success", (Boolean)Boolean.FALSE);
        if (!isSuccess.booleanValue()) {
            return Collections.emptyMap();
        }
        Map data = MapUtils.getMap(result, (Object)"data", Collections.emptyMap());
        List chgList = (List)MapUtils.getObject((Map)data, (Object)"data", Collections.emptyList());
        return chgList.stream().collect(Collectors.groupingBy(item -> MapUtils.getString((Map)item, (Object)"entity")));
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("B");
        tempSet.add("E");
        tempSet.add("F");
        RETRY_STATUS_SET = Collections.unmodifiableSet(tempSet);
    }

    private static class Load {
        private static final HPDICollaMsgServiceHelper INSTANCE = new HPDICollaMsgServiceHelper();

        private Load() {
        }
    }
}

