/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.msgreceive;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.basedata.BUValueHelper;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.factory.CollaTaskServiceFactory;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hpdi.business.msgreceive.HPDICollaMsgServiceHelper;
import kd.swc.hpdi.business.msgreceive.TaskCenterDataHelper;
import kd.swc.hpdi.business.service.ICollaTaskService;
import kd.swc.hpdi.common.entity.CollaResultEntity;
import kd.swc.hpdi.common.entity.CoreHRMessageContentEntity;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class TaskCenterCreateAsyncHelper {
    private static final Log log = LogFactory.getLog(TaskCenterCreateAsyncHelper.class);

    private TaskCenterCreateAsyncHelper() {
    }

    public static TaskCenterCreateAsyncHelper getInstance() {
        return Load.msgReceiveCenterReceiveHelper;
    }

    public Future<CollaResultEntity<String>> createTaskByMsg(DynamicObject msgReceiveLog) {
        return SWCThreadPoolFactory.getTaskCenterCreateThreadPool().submit((Callable)new TaskCenterCreateRunnable(msgReceiveLog));
    }

    public List<DynamicObject> generateTaskCenter(Map<String, Object> fieldDataMap) {
        Object taskArrange;
        String collaTaskEntityCode = null;
        if (fieldDataMap != null && (taskArrange = fieldDataMap.get("taskArrange")) != null) {
            collaTaskEntityCode = HPDICloudCollaHelper.getInstance().matchCollaTaskNumber(((DynamicObject)taskArrange).getDataEntityType().getName());
        }
        ICollaTaskService service = CollaTaskServiceFactory.getService(collaTaskEntityCode);
        return service.createCollaTaskEachAppFromMap(fieldDataMap);
    }

    public CollaResultEntity<String> saveTaskManagement(List<DynamicObject> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return new CollaResultEntity().fail(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u6709\u6548\u7684\u534f\u4f5c\u4efb\u52a1\u9700\u8981\u4fdd\u5b58\u3002", (String)"TaskCenterCreateAsyncHelper_7", (String)"swc-hpdi-business", (Object[])new Object[0]));
        }
        return TaskCenterDataHelper.batchSaveTask(tasks);
    }

    private DynamicObject getMapBU(DynamicObject msgRecieveLog, CoreHRMessageContentEntity msgEntity) {
        String msgSubNo = msgRecieveLog.getString("msgsubno");
        Map<String, Object> buMap = BUValueHelper.matchHrBu(msgSubNo, msgEntity);
        log.info("[colla]:getMapBU buMap = {}", buMap);
        if (null != buMap && !buMap.isEmpty()) {
            DynamicObject hrBuDyobj = (DynamicObject)buMap.get("hrbu");
            return hrBuDyobj;
        }
        return null;
    }

    private DynamicObject matchTaskRuleDyobj(DynamicObject orgMsgReceiveCenterDyobj, Long buId) {
        return this.matchTaskRuleDyobj(orgMsgReceiveCenterDyobj.getString("msgsubno"), buId);
    }

    public DynamicObject matchTaskRuleDyobj(String msgSubNo, Long buId) {
        return this.matchTaskRuleDyobj(msgSubNo, buId, null);
    }

    public DynamicObject matchTaskRuleDyobj(String msgSubNo, Long buId, String currentTaskArrangeName) {
        if (SWCStringUtils.isEmpty((String)currentTaskArrangeName)) {
            currentTaskArrangeName = HPDICloudCollaHelper.getInstance().getCurrentTaskArrangeNumber();
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(currentTaskArrangeName);
        QFilter qFilter = new QFilter("createorg", "=", (Object)buId);
        qFilter.and(new QFilter("msgsubscriber.msgsubno", "=", (Object)msgSubNo));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        return serviceHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)currentTaskArrangeName), new QFilter[]{qFilter});
    }

    private class TaskCenterCreateRunnable
    implements Callable<CollaResultEntity<String>> {
        private DynamicObject msgReceiveObject;
        private List<String> errorMsg = new ArrayList<String>(10);

        TaskCenterCreateRunnable(DynamicObject msgReceiveObject) {
            this.msgReceiveObject = msgReceiveObject;
        }

        @Override
        public CollaResultEntity<String> call() {
            try {
                CollaResultEntity<String> saveTaskManagement;
                List<CoreHRMessageContentEntity> msgs = HPDICollaMsgServiceHelper.getInstance().splitMsgReceiveLog(this.msgReceiveObject);
                if (msgs == null || msgs.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u6d88\u606f\u672a\u62c6\u5206\u51fa\u6709\u6548\u7684\u534f\u4f5c\u4efb\u52a1\u3002", (String)"TaskCenterCreateAsyncHelper_3", (String)"swc-hpdi-business", (Object[])new Object[0]));
                }
                ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(msgs.size());
                ArrayList<Map<String, Object>> verifyBills = new ArrayList<Map<String, Object>>(msgs.size());
                for (int i = 0; i < msgs.size(); ++i) {
                    CoreHRMessageContentEntity msgEntity = msgs.get(i);
                    Map<String, Object> validateResult = HPDICollaMsgServiceHelper.getInstance().validateMsgEntity(msgEntity);
                    if (!((Boolean)validateResult.get("success")).booleanValue()) {
                        throw new KDBizException((String)validateResult.get("msg"));
                    }
                    DynamicObject bu = TaskCenterCreateAsyncHelper.this.getMapBU(this.msgReceiveObject, msgEntity);
                    if (bu == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u5339\u914d\u5931\u8d25\u3002", (String)"TaskCenterCreateAsyncHelper_4", (String)"swc-hpdi-business", (Object[])new Object[0]));
                    }
                    DynamicObject taskRule = TaskCenterCreateAsyncHelper.this.matchTaskRuleDyobj(this.msgReceiveObject, bu.getLong("id"));
                    this.validateTaskRule(taskRule, bu);
                    Map<Long, String> taskVerifyConfig = CollaMsgVerifyBillHelper.getInstance().getTaskVerifyConfig(taskRule);
                    if (!CollectionUtils.isEmpty(taskVerifyConfig)) {
                        List dataResult;
                        Map<String, Object> tempResult = CollaMsgVerifyBillHelper.getInstance().generateVerifyBill(taskRule, this.msgReceiveObject, msgEntity, bu, i + 1);
                        if (!((Boolean)tempResult.get("success")).booleanValue()) {
                            throw new KDBizException((String)tempResult.get("msg"));
                        }
                        String resultCode = (String)tempResult.get("code");
                        if ("MUST_VERIFY".equalsIgnoreCase(resultCode) && !CollectionUtils.isEmpty((Collection)(dataResult = (List)tempResult.get("data")))) {
                            verifyBills.addAll(dataResult);
                        }
                        tasks.addAll(this.getTask(i, msgEntity, bu, taskRule, this.getVerifyApp(tempResult, taskRule)));
                        continue;
                    }
                    tasks.addAll(this.getTask(i, msgEntity, bu, taskRule, Collections.emptySet()));
                }
                if (!CollectionUtils.isEmpty(verifyBills)) {
                    CollaMsgVerifyBillHelper.getInstance().saveSummaryVerifyBills(verifyBills);
                }
                if (!CollectionUtils.isEmpty(tasks) && !(saveTaskManagement = TaskCenterCreateAsyncHelper.this.saveTaskManagement(tasks)).isSuccess()) {
                    throw new KDBizException(saveTaskManagement.getMsg());
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.errorMsg.add(e.getMessage());
            }
            if (!this.errorMsg.isEmpty()) {
                this.fail(this.msgReceiveObject, this.errorMsg);
                return new CollaResultEntity().fail(this.errorMsg.stream().collect(Collectors.joining(System.lineSeparator())));
            }
            this.success(this.msgReceiveObject);
            return new CollaResultEntity().success(null);
        }

        private Set<String> getVerifyApp(Map<String, Object> tempResult, DynamicObject taskRule) {
            List dataList = (List)MapUtils.getObject(tempResult, (Object)"data", Collections.emptyList());
            List verifyBill = dataList.stream().map(item -> (DynamicObject)MapUtils.getObject((Map)item, (Object)"verifyBill")).collect(Collectors.toList());
            HashSet<String> result = new HashSet<String>(16);
            for (DynamicObject dynamicObject : verifyBill) {
                DynamicObjectCollection verifyApp = dynamicObject.getDynamicObjectCollection("verifyapp");
                if (CollectionUtils.isEmpty((Collection)verifyApp)) continue;
                result.addAll(verifyApp.stream().map(item -> item.getString("fbasedataid.number")).collect(Collectors.toSet()));
            }
            return result;
        }

        private void validateTaskRule(DynamicObject taskRule, DynamicObject bu) {
            if (taskRule == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u521b\u5efa\u7ec4\u7ec7\u4e3a\u201c{0}\u201d\u7684\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u3002", (String)"TaskCenterCreateAsyncHelper_5", (String)"swc-hpdi-business", (Object[])new Object[]{bu.getString("name")}));
            }
            String trNumber = taskRule.getString("number");
            ArrayList<String> errorMsg = new ArrayList<String>(10);
            DynamicObjectCollection entryEntity = taskRule.getDynamicObjectCollection("entryentity");
            HashMap<String, Set<Long>> queryParam = new HashMap<String, Set<Long>>();
            for (DynamicObject entry : entryEntity) {
                String crClass = entry.getString("collaruletype");
                long crId = entry.getLong("collarule.id");
                if (SWCStringUtils.isEmpty((String)crClass) || crId == 0L) continue;
                Set crIdSet = queryParam.computeIfAbsent(crClass, item -> new HashSet(16));
                crIdSet.add(crId);
            }
            Table<String, Long, DynamicObject> crTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(queryParam, "id,name,number,enable,status,frfieldrule.id,frfieldrule.enable,frfieldrule.status,frfieldrule.name,frfieldrule.number");
            for (DynamicObject entry : entryEntity) {
                DynamicObjectCollection crEntry;
                DynamicObject cr;
                String crClass = entry.getString("collaruletype");
                long crId = entry.getLong("collarule.id");
                if (SWCStringUtils.isEmpty((String)crClass) || crId == 0L || (cr = (DynamicObject)crTable.get((Object)crClass, (Object)crId)) == null) continue;
                if (!"C".equalsIgnoreCase(cr.getString("status")) || !"1".equalsIgnoreCase(cr.getString("enable"))) {
                    errorMsg.add(ResManager.loadKDString((String)"\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u201c{0}\u201d\u6240\u5f15\u7528\u7684\u534f\u4f5c\u89c4\u5219\u201c{1}\u201d\u4e0d\u662f\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u63d0\u4ea4\u5ba1\u6838\u6216\u542f\u7528\u540e\u518d\u8bd5\u3002", (String)"TaskCenterCreateAsyncHelper_8", (String)"swc-hpdi-business", (Object[])new Object[]{trNumber, cr.getString("number")}));
                }
                if (CollectionUtils.isEmpty((Collection)(crEntry = cr.getDynamicObjectCollection("entryentity")))) continue;
                for (DynamicObject crEntryRow : crEntry) {
                    DynamicObjectCollection frEntry = crEntryRow.getDynamicObjectCollection("fieldrulesubentryentity");
                    if (CollectionUtils.isEmpty((Collection)frEntry)) continue;
                    for (DynamicObject frRow : frEntry) {
                        DynamicObject frObject = frRow.getDynamicObject("frfieldrule");
                        if (frObject == null || "C".equalsIgnoreCase(frObject.getString("status")) && "1".equalsIgnoreCase(frObject.getString("enable"))) continue;
                        errorMsg.add(ResManager.loadKDString((String)"\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u201c{0}\u201d\u6240\u5f15\u7528\u7684\u534f\u4f5c\u89c4\u5219\u201c{1}\u201d\u4e0d\u662f\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u63d0\u4ea4\u5ba1\u6838\u6216\u542f\u7528\u540e\u518d\u8bd5\u3002", (String)"TaskCenterCreateAsyncHelper_9", (String)"swc-hpdi-business", (Object[])new Object[]{trNumber, frObject.getString("number")}));
                    }
                }
            }
            if (!CollectionUtils.isEmpty(errorMsg)) {
                throw new KDBizException(errorMsg.stream().collect(Collectors.joining(System.lineSeparator())));
            }
        }

        private List<DynamicObject> getTask(int index, CoreHRMessageContentEntity msgEntity, DynamicObject bu, DynamicObject taskRule, Set<String> blackAppNumberSet) {
            HPDICollaMsgServiceHelper instance = HPDICollaMsgServiceHelper.getInstance();
            Map<String, Object> depEmp = instance.getDepemp(msgEntity.getDepempId(), null, null);
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(taskRule.getDataEntityType().getName());
            HashMap<String, Object> fieldDataMap = new HashMap<String, Object>();
            fieldDataMap.put("executeType", "auto");
            fieldDataMap.put("executeSeq", index + 1);
            fieldDataMap.put("flowType", msgEntity.getFlowType());
            fieldDataMap.put("changeTime", msgEntity.getEffectTime());
            fieldDataMap.put("orgTeam", depEmp.get("adminorg_id"));
            fieldDataMap.put("dutyWorkRole", depEmp.get("dutyworkroles_id"));
            fieldDataMap.put("taskArrange", taskRule);
            fieldDataMap.put("taskArrangeV", serviceHelper.generateDynamicObject((Object)taskRule.getLong("sourcevid"), SWCHisBaseDataHelper.getSelectProperties((String)taskRule.getDynamicObjectType().getName())));
            fieldDataMap.put("bu", bu);
            fieldDataMap.put("msgReceiveLog", this.msgReceiveObject);
            fieldDataMap.put("personId", msgEntity.getPersonId());
            fieldDataMap.put("employeeId", msgEntity.getEmployeeId());
            fieldDataMap.put("blackAppNumberSet", blackAppNumberSet);
            fieldDataMap.put("depempId", msgEntity.getDepempId());
            fieldDataMap.put("cmpempId", msgEntity.getComempId());
            return TaskCenterCreateAsyncHelper.this.generateTaskCenter(fieldDataMap);
        }

        private void success(DynamicObject msgRecieveLog) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hpdi_msgreceive");
            msgRecieveLog.set("taskcreatestatus", (Object)"B");
            serviceHelper.update(new DynamicObject[]{msgRecieveLog});
        }

        private void fail(DynamicObject msgRecieveLog, List<String> msgs) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hpdi_msgreceive");
            String msg = "";
            if (!CollectionUtils.isEmpty(msgs)) {
                msg = msgs.stream().collect(Collectors.joining(System.lineSeparator()));
            }
            msgRecieveLog.set("taskcreatestatus", (Object)"C");
            if (SWCStringUtils.isNotEmpty((String)msg) && msg.length() > 255) {
                msg = msg.substring(0, 255);
            }
            msgRecieveLog.set("errormsg", (Object)msg);
            serviceHelper.update(new DynamicObject[]{msgRecieveLog});
        }
    }

    private static class Load {
        private static final TaskCenterCreateAsyncHelper msgReceiveCenterReceiveHelper = new TaskCenterCreateAsyncHelper();

        private Load() {
        }
    }
}

