/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.msgreceive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.common.entity.CollaResultEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskCenterDataHelper {
    private static final Log LOGGER = LogFactory.getLog(TaskCenterDataHelper.class);
    private static final String SELECT_PROPERTIES = "id,org,name,number,flowtype,collaapp,orgmsgrecvcenter,executeseq,createtime,taskcreatemanner,taskexecutestatus,taskexecutedate,entryentity,entryentity.collaruleclass,entryentity.collarule,entryentity.taskexecutestatusent";
    private SWCDataServiceHelper taskCenterOrm;

    public TaskCenterDataHelper() {
        this.taskCenterOrm = new SWCDataServiceHelper(HPDICloudCollaHelper.getInstance().getCurrentCollaTaskNumber());
    }

    public TaskCenterDataHelper(String entityCode) {
        this.taskCenterOrm = StringUtil.isEmptyString((String)entityCode) ? new SWCDataServiceHelper(HPDICloudCollaHelper.getInstance().getCurrentCollaTaskNumber()) : new SWCDataServiceHelper(entityCode);
    }

    public DynamicObject[] getTaskCenterByMsgReceiveId(Long MsgReceiveId) {
        if (MsgReceiveId == null || MsgReceiveId == 0L) {
            return null;
        }
        QFilter qFilter = new QFilter("orgmsgrecvcenter", "=", (Object)MsgReceiveId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] result = this.taskCenterOrm.query(SELECT_PROPERTIES, new QFilter[]{qFilter, enableFilter}, "executeseq asc");
        return result;
    }

    public DynamicObject[] getTaskCenterByMsgReceiveIds(List<Long> MsgRecieveIds) {
        return this.getTaskCenterByMsgReceiveIds(SELECT_PROPERTIES, MsgRecieveIds);
    }

    public DynamicObject[] getTaskCenterByMsgReceiveIds(String queryProperty, List<Long> MsgReceiveIds) {
        if (MsgReceiveIds == null || MsgReceiveIds.size() == 0) {
            return null;
        }
        QFilter idFilter = new QFilter("orgmsgrecvcenter", "in", MsgReceiveIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] result = this.taskCenterOrm.query(queryProperty, new QFilter[]{idFilter, enableFilter}, "orgmsgrecvcenter.id asc");
        return result;
    }

    private static CollaResultEntity<List<DynamicObject>> saveTask(List<DynamicObject> tasks) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", Boolean.toString(true));
        operateOption.setVariableValue("skipCheckDataPermission", Boolean.toString(true));
        operateOption.setVariableValue("strictvalidation", Boolean.toString(true));
        OperationResult saveResult = new OperationServiceImpl().localInvokeOperation("save", tasks.toArray(new DynamicObject[0]), operateOption);
        if (saveResult.isSuccess()) {
            return new CollaResultEntity().success(tasks);
        }
        List allErrorOrValidateInfo = saveResult.getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            return new CollaResultEntity().fail(null);
        }
        StringBuilder msg = new StringBuilder();
        for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
            if (msg.length() == 0) {
                msg.append(iOperateInfo);
                continue;
            }
            msg.append(System.lineSeparator()).append(iOperateInfo);
        }
        return new CollaResultEntity().fail(msg.toString());
    }

    public static CollaResultEntity<String> batchSaveTask(List<DynamicObject> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return new CollaResultEntity().success(null);
        }
        HashMap<String, List> insertMap = new HashMap<String, List>(16);
        for (DynamicObject task : tasks) {
            String type2 = task.getDynamicObjectType().getName();
            List tempList = insertMap.computeIfAbsent(type2, item -> new ArrayList(10));
            tempList.add(task);
        }
        if (CollectionUtils.isEmpty(insertMap)) {
            return new CollaResultEntity().success(null);
        }
        try {
            insertMap.forEach((type, dataList) -> {
                CollaResultEntity<List<DynamicObject>> listCollaResultEntity = TaskCenterDataHelper.saveTask(dataList);
                if (!listCollaResultEntity.isSuccess()) {
                    throw new KDBizException(listCollaResultEntity.getMsg());
                }
            });
        }
        catch (Exception ex) {
            LOGGER.info("[colla] save colla task error.", (Object)ex);
            return new CollaResultEntity().fail(ex.getMessage());
        }
        return new CollaResultEntity().success(null);
    }

    private Map<String, Object> convertTaskCenterToMap(DynamicObject taskCenter) {
        if (taskCenter == null) {
            return Collections.emptyMap();
        }
        String typeName = taskCenter.getDynamicObjectType().getName();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("flowType", taskCenter.getString("flowtype"));
        result.put("cmpEmpId", taskCenter.getLong("cmpemp.id"));
        result.put("depEmpId", taskCenter.getLong("depemp.id"));
        result.put("employeeId", taskCenter.getLong("employee.id"));
        result.put("msgSubId", taskCenter.getLong("orgmsgrecvcenter.id"));
        result.put("personId", taskCenter.getLong("person.id"));
        result.put("taskCenterClass", typeName);
        result.put("taskCenterId", taskCenter.getLong("id"));
        result.put("dutyWorkRoleId", taskCenter.getLong("dutyworkrole.id"));
        result.put("orgTeamId", taskCenter.getLong("orgteam.id"));
        result.put("collaApp", taskCenter.getDynamicObjectCollection("collaapp").stream().map(dy -> dy.getString("fbasedataid.number")).collect(Collectors.toSet()));
        result.put("isPrimary", taskCenter.getBoolean("depemp.isprimary"));
        DynamicObjectCollection entry = taskCenter.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entry)) {
            return result;
        }
        List entryEntity = (List)result.computeIfAbsent("entryEntity", item -> new ArrayList(10));
        for (DynamicObject dynamicObject : entry) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
            tempMap.put("executeStatus", dynamicObject.getString("taskexecutestatusent"));
            tempMap.put("isManualVerify", dynamicObject.getBoolean("ismanualverify"));
            tempMap.put("payRollActGrpId", dynamicObject.getLong("collarule.id"));
            tempMap.put("payRollActGrpClass", dynamicObject.getString("collaruleclass"));
            tempMap.put("payRollActGrpVid", dynamicObject.getLong("collarulev.id"));
            tempMap.put("centerEntId", dynamicObject.getLong("id"));
            tempMap.put("result", dynamicObject.getString("result"));
            entryEntity.add(tempMap);
        }
        return result;
    }

    public Map<String, List<Map<String, Object>>> queryAllTaskCenterByMsgId(String tcClass, long msgCenterId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(tcClass);
        DynamicObject[] query = helper.query("id,employee,person,depemp,cmpemp,flowtype,orgmsgrecvcenter,collaruleclass,collarule,collarulev,taskexecutestatusent,ismanualverify,result,dutyworkrole,orgteam,collaapp", new QFilter[]{new QFilter("orgmsgrecvcenter.id", "=", (Object)msgCenterId), new QFilter("enable", "=", (Object)"1")});
        if (query == null || query.length < 1) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(16);
        for (DynamicObject dynamicObject : query) {
            String flowType = dynamicObject.getString("flowtype");
            if (SWCStringUtils.isEmpty((String)flowType)) {
                flowType = "0";
            }
            List tempList = result.computeIfAbsent(flowType, item -> new ArrayList(10));
            Map<String, Object> tempMap = this.convertTaskCenterToMap(dynamicObject);
            if (CollectionUtils.isEmpty(tempMap)) continue;
            tempList.add(tempMap);
        }
        return result;
    }

    public String generateKey(DynamicObject dataEntity) {
        Long msgId = dataEntity.getLong("orgmsgrecvcenter.id");
        String flowType = dataEntity.getString("flowtype");
        int flowTypeInt = 0;
        switch (flowType) {
            case "2": {
                flowTypeInt = 1;
                break;
            }
            case "1": {
                flowTypeInt = 2;
                break;
            }
            case "0": {
                flowTypeInt = 3;
                break;
            }
        }
        int msgIndex = dataEntity.getInt("executeseq");
        int arrangeIndex = dataEntity.getInt("arrangeseq");
        return String.format("%s#%04d#%04d#%04d", msgId, flowTypeInt, msgIndex, arrangeIndex);
    }
}

