/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.msgreceive;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.basedata.SubApiSettingHelper;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hpdi.business.msgreceive.HPDICollaMsgServiceHelper;
import kd.swc.hpdi.business.msgreceive.TaskCenterDataHelper;
import kd.swc.hpdi.common.entity.CollaResultEntity;
import kd.swc.hpdi.common.entity.CoreHRMessageContentEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import org.apache.commons.collections4.MapUtils;

public class TaskCenterExecuteAsyncHelper {
    private static final Log log = LogFactory.getLog(TaskCenterExecuteAsyncHelper.class);
    public static final Long PERSON_API_ID = 1355771386509054976L;
    public static final Long EMPLOYEE_API_ID = 1355777059179385856L;
    public static final Long CMPEMP_API_ID = 1355822002220487680L;
    public static final Long DEPEMP_API_ID = 1355810811012109312L;

    public static final TaskCenterExecuteAsyncHelper getInstance() {
        return Load.msgReceiveCenterReceiveHelper;
    }

    private boolean validatePreExecuteTask(DynamicObject taskCenterDyobj, DynamicObject taskRuleDyobj) {
        String errorMsg = "";
        if (null == taskRuleDyobj) {
            errorMsg = ResManager.loadKDString((String)"\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u5df2\u5220\u9664\u3002", (String)"TaskCenterExecuteAsyncHelper_0", (String)"swc-hpdi-business", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        return true;
    }

    public Future<CollaResultEntity<String>> executeTask(DynamicObject taskCenter, CoreHRMessageContentEntity msgEntity, String taskExecManner) {
        return SWCThreadPoolFactory.getTaskCenterExecuteThreadPool().submit((Callable)new TaskCenterExecuteCallable(RequestContext.get(), taskCenter, msgEntity, taskExecManner));
    }

    private class TaskCenterExecuteCallable
    implements Callable<CollaResultEntity<String>> {
        private RequestContext context;
        private DynamicObject taskCenter;
        private CoreHRMessageContentEntity msgEntity;
        private String taskExecManner;

        public TaskCenterExecuteCallable(RequestContext context, DynamicObject taskCenter, CoreHRMessageContentEntity msgEntity, String taskExecManner) {
            this.context = context;
            this.taskCenter = taskCenter;
            this.msgEntity = msgEntity;
            this.taskExecManner = taskExecManner;
        }

        @Override
        public CollaResultEntity<String> call() {
            RequestContext.copyAndSet((RequestContext)this.context);
            try {
                DynamicObject taskRule = this.taskCenter.getDynamicObject("taskrule");
                TaskCenterExecuteAsyncHelper.this.validatePreExecuteTask(this.taskCenter, taskRule);
                Map<String, Object> paramMap = this.getRequestParamMap(this.taskCenter.getString("orgmsgrecvcenter.msgsubno"));
                if (CollectionUtils.isEmpty((Collection)((List)paramMap.get("taskCenterEntryData")))) {
                    this.saveTaskCenter("D", null);
                    return new CollaResultEntity().success((Object)"");
                }
                this.taskCenter.set("taskexecutedate", (Object)new Date());
                this.saveTaskCenter("C", null);
                log.info("[colla] before call rpc service: IHSASService.executeCloudCollaTask");
                Map<Long, Map<String, Object>> result = HPDICloudCollaHelper.getInstance().executeCloudCollaTask(paramMap);
                if (result == null || result.isEmpty()) {
                    return new CollaResultEntity().fail("");
                }
                HashSet resultSet = new HashSet(16);
                result.forEach((resultId, resultMsg) -> {
                    Object success = resultMsg.get("success");
                    if (success != null) {
                        resultSet.add((Boolean)success);
                    } else {
                        resultSet.add(Boolean.FALSE);
                    }
                });
                if (resultSet.contains(Boolean.FALSE)) {
                    return new CollaResultEntity().fail("");
                }
            }
            catch (Exception ex) {
                log.info("[colla]:hpdi execute task error", (Object)ex);
                this.saveTaskCenter("E", ex.getMessage());
                return new CollaResultEntity().fail(ex.getMessage());
            }
            return new CollaResultEntity().success((Object)"");
        }

        private void saveTaskCenter(String status, String msg) {
            SWCDataServiceHelper taskCenterOrm = new SWCDataServiceHelper(this.taskCenter.getDataEntityType().getName());
            this.taskCenter.set("taskexecutestatus", (Object)status);
            this.taskCenter.set("executefailmsg", (Object)msg);
            DynamicObjectCollection taskCenterEntry = this.taskCenter.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : taskCenterEntry) {
                String executeStatus = dynamicObject.getString("taskexecutestatusent");
                boolean isManualVerify = dynamicObject.getBoolean("ismanualverify");
                if (isManualVerify || "D".equalsIgnoreCase(executeStatus)) continue;
                dynamicObject.set("collarulev", (Object)dynamicObject.getLong("collarule.sourcevid"));
            }
            taskCenterOrm.saveOne(this.taskCenter);
            if (ImmutableSet.of((Object)"D", (Object)"E", (Object)"F").contains((Object)status.toUpperCase(Locale.ROOT))) {
                HPDICollaMsgServiceHelper.getInstance().executeOtherFlowInTasks(new DynamicObject[]{this.taskCenter});
            }
        }

        private Map<String, Object> getRequestParamMap(String msgSubNo) {
            Map<String, Object> paramMapByMsgSubNo = SubApiSettingHelper.getInstance().getParamMapByMsgSubNo(msgSubNo);
            HPDICollaMsgServiceHelper collaMsgServiceHelper = HPDICollaMsgServiceHelper.getInstance();
            Map<String, List<Map<String, Object>>> apiResultData = collaMsgServiceHelper.getSubMsgApiData(msgSubNo, this.msgEntity, paramMapByMsgSubNo);
            Map<String, List<Map<String, Object>>> recordDetails = collaMsgServiceHelper.queryHrpfChgRecordDetail(this.msgEntity.getRecordId());
            Map apiIdNumberMap = (Map)paramMapByMsgSubNo.get("apiIdNumberMap");
            Map<String, Object> convertedApiResultData = collaMsgServiceHelper.apiResultProcessing(collaMsgServiceHelper.convertResultData(apiResultData, paramMapByMsgSubNo), this.msgEntity, apiIdNumberMap);
            Map<String, Object> verifyBillData = CollaMsgVerifyBillHelper.getInstance().getAllVerifyBillDataForTaskExecute(this.taskCenter.getLong("sumverifybillid"));
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            long tcId = this.taskCenter.getLong("id");
            String tcClass = this.taskCenter.getDataEntityType().getName();
            paramMap.put("taskCenterId", tcId);
            paramMap.put("taskCenterClass", tcClass);
            paramMap.put("orgId", this.taskCenter.getLong("org.id"));
            paramMap.put("orgNumber", this.taskCenter.getString("org.number"));
            paramMap.put("apiResult", apiResultData);
            paramMap.put("apiIdNumberMap", apiIdNumberMap);
            paramMap.put("key", this.getKey(apiResultData, apiIdNumberMap));
            paramMap.put("convertedApiResult", convertedApiResultData);
            paramMap.put("taskCenterEntryData", this.getTaskCenterEntryDatas());
            paramMap.put("taskExecManner", this.taskExecManner);
            paramMap.put("isInbound", this.msgEntity.getInbound());
            paramMap.put("flowType", this.msgEntity.getFlowType());
            paramMap.put("effectTime", this.msgEntity.getEffectTime());
            paramMap.put("verifyBillData", verifyBillData);
            paramMap.put("msgEntity", this.msgEntity.toMap());
            long msgCenterId = this.taskCenter.getLong("orgmsgrecvcenter.id");
            paramMap.put("orgMsgRecvCenterId", msgCenterId);
            paramMap.put("batchTaskCenterData", new TaskCenterDataHelper(tcClass).queryAllTaskCenterByMsgId(tcClass, msgCenterId));
            paramMap.put("recordDetails", recordDetails);
            return paramMap;
        }

        private Map<Long, Integer> getManualVerifyIds(DynamicObject taskRule) {
            if (taskRule == null) {
                return Collections.emptyMap();
            }
            DynamicObjectCollection entryEntity = taskRule.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                return Collections.emptyMap();
            }
            Map<Long, Integer> result = entryEntity.stream().collect(Collectors.toMap(item -> item.getLong("payrollactg.id"), item -> item.getBoolean("ismanualverify") ? 1 : 0, (first, second) -> first));
            return result;
        }

        private String getKey(Map<String, List<Map<String, Object>>> apiResultData, Map<Long, String> apiIdNumberMap) {
            if (CollectionUtils.isEmpty(apiResultData) || CollectionUtils.isEmpty(apiIdNumberMap)) {
                return null;
            }
            List person = (List)MapUtils.getObject(apiResultData, (Object)MapUtils.getObject(apiIdNumberMap, (Object)PERSON_API_ID, (Object)""), Collections.emptyList());
            if (!CollectionUtils.isEmpty((Collection)person)) {
                Map firstPerson = (Map)person.get(0);
                Long personIndexId = MapUtils.getLong((Map)firstPerson, (Object)"personindexid");
                if (personIndexId != null && personIndexId != 0L) {
                    return String.valueOf(personIndexId);
                }
                return String.valueOf(((Map)person.get(0)).get("boid"));
            }
            List employee = (List)MapUtils.getObject(apiResultData, (Object)MapUtils.getObject(apiIdNumberMap, (Object)EMPLOYEE_API_ID, (Object)""), Collections.emptyList());
            if (!CollectionUtils.isEmpty((Collection)person)) {
                return String.valueOf(((Map)employee.get(0)).get("boid"));
            }
            List cmpemp = (List)MapUtils.getObject(apiResultData, (Object)MapUtils.getObject(apiIdNumberMap, (Object)CMPEMP_API_ID, (Object)""), Collections.emptyList());
            if (!CollectionUtils.isEmpty((Collection)person)) {
                return String.valueOf(((Map)cmpemp.get(0)).get("boid"));
            }
            List depemp = (List)MapUtils.getObject(apiResultData, (Object)MapUtils.getObject(apiIdNumberMap, (Object)DEPEMP_API_ID, (Object)""), Collections.emptyList());
            if (!CollectionUtils.isEmpty((Collection)person)) {
                return String.valueOf(((Map)depemp.get(0)).get("boid"));
            }
            return null;
        }

        private List<Map<String, Object>> getTaskCenterEntryDatas() {
            DynamicObjectCollection dynamicObjectCollection = this.taskCenter.getDynamicObjectCollection("entryentity");
            List<Map<String, Object>> entryData = dynamicObjectCollection.stream().filter(item -> !"D".equals(item.getString("taskexecutestatusent"))).map(data -> {
                HashMap<String, Object> temp = new HashMap<String, Object>(16);
                temp.put("payRollActGrpId", data.getLong("collarule.id"));
                temp.put("payRollActGrpClass", data.getString("collaruleclass"));
                temp.put("payRollActGrpVid", data.getLong("collarulev.id"));
                temp.put("centerEntId", data.getLong("id"));
                temp.put("stopAfterFail", data.getBoolean("stopexecafterfail"));
                temp.put("isManualVerify", data.getBoolean("ismanualverify"));
                return temp;
            }).collect(Collectors.toList());
            return entryData;
        }
    }

    private static class Load {
        private static TaskCenterExecuteAsyncHelper msgReceiveCenterReceiveHelper = new TaskCenterExecuteAsyncHelper();

        private Load() {
        }
    }
}

