/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.bizdata.enums.OperateStep;
import kd.swc.hpdi.business.bizdata.enums.PresentErrorEnum;
import kd.swc.hpdi.business.bizdata.filter.BizDataFilterChain;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilter;
import kd.swc.hpdi.business.bizdata.filter.IBizDataFilterRequest;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.service.ITransSalaryService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractTransSalaryService
implements ITransSalaryService {
    private static final Log LOGGER = LogFactory.getLog(AbstractTransSalaryService.class);
    public static final String SELECT_FIELDS_FOR_HPDI_BIZDATA = "id, calperiod, bizdatastatus, errormsg, transsalaryerror, bizdatacode,calsalarydate, batchnum, applyno,expirydate,billtype,empposorgrel,empposorgrel.adminorg,bizitemgroup,bizitem,bizdatadim,relationrecord,payrollgrp,salaryfile, bizdatarecord, overdue, matchrule, updateddesc, submission";
    public static final String KEY_START_DATE = "startdate";
    public static final String SELECT_FIELDS_FOR_BIZDATARECORD = "id, bizdatastatus, errormsg, calsalarydate, payrollgrp, salaryfile, batchnum, overdue, matchrule";
    protected List<IBizDataFilter> bizDataFilters;

    protected abstract List<DynamicObject> beforeTransSalary(List<DynamicObject> var1, String var2);

    @Override
    public void transSalary(List<DynamicObject> bizDataList, String operateType) {
        long currTime = System.currentTimeMillis();
        LOGGER.info("AbstractTransSalaryService.transSalary...{}..begin...bizDataList.size={}...", (Object)currTime, (Object)bizDataList.size());
        HashMap<String, DynamicObject> recordMap = new HashMap<String, DynamicObject>();
        ArrayList<String> bizDataCodes = new ArrayList<String>(10);
        HashSet<String> markedBizDataCodes = new HashSet<String>(16);
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        ArrayList<Long> pkIds = new ArrayList<Long>(10);
        HashSet<Long> bizItemGroupIds = new HashSet<Long>(16);
        for (DynamicObject bizDataDy : bizDataList) {
            pkIds.add(bizDataDy.getLong("id"));
            bizDataCodes.add(bizDataDy.getString("bizdatacode"));
            bizItemGroupIds.add(bizDataDy.getLong("bizitemgroup.id"));
        }
        QFilter bizDataFilter = new QFilter("id", "in", pkIds);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizDataHelper.getEntityName());
        String allFilelds = String.join((CharSequence)",", SWCHisBaseDataHelper.getFields((MainEntityType)mainEntityType));
        String selectProperties = "id, bizitemgroup.calperiodtype.id, " + allFilelds;
        DynamicObject[] bizDataArr = bizDataHelper.query(selectProperties, new QFilter[]{bizDataFilter});
        bizDataList = new ArrayList<DynamicObject>(Arrays.asList(bizDataArr));
        this.setBizDataMatchRule(bizDataList, bizItemGroupIds);
        bizDataList = this.beforeTransSalary(bizDataList, operateType);
        if (CollectionUtils.isEmpty(bizDataList)) {
            return;
        }
        LOGGER.info("AbstractTransSalaryService.transSalary...{}..begin...filterChainValidate...bizDataList.size={}...", (Object)currTime, (Object)bizDataList.size());
        this.filterChainValidate(bizDataList, recordMap, markedBizDataCodes);
        LOGGER.info("AbstractTransSalaryService.transSalary...{}..end.....filterChainValidate...bizDataList.size={}...", (Object)currTime, (Object)bizDataList.size());
        List<DynamicObject> successBizDataList = bizDataList.stream().filter(tmpObj -> SWCStringUtils.isEmpty((String)tmpObj.getString("errormsg"))).collect(Collectors.toList());
        List<DynamicObject> failBizDataList = bizDataList.stream().filter(bizData -> BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode().equals(bizData.getString("bizdatastatus")) && !SWCStringUtils.isEmpty((String)bizData.getString("errormsg"))).collect(Collectors.toList());
        bizDataHelper.update(bizDataList.toArray(new DynamicObject[0]));
        this.writeBackBizDataStatus(failBizDataList);
        Set<Long> allBizDataRecordIds = bizDataList.stream().filter(dy -> dy.getLong("bizdatarecord.id") != 0L).map(dy -> dy.getLong("bizdatarecord.id")).collect(Collectors.toSet());
        LOGGER.info("AbstractTransSalaryService.transSalary...{}..begin...updateBizDataRecord...bizDataList.size={}...", (Object)currTime, (Object)bizDataList.size());
        this.updateBizDataRecord(allBizDataRecordIds, bizDataList);
        LOGGER.info("AbstractTransSalaryService.transSalary...{}..end.....updateBizDataRecord...bizDataList.size={}...", (Object)currTime, (Object)bizDataList.size());
        List<List<DynamicObject>> bizDataBatch = BizDataHelper.splitBizData(successBizDataList);
        try {
            for (List<DynamicObject> successBizDatas : bizDataBatch) {
                LOGGER.info("AbstractTransSalaryService.transSalary...{}..begin...synBizData...bizDatas.size={}...", (Object)currTime, (Object)successBizDatas.size());
                Map<String, Object> bizDataMap = this.synBizData(successBizDatas);
                LOGGER.info("AbstractTransSalaryService.transSalary...{}..end.....synBizData...bizDatas.size={}...", (Object)currTime, (Object)successBizDatas.size());
                LOGGER.info("AbstractTransSalaryService.transSalary...{}..begin...updateBizData...bizDatas.size={}...", (Object)currTime, (Object)successBizDatas.size());
                this.updateBizData(bizDataMap, recordMap, markedBizDataCodes);
                LOGGER.info("AbstractTransSalaryService.transSalary...{}..end.....updateBizData...bizDatas.size={}...", (Object)currTime, (Object)successBizDatas.size());
            }
        }
        catch (Exception exception) {
            LOGGER.error("AbstractTransSalaryService-transSalary,synBizData_error", (Throwable)exception);
            HashSet<Long> bizDataRecordIds = new HashSet<Long>(16);
            HashBasedTable statusTable = HashBasedTable.create();
            for (DynamicObject bizData2 : successBizDataList) {
                bizData2.set("bizdatastatus", (Object)BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode());
                bizData2.set("errormsg", (Object)"code error");
                String billNo = bizData2.getString("applyno");
                String bizDataCode = bizData2.getString("bizdatacode");
                if (billNo != null && !markedBizDataCodes.contains(bizDataCode)) {
                    this.initRecordMap(billNo, recordMap, "othernum");
                }
                markedBizDataCodes.add(bizDataCode);
                Long bizDataRecordId = bizData2.getLong("bizdatarecord.id");
                if (null != bizDataRecordId && 0L != bizDataRecordId) {
                    bizDataRecordIds.add(bizDataRecordId);
                }
                if (!"1".equals(bizData2.getString("submission"))) continue;
                statusTable.put((Object)bizDataCode, (Object)billNo, (Object)BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode());
            }
            this.updateBizDataRecord(bizDataRecordIds, successBizDataList);
            HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.update(successBizDataList.toArray(new DynamicObject[0]));
            LOGGER.info("AbstractTransSalaryService-transSalary, after exception update bizdata:{}", (Object)successBizDataList.get(0).getString("bizdatastatus"));
            BizDataBillEntryHelper.updateTransSalaryStatus((Table<String, String, String>)statusTable);
        }
        AbstractTransSalaryService.recordErrorCaseTranSalary(recordMap, operateType, bizDataCodes);
        LOGGER.info("AbstractTransSalaryService.transSalary...{}..end.....bizDataList.size={}...", (Object)currTime, (Object)bizDataList.size());
    }

    private void filterChainValidate(List<DynamicObject> bizDataList, Map<String, DynamicObject> recordMap, Set<String> markedBizDataCodes) {
        this.initValidateFilter();
        Map<String, Object> queryMap = this.initFilterQueryMap(bizDataList);
        ArrayList<DynamicObject> copyBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
        copyBizDataList.addAll(bizDataList);
        BizDataFilterChain filterChain = new BizDataFilterChain();
        this.bizDataFilters.forEach(filterChain::addFilter);
        HashMap<String, Map<String, Object>> responses = new HashMap<String, Map<String, Object>>(16);
        filterChain.doFilter(queryMap, copyBizDataList, filterChain, responses);
        for (DynamicObject bizDataBillEntry : bizDataList) {
            String bizDataCode = bizDataBillEntry.getString("bizdatacode");
            Map responseMap = (Map)responses.get(bizDataCode);
            if (MapUtils.isNotEmpty((Map)responseMap) && responseMap.get("key_result_error_msg") != null) {
                String presentErrorMsg = (String)responseMap.get("key_present_error_msg");
                String resultErrorMsg = (String)responseMap.get("key_result_error_msg");
                if (resultErrorMsg.trim().length() == 0) continue;
                String transSalaryError = "4";
                String errorCode = "othernum";
                if (PresentErrorEnum.TRANSALARY_NOT_IN_PERIOD.getCode().equals(presentErrorMsg)) {
                    transSalaryError = "3";
                    errorCode = "notintimewindownum";
                }
                bizDataBillEntry.set("transsalaryerror", (Object)transSalaryError);
                bizDataBillEntry.set("errormsg", (Object)resultErrorMsg);
                bizDataBillEntry.set("bizdatastatus", (Object)"4");
                String billNo = bizDataBillEntry.getString("applyno");
                if (StringUtils.isNotEmpty((String)billNo) && !markedBizDataCodes.contains(bizDataCode)) {
                    this.initRecordMap(billNo, recordMap, errorCode);
                }
                markedBizDataCodes.add(bizDataCode);
                continue;
            }
            bizDataBillEntry.set("errormsg", null);
        }
    }

    protected Map<String, Object> initFilterQueryMap(List<DynamicObject> bizDataList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(bizDataList) || CollectionUtils.isEmpty(this.bizDataFilters)) {
            return result;
        }
        Stream entryStream = null;
        try {
            HashMap<String, Object> finalResult = result;
            entryStream = this.bizDataFilters.stream().filter(IBizDataFilterRequest.class::isInstance).map(IBizDataFilterRequest.class::cast).map(filter -> filter.getQueryMap(bizDataList)).flatMap(map -> map.entrySet().stream());
            entryStream.forEach(queryMap -> finalResult.put((String)queryMap.getKey(), queryMap.getValue()));
        }
        catch (Exception exception) {
            LOGGER.error(MessageFormat.format("AbstractTransSalaryService-initFilterQueryMap: {0}", exception));
            throw new KDBizException((Throwable)exception, new ErrorCode("", exception.getMessage() == null ? "NullPointerException" : exception.getMessage()), new Object[0]);
        }
        finally {
            if (null != entryStream) {
                entryStream.close();
            }
        }
        return result;
    }

    protected abstract Map<String, Object> synBizData(List<DynamicObject> var1);

    protected abstract void initValidateFilter();

    private void updateBizData(Map<String, Object> param, Map<String, DynamicObject> recordMap, Set<String> markedBizDataCodes) {
        LOGGER.info(MessageFormat.format("updateBizData param:{0}", JSON.toJSONString(param)));
        List paramList = (List)param.get("result");
        Map bizDataCodeMap = paramList.stream().collect(Collectors.toMap(map -> (String)map.get("bizdatacode"), Function.identity(), (k1, k2) -> k1));
        Set<String> bizDataCodeSet = bizDataCodeMap.keySet();
        LOGGER.info(MessageFormat.format("bizDataCodeMap:{0}", JSON.toJSONString(bizDataCodeMap)));
        QFilter bizDataFilter = new QFilter("bizdatacode", "in", bizDataCodeSet);
        HashSet<String> statusSet = new HashSet<String>(3);
        statusSet.add(BizDataStatusEnum.TO_BE_PUSH_SALARY.getCode());
        statusSet.add(BizDataStatusEnum.PUSHING_SALARY.getCode());
        statusSet.add(BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode());
        statusSet.add(BizDataStatusEnum.WITHDRAWN.getCode());
        QFilter statusFilter = new QFilter("bizdatastatus", "in", statusSet);
        DynamicObject[] bizDataArr = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query(SELECT_FIELDS_FOR_HPDI_BIZDATA, new QFilter[]{statusFilter, bizDataFilter});
        Boolean success = (Boolean)param.get("success");
        String errorMsg = (String)param.get("message");
        ArrayList<DynamicObject> bizDataList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> bizDataHisList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> bizDataOperateLogList = new ArrayList<DynamicObject>(10);
        HashSet<Long> bizDataRecordIds = new HashSet<Long>(16);
        HashBasedTable statusTable = HashBasedTable.create();
        for (DynamicObject bizDataDy : bizDataArr) {
            LOGGER.info("start_update_one");
            bizDataList.add(bizDataDy);
            Long bizDataRecordId = bizDataDy.getLong("bizdatarecord.id");
            if (null != bizDataRecordId && 0L != bizDataRecordId) {
                bizDataRecordIds.add(bizDataRecordId);
            }
            String billNo = bizDataDy.getString("applyno");
            String bizDataCode = bizDataDy.getString("bizdatacode");
            bizDataDy.set("batchnum", (Object)billNo);
            Map bizDataMap = (Map)bizDataCodeMap.get(bizDataDy.getString("bizdatacode"));
            LOGGER.info(MessageFormat.format("bizDataMap:{0}", JSON.toJSONString((Object)bizDataMap)));
            if (CollectionUtils.isEmpty((Map)bizDataMap)) continue;
            if (bizDataMap.get("calpayrollid") != null) {
                bizDataDy.set("payrollgrp", bizDataMap.get("calpayrollid"));
            }
            if (bizDataMap.get("salaryfileid") != null) {
                bizDataDy.set("salaryfile", bizDataMap.get("salaryfileid"));
            }
            if (Boolean.TRUE.equals(success)) {
                LOGGER.info("start_update_success");
                String status = (String)bizDataMap.get("status");
                if ("1".equals(status)) {
                    LOGGER.info("start_update_status_one");
                    this.updateBizDataSuccess(bizDataHisList, bizDataOperateLogList, bizDataList, bizDataDy, (Table<String, String, String>)statusTable);
                    continue;
                }
                String errorCode = String.valueOf(bizDataMap.get("errorcode"));
                LOGGER.info("start_update_status_not_one");
                LOGGER.info(MessageFormat.format("bizdatacode_is:{0}", bizDataDy.getString("bizdatacode")));
                bizDataDy.set("bizdatastatus", (Object)BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode());
                this.cancelMarkOverdue(bizDataDy);
                if (errorCode != null) {
                    String tmpErrorMsg;
                    if ("-1".equals(errorCode)) {
                        tmpErrorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u524d\u7f6e\u4e1a\u52a1\u6570\u636e{0}\u63a8\u9001\u7b97\u85aa\u5931\u8d25\u3002", (String)"AbstractTransSalaryService_10", (String)"swc-hpdi-business", (Object[])new Object[0]), bizDataMap.get("relationbizdatacode") == null ? "" : bizDataMap.get("relationbizdatacode"));
                        bizDataDy.set("errormsg", (Object)new LocaleString(tmpErrorMsg));
                    } else if ("-2".equals(errorCode)) {
                        tmpErrorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u524d\u7f6e\u4e1a\u52a1\u6570\u636e{0}\u66f4\u65b0\u5931\u6548\u65e5\u671f\u5931\u8d25\u3002", (String)"AbstractTransSalaryService_11", (String)"swc-hpdi-business", (Object[])new Object[0]), bizDataMap.get("relationbizdatacode") == null ? "" : bizDataMap.get("relationbizdatacode"));
                        bizDataDy.set("errormsg", (Object)new LocaleString(tmpErrorMsg));
                    } else {
                        bizDataDy.set("errormsg", (Object)new LocaleString(BizDataFailStatusEnum.getDesc((String)errorCode)));
                    }
                }
                String errorType = "othernum";
                if (BizDataFailStatusEnum.FAILSTATUS_1032.getCode().equals(errorCode) || BizDataFailStatusEnum.FAILSTATUS_1033.getCode().equals(errorCode)) {
                    errorType = "notmatchfilenum";
                }
                if (billNo != null && !markedBizDataCodes.contains(bizDataCode)) {
                    this.initRecordMap(billNo, recordMap, errorType);
                }
                markedBizDataCodes.add(bizDataCode);
                if (!"1".equals(bizDataDy.getString("submission"))) continue;
                statusTable.put((Object)bizDataDy.getString("bizdatacode"), (Object)bizDataDy.getString("applyno"), (Object)bizDataDy.getString("bizdatastatus"));
                continue;
            }
            LOGGER.info("AbstractTransSalaryService-updateBizData start_update_fail ,success is: ", (Object)success);
            bizDataDy.set("bizdatastatus", (Object)BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode());
            bizDataDy.set("errormsg", (Object)new LocaleString(errorMsg));
            this.cancelMarkOverdue(bizDataDy);
            if (billNo != null && !markedBizDataCodes.contains(bizDataCode)) {
                this.initRecordMap(billNo, recordMap, "othernum");
            }
            markedBizDataCodes.add(bizDataCode);
            if (!"1".equals(bizDataDy.getString("submission"))) continue;
            statusTable.put((Object)bizDataDy.getString("bizdatacode"), (Object)bizDataDy.getString("applyno"), (Object)bizDataDy.getString("bizdatastatus"));
        }
        LOGGER.info(MessageFormat.format("UpdateTransSalaryService-updateBizData, to do update bizdata size is :{0}", bizDataList.size()));
        this.updateBizDataRecord(bizDataRecordIds, bizDataList);
        HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.update(bizDataList.toArray(new DynamicObject[0]));
        HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.save(bizDataHisList.toArray(new DynamicObject[0]));
        HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.save(bizDataOperateLogList.toArray(new DynamicObject[0]));
        BizDataBillEntryHelper.updateTransSalaryStatus((Table<String, String, String>)statusTable);
    }

    protected void updateBizDataSuccess(List<DynamicObject> bizDataHisList, List<DynamicObject> bizDataOperateLogList, List<DynamicObject> bizDataList, DynamicObject bizDataDy, Table<String, String, String> statusTable) {
        bizDataDy.set("bizdatastatus", (Object)BizDataStatusEnum.PUSHED_SALARY.getCode());
        LOGGER.info(MessageFormat.format("AbstractTransSalaryService-updateBizDataSuccess bizdatacode is :{0}, bizdatastatus is :{1}", bizDataDy.getString("bizdatacode"), bizDataDy.getString("bizdatastatus")));
        bizDataDy.set("errormsg", null);
        bizDataDy.set("calsalarydate", (Object)new Date());
        if ("1".equals(bizDataDy.getString("submission"))) {
            statusTable.put((Object)bizDataDy.getString("bizdatacode"), (Object)bizDataDy.getString("applyno"), (Object)bizDataDy.getString("bizdatastatus"));
        }
    }

    public void initRecordMap(String billNo, Map<String, DynamicObject> recordMap, String keyField) {
        if (!SWCStringUtils.isEmpty((String)billNo)) {
            if (recordMap.get(billNo) != null) {
                DynamicObject errorObject = recordMap.get(billNo);
                errorObject.set(keyField, (Object)(errorObject.getInt(keyField) + 1));
            } else {
                DynamicObject errorObject = HPDIDataServiceHelper.HPDI_BIZDATAERRORLOG_HELPER.generateEmptyDynamicObject();
                errorObject.set("billno", (Object)billNo);
                errorObject.set(keyField, (Object)1);
                recordMap.put(billNo, errorObject);
            }
        }
    }

    public static void recordErrorCaseTranSalary(Map<String, DynamicObject> recordMap, String transType, List<String> bizDataCodes) {
        Set<String> keys = recordMap.keySet();
        if (!CollectionUtils.isEmpty(keys)) {
            DynamicObject[] billObjs = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.query("billno,bizitemgroup,adminorg", new QFilter[]{new QFilter("billno", "in", keys)});
            List billIds = Arrays.stream(billObjs).map(billObj -> billObj.getLong("id")).collect(Collectors.toList());
            QFilter entFilter = new QFilter("bizdatabillid", "in", billIds);
            if (OperateStep.HAND_TRANS_SALARYA.getCode().equals(transType)) {
                entFilter.and(new QFilter("bizdatacode", "in", bizDataCodes));
            }
            DynamicObject[] billEnts = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query("bizdatabillid, entryentity", entFilter.toArray());
            Map<Long, List<DynamicObject>> billMap = Arrays.stream(billEnts).collect(Collectors.groupingBy(billEnt -> billEnt.getLong("bizdatabillid")));
            DynamicObject[] waitSaveDys = new DynamicObject[recordMap.size()];
            Iterator<Map.Entry<String, DynamicObject>> iter = recordMap.entrySet().iterator();
            int index = 0;
            while (iter.hasNext()) {
                RequestContext requestContext;
                Map.Entry<String, DynamicObject> entry = iter.next();
                String key = entry.getKey();
                DynamicObject errorObject = entry.getValue();
                errorObject.set("billno", (Object)key);
                errorObject.set("operatestage", (Object)transType);
                for (DynamicObject billObj2 : billObjs) {
                    if (billObj2.get("billno") == null || !billObj2.get("billno").equals(key)) continue;
                    errorObject.set("bizitemgroup", (Object)billObj2.getDynamicObject("bizitemgroup"));
                    errorObject.set("adminorg", (Object)billObj2.getDynamicObject("adminorg"));
                    List<DynamicObject> entryEntitys = billMap.get(billObj2.getPkValue());
                    if (CollectionUtils.isEmpty(entryEntitys)) break;
                    errorObject.set("operatenum", (Object)entryEntitys.size());
                    break;
                }
                if ((requestContext = RequestContext.get()) != null) {
                    errorObject.set("creator", (Object)RequestContext.get().getCurrUserId());
                }
                errorObject.set("operatetime", (Object)new Date());
                BizDataHelper.setErrorTotal(errorObject);
                waitSaveDys[index] = errorObject;
                ++index;
            }
            HPDIDataServiceHelper.HPDI_BIZDATAERRORLOG_HELPER.save(waitSaveDys);
        }
    }

    private void updateBizDataRecord(Set<Long> bizDataRecordIds, List<DynamicObject> bizDataList) {
        if (CollectionUtils.isEmpty(bizDataRecordIds)) {
            return;
        }
        SWCDataServiceHelper bizDataRecordHelper = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER;
        QFilter qFilter = new QFilter("id", "in", bizDataRecordIds);
        DynamicObject[] bizDataRecordArray = bizDataRecordHelper.query(SELECT_FIELDS_FOR_BIZDATARECORD, qFilter.toArray());
        Map<Long, List<DynamicObject>> bizDataMap = bizDataList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("bizdatarecord.id")));
        for (DynamicObject bizDataRecord : bizDataRecordArray) {
            List<DynamicObject> subList = bizDataMap.get(bizDataRecord.getLong("id"));
            if (CollectionUtils.isEmpty(subList)) continue;
            DynamicObject bizData = subList.get(0);
            bizDataRecord.set("batchnum", bizData.get("batchnum"));
            bizDataRecord.set("bizdatastatus", bizData.get("bizdatastatus"));
            bizDataRecord.set("errormsg", bizData.get("errormsg"));
            bizDataRecord.set("calsalarydate", bizData.get("calsalarydate"));
            bizDataRecord.set("matchrule", bizData.get("matchrule"));
            if (bizData.containsProperty("overdue")) {
                bizDataRecord.set("overdue", bizData.get("overdue"));
            }
            if (null != bizData.get("salaryfile")) {
                bizDataRecord.set("salaryfile", bizData.get("salaryfile"));
            }
            if (null == bizData.get("payrollgrp")) continue;
            bizDataRecord.set("payrollgrp", bizData.get("payrollgrp"));
        }
        bizDataRecordHelper.update(bizDataRecordArray);
    }

    private void cancelMarkOverdue(DynamicObject bizDatum) {
        String overdue = bizDatum.getString("overdue");
        if (!SWCStringUtils.equals((String)overdue, (String)"A")) {
            bizDatum.set("overdue", (Object)"");
        }
    }

    private void setBizDataMatchRule(List<DynamicObject> bizDataList, Set<Long> bizItemGroupIds) {
        DynamicObject defaultBizDataObjRule = BizDataHelper.queryDefaultBizDataObjRule();
        String defaultMatchRule = defaultBizDataObjRule.getString("matchrule");
        QFilter bizItemGroupFilter = new QFilter("id", "in", bizItemGroupIds);
        SWCDataServiceHelper bizItemGroupHelper = new SWCDataServiceHelper("hsbs_bizitemgroup");
        DynamicObject[] bizItemGroupArr = bizItemGroupHelper.query("id, bizdataobjrule.matchrule", new QFilter[]{bizItemGroupFilter});
        Map<Long, String> matchRuleMap = Arrays.stream(bizItemGroupArr).filter(dy -> !SWCObjectUtils.isEmpty((Object)dy.getDynamicObject("bizdataobjrule"))).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("bizdataobjrule.matchrule"), (k1, k2) -> k1));
        for (DynamicObject bizData : bizDataList) {
            if (!"1".equals(bizData.getString("billtype"))) continue;
            String matchRule = matchRuleMap.get(bizData.getLong("bizitemgroup.id"));
            matchRule = SWCStringUtils.isEmpty((String)matchRule) ? defaultMatchRule : matchRule;
            bizData.set("matchrule", (Object)matchRule);
        }
    }

    public void writeBackBizDataStatus(List<DynamicObject> failBizDataList) {
        if (CollectionUtils.isEmpty(failBizDataList)) {
            return;
        }
        HashBasedTable statusTable = HashBasedTable.create();
        for (DynamicObject bizData : failBizDataList) {
            if (!"1".equals(bizData.getString("submission"))) continue;
            statusTable.put((Object)bizData.getString("bizdatacode"), (Object)bizData.getString("applyno"), (Object)bizData.getString("bizdatastatus"));
        }
        BizDataBillEntryHelper.updateTransSalaryStatus((Table<String, String, String>)statusTable);
    }
}

