/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hpdi.common.events.bizdata.BizDataMatchSalaryFileArgs;
import kd.sdk.swc.hpdi.common.events.bizdata.BizDataTransSalaryArgs;
import kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataMatchSalaryFileExtPlugin;
import kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataTransSalaryExtPlugin;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.bizdata.filter.BizDataBeforeDateFilter;
import kd.swc.hpdi.business.bizdata.filter.BizDataEffectiveDataUseFilter;
import kd.swc.hpdi.business.bizdata.filter.BizDataTransCommPreDataFilter;
import kd.swc.hpdi.business.bizdata.filter.BizDataTransSalaryCODFilter;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataMatchSalaryFileExtService;
import kd.swc.hpdi.business.helper.BizDataTransSalaryExtService;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.service.AbstractTransSalaryService;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class AddTransSalaryService
extends AbstractTransSalaryService {
    private static final Log LOGGER = LogFactory.getLog(AddTransSalaryService.class);
    private static final String RESULT = "result";
    private static final String ERRORCODE = "errorcode";
    private static final String CALPERIODID = "calperiodid";
    private static final String STATUS = "status";
    private static final String BIZDATACODE = "bizdatacode";
    private static final String RELATION_BIZ_DATA_CODE = "relationbizdatacode";

    @Override
    protected List<DynamicObject> beforeTransSalary(List<DynamicObject> bizDataList, String operateType) {
        HashMap<String, DynamicObject> recordMap = new HashMap<String, DynamicObject>(16);
        HashSet<String> markedBizDataCodes = new HashSet<String>(16);
        List<String> allBizDataCodes = bizDataList.stream().map(dy -> dy.getString(BIZDATACODE)).collect(Collectors.toList());
        this.matchSalaryFile(recordMap, markedBizDataCodes, bizDataList);
        bizDataList = this.changeTransSalaryDepemp(recordMap, markedBizDataCodes, bizDataList);
        AbstractTransSalaryService.recordErrorCaseTranSalary(recordMap, operateType, allBizDataCodes);
        return bizDataList;
    }

    @Override
    public Map<String, Object> synBizData(List<DynamicObject> successBizDatas) {
        successBizDatas.sort((o1, o2) -> {
            if (o1 != null && o2 != null && o1.getDate("effectivedate") != null && o2.getDate("effectivedate") != null) {
                return o1.getDate("effectivedate").compareTo(o2.getDate("effectivedate"));
            }
            return 1;
        });
        Map<String, List<DynamicObject>> samePersonItemMap = this.getSamePersonSameItemBizDatas(successBizDatas);
        List<DynamicObject> samePersonSameItemBizDatas = samePersonItemMap.get("samePersonItemList");
        successBizDatas = samePersonItemMap.get("originalList");
        LOGGER.info("samePersonSameItemBizDatas size : {}", (Object)samePersonSameItemBizDatas.size());
        LOGGER.info("originalList size : {}", (Object)successBizDatas.size());
        Map<String, Object> caseRelationMap = this.tranSalaryRelationData(samePersonSameItemBizDatas);
        Map<String, Object> caseNoRelationMap = this.tranSalaryNoRelationData(successBizDatas);
        this.mergeResult(caseRelationMap, caseNoRelationMap);
        return caseRelationMap;
    }

    private Map<String, Object> tranSalaryRelationData(List<DynamicObject> bizDataList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", Boolean.TRUE);
        Map<Long, Map<Long, List<DynamicObject>>> maps = bizDataList.stream().collect(Collectors.groupingBy(bizData -> bizData.getLong("empposorgrel.id"), Collectors.groupingBy(bizData -> bizData.getLong("bizitem.id"))));
        ArrayList<List<DynamicObject>> groupList = new ArrayList<List<DynamicObject>>();
        Set<Map.Entry<Long, Map<Long, List<DynamicObject>>>> entrySet = maps.entrySet();
        for (Map.Entry<Long, Map<Long, List<DynamicObject>>> tempMap : entrySet) {
            Map<Long, List<DynamicObject>> groupMap = tempMap.getValue();
            Set<Map.Entry<Long, List<DynamicObject>>> set = groupMap.entrySet();
            for (Map.Entry<Long, List<DynamicObject>> findMap : set) {
                groupList.add(findMap.getValue());
            }
        }
        HashBasedTable statusTable = HashBasedTable.create();
        try {
            LOGGER.info("groupList is : {}", (Object)SWCJSONUtils.toString(groupList));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (List list : groupList) {
            Map<String, Object> returnMap = this.tranSalaryRelationDataByGroup(list, (Table<String, String, String>)statusTable);
            this.mergeResult(result, returnMap);
        }
        BizDataBillEntryHelper.updateTransSalaryStatus((Table<String, String, String>)statusTable);
        return result;
    }

    private void mergeResult(Map<String, Object> totalMap, Map<String, Object> subMap) {
        List subResultList;
        List totalList = totalMap.get(RESULT) == null ? new ArrayList(10) : (List)totalMap.get(RESULT);
        List list = subResultList = subMap.get(RESULT) == null ? new ArrayList(10) : (List)subMap.get(RESULT);
        if (subResultList != null) {
            totalList.addAll(subResultList);
        }
        totalMap.put(RESULT, totalList);
    }

    public Map<String, Object> tranSalaryRelationDataByGroup(List<DynamicObject> bizDataList, Table<String, String, String> statusTable) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", Boolean.TRUE);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        result.put(RESULT, list);
        LOGGER.info("bizDataList size : {}", (Object)bizDataList.size());
        try {
            LOGGER.info("bizDataList is : {}", (Object)SWCJSONUtils.toString(bizDataList));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (int index = 0; index < bizDataList.size(); ++index) {
            long calPeriodId;
            DynamicObject bizData = bizDataList.get(index);
            HashMap<String, Object> objectMap = new HashMap<String, Object>(16);
            Map<String, Object> returnMap = this.invokeAddBizData(objectMap, bizDataList, index);
            if (returnMap == null || !"true".equals(returnMap.get("success").toString())) continue;
            List resultAddList = (List)returnMap.get(RESULT);
            Map resultMap = null;
            if (!CollectionUtils.isEmpty((Collection)resultAddList)) {
                resultMap = (Map)resultAddList.get(0);
            }
            if (resultMap == null) continue;
            if ("1".equals(resultMap.get(STATUS))) {
                objectMap.put(BIZDATACODE, resultMap.get(BIZDATACODE));
                objectMap.put(STATUS, resultMap.get(STATUS));
                calPeriodId = bizData.getLong("calperiod.id");
                objectMap.put(CALPERIODID, calPeriodId == 0L ? resultMap.get(CALPERIODID) : Long.valueOf(calPeriodId));
                objectMap.put("calpayrollid", resultMap.get("calpayrollid"));
                objectMap.put("salaryfileid", resultMap.get("salaryfileid"));
                objectMap.put(ERRORCODE, resultMap.get(ERRORCODE));
                list.add(objectMap);
                this.updateDataInmidately(bizData.getLong("id"), objectMap, statusTable);
                continue;
            }
            objectMap.put(BIZDATACODE, resultMap.get(BIZDATACODE));
            objectMap.put(STATUS, resultMap.get(STATUS));
            calPeriodId = bizData.getLong("calperiod.id");
            objectMap.put(CALPERIODID, calPeriodId == 0L ? resultMap.get(CALPERIODID) : Long.valueOf(calPeriodId));
            objectMap.put("calpayrollid", resultMap.get("calpayrollid"));
            objectMap.put("salaryfileid", resultMap.get("salaryfileid"));
            objectMap.put(ERRORCODE, resultMap.get(ERRORCODE));
            list.add(objectMap);
            LOGGER.info("setErrorDataAfterFail04");
            this.setErrorDataAfterFail(list, objectMap, bizDataList, index + 1, -1);
            return result;
        }
        return result;
    }

    private void updateDataInmidately(Long bizDataId, Map<String, Object> objectMap, Table<String, String, String> statusTable) {
        DynamicObject nowData = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.queryOne("bizdatastatus,calperiod,errormsg,calsalarydate,payrollgrp,salaryfile,bizdatacode,applyno,submission", (Object)bizDataId);
        if (nowData != null) {
            nowData.set("bizdatastatus", (Object)"3");
            nowData.set("calperiod", objectMap.get(CALPERIODID));
            nowData.set("payrollgrp", objectMap.get("calpayrollid"));
            nowData.set("salaryfile", objectMap.get("salaryfileid"));
            nowData.set("errormsg", null);
            nowData.set("calsalarydate", (Object)new Date());
            HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.updateOne(nowData);
            if ("1".equals(nowData.getString("submission"))) {
                statusTable.put((Object)nowData.getString(BIZDATACODE), (Object)nowData.getString("applyno"), (Object)nowData.getString("bizdatastatus"));
            }
        }
    }

    public void recordLogAndUpdateLocalData(DynamicObject relationObj, DynamicObject bizDataDy, Map<String, Object> objectMap) {
        DynamicObject salaryFile = relationObj.getDynamicObject("salaryfile");
        Long returnSalaryFileId = MapUtils.getLong(objectMap, (Object)"salaryfileid");
        LOGGER.info(MessageFormat.format("returnSalaryFileId: {0}", returnSalaryFileId));
        if (null != salaryFile) {
            LOGGER.info(MessageFormat.format("relate salaryFileId: {0}", salaryFile.get("id")));
        }
        if (null != salaryFile && null != returnSalaryFileId && returnSalaryFileId.equals(salaryFile.getLong("id"))) {
            LOGGER.info("********update relationBizData expirydate*******");
            DynamicObject bizDataHis = HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.generateEmptyDynamicObject();
            bizDataHis.set("empposorgrel", bizDataDy.get("empposorgrel.id"));
            bizDataHis.set("bizitem", bizDataDy.get("bizitem.id"));
            bizDataHis.set("currentbizdatacode", (Object)relationObj.getString(BIZDATACODE));
            bizDataHis.set("operatebizdatacode", (Object)bizDataDy.getString(BIZDATACODE));
            bizDataHis.set("beforupdatedate", (Object)relationObj.getDate("expirydate"));
            bizDataHis.set("afterupdatedate", (Object)SWCDateTimeUtils.addDay((Date)bizDataDy.getDate("effectivedate"), (long)-1L));
            bizDataHis.set("operatetype", (Object)"1");
            bizDataHis.set("operater", (Object)RequestContext.get().getCurrUserId());
            bizDataHis.set("operatetime", (Object)new Date());
            bizDataHis.set("bizdata", bizDataDy.getPkValue());
            HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.saveOne(bizDataHis);
            relationObj.set("expirydate", (Object)SWCDateTimeUtils.addDay((Date)bizDataDy.getDate("effectivedate"), (long)-1L));
            relationObj.set("relationrecord", (Object)"A");
            HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.updateOne(relationObj);
        }
        this.updateDataInmidately(bizDataDy.getLong("id"), objectMap, (Table<String, String, String>)HashBasedTable.create());
    }

    public void setErrorDataAfterFail(List<Map<String, Object>> list, Map<String, Object> objectMap, List<DynamicObject> bizDataList, int index, int errorCode) {
        for (int indexT = index; indexT < bizDataList.size(); ++indexT) {
            HashMap<String, Object> tmpMap = new HashMap<String, Object>(16);
            tmpMap.put(BIZDATACODE, bizDataList.get(indexT).getString(BIZDATACODE));
            tmpMap.put(STATUS, "0");
            tmpMap.put(ERRORCODE, errorCode);
            tmpMap.put(RELATION_BIZ_DATA_CODE, objectMap.get(BIZDATACODE));
            list.add(tmpMap);
            LOGGER.info(MessageFormat.format("tmpMap:{0}", JSON.toJSONString(tmpMap)));
        }
    }

    public Map<String, Object> invokeUpdateBizData(DynamicObject relationObj, DynamicObject obj) {
        HashMap<String, Object> updateRequestMap = new HashMap<String, Object>(16);
        updateRequestMap.put("opsystem", "hpdi");
        ArrayList dataList = new ArrayList();
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        codeMap.put(BIZDATACODE, relationObj.getString(BIZDATACODE));
        codeMap.put("bizitemid", relationObj.getLong("bizitem.id"));
        codeMap.put("bsled", SWCDateTimeUtils.addDay((Date)obj.getDate("effectivedate"), (long)-1L));
        dataList.add(codeMap);
        updateRequestMap.put("data", dataList);
        LOGGER.info(MessageFormat.format("updateRequestMap:{0}", JSON.toJSONString(updateRequestMap)));
        return HPDIServiceUtils.updateBlsed(updateRequestMap);
    }

    private Map<String, Object> invokeAddBizData(Map<String, Object> objectMap, List<DynamicObject> bizDataList, int index) {
        Map<String, Object> relationResult;
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("operate", "1");
        requestMap.put("opsystem", "hpdi");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(1);
        list.add(this.initFieldColumnRequestMap(bizDataList.get(index)));
        requestMap.put("data", list);
        LOGGER.info(String.valueOf(JSON.toJSON(requestMap)));
        if ("2".equals(bizDataList.get(index).getString("matchrule"))) {
            LOGGER.info("**********invoke synBizDataBySalaryFile*********");
            relationResult = HPDIServiceUtils.synBizDataBySalaryFile(requestMap);
        } else {
            LOGGER.info("**********invoke synBizData*********");
            relationResult = HPDIServiceUtils.synBizData(requestMap);
        }
        LOGGER.info(String.valueOf(JSON.toJSON(relationResult)));
        return relationResult;
    }

    private Map<String, Object> initFieldColumnRequestMap(DynamicObject bizDataDy) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("batchcode", bizDataDy.getString("applyno"));
        result.put("bizdataaccesstplid", bizDataDy.getLong("bizitemgroup.id"));
        result.put("datasources", "3");
        result.put("srcsystem", "hpdi");
        result.put("bsed", bizDataDy.getDate("effectivedate"));
        result.put("bsled", bizDataDy.getDate("expirydate"));
        Long employeeId = bizDataDy.getLong("empposorgrel.employee.id");
        result.put("employeeid", employeeId);
        Long depEmpId = bizDataDy.getLong("depemp.id");
        result.put("depempid", depEmpId);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizDataDy.getDataEntityType().getName());
        Map fieldTypeMap = mainEntityType.getFields();
        for (Map.Entry field : fieldTypeMap.entrySet()) {
            String propkey = (String)field.getKey();
            String idkey = (String)field.getKey();
            String getValkey = (String)field.getKey();
            if (field.getValue() instanceof BasedataProp) {
                idkey = propkey + "id";
                getValkey = propkey + ".id";
            }
            if (result.containsKey(idkey)) continue;
            result.put(idkey, bizDataDy.get(getValkey));
        }
        DynamicObject salaryFile = bizDataDy.getDynamicObject("salaryfile");
        if (!SWCObjectUtils.isEmpty((Object)salaryFile)) {
            result.put("salaryfileid", salaryFile.getLong("id"));
        }
        return result;
    }

    private Map<String, Object> tranSalaryNoRelationData(List<DynamicObject> bizDataList) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty(bizDataList)) {
            result.put("success", Boolean.TRUE);
            return result;
        }
        Map<Boolean, List<DynamicObject>> listMap = bizDataList.stream().collect(Collectors.groupingBy(bizData -> "2".equals(bizData.getString("matchrule"))));
        ArrayList customList = new ArrayList(bizDataList.size());
        boolean success = false;
        if (!CollectionUtils.isEmpty((Collection)listMap.get(Boolean.FALSE))) {
            Map<String, Object> res1 = this.tranSalaryNoRelationData(listMap.get(Boolean.FALSE), false);
            customList.addAll((List)res1.get(RESULT));
            success = (Boolean)res1.get("success") != false || success;
            LOGGER.info("**********transSalaryNoRelationData by depemp size: {}", (Object)customList.size());
        }
        if (!CollectionUtils.isEmpty((Collection)listMap.get(Boolean.TRUE))) {
            Map<String, Object> res2 = this.tranSalaryNoRelationData(listMap.get(Boolean.TRUE), true);
            customList.addAll((List)res2.get(RESULT));
            success = (Boolean)res2.get("success") != false || success;
            LOGGER.info("**********transSalaryNoRelationData by salaryFile size: {}", (Object)((List)res2.get(RESULT)).size());
        }
        result.put("success", success);
        result.put(RESULT, customList);
        return result;
    }

    private Map<String, Object> tranSalaryNoRelationData(List<DynamicObject> bizDataList, boolean bySalaryFile) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("operate", "1");
        requestMap.put("opsystem", "hpdi");
        HashSet<Long> bizDataRecordIds = new HashSet<Long>(16);
        ArrayList<Map<String, Object>> recordParamList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject bizDataDy : bizDataList) {
            Map<String, Object> paramMap = this.initFieldColumnRequestMap(bizDataDy);
            paramList.add(paramMap);
            Long bizDataRecordId = bizDataDy.getLong("bizdatarecord.id");
            paramMap.put("bizdatarecord", bizDataRecordId);
            bizDataRecordIds.add(bizDataRecordId);
        }
        if (!CollectionUtils.isEmpty(bizDataRecordIds)) {
            DynamicObject[] bizDataRecordArray;
            Map<Object, Object> sfMap = new HashMap(bizDataRecordIds.size());
            if (bySalaryFile) {
                sfMap = paramList.stream().collect(Collectors.toMap(param -> (Long)param.get("bizdatarecord"), param -> (Long)param.get("salaryfileid"), (k1, k2) -> k1));
            }
            QFilter qFilter = new QFilter("id", "in", bizDataRecordIds);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.getEntityName());
            String allFilelds = String.join((CharSequence)",", SWCHisBaseDataHelper.getFields((MainEntityType)mainEntityType));
            String selectProperties = "id, bizitemgroup.calperiodtype.id, " + allFilelds;
            for (DynamicObject bizDataRecord : bizDataRecordArray = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.query(selectProperties, new QFilter[]{qFilter})) {
                Map<String, Object> recordParam = this.initRecordFieldColumnRequestMap(bizDataRecord);
                if (bySalaryFile) {
                    recordParam.put("salaryfileid", sfMap.get(bizDataRecord.getLong("id")));
                }
                recordParamList.add(recordParam);
            }
        }
        requestMap.put("data", paramList);
        requestMap.put("data_record", recordParamList);
        Map<String, Object> result = bySalaryFile ? HPDIServiceUtils.synBizDataBySalaryFile(requestMap) : HPDIServiceUtils.synBizData(requestMap);
        if ("false".equals(result.get("success").toString())) {
            ArrayList<HashMap> coustomList = new ArrayList<HashMap>(bizDataList.size());
            for (DynamicObject bizData : bizDataList) {
                HashMap tempMap = Maps.newHashMapWithExpectedSize((int)3);
                tempMap.put(BIZDATACODE, bizData.getString(BIZDATACODE));
                tempMap.put(STATUS, "0");
                tempMap.put(ERRORCODE, 0);
                coustomList.add(tempMap);
            }
            result.put(RESULT, coustomList);
        }
        return result;
    }

    private Map<String, List<DynamicObject>> getSamePersonSameItemBizDatas(List<DynamicObject> successBizDatas) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        ArrayList samePersonItemList = new ArrayList(10);
        Map<Long, Long> personItemMap = successBizDatas.stream().collect(Collectors.toMap(obj -> obj.getLong("empposorgrel.id"), obj -> obj.getLong("bizitem.id"), (k1, k2) -> k1));
        Set<Map.Entry<Long, Long>> entrySet = personItemMap.entrySet();
        Iterator<Map.Entry<Long, Long>> it = entrySet.iterator();
        ArrayList<String> existsList = new ArrayList<String>(10);
        while (it.hasNext()) {
            List filterList;
            Map.Entry<Long, Long> next = it.next();
            Long personID = next.getKey();
            Long itemID = next.getValue();
            String comBineStr = personID + "_" + itemID;
            if (!existsList.contains(comBineStr)) {
                existsList.add(personID + "_" + itemID);
            }
            if ((filterList = successBizDatas.stream().filter(obj -> obj.getLong("empposorgrel.id") == personID.longValue() && obj.getLong("bizitem.id") == itemID.longValue() && SWCStringUtils.equals((String)obj.getString("bizitem.cycle"), (String)"1")).collect(Collectors.toList())) == null || filterList.size() <= 1) continue;
            samePersonItemList.addAll(filterList);
            successBizDatas = successBizDatas.stream().filter(obj -> obj.getLong("empposorgrel.id") != personID.longValue() || obj.getLong("bizitem.id") != itemID.longValue()).collect(Collectors.toList());
        }
        List<DynamicObject> originalList = successBizDatas;
        result.put("originalList", originalList);
        result.put("samePersonItemList", samePersonItemList);
        return result;
    }

    @Override
    protected void initValidateFilter() {
        this.bizDataFilters = Lists.newArrayListWithCapacity((int)2);
        this.bizDataFilters.add(new BizDataTransCommPreDataFilter());
        this.bizDataFilters.add(new BizDataBeforeDateFilter());
        this.bizDataFilters.add(new BizDataEffectiveDataUseFilter());
        this.bizDataFilters.add(new BizDataTransSalaryCODFilter());
    }

    private Map<String, Object> initRecordFieldColumnRequestMap(DynamicObject bizDataRecord) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("datasources", "3");
        result.put("srcsystem", "hpdi");
        result.put("bizdatarecord", bizDataRecord.getLong("id"));
        result.put("batchcode", bizDataRecord.getString("applyno"));
        result.put("bizdataaccesstplid", bizDataRecord.getLong("bizitemgroup.id"));
        result.put("bsed", bizDataRecord.getDate("effectivedate"));
        result.put("bsled", bizDataRecord.getDate("expirydate"));
        Long employeeId = bizDataRecord.getLong("empposorgrel.employee.id");
        result.put("employeeid", employeeId);
        Long depEmpId = bizDataRecord.getLong("depemp.id");
        result.put("depempid", depEmpId);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizDataRecord.getDataEntityType().getName());
        Map fieldTypeMap = mainEntityType.getFields();
        for (Map.Entry field : fieldTypeMap.entrySet()) {
            String propkey = (String)field.getKey();
            String idkey = (String)field.getKey();
            String getValkey = (String)field.getKey();
            if (field.getValue() instanceof BasedataProp) {
                idkey = propkey + "id";
                getValkey = propkey + ".id";
            }
            if (result.containsKey(idkey)) continue;
            result.put(idkey, bizDataRecord.get(getValkey));
        }
        return result;
    }

    private List<DynamicObject> changeTransSalaryDepemp(Map<String, DynamicObject> recordMap, Set<String> markedBizDataCodes, List<DynamicObject> bizDataList) {
        if (CollectionUtils.isEmpty(bizDataList)) {
            return bizDataList;
        }
        Map<Long, String> matchRuleMap = bizDataList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("matchrule"), (k1, k2) -> k1));
        BizDataTransSalaryArgs args = new BizDataTransSalaryArgs();
        args.setBizDataList(bizDataList);
        args.setReturnBizDataList(bizDataList);
        this.invokeChangeDepempBeforeTransSalary(args);
        Map errorMap = args.getErrorMap();
        this.updateBizDataCalFailed(errorMap, matchRuleMap);
        if (null != errorMap && !errorMap.isEmpty()) {
            Map<Long, DynamicObject> bizDataMap = bizDataList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
            for (Map.Entry entry : errorMap.entrySet()) {
                String bizDataCode;
                DynamicObject bizData = bizDataMap.get(entry.getKey());
                if (SWCObjectUtils.isEmpty((Object)bizData) || markedBizDataCodes.contains(bizDataCode = bizData.getString(BIZDATACODE))) continue;
                this.initRecordMap(bizData.getString("applyno"), recordMap, "othernum");
                markedBizDataCodes.add(bizDataCode);
            }
        }
        return args.getReturnBizDataList();
    }

    private void matchSalaryFile(Map<String, DynamicObject> recordMap, Set<String> markedBizDataCodes, List<DynamicObject> bizDataList) {
        List<DynamicObject> waitMatchList = bizDataList.stream().filter(dy -> "2".equals(dy.getString("matchrule"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(waitMatchList)) {
            return;
        }
        Map<Long, String> matchRuleMap = waitMatchList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("matchrule"), (k1, k2) -> k1));
        HashMap<Long, String> errorMap = new HashMap<Long, String>(waitMatchList.size());
        ArrayList<DynamicObject> noPayrollGrpList = new ArrayList<DynamicObject>(10);
        for (DynamicObject bizData : waitMatchList) {
            if (!SWCObjectUtils.isEmpty((Object)bizData.getDynamicObject("bizdatadim"))) continue;
            noPayrollGrpList.add(bizData);
            errorMap.put(bizData.getLong("id"), HPDIResMgrBusiness.getMsgOfNoBizDataDim());
            String bizDataCode = bizData.getString(BIZDATACODE);
            if (markedBizDataCodes.contains(bizDataCode)) continue;
            this.initRecordMap(bizData.getString("applyno"), recordMap, "othernum");
            markedBizDataCodes.add(bizDataCode);
        }
        waitMatchList.removeAll(noPayrollGrpList);
        HashMap bizDataMap = new HashMap(waitMatchList.size());
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(waitMatchList.size());
        for (DynamicObject bizData : waitMatchList) {
            String string = bizData.getString(BIZDATACODE);
            List<Object> subList = (List)bizDataMap.get(string);
            if (null == subList) {
                subList = new ArrayList<DynamicObject>(10);
                bizDataMap.put(string, subList);
            }
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("person", bizData.getLong("empposorgrel.person.id"));
            param.put("payrollgrp", bizData.getLong("bizdatadim.payrollgroup.id"));
            params.add(param);
            param.put(BIZDATACODE, string);
            subList.add(bizData);
        }
        List<Object> result = new ArrayList(params.size());
        try {
            result = HPDIServiceUtils.matchSalaryFileByPerson(params);
        }
        catch (Exception exp) {
            LOGGER.error("AddTransSalaryService-matchSalaryFileByPerson error:", (Throwable)exp);
            waitMatchList.forEach(dy -> errorMap.put(dy.getLong("id"), HPDIResMgrBusiness.getMsgOfInvokeItfFail()));
        }
        for (Map map : result) {
            int queryRowCount = (Integer)map.get("queryRowCount");
            List subList = (List)bizDataMap.get(map.get(BIZDATACODE));
            if (queryRowCount == 0) {
                LOGGER.info("***********error: not match salaryFile. bizdatacode: {}", (Object)((DynamicObject)subList.get(0)).getString(BIZDATACODE));
                subList.forEach(dy -> errorMap.put(dy.getLong("id"), BizDataFailStatusEnum.FAILSTATUS_1032.getDesc()));
                continue;
            }
            if (queryRowCount == 2) {
                LOGGER.info("***********error:match more salaryFile. bizdatacode: {}", (Object)((DynamicObject)subList.get(0)).getString(BIZDATACODE));
                subList.forEach(dy -> errorMap.put(dy.getLong("id"), BizDataFailStatusEnum.FAILSTATUS_1033.getDesc()));
                continue;
            }
            if (queryRowCount != 1) continue;
            subList.forEach(dy -> dy.set("salaryfile", ((List)record.get("matchSalaryFiles")).get(0)));
        }
        BizDataMatchSalaryFileArgs args = new BizDataMatchSalaryFileArgs();
        args.setBizDataList(waitMatchList);
        this.invokeMatchAndSetSalaryFile(args);
        Map map = args.getErrorMap();
        if (null != map) {
            errorMap.putAll(map);
        }
        List failList = waitMatchList.stream().filter(dy -> SWCObjectUtils.isEmpty((Object)dy.get("salaryfile"))).collect(Collectors.toList());
        failList.addAll(noPayrollGrpList);
        Map<Long, DynamicObject> failMap = failList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        Iterator iterator = errorMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String bizDataCode;
            Map.Entry entry = iterator.next();
            if (!failMap.containsKey(entry.getKey())) {
                iterator.remove();
                continue;
            }
            DynamicObject bizData = failMap.get(entry.getKey());
            if (SWCObjectUtils.isEmpty((Object)bizData) || markedBizDataCodes.contains(bizDataCode = bizData.getString(BIZDATACODE))) continue;
            this.initRecordMap(bizData.getString("applyno"), recordMap, "notmatchfilenum");
            markedBizDataCodes.add(bizDataCode);
        }
        this.updateBizDataCalFailed(errorMap, matchRuleMap);
        bizDataList.removeAll(failList);
    }

    private void invokeChangeDepempBeforeTransSalary(BizDataTransSalaryArgs args) {
        BizDataTransSalaryExtService extService = new BizDataTransSalaryExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, IBizDataTransSalaryExtPlugin.class, (String)"kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataTransSalaryExtPlugin#beforeAddTransSalary", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.beforeAddTransSalary(args);
            return null;
        });
    }

    private void invokeMatchAndSetSalaryFile(BizDataMatchSalaryFileArgs args) {
        BizDataMatchSalaryFileExtService extService = new BizDataMatchSalaryFileExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, IBizDataMatchSalaryFileExtPlugin.class, (String)"kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataMatchSalaryFileExtPlugin#matchAndSetSalaryFile", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.matchAndSetSalaryFile(args);
            return null;
        });
    }

    private void updateBizDataCalFailed(Map<Long, String> errorMap, Map<Long, String> matchRuleMap) {
        if (null == errorMap || errorMap.isEmpty()) {
            return;
        }
        SWCDataServiceHelper bizdataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter filter = new QFilter("id", "in", errorMap.keySet());
        DynamicObject[] bizDataArr = bizdataHelper.query("bizdatastatus, errormsg, bizdatarecord.id, matchrule, submission, applyno, bizdatacode", new QFilter[]{filter});
        HashMap<Long, String> recordMap = new HashMap<Long, String>(16);
        HashMap<Long, String> recordMatchRuleMap = new HashMap<Long, String>(16);
        for (DynamicObject bizData : bizDataArr) {
            Long bizDataRecordId = bizData.getLong("bizdatarecord.id");
            bizData.set("matchrule", (Object)matchRuleMap.get(bizData.getLong("id")));
            String errorMsg = errorMap.get(bizData.getLong("id"));
            bizData.set("bizdatastatus", (Object)"4");
            bizData.set("errormsg", (Object)errorMsg);
            bizData.set("matchrule", bizData.get("matchrule"));
            if (0L == bizDataRecordId) continue;
            recordMap.put(bizDataRecordId, errorMsg);
            recordMatchRuleMap.put(bizDataRecordId, bizData.getString("matchrule"));
        }
        bizdataHelper.update(bizDataArr);
        this.writeBackBizDataStatus(Arrays.asList(bizDataArr));
        if (!recordMap.isEmpty()) {
            DynamicObject[] bizDataRecordArr;
            SWCDataServiceHelper recordHelper = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER;
            QFilter recordFilter = new QFilter("id", "in", recordMap.keySet());
            for (DynamicObject record : bizDataRecordArr = recordHelper.query("bizdatastatus, errormsg, matchrule", new QFilter[]{recordFilter})) {
                record.set("bizdatastatus", (Object)"4");
                record.set("errormsg", recordMap.get(record.getLong("id")));
                record.set("matchrule", recordMatchRuleMap.get(record.getLong("id")));
            }
            recordHelper.update(bizDataRecordArr);
        }
    }
}

