/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.service.IReceiveMsgParseService;
import kd.swc.hpdi.common.entity.CoreHRMessageContentEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DefaultReceiveMsgParseService
implements IReceiveMsgParseService {
    private static final Log LOGGER = LogFactory.getLog(DefaultReceiveMsgParseService.class);
    private static final String BOID = "boid";
    private static final String RECORD_ID = "recordId";
    private static final String CHG_RECORD_ID = "chgrecordId";
    private static final String CHG_MODE = "chgmode";
    private static final String FLOW_TYPE = "flowtype";
    private static final String HRPI_PERSON = "hrpi_person";
    private static final String HRPI_DEPEMP = "hrpi_depemp";
    private static final String HRPI_CMPEMP = "hrpi_cmpemp";
    private static final String HRPI_EMPLOYEE = "hrpi_employee";
    private static final String CHANGE_MODE_UNCHANGED = "4";
    private static final Set<Long> FLOW_IN_IGNORE_ACTION_TYPE_ID = new HashSet<Long>(16);
    private static final Set<Long> FLOW_IN_IGNORE_CHANGE_EVENT_ID = new HashSet<Long>(16);
    public static final Long PART_TIME_ACTION_TYPE = 1070L;

    private DefaultReceiveMsgParseService() {
    }

    public static DefaultReceiveMsgParseService getInstance() {
        return Load.instance;
    }

    @Override
    public List<CoreHRMessageContentEntity> parse(DynamicObject msgReceiveLog) {
        return this.splitMsgReceiveLogContent(msgReceiveLog);
    }

    public List<CoreHRMessageContentEntity> splitMsgReceiveLogContent(DynamicObject msgReceiveLog) {
        if (SWCObjectUtils.isEmpty((Object)msgReceiveLog)) {
            return Collections.emptyList();
        }
        return this.parMsgContent(msgReceiveLog);
    }

    private List<CoreHRMessageContentEntity> parMsgContent(DynamicObject msgReceiveLog) {
        String content = msgReceiveLog.getString("msgcontent");
        if (SWCStringUtils.isEmpty((String)content)) {
            return Collections.emptyList();
        }
        Map contentMap = (Map)SerializationUtils.deSerializeFromBase64((String)content);
        Long affactionId = (Long)contentMap.get("affactionId");
        Long recordId = this.getChgrecordId(contentMap);
        Map eventData = (Map)SWCMServiceUtils.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoByRecordId", (Object[])new Object[]{recordId});
        Boolean success = (Boolean)eventData.get("success");
        if (!success.booleanValue()) {
            return null;
        }
        try {
            LOGGER.info("[colla] 1.1 IHPFSPersonChgService.getChgInfoByRecordId,recordId = {},result = {}", (Object)recordId, (Object)SWCJSONUtils.toString((Object)eventData));
        }
        catch (IOException ex) {
            LOGGER.info("[colla] parse data error.", (Object)ex);
        }
        Map datas = (Map)eventData.get("data");
        String billNo = (String)datas.get("billNo");
        Long billId = (Long)datas.get("billId");
        Long eventId = (Long)datas.get("eventId");
        String billSource = (String)datas.get("billSource");
        Long chgActionId = (Long)datas.get("chgActionId");
        Long chgCategoryId = (Long)datas.get("chgCategoryId");
        Long chgRuleId = (Long)datas.get("chgRuleId");
        Date effectTime = new Date((Long)datas.get("effectTime"));
        String datastatus = (String)datas.get("datastatus");
        String dataEventEntity = (String)datas.get("eventEntity");
        Long bizActionId = msgReceiveLog.getLong("msgaction.id");
        Long bizCategoryId = msgReceiveLog.getLong("msgaction.actiontype.id");
        List dataList = (List)datas.get("data");
        ArrayList<CoreHRMessageContentEntity> entityResultList = new ArrayList<CoreHRMessageContentEntity>(10);
        DynamicObject dynamicObject = new SWCDataServiceHelper("hpfs_chgcategory").queryOne("chgevent", (Object)chgCategoryId);
        Long changeEventId = dynamicObject != null ? Long.valueOf(dynamicObject.getLong("chgevent.id")) : null;
        for (Map map : dataList) {
            if (CollectionUtils.isEmpty((Map)map) || this.isIgnored(chgCategoryId, changeEventId, map)) continue;
            CoreHRMessageContentEntity tempEntity = new CoreHRMessageContentEntity();
            tempEntity.setEmployeeId(this.getBizBoId(HRPI_EMPLOYEE, map));
            tempEntity.setComempId(this.getBizBoId(HRPI_CMPEMP, map));
            tempEntity.setDepempId(this.getBizBoId(HRPI_DEPEMP, map));
            tempEntity.setPersonId(this.getBizBoId(HRPI_PERSON, map));
            tempEntity.setEmployeeVId(this.getBizVId(HRPI_EMPLOYEE, map));
            tempEntity.setComempVId(this.getBizVId(HRPI_CMPEMP, map));
            tempEntity.setDepempVId(this.getBizVId(HRPI_DEPEMP, map));
            tempEntity.setPersonVId(this.getBizVId(HRPI_PERSON, map));
            tempEntity.setChgCategoryId(chgCategoryId);
            tempEntity.setChgActionId(chgActionId);
            tempEntity.setChgRuleId(chgRuleId);
            tempEntity.setEffectTime(effectTime);
            tempEntity.setDatastatus(datastatus);
            tempEntity.setBillId(billId);
            tempEntity.setBillNo(billNo);
            tempEntity.setBillSource(billSource);
            tempEntity.setEventEntity(dataEventEntity);
            tempEntity.setEventId(eventId);
            tempEntity.setRecordId(recordId);
            tempEntity.setAffactionId(affactionId);
            tempEntity.setBizActionId(bizActionId);
            tempEntity.setBizCategoryId(bizCategoryId);
            Map depEmp = (Map)map.get(HRPI_DEPEMP);
            if (CollectionUtils.isEmpty((Map)depEmp)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u52a1\u53d8\u52a8\u6d88\u606f\u201c{0}\u201d\u4e2d\u7ec4\u7ec7\u4eba\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa\u534f\u4f5c\u4efb\u52a1\u3002", (String)"DefaultReceiveMsgParseService_0", (String)"swc-hpdi-business", (Object[])new Object[]{recordId}));
            }
            String flowType = (String)depEmp.get(FLOW_TYPE);
            if (SWCStringUtils.isEmpty((String)flowType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u52a1\u53d8\u52a8\u6d88\u606f\u201c{0}\u201d\u4e2d\u7ec4\u7ec7\u4eba\u201c\u6d41\u52a8\u7c7b\u578b\u201d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa\u534f\u4f5c\u4efb\u52a1\u3002", (String)"DefaultReceiveMsgParseService_1", (String)"swc-hpdi-business", (Object[])new Object[]{recordId}));
            }
            tempEntity.setInbound(Boolean.valueOf("1".equals(flowType)));
            tempEntity.setFlowType(flowType);
            entityResultList.add(tempEntity);
        }
        List<CoreHRMessageContentEntity> collect = entityResultList.stream().sorted((first, second) -> {
            String secondFlowType;
            String firstFlowType = first.getFlowType();
            int firstParam = 0;
            int secondParam = 0;
            if (!SWCStringUtils.isEmpty((String)firstFlowType)) {
                firstParam = Integer.parseInt(firstFlowType);
            }
            if (!SWCStringUtils.isEmpty((String)(secondFlowType = second.getFlowType()))) {
                secondParam = Integer.parseInt(secondFlowType);
            }
            return secondParam - firstParam;
        }).collect(Collectors.toList());
        return collect;
    }

    private Long getChgrecordId(Map<String, Object> contentMap) {
        Long chgrecordId = (Long)contentMap.get(CHG_RECORD_ID);
        if (chgrecordId != null && chgrecordId > 0L) {
            return chgrecordId;
        }
        Long recordId = (Long)contentMap.get(RECORD_ID);
        if (recordId != null && recordId > 0L) {
            return recordId;
        }
        return null;
    }

    private boolean isIgnored(Long chgCategoryId, Long changeEventId, Map<String, Map<String, Object>> map) {
        String personChgMode;
        Map<String, Object> employee = map.get(HRPI_EMPLOYEE);
        Map<String, Object> cmpEmp = map.get(HRPI_CMPEMP);
        Map<String, Object> depEmp = map.get(HRPI_DEPEMP);
        Map<String, Object> person = map.get(HRPI_PERSON);
        String employeeChgMode = employee == null ? null : String.valueOf(employee.get(CHG_MODE));
        String cmpEmpChgMode = cmpEmp == null ? null : String.valueOf(cmpEmp.get(CHG_MODE));
        String depEmpChgMode = depEmp == null ? null : String.valueOf(depEmp.get(CHG_MODE));
        String string = personChgMode = person == null ? null : String.valueOf(person.get(CHG_MODE));
        if (PART_TIME_ACTION_TYPE.equals(chgCategoryId)) {
            return CHANGE_MODE_UNCHANGED.equals(employeeChgMode) && CHANGE_MODE_UNCHANGED.equals(cmpEmpChgMode) && CHANGE_MODE_UNCHANGED.equals(depEmpChgMode) && CHANGE_MODE_UNCHANGED.equals(personChgMode);
        }
        String flowType = "0";
        if (depEmp != null) {
            flowType = (String)depEmp.getOrDefault(FLOW_TYPE, "0");
        }
        return !(!FLOW_IN_IGNORE_ACTION_TYPE_ID.contains(chgCategoryId) && !FLOW_IN_IGNORE_CHANGE_EVENT_ID.contains(changeEventId) || !"2".equals(flowType) && !"0".equals(flowType));
    }

    private Long getBizBoId(String bizEntity, Map<String, Map<String, Object>> map) {
        Map<String, Object> bizData = map.get(bizEntity);
        if (bizData == null) {
            return null;
        }
        return (Long)bizData.get(BOID);
    }

    private Long getBizVId(String bizEntity, Map<String, Map<String, Object>> map) {
        Map<String, Object> bizData = map.get(bizEntity);
        if (bizData == null) {
            return null;
        }
        Long vid = (Long)bizData.get("vid");
        if (vid == null || vid == 0L) {
            return this.getBizBoId(bizEntity, map);
        }
        return vid;
    }

    static {
        FLOW_IN_IGNORE_ACTION_TYPE_ID.add(1080L);
        FLOW_IN_IGNORE_ACTION_TYPE_ID.add(102010L);
        FLOW_IN_IGNORE_ACTION_TYPE_ID.add(1160L);
        FLOW_IN_IGNORE_ACTION_TYPE_ID.add(1150L);
        FLOW_IN_IGNORE_ACTION_TYPE_ID.add(1030L);
        FLOW_IN_IGNORE_ACTION_TYPE_ID.add(1010L);
        FLOW_IN_IGNORE_CHANGE_EVENT_ID.add(1010L);
    }

    private static class Load {
        private static final DefaultReceiveMsgParseService instance = new DefaultReceiveMsgParseService();

        private Load() {
        }
    }

    private static final class FlowType {
        private static final String FLOW_IN = "1";
        private static final String FLOW_OUT = "2";
        private static final String FLOW_EMPTY = "0";

        private FlowType() {
        }
    }
}

