/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.service.IReceiveMsgParseService;
import kd.swc.hpdi.common.entity.CoreHRMessageContentEntity;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ExpChangeReceiveMsgParseService
implements IReceiveMsgParseService {
    private static final Log LOGGER = LogFactory.getLog(ExpChangeReceiveMsgParseService.class);
    private static final Long EXP_BILL_QUERY_API_ID = 1449239926729140224L;

    private ExpChangeReceiveMsgParseService() {
    }

    public static ExpChangeReceiveMsgParseService getInstance() {
        return Load.instance;
    }

    @Override
    public List<CoreHRMessageContentEntity> parse(DynamicObject msgReceiveLog) {
        String data = msgReceiveLog.getString("msgcontent");
        if (SWCStringUtils.isEmpty((String)data)) {
            return new ArrayList<CoreHRMessageContentEntity>(1);
        }
        Map contentMap = (Map)SerializationUtils.deSerializeFromBase64((String)data);
        String billNo = (String)contentMap.get("billNo");
        if (SWCStringUtils.isEmpty((String)billNo)) {
            return new ArrayList<CoreHRMessageContentEntity>(1);
        }
        QFilter billNoFilter = new QFilter("billno", "=", contentMap.get("billNo"));
        try {
            List result = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"getDataBySub", (Object[])new Object[]{EXP_BILL_QUERY_API_ID, billNoFilter, null});
            LOGGER.info("[colla] call hrcs IHRCSMsgService.getDataBySub result EXP_BILL_QUERY_API_ID = {}", (Object)EXP_BILL_QUERY_API_ID);
            return this.parseResult(result, msgReceiveLog);
        }
        catch (Exception ex) {
            LOGGER.info("[colla] call hrcs IHRCSMsgService.getDataBySub error.", (Object)ex);
            return new ArrayList<CoreHRMessageContentEntity>(1);
        }
    }

    private List<CoreHRMessageContentEntity> parseResult(List<Map<String, Object>> result, DynamicObject msgReceiveLog) {
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        Long bizActionId = msgReceiveLog.getLong("msgaction.id");
        Long bizCategoryId = msgReceiveLog.getLong("msgaction.actiontype.id");
        return result.stream().map(item -> {
            CoreHRMessageContentEntity coreHRMessageContentEntity = new CoreHRMessageContentEntity();
            coreHRMessageContentEntity.setFlowType("0");
            coreHRMessageContentEntity.setPersonId((Long)item.get("ham_dispatchrecordchg.person"));
            coreHRMessageContentEntity.setDepempId((Long)item.get("ham_dispatchrecordchg.depemp"));
            coreHRMessageContentEntity.setEmployeeId((Long)item.get("ham_dispatchrecordchg.depemp.employee"));
            coreHRMessageContentEntity.setPersonVId((Long)item.get("ham_dispatchrecordchg.person"));
            coreHRMessageContentEntity.setDepempVId((Long)item.get("ham_dispatchrecordchg.depemp"));
            coreHRMessageContentEntity.setEmployeeVId((Long)item.get("ham_dispatchrecordchg.depemp.employee"));
            coreHRMessageContentEntity.setBillNo((String)item.get("ham_dispatchrecordchg.billno"));
            coreHRMessageContentEntity.setEffectTime((Date)item.get("ham_dispatchrecordchg.startdate"));
            coreHRMessageContentEntity.setBizActionId(bizActionId);
            coreHRMessageContentEntity.setBizCategoryId(bizCategoryId);
            return coreHRMessageContentEntity;
        }).collect(Collectors.toList());
    }

    private static class Load {
        private static final ExpChangeReceiveMsgParseService instance = new ExpChangeReceiveMsgParseService();

        private Load() {
        }
    }
}

