/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.service.IApiResultHandler;
import kd.swc.hpdi.common.entity.CoreHRMessageContentEntity;
import org.apache.commons.collections4.MapUtils;

public class JobLevelApiResultHandler
implements IApiResultHandler {
    private static final Log LOGGER = LogFactory.getLog(JobLevelApiResultHandler.class);
    public static final String HSAS_EMPJOBREL = "hsas_empjobrel";
    public static final String HRPI_EMPJOBREL = "hrpi_empjobrel";

    @Override
    public Set<String> getEntityNameSet() {
        HashSet<String> entityName = new HashSet<String>(16);
        entityName.add(HSAS_EMPJOBREL);
        entityName.add(HRPI_EMPJOBREL);
        return entityName;
    }

    @Override
    public List<DynamicObject> execute(List<DynamicObject> apiDataList, List<Map<String, Object>> chgRecodDetail, CoreHRMessageContentEntity msgEntity) {
        if (CollectionUtils.isEmpty(apiDataList)) {
            return Collections.emptyList();
        }
        Map<Long, List<DynamicObject>> apiDataMap = apiDataList.stream().collect(Collectors.groupingBy(item -> item.getLong("boid")));
        if (apiDataMap.size() == 1) {
            return apiDataList;
        }
        if (chgRecodDetail == null) {
            chgRecodDetail = Collections.emptyList();
        }
        Map<String, List<Map>> chgModeMap = chgRecodDetail.stream().collect(Collectors.groupingBy(item -> MapUtils.getString((Map)item, (Object)"chgmode")));
        List<Map> addChangeModeList = chgModeMap.get("0");
        String flowType = msgEntity.getFlowType();
        if (!CollectionUtils.isEmpty(addChangeModeList)) {
            List<Map> disabledList;
            if ("1".equalsIgnoreCase(flowType)) {
                Long idAfter = MapUtils.getLong((Map)addChangeModeList.get(0), (Object)"idafter");
                return apiDataMap.getOrDefault(idAfter, Collections.emptyList());
            }
            if ("2".equalsIgnoreCase(flowType) && !CollectionUtils.isEmpty(disabledList = chgModeMap.get("2"))) {
                Long idAfter = MapUtils.getLong((Map)disabledList.get(0), (Object)"idafter");
                return apiDataMap.getOrDefault(idAfter, Collections.emptyList());
            }
        }
        return this.getLatestData(apiDataMap);
    }

    private List<DynamicObject> getLatestData(Map<Long, List<DynamicObject>> apiDataMap) {
        Optional<Optional> max = apiDataMap.values().stream().map(dynamicObjects -> dynamicObjects.stream().filter(item -> item.getBoolean("iscurrentversion")).findFirst()).max((first, second) -> {
            boolean firstPresent = first.isPresent();
            boolean secondPresent = second.isPresent();
            if (firstPresent && secondPresent) {
                DynamicObject firstObject = (DynamicObject)first.get();
                DynamicObject secondObject = (DynamicObject)second.get();
                int compareTo = firstObject.getDate("enddate").compareTo(secondObject.getDate("enddate"));
                if (compareTo != 0) {
                    return compareTo;
                }
                return firstObject.getDate("startdate").compareTo(secondObject.getDate("startdate"));
            }
            if (!firstPresent && secondPresent) {
                return -1;
            }
            if (firstPresent) {
                return 1;
            }
            return 0;
        });
        if (max.isPresent() && max.get().isPresent()) {
            long boid = ((DynamicObject)max.get().get()).getLong("boid");
            return apiDataMap.getOrDefault(boid, Collections.emptyList());
        }
        return Collections.emptyList();
    }
}

