/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.bizdata.filter.BizDataCaledFilter;
import kd.swc.hpdi.business.bizdata.filter.BizDataUpdateCODFilter;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.service.AbstractTransSalaryService;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hpdi.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class UpdateTransSalaryService
extends AbstractTransSalaryService {
    private static final Log LOGGER = LogFactory.getLog(UpdateTransSalaryService.class);

    @Override
    protected List<DynamicObject> beforeTransSalary(List<DynamicObject> bizDataList, String operateType) {
        return bizDataList;
    }

    @Override
    public Map<String, Object> synBizData(List<DynamicObject> successBizDatas) {
        HashMap reqMap = Maps.newHashMapWithExpectedSize((int)2);
        ArrayList paramList = Lists.newArrayListWithCapacity((int)successBizDatas.size());
        for (DynamicObject bizDataDy : successBizDatas) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("bizdatacode", bizDataDy.getString("bizdatacode"));
            paramMap.put("bizitemid", bizDataDy.getLong("bizitem.id"));
            paramMap.put("bsled", bizDataDy.getDate("expirydate"));
            paramList.add(paramMap);
        }
        reqMap.put("opsystem", "hpdi");
        reqMap.put("data", paramList);
        return HPDIServiceUtils.updateBlsed(reqMap);
    }

    @Override
    protected void initValidateFilter() {
        this.bizDataFilters = Lists.newArrayListWithCapacity((int)4);
        this.bizDataFilters.add(new BizDataCaledFilter());
        this.bizDataFilters.add(new BizDataUpdateCODFilter());
    }

    @Override
    public void updateBizDataSuccess(List<DynamicObject> bizDataHisList, List<DynamicObject> bizDataOperateLogList, List<DynamicObject> bizDataList, DynamicObject bizDataDy, Table<String, String, String> statusTable) {
        super.updateBizDataSuccess(bizDataHisList, bizDataOperateLogList, bizDataList, bizDataDy, statusTable);
        LOGGER.info(MessageFormat.format("UpdateTransSalaryService-updateBizDataSuccess,bizdatacode is :{0}, bizdatastatus is:{1}", bizDataDy.getString("bizdatacode"), bizDataDy.getString("bizdatastatus")));
        QFilter bizDataFilter = new QFilter("bizdatacode", "=", (Object)bizDataDy.getString("bizdatacode"));
        QFilter typeFilter = new QFilter("billtype", "=", (Object)"1");
        DynamicObject bizSourceData = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.queryOne("id, calperiod, bizdatastatus, errormsg, transsalaryerror, bizdatacode,calsalarydate, batchnum, applyno,expirydate,billtype,empposorgrel,empposorgrel.adminorg,bizitemgroup,bizitem,bizdatadim,relationrecord,payrollgrp,salaryfile, bizdatarecord, overdue, matchrule, updateddesc, submission", new QFilter[]{bizDataFilter, typeFilter});
        if (bizSourceData == null) {
            LOGGER.info("UpdateTransSalaryService-updateBizDataSuccess,bizSourceData is null");
            return;
        }
        LOGGER.info(MessageFormat.format("UpdateTransSalaryService-updateBizDataSuccess,query salaryfileID is:{0}, payrollgrpID is:{1}", bizSourceData.getLong("salaryfile.id"), bizSourceData.getLong("payrollgrp.id")));
        LOGGER.info("UpdateTransSalaryService-updateBizDataSuccess,bizSourceData bizdatacode is :{0},query bizdatastatus is:{1}, calPeriodId is:{3}", new Object[]{bizSourceData.getString("bizdatacode"), bizSourceData.getString("bizdatastatus"), bizSourceData.getLong("calperiod.id")});
        Date backUpDate = bizSourceData.getDate("expirydate");
        bizSourceData.set("expirydate", (Object)bizDataDy.getDate("expirydate"));
        bizSourceData.set("relationrecord", (Object)"A");
        bizDataList.add(bizSourceData);
        bizDataDy.set("calperiod", (Object)bizSourceData.getLong("calperiod.id"));
        LOGGER.info("updateBizDataSuccess_record");
        DynamicObject bizDataHis = HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.generateEmptyDynamicObject();
        bizDataHis.set("empposorgrel", bizDataDy.getDynamicObject("empposorgrel").getPkValue());
        bizDataHis.set("bizitem", bizDataDy.getDynamicObject("bizitem").getPkValue());
        bizDataHis.set("currentbizdatacode", (Object)bizDataDy.getString("bizdatacode"));
        bizDataHis.set("operatebizdatacode", (Object)bizDataDy.getString("bizdatacode"));
        bizDataHis.set("beforupdatedate", (Object)backUpDate);
        bizDataHis.set("afterupdatedate", (Object)bizDataDy.getDate("expirydate"));
        bizDataHis.set("operatetype", (Object)BizDataOperateEnum.OPERATE_UPDATE.getCode());
        bizDataHis.set("operater", (Object)RequestContext.get().getCurrUserId());
        bizDataHis.set("operatetime", (Object)new Date());
        bizDataHis.set("bizdata", bizDataDy.getPkValue());
        bizDataHisList.add(bizDataHis);
        bizDataOperateLogList.add(this.assembleOperateLog(bizDataHis, bizDataDy));
    }

    private DynamicObject assembleOperateLog(DynamicObject recordDy, DynamicObject bizData) {
        DynamicObject operateLog = HPDIDataServiceHelper.HPDI_BIZDATAOPERATELOG_HELPER.generateEmptyDynamicObject();
        operateLog.set("dataid", (Object)bizData.getLong("id"));
        operateLog.set("modeltype", (Object)"1");
        operateLog.set("empposorgrel", (Object)bizData.getDynamicObject("empposorgrel"));
        operateLog.set("salaryfile", (Object)bizData.getDynamicObject("salaryfile"));
        operateLog.set("adminorg", (Object)bizData.getDynamicObject("empposorgrel.adminorg"));
        operateLog.set("bizitemgroup", (Object)bizData.getDynamicObject("bizitemgroup"));
        operateLog.set("bizdatacode", (Object)bizData.getString("bizdatacode"));
        operateLog.set("bizitem", (Object)bizData.getDynamicObject("bizitem"));
        operateLog.set("bizdatadim", (Object)bizData.getDynamicObject("bizdatadim"));
        operateLog.set("description", (Object)bizData.getString("updateddesc"));
        operateLog.set("operatetype", (Object)BizDataOperateEnum.OPERATE_UPDATE.getCode());
        operateLog.set("updatefield", (Object)BizDataUpdateFieldEnum.FIELD_EXPIRYDATE.getCode());
        String beforeUpdate = null;
        String afterUpdate = null;
        beforeUpdate = null == recordDy.getDate("beforupdatedate") ? null : SWCDateTimeUtils.formatDate((Date)recordDy.getDate("beforupdatedate"));
        afterUpdate = null == bizData.getDate("expirydate") ? null : SWCDateTimeUtils.formatDate((Date)bizData.getDate("expirydate"));
        operateLog.set("beforeupdate", (Object)beforeUpdate);
        operateLog.set("afterupdate", (Object)afterUpdate);
        return operateLog;
    }
}

