/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.service.bizdataentryvalidate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataValueValidatorService {
    public static String checkDecimalTypeValue(DynamicObject entry, Map<Long, DynamicObject> bizItemGroupEntMap, int index) {
        DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
        List decimalDetails = details.stream().filter(dy -> "1010_S".equals(dy.getString("bizitem.datatype.number"))).collect(Collectors.toList());
        StringBuilder msgBuilder = new StringBuilder();
        for (DynamicObject detail : decimalDetails) {
            String value = detail.getString("value");
            DynamicObject bizItemObj = detail.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemObj) || SWCStringUtils.isEmpty((String)value)) {
                return null;
            }
            BigDecimal decimalValue = new BigDecimal(value);
            int indexOf = value.indexOf(46);
            int precision = 0;
            if (indexOf > 0) {
                precision = value.substring(indexOf + 1).length();
            }
            String scaleLimit = bizItemObj.getString("scalelimit");
            int scale = 10;
            if (!SWCStringUtils.isEmpty((String)scaleLimit)) {
                scale = Integer.parseInt(scaleLimit);
            }
            if (scale < precision) {
                if (msgBuilder.length() > 0) {
                    msgBuilder.append('\n');
                }
                msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u9879\u76ee\u503c\u5c0f\u6570\u4f4d\u6570\u9700\u63a7\u5236\u5728{2}\u5185\u3002", (String)"BizDataValueValidatorService_01", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name"), scale));
                continue;
            }
            boolean isMinValNull = bizItemObj.getBoolean("isminvalnull");
            boolean isMaxValNull = bizItemObj.getBoolean("ismaxvalnull");
            BigDecimal minVal = bizItemObj.getBigDecimal("minvalue");
            BigDecimal maxVal = bizItemObj.getBigDecimal("maxvalue");
            DynamicObject bizItemGroupEnt = bizItemGroupEntMap.get(bizItemObj.getLong("id"));
            if (!SWCObjectUtils.isEmpty((Object)bizItemGroupEnt)) {
                BigDecimal submitMaxValue = bizItemGroupEnt.getBigDecimal("submitmaxvalue");
                BigDecimal submitMinValue = bizItemGroupEnt.getBigDecimal("submitminvalue");
                if (null != submitMinValue) {
                    minVal = isMinValNull ? submitMinValue : submitMinValue.max(minVal);
                    isMinValNull = false;
                }
                if (null != submitMaxValue) {
                    maxVal = isMaxValNull ? submitMaxValue : submitMaxValue.min(maxVal);
                    isMaxValNull = false;
                }
            }
            if (!isMinValNull && isMaxValNull && minVal.compareTo(decimalValue) > 0) {
                if (msgBuilder.length() > 0) {
                    msgBuilder.append('\n');
                }
                msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u9879\u76ee\u503c\u4e0d\u7b26\u5408\u6700\u5c0f\uff08{2}\uff09\u8f93\u5165\u503c\u7684\u8981\u6c42\u3002", (String)"BizDataValueValidatorService_02", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name"), minVal.setScale(scale, RoundingMode.HALF_UP).toPlainString()));
                continue;
            }
            if (isMinValNull && !isMaxValNull && maxVal.compareTo(decimalValue) < 0) {
                if (msgBuilder.length() > 0) {
                    msgBuilder.append('\n');
                }
                msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u9879\u76ee\u503c\u4e0d\u7b26\u5408\u6700\u5927\uff08{2}\uff09\u8f93\u5165\u503c\u7684\u8981\u6c42\u3002", (String)"BizDataValueValidatorService_03", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name"), maxVal.setScale(scale, RoundingMode.HALF_UP).toPlainString()));
                continue;
            }
            if (isMinValNull || isMaxValNull || maxVal.compareTo(decimalValue) >= 0 && minVal.compareTo(decimalValue) <= 0) continue;
            if (msgBuilder.length() > 0) {
                msgBuilder.append('\n');
            }
            msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u9879\u76ee\u503c\u4e0d\u7b26\u5408\u6700\u5c0f\uff08{2}\uff09\u3001\u6700\u5927\uff08{3}\uff09\u8f93\u5165\u503c\u7684\u8981\u6c42\u3002", (String)"BizDataValueValidatorService_04", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name"), minVal.setScale(scale, RoundingMode.HALF_UP).toPlainString(), maxVal.setScale(scale, RoundingMode.HALF_UP).toPlainString()));
        }
        return msgBuilder.toString();
    }

    public static String checkAmountTypeValue(DynamicObject entry, int index) {
        DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
        DynamicObject currency = entry.getDynamicObject("currency");
        List amountDetails = details.stream().filter(dy -> "1020_S".equals(dy.getString("bizitem.datatype.number"))).collect(Collectors.toList());
        String rangeErrorMsg = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u91d1\u989d\u7c7b\u578b\u7684\u9879\u76ee\u201c{1}\u201d\u5e01\u79cd\u9700\u8981\u5728\u4e1a\u52a1\u9879\u76ee\u89c4\u5b9a\u7684\u5e01\u79cd\u8303\u56f4\u5185{2}\u3002", (String)"BizDataValueValidatorService_15", (String)"swc-hpdi-business", (Object[])new Object[0]);
        String precisionErrorMsg = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u9879\u76ee\u503c\u9700\u63a7\u5236\u5728\u5bf9\u5e94\u5e01\u79cd\u7684\u5e01\u79cd\u7cbe\u5ea6\u8303\u56f4{2}\u5185\u3002", (String)"BizDataValueValidatorService_14", (String)"swc-hpdi-business", (Object[])new Object[0]);
        StringBuilder msgBuilder = new StringBuilder();
        for (DynamicObject detail : amountDetails) {
            String value = detail.getString("value");
            DynamicObject bizItemObj = detail.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemObj) || SWCStringUtils.isEmpty((String)value)) {
                return null;
            }
            int indexOf = value.indexOf(46);
            int precision = 0;
            if (indexOf > 0) {
                precision = value.substring(indexOf + 1).length();
            }
            if (SWCObjectUtils.isEmpty((Object)currency)) {
                return null;
            }
            int amtPrecision = currency.getInt("amtprecision");
            if (amtPrecision < precision) {
                if (msgBuilder.length() > 0) {
                    msgBuilder.append('\n');
                }
                msgBuilder.append(MessageFormat.format(precisionErrorMsg, index + 1, bizItemObj.getString("name"), amtPrecision));
                continue;
            }
            DynamicObjectCollection currencyColl = bizItemObj.getDynamicObjectCollection("currency");
            HashSet<Long> currencyIdSet = new HashSet<Long>(16);
            HashSet<String> currencyNameSet = new HashSet<String>(16);
            for (DynamicObject currencyObj : currencyColl) {
                currencyIdSet.add(currencyObj.getLong("fbasedataid_id"));
                currencyNameSet.add(currencyObj.getString("fbasedataid.name"));
            }
            if (currencyColl.size() <= 0 || currencyIdSet.contains(currency.getLong("id"))) continue;
            if (msgBuilder.length() > 0) {
                msgBuilder.append('\n');
            }
            msgBuilder.append(MessageFormat.format(rangeErrorMsg, index + 1, bizItemObj.getString("name"), ((Object)currencyNameSet).toString()));
        }
        return msgBuilder.toString();
    }

    public static String checkDateTypeValue(DynamicObject entry, Map<Long, DynamicObject> bizItemGroupEntMap, int index) {
        DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
        List dateDetails = details.stream().filter(dy -> "1050_S".equals(dy.getString("bizitem.datatype.number"))).collect(Collectors.toList());
        StringBuilder msgBuilder = new StringBuilder();
        for (DynamicObject detail : dateDetails) {
            Date dateValue;
            String value = detail.getString("value");
            DynamicObject bizItemObj = detail.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemObj) || SWCStringUtils.isEmpty((String)value)) {
                return null;
            }
            String[] splitStr = value.trim().split("-");
            if (splitStr.length != 3) {
                if (msgBuilder.length() > 0) {
                    msgBuilder.append('\n');
                }
                msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u6570\u636e\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u6570\u636e\u7c7b\u578b\u8981\u6c42(yyyy-MM-dd)\u3002", (String)"BizDataValueValidatorService_13", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name")));
                continue;
            }
            String year = splitStr[0];
            String month = splitStr[1];
            String day = splitStr[2];
            if (year.length() != 4 || month.length() != 2 || day.length() != 2) {
                if (msgBuilder.length() > 0) {
                    msgBuilder.append('\n');
                }
                msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u6570\u636e\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u6570\u636e\u7c7b\u578b\u8981\u6c42(yyyy-MM-dd)\u3002", (String)"BizDataValueValidatorService_13", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name")));
                continue;
            }
            try {
                dateValue = SWCDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
            }
            catch (Exception exception) {
                if (msgBuilder.length() > 0) {
                    msgBuilder.append('\n');
                }
                msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u6570\u636e\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u6570\u636e\u7c7b\u578b\u8981\u6c42(yyyy-MM-dd)\u3002", (String)"BizDataValueValidatorService_13", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name")));
                continue;
            }
            Date earliestDate = bizItemObj.getDate("earliestdate");
            Date lastDate = bizItemObj.getDate("lastdate");
            DynamicObject bizItemGroupEnt = bizItemGroupEntMap.get(bizItemObj.getLong("id"));
            if (!SWCObjectUtils.isEmpty((Object)bizItemGroupEnt)) {
                Date submitStartDate = bizItemGroupEnt.getDate("submitstartdate");
                Date submitEndDate = bizItemGroupEnt.getDate("submitenddate");
                earliestDate = BizDataHelper.getMaxDate(earliestDate, submitStartDate);
                lastDate = BizDataHelper.getMinDate(lastDate, submitEndDate);
            }
            if (earliestDate != null && lastDate == null && earliestDate.compareTo(dateValue) > 0) {
                if (msgBuilder.length() > 0) {
                    msgBuilder.append('\n');
                }
                msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u9879\u76ee\u503c\u4e0d\u7b26\u5408\u6700\u65e9\uff08{2}\uff09\u65e5\u671f\u8981\u6c42\u3002", (String)"BizDataValueValidatorService_07", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name"), SWCDateTimeUtils.formatDate((Date)earliestDate)));
                continue;
            }
            if (earliestDate == null && lastDate != null && lastDate.compareTo(dateValue) < 0) {
                if (msgBuilder.length() > 0) {
                    msgBuilder.append('\n');
                }
                msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u9879\u76ee\u503c\u4e0d\u7b26\u5408\u6700\u665a\uff08{2}\uff09\u65e5\u671f\u8981\u6c42\u3002", (String)"BizDataValueValidatorService_08", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name"), SWCDateTimeUtils.formatDate((Date)lastDate)));
                continue;
            }
            if (earliestDate == null || lastDate == null || earliestDate.compareTo(dateValue) <= 0 && lastDate.compareTo(dateValue) >= 0) continue;
            if (msgBuilder.length() > 0) {
                msgBuilder.append('\n');
            }
            msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u9879\u76ee\u503c\u4e0d\u7b26\u5408\u6700\u65e9\uff08{2}\uff09\u3001\u6700\u665a\uff08{3}\uff09\u65e5\u671f\u8981\u6c42\u3002", (String)"BizDataValueValidatorService_09", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name"), SWCDateTimeUtils.formatDate((Date)earliestDate), SWCDateTimeUtils.formatDate((Date)lastDate)));
        }
        return msgBuilder.toString();
    }

    public static String checkTextTypeValue(DynamicObject entry, int index) {
        DynamicObjectCollection details = entry.getDynamicObjectCollection("entryentity");
        List dateDetails = details.stream().filter(dy -> "1030_S".equals(dy.getString("bizitem.datatype.number"))).collect(Collectors.toList());
        StringBuilder msgBuilder = new StringBuilder();
        for (DynamicObject detail : dateDetails) {
            String value = detail.getString("value");
            DynamicObject bizItemObj = detail.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemObj) || SWCStringUtils.isEmpty((String)value)) {
                return null;
            }
            int dataLength = bizItemObj.getInt("datalength");
            if (value.length() <= dataLength) continue;
            if (msgBuilder.length() > 0) {
                msgBuilder.append('\n');
            }
            msgBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u6570\u636e\u201d\u7b2c{0}\u884c\uff0c\u201c{1}\u201d\u9879\u76ee\u503c\u957f\u5ea6\u4e0d\u7b26\u5408\u4e1a\u52a1\u9879\u76ee\u6570\u636e\u957f\u5ea6\uff08{2}\uff09\u8981\u6c42\u3002", (String)"BizDataValueValidatorService_10", (String)"swc-hpdi-business", (Object[])new Object[0]), index + 1, bizItemObj.getString("name"), dataLength));
        }
        return msgBuilder.toString();
    }
}

