/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.EmpInfoReviseHelper;
import kd.swc.hpdi.business.service.IShowReviseDetailService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import org.apache.commons.collections4.MapUtils;

public abstract class BaseShowReviseDetailService
implements IShowReviseDetailService {
    public static final String SWC_HPDI_BUSINESS = "swc-hpdi-business";

    abstract String entityNumber();

    abstract String entityName();

    abstract List<String> entityShowField();

    protected void beforeShowSingleDetailPage(List<Map<String, Object>> entryData, List<Map<String, Object>> entryTitle, Map<Long, Map<String, Object>> reviseDetailMap) {
    }

    protected void beforeShowMultiDetailPage(List<Map<String, Object>> entryData, List<Map<String, Object>> entryTitle) {
    }

    protected int compareMultiData(Map<String, Object> first, Map<String, Object> second) {
        return 0;
    }

    @Override
    public Optional<FormShowParameter> showSingle(Map<String, Object> reviseMap) {
        Long reviseDetId = MapUtils.getLong(reviseMap, (Object)"reviseDetId");
        Long reviseBoId = MapUtils.getLong(reviseMap, (Object)"reviseBoId");
        Map<Long, Map<String, Object>> reviseDetailMap = EmpInfoReviseHelper.getInstance().queryReviseFieldDetailMapByDetId(reviseDetId);
        List<Map<String, Object>> entryDataList = this.getSingleDataEntry(reviseMap, reviseDetailMap);
        Map<String, Object> billData = this.getReviseDescData((Map)MapUtils.getObject(reviseDetailMap, (Object)reviseBoId, Collections.emptyMap()));
        List<Map<String, Object>> showSinglePagetTitle = this.getShowSinglePageTitle();
        this.beforeShowSingleDetailPage(entryDataList, showSinglePagetTitle, reviseDetailMap);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"{0}\u4fee\u8ba2\u8be6\u60c5", (String)"BaseShowReviseDetailService_0", (String)SWC_HPDI_BUSINESS, (Object[])new Object[]{this.entityName()}));
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParam("billData", (Object)JSON.toJSONString(billData));
        formShowParameter.setCustomParam("entryData", (Object)JSON.toJSONString(entryDataList));
        formShowParameter.setCustomParam("fieldParamMaps", (Object)JSON.toJSONString(showSinglePagetTitle));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hpdi_empsigledetail");
        return Optional.of(formShowParameter);
    }

    private Map<String, Object> getReviseDescData(Map<String, Object> reviseDetails) {
        if (CollectionUtils.isEmpty(reviseDetails)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        ArrayList reasonList = new ArrayList(10);
        ArrayList descList = new ArrayList(10);
        reasonList.addAll((List)MapUtils.getObject(reviseDetails, (Object)"reviseReason", Collections.emptyList()));
        descList.addAll((List)MapUtils.getObject(reviseDetails, (Object)"reviseDesc", Collections.emptyList()));
        result.put("reviseReason", String.join((CharSequence)",", reasonList));
        result.put("reviseDesc", String.join((CharSequence)",", descList));
        return result;
    }

    @Override
    public Optional<FormShowParameter> showMulti(Map<String, Object> reviseParam) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"{0}\u4fee\u8ba2\u8be6\u60c5", (String)"BaseShowReviseDetailService_0", (String)SWC_HPDI_BUSINESS, (Object[])new Object[]{this.entityName()}));
        formShowParameter.setStatus(OperationStatus.VIEW);
        Long reviseLogId = MapUtils.getLong(reviseParam, (Object)"reviseLogId");
        Map<Long, Map<String, Object>> reviseDetailMap = EmpInfoReviseHelper.getInstance().queryReviseFieldDetailMapByLogId(reviseLogId);
        Set<String> reviseFields = EmpInfoReviseHelper.getInstance().getAllReviseFields(reviseDetailMap);
        List<String> fields = this.getAllShowFields(reviseFields);
        List<Map<String, Object>> multiEntryData = this.getMultiEntryData(reviseParam, fields, reviseDetailMap);
        List<Map<String, Object>> multiEntryTitle = this.getMultiEntryTitle(fields);
        this.beforeShowMultiDetailPage(multiEntryData, multiEntryTitle);
        List sortedEntryData = multiEntryData.stream().sorted((first, second) -> {
            Map secondData;
            String secondType;
            Map firstData = MapUtils.getMap((Map)first, (Object)"data");
            String firstType = MapUtils.getString((Map)firstData, (Object)"_$revisetype");
            int compare = this.compareReviseType(firstType, secondType = MapUtils.getString((Map)(secondData = MapUtils.getMap((Map)second, (Object)"data")), (Object)"_$revisetype"));
            if (compare == 0) {
                return this.compareMultiData(firstData, secondData);
            }
            return compare;
        }).collect(Collectors.toList());
        formShowParameter.setCustomParam("entryData", (Object)JSON.toJSONString(sortedEntryData));
        formShowParameter.setCustomParam("fieldParamMaps", (Object)JSON.toJSONString(multiEntryTitle));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hpdi_dynamicentry");
        formShowParameter.addCustPlugin("kd.swc.hpdi.formplugin.web.msgreceive.ReviseDetailEdit");
        return Optional.of(formShowParameter);
    }

    protected DynamicObject[] queryMultiBizData(Map<String, Object> reviseMap, Map<Long, Map<String, Object>> reviseDetailMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(this.entityNumber());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber());
        String keyNumber = dataEntityType.getPrimaryKey().getName();
        return helper.query(SWCHisBaseDataHelper.getSelectProperties((String)this.entityNumber()), new QFilter[]{new QFilter(keyNumber, "in", this.getAllReviseAfterId(reviseDetailMap))});
    }

    protected List<Long> getAllReviseAfterId(Map<Long, Map<String, Object>> reviseDetailMap) {
        if (CollectionUtils.isEmpty(reviseDetailMap)) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>(10);
        reviseDetailMap.forEach((boId, dataMap) -> {
            Long tempId = MapUtils.getLong((Map)dataMap, (Object)"_$reviseafterid");
            Long reviseBoId = MapUtils.getLong((Map)dataMap, (Object)"_$reviseboid");
            if (tempId != null && tempId != 0L) {
                result.add(tempId);
            } else {
                result.add(reviseBoId);
            }
        });
        return result;
    }

    private List<String> getAllShowFields(Set<String> others) {
        ArrayList fields = Lists.newArrayList(this.getMultiPreEntryField());
        fields.addAll(this.entityShowField(others));
        fields.addAll(this.getMultiSufEntryField());
        return fields;
    }

    private List<String> entityShowField(Set<String> others) {
        ArrayList<String> result = new ArrayList<String>(this.entityShowField());
        if (CollectionUtils.isEmpty(others)) {
            return result;
        }
        HashSet<String> tempSet = new HashSet<String>(result);
        for (String other : others) {
            if (tempSet.contains(other)) continue;
            result.add(other);
        }
        return result;
    }

    private int compareReviseType(String firstType, String secondType) {
        ImmutableMap scoreMap = ImmutableMap.of((Object)"0", (Object)1, (Object)"5", (Object)2, (Object)"-99", (Object)3, (Object)"1", (Object)4);
        return MapUtils.getInteger((Map)scoreMap, (Object)firstType, (Integer)0) - MapUtils.getInteger((Map)scoreMap, (Object)secondType, (Integer)0);
    }

    private List<Map<String, Object>> getMultiEntryData(Map<String, Object> reviseParam, List<String> fields, Map<Long, Map<String, Object>> reviseDetailMap) {
        String entityNumber = this.entityNumber();
        Long reviseLogId = MapUtils.getLong(reviseParam, (Object)"reviseLogId", (Long)0L);
        Map<Long, Long> reviseDetIdMap = EmpInfoReviseHelper.getInstance().queryReviseDetMap(reviseLogId);
        DynamicObject[] dynamicObjects = this.queryMultiBizData(reviseParam, reviseDetailMap);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            long boId = dynamicObject.getLong("boid");
            Map reviseObjectMap = MapUtils.getMap(reviseDetailMap, (Object)boId, Collections.emptyMap());
            Set reviseFields = (Set)MapUtils.getObject((Map)reviseObjectMap, (Object)"reviseFields", Collections.emptySet());
            for (String field : fields) {
                Object value;
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)field);
                if (property == null || (value = EmpInfoReviseHelper.getInstance().getObjectValue(dynamicObject, property)) == null) continue;
                dataMap.put(field, value);
            }
            if (CollectionUtils.isEmpty(dataMap)) continue;
            String reviseType = MapUtils.getString((Map)reviseObjectMap, (Object)"_$revisetype", (String)"-99");
            dataMap.put("_$viewdetail", ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"BaseShowReviseDetailService_1", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]));
            dataMap.put("_$revisetype", reviseType);
            dataMap.put("_$revisebeforeid", MapUtils.getLong((Map)reviseObjectMap, (Object)"_$revisebeforeid"));
            dataMap.put("_$reviseafterid", MapUtils.getLong((Map)reviseObjectMap, (Object)"_$reviseafterid"));
            dataMap.put("_$entitynumber", entityNumber);
            dataMap.put("_$reviseboid", String.valueOf(boId));
            dataMap.put("_$revisedetid", MapUtils.getLong(reviseDetIdMap, (Object)boId));
            List reviseReason = (List)MapUtils.getObject((Map)reviseObjectMap, (Object)"reviseReason", Collections.emptyList());
            dataMap.put("_$revisereason", String.join((CharSequence)",", reviseReason));
            List reviseDesc = (List)MapUtils.getObject((Map)reviseObjectMap, (Object)"reviseDesc", Collections.emptyList());
            dataMap.put("_$revisedesc", String.join((CharSequence)",", reviseDesc));
            HashMap<String, String> renderColor = new HashMap<String, String>(16);
            if ("5".equals(reviseType)) {
                renderColor.putAll(reviseFields.stream().collect(Collectors.toMap(item -> item, item -> "#ff0000", (first, second) -> second)));
            }
            if ("0".equals(reviseType) || "1".equals(reviseType) || "5".equals(reviseType)) {
                renderColor.put("_$revisetype", "#ff0000");
            }
            if ("-99".equals(reviseType)) {
                dataMap.put("_$revisebeforeid", String.valueOf(boId));
                dataMap.put("_$reviseafterid", String.valueOf(boId));
            }
            result.add((Map<String, Object>)ImmutableMap.of((Object)"data", dataMap, (Object)"renderColor", renderColor));
        }
        return result;
    }

    private List<Map<String, Object>> getMultiEntryTitle(List<String> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber());
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (String field : fields) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)field);
            if (property == null) continue;
            String name = property.getDisplayName().getLocaleValue();
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)16);
            if (property instanceof BasedataProp) {
                tempMap.put("dataType", "BASEDATA");
                tempMap.put("baseEntityId", ((BasedataProp)property).getBaseEntityId());
            } else if (property instanceof ComboProp) {
                tempMap.put("dataType", "COMBO");
                List comboItems = ((ComboProp)property).getComboItems();
                ArrayList pairs = new ArrayList(10);
                for (ValueMapItem comboItem : comboItems) {
                    HashMap<String, String> pair = new HashMap<String, String>(16);
                    pair.put("key", comboItem.getValue());
                    pair.put("value", comboItem.getName().getLocaleValue());
                    pairs.add(pair);
                }
                tempMap.put("pairs", pairs);
            } else if (property instanceof BooleanProp) {
                tempMap.put("dataType", "COMBO");
                tempMap.put("pairs", ImmutableList.of((Object)ImmutableMap.of((Object)"key", (Object)"true", (Object)"value", (Object)ResManager.loadKDString((String)"\u662f", (String)"BaseShowReviseDetailService_2", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0])), (Object)ImmutableMap.of((Object)"key", (Object)"false", (Object)"value", (Object)ResManager.loadKDString((String)"\u5426", (String)"BaseShowReviseDetailService_3", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]))));
            } else if (property instanceof DateProp) {
                tempMap.put("dataType", "DATETIME");
            } else {
                tempMap.put("dataType", "TEXT");
            }
            tempMap.put("name", name);
            tempMap.put("key", field);
            result.add(tempMap);
        }
        result.addAll(0, (Collection<Map<String, Object>>)this.getMultiPreEntryTitle());
        result.addAll((Collection<Map<String, Object>>)this.getMultiSufEntryTitle());
        return result;
    }

    private List<Map<String, Object>> getSingleDataEntry(Map<String, Object> reviseMap, Map<Long, Map<String, Object>> reviseDetailMap) {
        List<String> reviseFields;
        Long reviseBeforeId = MapUtils.getLong(reviseMap, (Object)"reviseBeforeId");
        Long reviseAfterId = MapUtils.getLong(reviseMap, (Object)"reviseAfterId");
        Long reviseBoId = MapUtils.getLong(reviseMap, (Object)"reviseBoId");
        Long reviseDetId = MapUtils.getLong(reviseMap, (Object)"reviseDetId");
        String reviseType = MapUtils.getString(reviseMap, (Object)"reviseType");
        String entityNumber = this.entityNumber();
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityNumber);
        DynamicObject[] query = helper.query(String.join((CharSequence)",", reviseFields = this.entityShowField(EmpInfoReviseHelper.getInstance().getAllReviseFields(reviseDetailMap))), new QFilter[]{new QFilter("id", "in", (Object)new Long[]{reviseAfterId, reviseBeforeId})});
        if (query == null || query.length == 0) {
            return Collections.emptyList();
        }
        HashBasedTable table = HashBasedTable.create();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (DynamicObject object : query) {
            long id = object.getLong("id");
            boolean isAfter = reviseAfterId == id;
            boolean isBefore = reviseBeforeId == id;
            String afterColumnName = "reviseafter";
            String beforeColumnName = "revisebefore";
            if (!isBefore && !isAfter) continue;
            for (String field : reviseFields) {
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)field);
                if (property == null) {
                    if (isBefore) {
                        table.put((Object)field, (Object)beforeColumnName, (Object)"");
                    }
                    if (!isAfter) continue;
                    table.put((Object)field, (Object)afterColumnName, (Object)"");
                    continue;
                }
                String objectValue = EmpInfoReviseHelper.getInstance().getDisplayValueByProp(object, property);
                if (objectValue == null) {
                    objectValue = "";
                }
                if (isBefore) {
                    table.put((Object)field, (Object)beforeColumnName, (Object)objectValue);
                }
                if (!isAfter) continue;
                table.put((Object)field, (Object)afterColumnName, (Object)objectValue);
            }
        }
        if (table.isEmpty()) {
            return Collections.emptyList();
        }
        return BaseShowReviseDetailService.parseEntryList(reviseFields, (Table<String, String, Object>)table, properties, reviseType, (Map)MapUtils.getObject(reviseDetailMap, (Object)reviseBoId, Collections.emptyMap()));
    }

    private static List<Map<String, Object>> parseEntryList(List<String> reviseFields, Table<String, String, Object> table, DataEntityPropertyCollection properties, String reviseType, Map<String, Object> reviseDetailMap) {
        ArrayList<Map<String, Object>> entryDataList = new ArrayList<Map<String, Object>>(10);
        Set hrReviseFields = (Set)MapUtils.getObject(reviseDetailMap, (Object)"reviseFields", Collections.emptySet());
        for (String field : reviseFields) {
            boolean isRenDerColor;
            IDataEntityProperty property;
            Object before;
            Object after = table.get((Object)field, (Object)"reviseafter");
            if (after == null) {
                after = "";
            }
            if ((before = table.get((Object)field, (Object)"revisebefore")) == null) {
                before = "";
            }
            String fieldName = (property = (IDataEntityProperty)properties.get((Object)field)) == null ? field : property.getDisplayName().getLocaleValue();
            HashMap<String, ImmutableMap> tempMap = new HashMap<String, ImmutableMap>(16);
            tempMap.put("data", ImmutableMap.of((Object)"fieldName", (Object)fieldName, (Object)"field", (Object)field, (Object)"reviseafter", (Object)after, (Object)"revisebefore", (Object)before));
            entryDataList.add(tempMap);
            boolean bl = isRenDerColor = !hrReviseFields.contains(field) || "0".equals(reviseType) || "1".equals(reviseType) || "-99".equals(reviseType);
            if (isRenDerColor) continue;
            tempMap.put("renderColor", ImmutableMap.of((Object)"reviseafter", (Object)"#ff0000"));
        }
        return entryDataList;
    }

    private List<Map<String, Object>> getShowSinglePageTitle() {
        return ImmutableList.of((Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u5b57\u6bb5\u540d", (String)"BaseShowReviseDetailService_4", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"fieldName"), (Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2\u524d", (String)"BaseShowReviseDetailService_5", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"revisebefore"), (Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2\u540e", (String)"BaseShowReviseDetailService_6", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"reviseafter"));
    }

    private ImmutableList<ImmutableMap<String, Object>> getMultiSufEntryTitle() {
        return ImmutableList.of((Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2\u63cf\u8ff0", (String)"BaseShowReviseDetailService_7", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"_$revisedesc"), (Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2\u539f\u56e0", (String)"BaseShowReviseDetailService_8", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"_$revisereason"), (Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2\u8bb0\u5f55\u540eID", (String)"BaseShowReviseDetailService_9", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"_$reviseafterid", (Object)"isHidden", (Object)"1"), (Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2\u8bb0\u5f55\u524dID", (String)"BaseShowReviseDetailService_10", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"_$revisebeforeid", (Object)"isHidden", (Object)"1"), (Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2\u8bb0\u5f55\u8be6\u60c5ID", (String)"BaseShowReviseDetailService_11", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"_$revisedetid", (Object)"isHidden", (Object)"1"), (Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2\u5b9e\u4f53BOID", (String)"BaseShowReviseDetailService_12", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"_$reviseboid", (Object)"isHidden", (Object)"1"), (Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2\u5b9e\u4f53\u7f16\u7801", (String)"BaseShowReviseDetailService_13", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"_$entitynumber", (Object)"isHidden", (Object)"1"));
    }

    private ImmutableList<ImmutableMap<String, Object>> getMultiPreEntryTitle() {
        return ImmutableList.of((Object)ImmutableMap.of((Object)"dataType", (Object)"TEXT", (Object)"name", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5217", (String)"BaseShowReviseDetailService_14", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"_$viewdetail", (Object)"isHyperLink", (Object)"1", (Object)"isFixed", (Object)"1"), (Object)ImmutableMap.of((Object)"dataType", (Object)"COMBO", (Object)"name", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2\u7c7b\u578b", (String)"BaseShowReviseDetailService_15", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0]), (Object)"key", (Object)"_$revisetype", (Object)"pairs", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"key", (Object)"0", (Object)"value", (Object)ResManager.loadKDString((String)"\u65b0\u589e", (String)"BaseShowReviseDetailService_16", (String)SWC_HPDI_BUSINESS, (Object[])new Object[]{this.entityName()})), (Object)ImmutableMap.of((Object)"key", (Object)"1", (Object)"value", (Object)ResManager.loadKDString((String)"\u5220\u9664", (String)"BaseShowReviseDetailService_17", (String)SWC_HPDI_BUSINESS, (Object[])new Object[]{this.entityName()})), (Object)ImmutableMap.of((Object)"key", (Object)"5", (Object)"value", (Object)ResManager.loadKDString((String)"\u4fee\u8ba2", (String)"BaseShowReviseDetailService_18", (String)SWC_HPDI_BUSINESS, (Object[])new Object[]{this.entityName()})), (Object)ImmutableMap.of((Object)"key", (Object)"-99", (Object)"value", (Object)ResManager.loadKDString((String)"\u672a\u4fee\u8ba2", (String)"BaseShowReviseDetailService_19", (String)SWC_HPDI_BUSINESS, (Object[])new Object[0])))));
    }

    private List<String> getMultiPreEntryField() {
        return ImmutableList.of((Object)"_$viewdetail", (Object)"_$revisetype");
    }

    private List<String> getMultiSufEntryField() {
        return ImmutableList.of((Object)"_$revisedesc", (Object)"_$revisereason", (Object)"_$revisebeforeid", (Object)"_$reviseafterid", (Object)"_$entitynumber");
    }
}

