/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.service.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hpdi.business.service.ICollaTaskService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

class CommonCollaTaskServiceImpl
implements ICollaTaskService {
    CommonCollaTaskServiceImpl() {
    }

    @Override
    public DynamicObject createCollaTaskFromMap(Map<String, Object> fieldDataMap) {
        DynamicObject msgReceiveLog = (DynamicObject)fieldDataMap.get("msgReceiveLog");
        DynamicObject bu = (DynamicObject)fieldDataMap.get("bu");
        DynamicObject taskArrange = (DynamicObject)fieldDataMap.get("taskArrange");
        DynamicObject taskArrangeV = (DynamicObject)fieldDataMap.get("taskArrangeV");
        DynamicObject verifyBill = (DynamicObject)fieldDataMap.get("verifyBill");
        Assert.notNull((Object)msgReceiveLog);
        Assert.notNull((Object)bu);
        Assert.notNull((Object)taskArrangeV);
        String executeType = (String)fieldDataMap.get("executeType");
        Integer executeSeq = (Integer)fieldDataMap.get("executeSeq");
        if (SWCStringUtils.isEmpty((String)executeType)) {
            executeType = "manner";
        }
        String caollTaskNumber = HPDICloudCollaHelper.getInstance().matchCollaTaskNumber(taskArrange.getDataEntityType().getName());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(caollTaskNumber);
        DynamicObject taskCenterDyobj = serviceHelper.generateEmptyDynamicObject();
        taskCenterDyobj.set("orgmsgrecvcenter", (Object)msgReceiveLog);
        taskCenterDyobj.set("org", (Object)bu);
        taskCenterDyobj.set("executeseq", (Object)executeSeq);
        if (verifyBill != null) {
            taskCenterDyobj.set("sumverifybillid", verifyBill.getPkValue());
        }
        taskCenterDyobj.set("changetime", fieldDataMap.get("changeTime"));
        taskCenterDyobj.set("flowtype", fieldDataMap.get("flowType"));
        taskCenterDyobj.set("orgteam", fieldDataMap.get("orgTeam"));
        taskCenterDyobj.set("dutyworkrole", fieldDataMap.get("dutyWorkRole"));
        String accountId = RequestContext.get().getAccountId();
        taskCenterDyobj.set("creator", (Object)accountId);
        taskCenterDyobj.set("modifier", (Object)accountId);
        Date date = new Date();
        taskCenterDyobj.set("createtime", (Object)date);
        taskCenterDyobj.set("modifytime", (Object)date);
        taskCenterDyobj.set("name", (Object)ResManager.loadKDString((String)"{0}\u4efb\u52a1", (String)"CommonCollaTaskServiceImpl_0", (String)"swc-hpdi-business", (Object[])new Object[]{msgReceiveLog.getString("name")}));
        taskCenterDyobj.set("number", (Object)CodeRuleServiceHelper.readNumber((String)caollTaskNumber, (DynamicObject)taskCenterDyobj, null));
        taskCenterDyobj.set("enable", (Object)"1");
        taskCenterDyobj.set("status", (Object)"C");
        taskCenterDyobj.set("taskcreatemanner", (Object)"B");
        taskCenterDyobj.set("taskexecutestatus", (Object)"B");
        taskCenterDyobj.set("id", (Object)ORM.create().genLongId(caollTaskNumber));
        taskCenterDyobj.set("person", (Object)MapUtils.getLong(fieldDataMap, (Object)"personId"));
        taskCenterDyobj.set("employee", (Object)MapUtils.getLong(fieldDataMap, (Object)"employeeId"));
        taskCenterDyobj.set("depemp", (Object)MapUtils.getLong(fieldDataMap, (Object)"depempId"));
        taskCenterDyobj.set("cmpemp", (Object)MapUtils.getLong(fieldDataMap, (Object)"cmpempId"));
        taskCenterDyobj.set("entryentity", (Object)serviceHelper.generateEmptyEntryCollection(taskCenterDyobj, "entryentity"));
        Table<String, Long, DynamicObject> crTable = HashBasedTable.create();
        if (verifyBill != null) {
            DynamicObjectCollection collaRuleEntryV = verifyBill.getDynamicObjectCollection("collaruleventry");
            HashMap<String, Set<Long>> idMap = new HashMap<String, Set<Long>>();
            collaRuleEntryV.stream().forEach(item -> {
                String collaRuleVClass = item.getString("collarulevclass");
                long collaRuleVid = item.getLong("collarulev.id");
                if (SWCStringUtils.isEmpty((String)collaRuleVClass) || collaRuleVid == 0L) {
                    return;
                }
                Set tempIds = idMap.computeIfAbsent(collaRuleVClass, it -> new HashSet(16));
                tempIds.add(collaRuleVid);
            });
            crTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(idMap);
        }
        HashBasedTable crVTable = HashBasedTable.create();
        if (!crTable.isEmpty()) {
            for (Table.Cell cell : crTable.cellSet()) {
                crVTable.put(cell.getRowKey(), (Object)((DynamicObject)cell.getValue()).getLong("boid"), cell.getValue());
            }
        }
        this.initTaskCenterEntry(taskCenterDyobj, taskArrangeV, (Table<String, Long, DynamicObject>)crVTable);
        return taskCenterDyobj;
    }

    @Override
    public List<DynamicObject> createCollaTaskEachAppFromMap(Map<String, Object> fieldDataMap) {
        return Collections.emptyList();
    }

    private void initTaskCenterEntry(DynamicObject taskCenter, DynamicObject taskArrangeV, Table<String, Long, DynamicObject> crVTable) {
        HashMap<String, Set<Long>> waitQueryCrIdMap = new HashMap<String, Set<Long>>(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(taskCenter.getDynamicObjectType().getName());
        DynamicObjectCollection taskCenterEnts = taskCenter.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection taskArrangeEnts = taskArrangeV.getDynamicObjectCollection("entryentity");
        boolean empty = crVTable == null || crVTable.isEmpty();
        for (int i = 0; i < taskArrangeEnts.size(); ++i) {
            DynamicObject taskArrangeEnt = (DynamicObject)taskArrangeEnts.get(i);
            DynamicObject newEntryDy = serviceHelper.generateEmptyEntryDynamicObject(taskCenter, "entryentity");
            newEntryDy.set("seq", (Object)(i + 1));
            String collaRuleClass = taskArrangeEnt.getString("collaruletype");
            if (SWCStringUtils.isEmpty((String)collaRuleClass)) continue;
            DynamicObject collaRule = new SWCDataServiceHelper(collaRuleClass).generateEmptyDynamicObject();
            collaRule.set("id", taskArrangeEnt.get("collarule.id"));
            newEntryDy.set("collarule", (Object)collaRule);
            newEntryDy.set("stopexecafterfail", taskArrangeEnt.get("stopexecafterfail"));
            newEntryDy.set("taskexecutestatusent", (Object)"B");
            newEntryDy.set("executefailmsgent", (Object)" ");
            newEntryDy.set("taskexecutetime", null);
            newEntryDy.set("taskexecmanner", (Object)" ");
            newEntryDy.set("taskexecuser", (Object)0);
            long collaRuleId = newEntryDy.getLong("collarule.id");
            newEntryDy.set("ismanualverify", (Object)Boolean.FALSE);
            newEntryDy.set("collaruleclass", (Object)collaRuleClass);
            DynamicObject collaRuleV = null;
            if (!empty) {
                collaRuleV = (DynamicObject)crVTable.get((Object)collaRuleClass, (Object)collaRuleId);
            }
            if (!empty && taskArrangeEnt.getBoolean("ismanualverify") && collaRuleV != null) {
                newEntryDy.set("collarulev", (Object)collaRuleV);
                newEntryDy.set("ismanualverify", (Object)Boolean.TRUE);
            }
            Set collaRuleIds = waitQueryCrIdMap.computeIfAbsent(collaRuleClass, item -> new HashSet(16));
            if (collaRuleV != null) {
                collaRuleIds.add(collaRuleV.getLong("id"));
            }
            taskCenterEnts.add((Object)newEntryDy);
        }
        if (empty) {
            this.queryAndSetPayRollActv(taskCenterEnts, waitQueryCrIdMap);
        }
        taskCenter.set("taskexecutenum", (Object)0);
    }

    private void queryAndSetPayRollActv(DynamicObjectCollection taskCenterEnts, Map<String, Set<Long>> waitQueryActgIds) {
        Table<String, Long, DynamicObject> crTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(waitQueryActgIds);
        if (crTable.isEmpty()) {
            return;
        }
        for (DynamicObject taskCenterEnt : taskCenterEnts) {
            long collaRuleId = taskCenterEnt.getLong("collarule.id");
            String crClass = taskCenterEnt.getString("collaruleclass");
            if (SWCStringUtils.isEmpty((String)crClass) || collaRuleId == 0L) continue;
            taskCenterEnt.set("collarulev", crTable.get((Object)crClass, (Object)collaRuleId));
        }
    }

    public List<DynamicObject> splitTaskByApp(DynamicObject currentTaskObject, Set<String> appNumberSet, Set<String> blackAppNumberSet) {
        if (currentTaskObject == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection entryEntity = currentTaskObject.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return Collections.emptyList();
        }
        HashMap<String, Set<Long>> param = new HashMap<String, Set<Long>>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            String crClass = dynamicObject.getString("collaruleclass");
            long crId = dynamicObject.getLong("collarule.id");
            if (SWCStringUtils.isEmpty((String)crClass) || crId == 0L) continue;
            Set tempIds = param.computeIfAbsent(crClass, item -> new HashSet(16));
            tempIds.add(crId);
        }
        Table<String, Long, DynamicObject> crObjectTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(param);
        HashMap<String, DynamicObject> taskMap = new HashMap<String, DynamicObject>(16);
        String ctClass = currentTaskObject.getDynamicObjectType().getName();
        SWCDataServiceHelper ctHelper = new SWCDataServiceHelper(ctClass);
        for (DynamicObject entry : entryEntity) {
            long crId;
            String crClass = entry.getString("collaruleclass");
            DynamicObject cr = (DynamicObject)crObjectTable.get((Object)crClass, (Object)(crId = entry.getLong("collarule.id")));
            if (cr == null) continue;
            String bizAppNumber = cr.getString("payrollactgtpl.bizapp.number");
            if (!CollectionUtils.isEmpty(appNumberSet) && !appNumberSet.contains(bizAppNumber) || blackAppNumberSet.contains(bizAppNumber)) continue;
            DynamicObject bizApp = cr.getDynamicObject("payrollactgtpl.bizapp");
            int arrangeSeq = entry.getInt("seq");
            taskMap.compute(bizAppNumber, (key, oldValue) -> {
                if (oldValue == null) {
                    DynamicObject newObject = ctHelper.generateEmptyDynamicObject(ctClass);
                    HRDynamicObjectUtils.copy((DynamicObject)currentTaskObject, (DynamicObject)newObject);
                    newObject.set("arrangeseq", (Object)arrangeSeq);
                    this.setBizApp(newObject, bizApp);
                    DynamicObjectCollection tempEntryEntity = newObject.getDynamicObjectCollection("entryentity");
                    tempEntryEntity.clear();
                    tempEntryEntity.add((Object)entry);
                    return newObject;
                }
                DynamicObjectCollection tempEntryEntity = oldValue.getDynamicObjectCollection("entryentity");
                tempEntryEntity.add((Object)entry);
                return oldValue;
            });
        }
        if (CollectionUtils.isEmpty(taskMap)) {
            return Collections.emptyList();
        }
        return new ArrayList<DynamicObject>(taskMap.values());
    }

    private void setBizApp(DynamicObject object, DynamicObject bizApp) {
        DynamicObjectCollection collaApp = object.getDynamicObjectCollection("collaapp");
        DynamicObjectType dynamicObjectType = collaApp.getDynamicObjectType();
        DynamicObject subObject = new DynamicObject(dynamicObjectType);
        subObject.set("fbasedataid", (Object)bizApp);
        collaApp.add((Object)subObject);
        object.set("name", (Object)ResManager.loadKDString((String)"{0}\u4efb\u52a1\uff08{1}\uff09", (String)"CommonCollaTaskServiceImpl_1", (String)"swc-hpdi-business", (Object[])new Object[]{object.getString("orgmsgrecvcenter.name"), bizApp.getString("name")}));
    }
}

