/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.task;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.util.CollectionUtils;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;

public class BizDataBillOrgUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(BizDataBillOrgUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("BizDataBillOrgUpdateTask begin...");
        this.saveBizDataBillOrg();
        LOGGER.info("BizDataBillOrgUpdateTask end...");
    }

    private void saveBizDataBillOrg() {
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        QFilter filter = QFilter.isNull((String)"org");
        filter.or(new QFilter("org", "=", (Object)0));
        int batchSize = 990;
        Long businessObjectId = 1010L;
        Long businessTypeId = 107010L;
        Long defaultOrgId = this.getRootOrgId();
        HashMap orgMap = new HashMap(16);
        while (true) {
            Object[] bizDataBillArr;
            if (SWCArrayUtils.isEmpty((Object[])(bizDataBillArr = helper.query("id, org, adminorg.id", new QFilter[]{filter}, null, batchSize)))) break;
            Set adminOrgIds = Arrays.stream(bizDataBillArr).filter(bill -> !orgMap.containsKey(bill.getLong("adminorg.id"))).map(bill -> bill.getLong("adminorg.id")).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(adminOrgIds)) {
                Object adminOrgId2;
                HashMap orgId2BusinessType = Maps.newHashMapWithExpectedSize((int)adminOrgIds.size());
                HashSet businessTypeSet = Sets.newHashSetWithExpectedSize((int)1);
                businessTypeSet.add(businessTypeId);
                for (Object adminOrgId2 : adminOrgIds) {
                    orgId2BusinessType.put(adminOrgId2, businessTypeSet);
                }
                List<Map<String, Long>> buResult = HPDIServiceUtils.getHrBuByBusinessType(orgId2BusinessType, businessObjectId);
                adminOrgId2 = buResult.iterator();
                while (adminOrgId2.hasNext()) {
                    Map bu = (Map)adminOrgId2.next();
                    orgMap.put(bu.get("adminOrgId"), bu.get("hrBuId"));
                }
            }
            for (Object bizDataBill : bizDataBillArr) {
                bizDataBill.set("org", (Object)orgMap.getOrDefault(bizDataBill.getLong("adminorg.id"), defaultOrgId));
            }
            helper.update((DynamicObject[])bizDataBillArr);
        }
        LOGGER.info("-----------ALL BIZDATABILL UPGRADE SUCCESS-----------");
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        service.disableSchedule("3822+MSBECH/");
    }

    private long getRootOrgId() {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        Map map = orgService.getRootOrgId(Collections.singletonList(29L));
        return (Long)map.get(29L);
    }
}

