/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;

public class BizDataDepempUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(BizDataDepempUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("BizDataDepempUpdateTask begin...");
        this.saveBizDataDepemp();
        this.saveBizDataRecordDepemp();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        service.disableSchedule("3=XJH20LKJ46");
        LOGGER.info("BizDataDepempUpdateTask end...");
    }

    private void saveBizDataDepemp() {
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        this.updateDepemp(helper);
    }

    private void saveBizDataRecordDepemp() {
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER;
        this.updateDepemp(helper);
    }

    private void updateDepemp(SWCDataServiceHelper helper) {
        QFilter filter = this.getDepempFilter();
        filter.and(QFilter.isNotNull((String)"empposorgrel.depemp.id"));
        filter.and("empposorgrel.depemp.id", "!=", (Object)0);
        int batch = 500;
        while (true) {
            Object[] bizDataArr = helper.query("empposorgrel.depemp.id, depemp.id", new QFilter[]{filter}, null, batch);
            LOGGER.info("-------------- bizDataArr size: {}", (Object)bizDataArr.length);
            if (SWCArrayUtils.isEmpty((Object[])bizDataArr)) break;
            for (Object bizData : bizDataArr) {
                Long depempId = bizData.getLong("empposorgrel.depemp.id");
                if (null == depempId || 0L == depempId) {
                    depempId = -1L;
                }
                bizData.set("depemp", (Object)depempId);
            }
            helper.update((DynamicObject[])bizDataArr);
        }
        LOGGER.info("------------------- Table {} upgrade finished -------------------", (Object)helper.getEntityName());
    }

    private QFilter getDepempFilter() {
        QFilter filter = new QFilter("depemp", "=", (Object)0);
        filter.or(QFilter.isNull((String)"depemp"));
        return filter;
    }
}

