/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataOperateHisSyncTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BizDataOperateHisSyncTask.class);
    private static final String UPGRADE_NUMBER = "task_operatehis_sync_hsas";
    private static final String ALGO_KEY = "BizDataOperateHisSyncTask.queryBizDataOperateHis";
    private static final String SQL = "select fid ,fbizitemid ,fcurrentbizdatacode ,foperatebizdatacode ,fbeforupdatedate ,fafterupdatedate ,foperatetype ,foperater ,foperatetime from t_hpdi_bizdataoperatehis where foperatetype in ('1','3')";
    private static final String ROLLBACK_SQL = "select fid ,fbizitemid ,fcurrentbizdatacode ,foperatebizdatacode ,fbeforupdatedate ,fafterupdatedate ,foperatetype ,foperater ,foperatetime from t_hpdi_bizdataoperatehis where foperatetype = '2'";
    private static final int BATCH_SIZE = 5000;
    private int queryCount = 0;
    private static Map<String, String> operateTypeMap = new HashMap<String, String>(16);
    private SWCDataServiceHelper upgradeHelper = new SWCDataServiceHelper("hsas_upgraderecord");
    private SWCDataServiceHelper bsledHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        logger.info("... BizDataOperateHisSyncTask start execution!");
        DynamicObject upgradeRecord = this.getUpdateRecord();
        if (!SWCObjectUtils.isEmpty((Object)upgradeRecord) && upgradeRecord.getBoolean("issuccess")) {
            logger.info("BizData had been upgrade! Upgrade number: {}", (Object)UPGRADE_NUMBER);
            this.disableTask();
            return;
        }
        this.syncOperateHis(false);
        this.syncOperateHis(true);
        this.saveUpgradeRecord(upgradeRecord, Boolean.TRUE);
        this.disableTask();
        logger.info("...BizDataOperateHisSyncTask execute finish. Total spen time: {}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void syncOperateHis(boolean isRollback) {
        String querySql = isRollback ? ROLLBACK_SQL : SQL;
        ArrayList<Map<String, Object>> waitDealList = new ArrayList<Map<String, Object>>(5000);
        ArrayList<Long> operateHisIds = new ArrayList<Long>(5000);
        try (DataSet dataSet = this.getDbConnection(querySql);){
            while (dataSet.hasNext()) {
                if (waitDealList.size() < 5000) {
                    Row row = dataSet.next();
                    HashMap<String, Object> rowMap = new HashMap<String, Object>(16);
                    rowMap.put("fbizitemid", row.getLong("fbizitemid"));
                    rowMap.put("fcurrentbizdatacode", row.getString("fcurrentbizdatacode"));
                    rowMap.put("foperatebizdatacode", row.getString("foperatebizdatacode"));
                    rowMap.put("fbeforupdatedate", row.getDate("fbeforupdatedate"));
                    rowMap.put("fafterupdatedate", row.getDate("fafterupdatedate"));
                    rowMap.put("foperatetype", row.getString("foperatetype"));
                    rowMap.put("foperater", row.getLong("foperater"));
                    rowMap.put("foperatetime", row.getDate("foperatetime"));
                    waitDealList.add(rowMap);
                    operateHisIds.add(row.getLong("fid"));
                    continue;
                }
                this.validateAndSave(waitDealList, operateHisIds, isRollback);
                if (this.queryCount < 1000) continue;
                this.queryCount = 0;
                dataSet.close();
                dataSet = this.getDbConnection(querySql);
            }
            this.validateAndSave(waitDealList, operateHisIds, isRollback);
            this.queryCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAndSave(List<Map<String, Object>> waitDealList, List<Long> operateHisIds, boolean isRollback) {
        DynamicObject[] operateHisArr;
        if (CollectionUtils.isEmpty(waitDealList)) {
            return;
        }
        DynamicObject[] currentBizDataArr = this.getBizDataOfAddType(waitDealList);
        Map<String, Long> sfMap = Arrays.stream(currentBizDataArr).collect(Collectors.toMap(dy -> dy.getString("bizdatacode"), dy -> dy.getLong("salaryfile.id"), (k1, k2) -> k1));
        DynamicObject[] bsledRecordArr = this.getBizDataBsledRecord(waitDealList);
        Map<String, List<DynamicObject>> recordMap = Arrays.stream(bsledRecordArr).collect(Collectors.groupingBy(dy -> dy.getString("bizdatacode") + dy.getString("bizitem.id") + dy.getString("optype")));
        ArrayList<DynamicObject> waitSaveBsledRecordList = new ArrayList<DynamicObject>(waitDealList.size());
        ArrayList<DynamicObject> waitUpdateBsledRecordList = new ArrayList<DynamicObject>(waitDealList.size());
        for (Map<String, Object> row : waitDealList) {
            List<DynamicObject> addTypeDys;
            String operateType;
            row.put("fsalaryfileid", sfMap.get(row.get("fcurrentbizdatacode")));
            boolean isAddType = !SWCStringUtils.equals((String)MapUtils.getString(row, (Object)"fcurrentbizdatacode"), (String)MapUtils.getString(row, (Object)"foperatebizdatacode"));
            String string = operateType = isRollback && !isAddType ? BizDataOperateEnum.OPERATE_ROLLBACK_UPDATE.getCode() : operateTypeMap.get(MapUtils.getString(row, (Object)"foperatetype"));
            String key = MapUtils.getString(row, (Object)"fcurrentbizdatacode") + MapUtils.getLong(row, (Object)"fbizitemid") + operateType;
            if (recordMap.containsKey(key)) continue;
            if (isRollback && isAddType && CollectionUtils.isNotEmpty(addTypeDys = recordMap.get(MapUtils.getString(row, (Object)"fcurrentbizdatacode") + MapUtils.getLong(row, (Object)"fbizitemid") + BizDataOperateEnum.OPERATE_ADD.getCode()))) {
                addTypeDys.forEach(dy -> dy.set("isabandon", (Object)"1"));
                waitUpdateBsledRecordList.addAll(addTypeDys);
            }
            DynamicObject bsledRecord = this.assembleBsledRecord(row, isRollback, isAddType);
            waitSaveBsledRecordList.add(bsledRecord);
        }
        QFilter hisFilter = new QFilter("id", "in", operateHisIds);
        for (DynamicObject his : operateHisArr = HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.query("id, operatetype, currentbizdatacode, operatebizdatacode", new QFilter[]{hisFilter})) {
            if (isRollback) {
                boolean isUpdateType = SWCStringUtils.isEmpty((String)his.getString("operatebizdatacode")) || SWCStringUtils.equals((String)his.getString("currentbizdatacode"), (String)his.getString("operatebizdatacode"));
                String operateType = isUpdateType ? BizDataOperateEnum.OPERATE_ROLLBACK_UPDATE.getCode() : BizDataOperateEnum.OPERATE_ROLLBACK_ADD.getCode();
                his.set("operatetype", (Object)operateType);
                continue;
            }
            his.set("operatetype", (Object)operateTypeMap.get(his.getString("operatetype")));
        }
        try (TXHandle txHandle = TX.requiresNew();){
            if (CollectionUtils.isNotEmpty(waitSaveBsledRecordList)) {
                this.bsledHelper.save(waitSaveBsledRecordList.toArray(new DynamicObject[0]));
            }
            if (isRollback && CollectionUtils.isNotEmpty(waitUpdateBsledRecordList)) {
                this.bsledHelper.update(waitUpdateBsledRecordList.toArray(new DynamicObject[0]));
            }
            txHandle.commit();
            HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.update(operateHisArr);
        }
        waitDealList.clear();
        operateHisIds.clear();
        ++this.queryCount;
    }

    private void saveUpgradeRecord(DynamicObject upgradeRecord, Boolean isSuccess) {
        if (SWCObjectUtils.isEmpty((Object)upgradeRecord)) {
            upgradeRecord = this.upgradeHelper.generateEmptyDynamicObject();
            upgradeRecord.set("number", (Object)UPGRADE_NUMBER);
        }
        upgradeRecord.set("issuccess", (Object)isSuccess);
        upgradeRecord.set("upgradetime", (Object)new Date());
        this.upgradeHelper.saveOne(upgradeRecord);
    }

    private DynamicObject assembleBsledRecord(Map<String, Object> row, boolean isRollback, boolean isAddType) {
        DynamicObject record = this.bsledHelper.generateEmptyDynamicObject();
        record.set("salaryfile", row.get("fsalaryfileid"));
        record.set("bizitem", row.get("fbizitemid"));
        record.set("bizdatacode", row.get("fcurrentbizdatacode"));
        record.set("opbizdatacode", row.get("foperatebizdatacode"));
        record.set("beforebsled", row.get("fbeforupdatedate"));
        record.set("afterbsled", row.get("fafterupdatedate"));
        record.set("optype", (Object)operateTypeMap.get(row.get("foperatetype")));
        record.set("modifier", row.get("foperater"));
        record.set("modifytime", row.get("foperatetime"));
        if (isRollback && isAddType) {
            record.set("isabandon", (Object)"1");
        } else if (isRollback && !isAddType) {
            record.set("optype", (Object)BizDataOperateEnum.OPERATE_UPDATE.getCode());
        }
        return record;
    }

    private DynamicObject getUpdateRecord() {
        QFilter filter = new QFilter("number", "=", (Object)UPGRADE_NUMBER);
        DynamicObject upgradeRecord = this.upgradeHelper.queryOne("id, number, issuccess, upgradetime", new QFilter[]{filter});
        return upgradeRecord;
    }

    private DynamicObject[] getBizDataOfAddType(List<Map<String, Object>> waitDealList) {
        Set bizDataCodes = waitDealList.stream().map(row -> MapUtils.getString((Map)row, (Object)"fcurrentbizdatacode")).collect(Collectors.toSet());
        QFilter filter = new QFilter("bizdatacode", "in", bizDataCodes);
        filter.and("billtype", "=", (Object)"1");
        DynamicObject[] bizDataArr = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("bizdatacode, salaryfile.id", new QFilter[]{filter});
        return bizDataArr;
    }

    private DynamicObject[] getBizDataBsledRecord(List<Map<String, Object>> waitDealList) {
        HashSet<String> bizDataCodes = new HashSet<String>(waitDealList.size());
        HashSet<Long> bizItemIds = new HashSet<Long>(waitDealList.size());
        for (Map<String, Object> row : waitDealList) {
            bizDataCodes.add((String)row.get("fcurrentbizdatacode"));
            bizItemIds.add((Long)row.get("fbizitemid"));
        }
        ArrayList<String> operateTypes = new ArrayList<String>(3);
        operateTypes.add(BizDataOperateEnum.OPERATE_ADD.getCode());
        operateTypes.add(BizDataOperateEnum.OPERATE_ROLLBACK_ADD.getCode());
        operateTypes.add(BizDataOperateEnum.OPERATE_ROLLBACK_UPDATE.getCode());
        operateTypes.add(BizDataOperateEnum.OPERATE_UPDATE.getCode());
        QFilter bsledFilter = new QFilter("bizdatacode", "in", bizDataCodes);
        bsledFilter.and("bizitem", "in", bizItemIds);
        bsledFilter.and("optype", "in", operateTypes);
        DynamicObject[] bsledRecordArr = this.bsledHelper.query("bizdatacode, bizitem.id, optype, isabandon", new QFilter[]{bsledFilter});
        return bsledRecordArr;
    }

    private DataSet getDbConnection(String sql) {
        return DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)"hpdi"), (String)sql);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    static {
        operateTypeMap.put("1", "5");
        operateTypeMap.put("2", "10");
        operateTypeMap.put("3", "20");
    }
}

