/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.task;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;

public class BizDataRollbackStatusTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.changeRelationDataStatusForUpdateType("7");
        this.changeRelationDataStatusForUpdateType("6");
        this.disableTask();
    }

    private void changeRelationDataStatusForUpdateType(String targetStatus) {
        QFilter filter = new QFilter("bizdatastatus", "=", (Object)targetStatus);
        filter.and("billtype", "=", (Object)"1");
        filter.and("bizitem.cycle", "=", (Object)"1");
        Object[] bizDataArrOfAdd = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("bizdatacode", new QFilter[]{filter});
        if (SWCArrayUtils.isEmpty((Object[])bizDataArrOfAdd)) {
            return;
        }
        List bizDataCodes = Arrays.stream(bizDataArrOfAdd).map(dy -> dy.getString("bizdatacode")).collect(Collectors.toList());
        List partitionList = Lists.partition(bizDataCodes, (int)10000);
        for (List subList : partitionList) {
            this.updateBizDataStatus(subList, targetStatus);
        }
    }

    private void updateBizDataStatus(List<String> bizDataCodes, String targetStatus) {
        QFilter filter1 = new QFilter("bizdatacode", "in", bizDataCodes);
        filter1.and("billtype", "=", (Object)"2");
        filter1.and("bizdatastatus", "!=", (Object)targetStatus);
        Object[] bizDataArrOfUpdate = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("bizdatastatus", new QFilter[]{filter1});
        if (SWCArrayUtils.isEmpty((Object[])bizDataArrOfUpdate)) {
            return;
        }
        for (Object bizData : bizDataArrOfUpdate) {
            bizData.set("bizdatastatus", (Object)targetStatus);
        }
        HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.update((DynamicObject[])bizDataArrOfUpdate);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

