/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.task;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.util.HPDITaskUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class BizDataTransSalaryStatusTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BizDataTransSalaryStatusTask.class);
    private static final String UPGRADE_NUMBER = "task_bizdatatranssalarystatusupgrade";
    private static final String SQL = "select fid ,fbizdatacode ,fbizdatastatus ,fapplyno from t_hpdi_bizdata where fid > ? and fsubmission = '1' order by fid asc";
    private static final String ALGO_KEY = "BizDataTransSalaryStatusTask.queryBizDataSQl";
    private static final int BATCH_SIZE = 5000;
    private int queryCount = 0;
    private SWCDataServiceHelper upgradeHelper = new SWCDataServiceHelper("hsas_upgraderecord");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("... BizDataSyncTask start execution!");
        this.upgradeBizDataBillEntStatus();
        HPDITaskUtils.disableTask(this.taskId);
    }

    private void upgradeBizDataBillEntStatus() {
        QFilter filter = new QFilter("number", "=", (Object)UPGRADE_NUMBER);
        DynamicObject upgradeRecord = this.upgradeHelper.queryOne("id, number, issuccess, lastdataid, upgradetime", new QFilter[]{filter});
        if (!SWCObjectUtils.isEmpty((Object)upgradeRecord) && upgradeRecord.getBoolean("issuccess")) {
            logger.info("BizData had been upgrade! Upgrade number: {}", (Object)UPGRADE_NUMBER);
            return;
        }
        Long lastDataId = SWCObjectUtils.isEmpty((Object)upgradeRecord) ? 0L : upgradeRecord.getLong("lastdataid");
        ArrayList<Map<String, Object>> waitDealList = new ArrayList<Map<String, Object>>(5000);
        try (DataSet dataSet = this.getDbConnecton(SQL, lastDataId);){
            while (dataSet.hasNext()) {
                if (waitDealList.size() < 5000) {
                    Row row = dataSet.next();
                    HashMap<String, Object> rowMap = new HashMap<String, Object>(16);
                    rowMap.put("fid", row.getLong("fid"));
                    rowMap.put("fbizdatacode", row.getString("fbizdatacode"));
                    rowMap.put("fbizdatastatus", row.getString("fbizdatastatus"));
                    rowMap.put("fapplyno", row.getString("fapplyno"));
                    waitDealList.add(rowMap);
                    continue;
                }
                lastDataId = MapUtils.getLong((Map)((Map)waitDealList.get(waitDealList.size() - 1)), (Object)"fid");
                this.batchUpdateBizDataBillEnt(waitDealList);
                if (this.queryCount < 1000) continue;
                this.saveUpgradeRecord(upgradeRecord, Boolean.FALSE, lastDataId);
                this.queryCount = 0;
                dataSet.close();
                dataSet = this.getDbConnecton(SQL, lastDataId);
            }
            if (!CollectionUtils.isEmpty(waitDealList)) {
                lastDataId = MapUtils.getLong((Map)((Map)waitDealList.get(waitDealList.size() - 1)), (Object)"fid");
            }
            this.batchUpdateBizDataBillEnt(waitDealList);
            this.queryCount = 0;
            this.saveUpgradeRecord(upgradeRecord, Boolean.TRUE, lastDataId);
        }
    }

    private void batchUpdateBizDataBillEnt(List<Map<String, Object>> waitDealList) {
        if (CollectionUtils.isEmpty(waitDealList)) {
            return;
        }
        HashBasedTable statusTable = HashBasedTable.create();
        for (Map<String, Object> row : waitDealList) {
            String bizDataCode = MapUtils.getString(row, (Object)"fbizdatacode");
            String billNo = MapUtils.getString(row, (Object)"fapplyno");
            if (SWCStringUtils.isEmpty((String)bizDataCode) || SWCStringUtils.isEmpty((String)billNo)) continue;
            statusTable.put((Object)bizDataCode, (Object)billNo, (Object)MapUtils.getString(row, (Object)"fbizdatastatus"));
        }
        BizDataBillEntryHelper.updateTransSalaryStatus((Table<String, String, String>)statusTable);
        waitDealList.clear();
        ++this.queryCount;
    }

    private void saveUpgradeRecord(DynamicObject upgradeRecord, Boolean isSuccess, Long lastDataId) {
        logger.info("... saveUpgradeRecord.lastDataId is: {}", (Object)lastDataId);
        if (SWCObjectUtils.isEmpty((Object)upgradeRecord)) {
            upgradeRecord = this.upgradeHelper.generateEmptyDynamicObject();
            upgradeRecord.set("number", (Object)UPGRADE_NUMBER);
        }
        upgradeRecord.set("issuccess", (Object)isSuccess);
        upgradeRecord.set("lastdataid", (Object)lastDataId);
        upgradeRecord.set("upgradetime", (Object)new Date());
        this.upgradeHelper.saveOne(upgradeRecord);
    }

    private DataSet getDbConnecton(String sql, Long lastDataId) {
        DataSet dataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)"hpdi"), (String)sql, (Object[])new Object[]{lastDataId});
        return dataSet;
    }
}

