/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class CollaTaskArrangeUpdateTask
extends AbstractTask {
    private static final String HPDI_COLLARULESAL = "hpdi_collarulesal";
    private static final Long BIZ_TYPE = 107010L;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.doUpgrade();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    private void doUpgrade() {
        String querySql = "SELECT FENTRYID,FPAYROLLACTGID FROM T_HPDI_TASKRULEENT WHERE (FCOLLARULEID = ? OR FCOLLARULEID IS NULL) AND FPAYROLLACTGID != ?";
        ArrayList taskRuleMaps = new ArrayList(100);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryTaskRuleEntForUpgrade", (DBRoute)new DBRoute("hpdi"), (String)querySql, (Object[])new Object[]{0L, 0L});){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Map taskRuleMap = new HashMap<String, Long>(2);
                taskRuleMap.put("FENTRYID", row.getLong("FENTRYID"));
                taskRuleMap.put("FPAYROLLACTGID", row.getLong("FPAYROLLACTGID"));
                taskRuleMaps.add(taskRuleMap);
            }
        }
        if (taskRuleMaps.isEmpty()) {
            return;
        }
        String updateSql = "UPDATE T_HPDI_TASKRULEENT SET FBIZTYPEID = ?,FCOLLARULETYPE = ? ,FCOLLARULEID = ? WHERE FENTRYID = ? ";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        for (Map taskRuleMap : taskRuleMaps) {
            Object[] param = new Object[]{BIZ_TYPE, HPDI_COLLARULESAL, taskRuleMap.get("FPAYROLLACTGID"), taskRuleMap.get("FENTRYID")};
            params.add(param);
        }
        SWCDbUtil.executeBatch((DBRoute)new DBRoute("hpdi"), (String)updateSql, params);
    }
}

