/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.task;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.util.StringUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;

public class TaskRuleExecTaskHelper {
    private static Log LOGGER = LogFactory.getLog(TaskRuleExecTaskHelper.class);
    private static String KEY_TASKRULE = "taskRuleId";
    public static String TASK_RULE_NEW_KEY = "swcBizTaskRuleId";
    private static String OP_EXECUTETASK = "executetask";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("TaskRuleExecTask execute begin...");
        Long taskRuleId = Long.parseLong(String.valueOf(map.get(TASK_RULE_NEW_KEY)));
        String entityCode = "hpdi_taskcenter";
        if (!"hpdi_taskrule".equals(map.get("useEntityCode"))) {
            entityCode = "hpdi_collatask";
            LOGGER.info("useEntityCode = {}...", map.get("useEntityCode"));
        }
        SWCDataServiceHelper registerHelper = new SWCDataServiceHelper(entityCode);
        QFilter filter = new QFilter("taskrule", "=", (Object)taskRuleId);
        filter.and("taskexecutestatus", "=", (Object)"B");
        filter.and("enable", "=", (Object)"1");
        String field = SWCHisBaseDataHelper.getSelectProperties((String)entityCode);
        Object[] dys = registerHelper.query(field, new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])dys)) {
            LOGGER.info("taskCenter has no valid data for taskRule = {}...", (Object)taskRuleId);
            return;
        }
        StringBuffer errorMsg = new StringBuffer();
        for (Object dy : dys) {
            this.executeOp(OP_EXECUTETASK, (DynamicObject)dy, errorMsg);
        }
        LOGGER.info("TaskRuleExecTask execute end.........taskRuleId = {}", (Object)taskRuleId);
        if (errorMsg.length() != 0) {
            throw new RuntimeException(errorMsg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOp(String opName, DynamicObject dy, StringBuffer errorMsg) {
        try (TXHandle txHandle = TX.required();){
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("taskexecmanner", "auto");
            operateOption.setVariableValue("ishasright", "true");
            operateOption.setVariableValue("skipCheckDataPermission", Boolean.toString(true));
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperationResult operationResult = opImpl.localInvokeOperation(opName, new DynamicObject[]{dy}, operateOption);
            this.dealOperationResult(operationResult, errorMsg);
            txHandle.commit();
        }
    }

    private void dealOperationResult(OperationResult operationResult, StringBuffer errorMsg) {
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                errorMsg.append(operateInfo.getMessage());
            }
            String msg = operationResult.getMessage();
            if (CollectionUtils.isEmpty((Collection)operateInfos) && StringUtils.isNotEmpty((String)msg)) {
                errorMsg.append(msg);
            }
        }
    }
}

