/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskRuleVerConfUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(TaskRuleVerConfUpdateTask.class);
    private static final String SCHEDULE_PLAN_ID = "49ZNC8=L/GMW";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("TaskRuleVerConfUpdateTask...");
        this.updateVerConf("hpdi_taskrule");
        this.updateVerConf("hpdi_taskarrange");
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        service.disableSchedule(SCHEDULE_PLAN_ID);
    }

    private void updateVerConf(String entityName) {
        DynamicObject[] taskRuleArr;
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        QFilter qFilterManual = new QFilter("entryentity.ismanualverify", "=", (Object)Boolean.TRUE);
        QFilter qFilterVerNum = new QFilter("entryentity.verifynumber", "=", (Object)" ");
        qFilterVerNum.or(new QFilter("entryentity.verifynumber", "is null", null));
        for (DynamicObject taskRule : taskRuleArr = helper.query("createtime, entryentity, entryentity.ismanualverify, entryentity.verifynumber", new QFilter[]{qFilterManual, qFilterVerNum})) {
            DynamicObjectCollection entryEntity = taskRule.getDynamicObjectCollection("entryentity");
            String verNumber = "HDD-" + SWCDateTimeUtils.format((Date)taskRule.getDate("createtime"), (String)"yyyyMMddHHmmssSSSS");
            for (DynamicObject dynamicObject : entryEntity) {
                Boolean isManualVerify = dynamicObject.getBoolean("ismanualverify");
                String verifyNumber = dynamicObject.getString("verifynumber");
                if (!isManualVerify.booleanValue() || !SWCStringUtils.isEmpty((String)verifyNumber)) continue;
                dynamicObject.set("verifynumber", (Object)verNumber);
            }
        }
        helper.save(taskRuleArr);
    }
}

