/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.verify.listener;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import kd.swc.hpdi.business.verify.event.ClearTaskIdEvent;
import kd.swc.hpdi.business.verify.event.RuleEngineConvertEvent;
import kd.swc.hpdi.business.verify.event.WriteBackTaskIdEvent;
import kd.swc.hsbp.business.cloudcolla.verify.VerifyBillDataService;
import kd.swc.hsbp.business.cloudcolla.verify.event.IVerifyBillListener;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.AbstractVerifyBillEvent;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillAuditEvent;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillChangeStatusEvent;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillDeleteEvent;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillDiscardEvent;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillSaveEvent;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillSubmitEvent;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillUnAuditEvent;
import kd.swc.hsbp.business.cloudcolla.verify.handler.factory.VerifyBillHandlerFactory;
import kd.swc.hsbp.common.enums.VerifyBillHandlerType;

public abstract class BaseVerifyBillListener
implements IVerifyBillListener {
    abstract String getVerifyApp();

    public void audit(BillAuditEvent event) {
        super.audit(event);
        this.execute((AbstractVerifyBillEvent)event, VerifyBillHandlerType.AUDIT);
    }

    public void delete(BillDeleteEvent event) {
        super.delete(event);
        this.execute((AbstractVerifyBillEvent)event, VerifyBillHandlerType.DELETE);
    }

    public void submit(BillSubmitEvent event) {
        super.submit(event);
        this.execute((AbstractVerifyBillEvent)event, VerifyBillHandlerType.SUBMIT);
    }

    public void save(BillSaveEvent event) {
        super.save(event);
        this.execute((AbstractVerifyBillEvent)event, VerifyBillHandlerType.SAVE);
    }

    public void unAudit(BillUnAuditEvent event) {
        super.unAudit(event);
        this.execute((AbstractVerifyBillEvent)event, VerifyBillHandlerType.UNAUDIT);
    }

    public void discard(BillDiscardEvent event) {
        super.discard(event);
        this.execute((AbstractVerifyBillEvent)event, VerifyBillHandlerType.DISCARD);
    }

    @Subscribe
    public void writeBackTaskId(WriteBackTaskIdEvent event) {
        this.execute(event, VerifyBillHandlerType.WRITE_BACK_TASK_ID);
    }

    @Subscribe
    public void clearTaskId(ClearTaskIdEvent event) {
        this.execute(event, VerifyBillHandlerType.BATCH_CLEAR_TASK_ID);
    }

    @Subscribe
    public void ruleEngineConvert(RuleEngineConvertEvent event) {
        this.execute(event, VerifyBillHandlerType.RULE_ENGINE_CONVERT);
    }

    @Subscribe
    public void changeStatus(BillChangeStatusEvent event) {
        this.execute((AbstractVerifyBillEvent)event, VerifyBillHandlerType.CHANGE_STATUS);
    }

    private void execute(AbstractVerifyBillEvent event, VerifyBillHandlerType type) {
        Map result = VerifyBillDataService.getInstance().accept(VerifyBillHandlerFactory.create((VerifyBillHandlerType)type), this.getVerifyApp(), this.getBillFormId(), event.getSource());
        event.success((IVerifyBillListener)this, result);
    }
}

