/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.verify.listener;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.msgreceive.CollaMsgVerifyBillHelper;
import kd.swc.hpdi.business.verify.listener.BaseVerifyBillListener;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.BillSaveEvent;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class SalaryVerifyBillListener
extends BaseVerifyBillListener {
    @Override
    String getVerifyApp() {
        return "hsas";
    }

    public String getBillFormId() {
        return "hpdi_salaryverbill";
    }

    @Override
    @Subscribe
    public void save(BillSaveEvent event) {
        this.beforeSalaryBillSave(event);
        super.save(event);
    }

    private void beforeSalaryBillSave(BillSaveEvent event) {
        Map source = event.getSource();
        List<DynamicObject> summaryVerifyBills = Arrays.asList((DynamicObject[])source.get("summaryVerifyBill"));
        Map sumVerifyBillMap = summaryVerifyBills.stream().collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (first, second) -> first));
        Map billFieldValues = (Map)source.get("billFieldValues");
        if (CollectionUtils.isEmpty((Map)billFieldValues)) {
            return;
        }
        SWCDataServiceHelper sumOrm = new SWCDataServiceHelper("hpdi_summaryvbill");
        DynamicObject[] dbSumVerifyBills = sumOrm.query("id,depemp.id,depemp.boid,changetime", new QFilter[]{new QFilter("id", "in", billFieldValues.keySet())});
        if (dbSumVerifyBills == null || dbSumVerifyBills.length == 0) {
            return;
        }
        ArrayList<Map<String, Object>> queryParam = new ArrayList<Map<String, Object>>(10);
        List<String> status = Arrays.asList("A", "B", "C");
        HashMap<Long, String> keyMap = new HashMap<Long, String>(16);
        for (DynamicObject dbSumVerifyBill : dbSumVerifyBills) {
            Date endDate = dbSumVerifyBill.getDate("changetime");
            long depEmpId = dbSumVerifyBill.getLong("depemp.boid");
            HashMap<String, Object> tempMap = new HashMap<String, Object>(16);
            tempMap.put("status", status);
            tempMap.put("endDate", endDate);
            tempMap.put("depEmpId", depEmpId);
            queryParam.add(tempMap);
            keyMap.put(dbSumVerifyBill.getLong("id"), depEmpId + "#" + endDate.getTime());
        }
        Map<String, DynamicObject> existSalaryFiles = CollaMsgVerifyBillHelper.getInstance().getExistSalaryFile(queryParam);
        billFieldValues.forEach((sumBillId, data) -> ((Map)data).forEach((subVerifyBillId, subData) -> SalaryVerifyBillListener.processData(sumVerifyBillMap, keyMap, existSalaryFiles, sumBillId, (Map)subData)));
    }

    private static void processData(Map<Long, DynamicObject> sumVerifyBillMap, Map<Long, String> keyMap, Map<String, DynamicObject> existSalaryFiles, Long sumBillId, Map<String, Object> subData) {
        if (!"hsas_salaryfile".equalsIgnoreCase((String)subData.get("objectNumber"))) {
            return;
        }
        List objectValues = (List)subData.get("objectValues");
        SalaryVerifyBillListener.processOrg(sumVerifyBillMap, sumBillId, objectValues);
        SalaryVerifyBillListener.processPayRollGroup(keyMap, existSalaryFiles, sumBillId, objectValues);
    }

    private static void processOrg(Map<Long, DynamicObject> sumVerifyBillMap, Long sumBillId, List<Map<String, Object>> objectValues) {
        Optional<Map> first = objectValues.stream().filter(item -> "org".equalsIgnoreCase((String)item.get("fieldNumber"))).findFirst();
        if (!first.isPresent()) {
            HashMap<String, Object> tempValue = new HashMap<String, Object>(16);
            DynamicObject dynamicObject = sumVerifyBillMap.get(sumBillId);
            Long orgValue = null;
            if (dynamicObject != null) {
                String trClass = dynamicObject.getString("taskarrangeclass");
                Object org = dynamicObject.get("hpdi_taskrule".equalsIgnoreCase(trClass) ? "org" : "morg");
                if (org instanceof DynamicObject) {
                    orgValue = ((DynamicObject)org).getLong("id");
                } else if (org instanceof Long) {
                    orgValue = (Long)org;
                }
            }
            tempValue.put("fieldNumber", "org");
            tempValue.put("fieldValue", orgValue);
            objectValues.add(0, tempValue);
        }
    }

    private static void processPayRollGroup(Map<Long, String> keyMap, Map<String, DynamicObject> existSalaryFiles, Long sumBillId, List<Map<String, Object>> objectValues) {
        String key = keyMap.get(sumBillId);
        DynamicObject existSalaryFile = existSalaryFiles.get(key);
        if (existSalaryFile == null) {
            return;
        }
        DynamicObject payRollGroup = existSalaryFile.getDynamicObject("payrollgroup");
        if (payRollGroup == null) {
            return;
        }
        Optional<Map> firstPayRollGroup = objectValues.stream().filter(item -> "payrollgroup".equalsIgnoreCase((String)item.get("fieldNumber"))).findFirst();
        if (firstPayRollGroup.isPresent()) {
            Map objectMap = firstPayRollGroup.get();
            objectMap.put("fieldValue", payRollGroup);
        }
    }
}

