/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.business.verify.listener;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.verify.event.ClearTaskIdEvent;
import kd.swc.hpdi.business.verify.event.WriteBackTaskIdEvent;
import kd.swc.hsbp.business.cloudcolla.verify.VerifyBillDataService;
import kd.swc.hsbp.business.cloudcolla.verify.event.IVerifyBillListener;
import kd.swc.hsbp.business.cloudcolla.verify.event.object.AbstractVerifyBillEvent;
import kd.swc.hsbp.business.cloudcolla.verify.handler.factory.VerifyBillHandlerFactory;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.VerifyBillHandlerType;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class SummaryVerifyBillListener
implements IVerifyBillListener {
    private String getVerifyApp() {
        return "hpdi";
    }

    public String getBillFormId() {
        return "hpdi_summaryvbill";
    }

    @Subscribe
    public void clearTaskId(ClearTaskIdEvent event) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hpdi_summaryvbill");
        Map source = event.getSource();
        Map object = (Map)MapUtils.getObject((Map)source, (Object)"clearDataMap", Collections.emptyMap());
        DynamicObject[] query = helper.query("id,collataskclass,mulcollatask,multaskcenter", new QFilter[]{new QFilter("id", "in", object.keySet())});
        if (query == null || query.length == 0) {
            return;
        }
        for (DynamicObject tempObject : query) {
            long billId = tempObject.getLong("id");
            Set taskIdSet = (Set)MapUtils.getObject((Map)object, (Object)billId, Collections.emptySet());
            String ctClass = tempObject.getString("collataskclass");
            DynamicObjectCollection tasks = tempObject.getDynamicObjectCollection("hpdi_collatask".equalsIgnoreCase(ctClass) ? "mulcollatask" : "multaskcenter");
            ArrayList<DynamicObject> removeList = new ArrayList<DynamicObject>(10);
            for (DynamicObject task : tasks) {
                if (!taskIdSet.contains(task.getLong("fbasedataid.id"))) continue;
                removeList.add(task);
            }
            if (CollectionUtils.isEmpty(removeList)) continue;
            tasks.removeAll(removeList);
        }
        helper.save(query);
    }

    private void execute(AbstractVerifyBillEvent event, VerifyBillHandlerType type) {
        Map result = VerifyBillDataService.getInstance().accept(VerifyBillHandlerFactory.create((VerifyBillHandlerType)type), this.getVerifyApp(), this.getBillFormId(), event.getSource());
        event.success((IVerifyBillListener)this, result);
    }

    @Subscribe
    public void writeBackTaskId(WriteBackTaskIdEvent event) {
        this.writeBackTaskId(this.getBillFormId(), event.getSource());
    }

    private void writeBackTaskId(String formId, Map<String, Object> data) {
        if (SWCStringUtils.isEmpty((String)formId) || CollectionUtils.isEmpty(data)) {
            return;
        }
        Map idMap = MapUtils.getMap(data, (Object)"idMap", Collections.emptyMap());
        HashSet sumBillIds = new HashSet(idMap.keySet());
        if (CollectionUtils.isEmpty(sumBillIds)) {
            return;
        }
        SWCDataServiceHelper orm = new SWCDataServiceHelper(formId);
        String fieldKey = "hpdi_summaryvbill".equalsIgnoreCase(formId) ? "id" : "relbillid";
        DynamicObject[] query = orm.query("id,relbillid,taskcenter,taskcentern,collatask,collataskclass,verifyapp,multaskcenter,mulcollatask", new QFilter[]{new QFilter(fieldKey, "in", sumBillIds)});
        if (query == null || query.length == 0) {
            return;
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(query.length * 2);
        for (DynamicObject tmp : query) {
            long sumBillId = tmp.getLong(fieldKey);
            List tempList = (List)MapUtils.getObject((Map)idMap, (Object)sumBillId, Collections.emptyList());
            if (CollectionUtils.isEmpty((Collection)tempList)) continue;
            DynamicObjectCollection mulTaskCenter = tmp.getDynamicObjectCollection("multaskcenter");
            Set<String> existMulTaskCenterSet = mulTaskCenter.stream().map(item -> item.getString("fbasedataid")).collect(Collectors.toSet());
            DynamicObjectCollection mulCollaTask = tmp.getDynamicObjectCollection("mulcollatask");
            Set<String> existMulCollaTaskSet = mulCollaTask.stream().map(item -> item.getString("fbasedataid")).collect(Collectors.toSet());
            boolean isAdd = false;
            for (Map temp : tempList) {
                Long collaTaskId = MapUtils.getLongValue((Map)temp, (Object)"collaTaskId", (long)0L);
                String collaTaskClass = MapUtils.getString((Map)temp, (Object)"collaTaskClass");
                if (collaTaskId == 0L || SWCStringUtils.isEmpty((String)collaTaskClass)) continue;
                tmp.set("collataskclass", (Object)collaTaskClass);
                if ("hpdi_taskcenter".equalsIgnoreCase(collaTaskClass)) {
                    this.setMultiObjectValue(mulTaskCenter, collaTaskId, existMulTaskCenterSet);
                } else {
                    this.setMultiObjectValue(mulCollaTask, collaTaskId, existMulCollaTaskSet);
                }
                isAdd = true;
            }
            if (!isAdd) continue;
            saveList.add(tmp);
        }
        orm.save(saveList.toArray(new DynamicObject[0]));
    }

    private void setMultiObjectValue(DynamicObjectCollection multiField, Object dataId, Set<String> existIds) {
        if (!CollectionUtils.isEmpty(existIds) && existIds.contains(String.valueOf(dataId))) {
            return;
        }
        DynamicObject dynamicObject = new DynamicObject(multiField.getDynamicObjectType());
        dynamicObject.set("fbasedataid", dataId);
        multiField.add((Object)dynamicObject);
    }
}

