/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.accumulator;

import java.util.Date;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class AccumulatorAuditValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            this.checkStartDateAndEndDate(dataEntity, data);
            this.checkAccMemItem(dataEntity, data);
        }
    }

    private void checkStartDateAndEndDate(ExtendedDataEntity dataEntity, DynamicObject data) {
        DynamicObjectCollection accMemberEntrys = data.getDynamicObjectCollection("accmemberentry");
        for (int index = 0; index < accMemberEntrys.size(); ++index) {
            DynamicObject entry = (DynamicObject)accMemberEntrys.get(index);
            Date startDate = entry.getDate("accmemstartdate");
            Date endDate = entry.getDate("accmemenddate");
            if (startDate == null) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7d2f\u52a0\u6210\u5458\u201d\u7b2c%s\u884c\uff1a\u201c\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"AccumulatorAuditValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, msg, index + 1));
                continue;
            }
            if (endDate == null || !startDate.after(endDate)) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u9700\u5c0f\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"AccumulatorAuditValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkAccMemItem(ExtendedDataEntity dataEntity, DynamicObject data) {
        DynamicObjectCollection accMemEntrys = data.getDynamicObjectCollection("accmemberentry");
        for (DynamicObject entry : accMemEntrys) {
            String memberType = entry.getString("membertype");
            if (SWCStringUtils.equals((String)"2", (String)memberType)) {
                DynamicObject bizItem = entry.getDynamicObject("bizitem");
                if (!SWCObjectUtils.isEmpty((Object)bizItem)) continue;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7d2f\u52a0\u6210\u5458\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccumulatorAuditValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject salaryItem = entry.getDynamicObject("salaryitem");
            if (!SWCObjectUtils.isEmpty((Object)salaryItem)) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7d2f\u52a0\u6210\u5458\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccumulatorAuditValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }
}

