/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.agencypay;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.agencypay.AgencyPayMService;
import kd.swc.hsas.business.agencypay.bean.CancelPayResult;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AgencyPayUnSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(AgencyPayUnSubmitValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        ArrayList<String> billIds = new ArrayList<String>(dataEntities.length);
        HashMap idEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dyObj = dataEntity.getDataEntity();
            String billStatus = dyObj.getString("auditstatus");
            String errMsg = this.veriStatus(billStatus);
            if (SWCStringUtils.isEmpty((String)errMsg)) {
                String id2 = dyObj.getString("id");
                billIds.add(id2);
                idEntityMap.put(id2, dataEntity);
                continue;
            }
            this.addFatalErrorMessage(dataEntity, errMsg);
        }
        if (billIds.isEmpty()) {
            return;
        }
        CancelPayResult casResult = AgencyPayMService.checkUnSubmitCas(billIds);
        if (casResult != null) {
            logger.info("casResult {}", (Object)casResult);
            List failBills = casResult.getFailBills();
            if (failBills == null) {
                return;
            }
            failBills.forEach(id -> {
                ExtendedDataEntity entity = (ExtendedDataEntity)idEntityMap.get(id);
                if (entity != null) {
                    this.addFatalErrorMessage(entity, this.getCasFailContent());
                }
            });
        }
    }

    private String getCasFailContent() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u5df2\u8fdb\u5165\u51fa\u7eb3\u4ed8\u6b3e\u6d41\u7a0b\uff0c\u65e0\u6cd5\u64a4\u9500\u3002", (String)"AgencyPayUnSubmitValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
    }

    private String veriStatus(String billStatus) {
        String msg = SWCStringUtils.equals((String)billStatus, (String)"B") ? null : (SWCStringUtils.equals((String)billStatus, (String)"A") ? ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u8fd8\u672a\u63d0\u4ea4\u8d22\u52a1\uff0c\u65e0\u6cd5\u64cd\u4f5c\u64a4\u9500\u3002", (String)"AgencyPayUnSubmitValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]) : (SWCStringUtils.equals((String)billStatus, (String)"J") ? ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u5df2\u63d0\u4ea4\u8d22\u52a1\u4ed8\u6b3e\u4e2d\uff0c\u65e0\u6cd5\u64cd\u4f5c\u64a4\u9500\u3002", (String)"AgencyPayUnSubmitValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]) : (SWCStringUtils.equals((String)billStatus, (String)"K") ? ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25\uff1a\u4ee3\u53d1\u5355\u5df2\u63d0\u4ea4\uff0c\u8d22\u52a1\u4ed8\u6b3e\u5df2\u5b8c\u6210\u3002", (String)"AgencyPayUnSubmitValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]) : null)));
        return msg;
    }
}

