/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.approvebill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.business.cal.service.HSASCalListService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;

public class CalApproveDisapproveValidator
extends AbstractValidator {
    public final Log logger = LogFactory.getLog(CalApproveDisapproveValidator.class);
    private Map<Long, ExtendedDataEntity> approveBillMap = new HashMap<Long, ExtendedDataEntity>(16);

    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        ArrayList<Long> pkIdList = new ArrayList<Long>(10);
        ArrayList<Long> calPersonIds = new ArrayList<Long>(10);
        for (ExtendedDataEntity entry : entities) {
            DynamicObject dataEntity = entry.getDataEntity();
            pkIdList.add(dataEntity.getLong("id"));
            this.approveBillMap.put(dataEntity.getLong("id"), entry);
            DynamicObjectCollection calEntryList = dataEntity.getDynamicObjectCollection("calentryentity");
            for (DynamicObject calEntry : calEntryList) {
                calPersonIds.add(calEntry.getLong("calpersonid"));
            }
        }
        List calPersonIdList = calPersonIds.stream().distinct().collect(Collectors.toList());
        this.logger.info("bankOfferExportedIds calPersonIds: {}", (Object)JSON.toJSONString(calPersonIdList));
        HSASCalListService calService = new HSASCalListService();
        Set bankOfferExportedIds = calService.getBankOfferExportedIds(calPersonIdList);
        this.logger.info("bankOfferExportedIds is: {}", (Object)JSON.toJSONString((Object)bankOfferExportedIds));
        this.disapproveValidate(pkIdList, bankOfferExportedIds);
    }

    private void disapproveValidate(List<Long> pkIdList, Set<Long> bankOfferExportedIds) {
        DynamicObject[] approveBillList;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebill");
        block0: for (DynamicObject approveBillDy : approveBillList = ApproveBillService.getApproveBillList(pkIdList, (SWCDataServiceHelper)helper)) {
            String billStatus = approveBillDy.getString("billstatus");
            Long approveBillId = approveBillDy.getLong("id");
            DynamicObjectCollection approveBillEntry = approveBillDy.getDynamicObjectCollection("calentryentity");
            ArrayList calPersonIds = new ArrayList(10);
            approveBillEntry.forEach(approveBillEnt -> calPersonIds.add(approveBillEnt.getLong("calpersonid")));
            DynamicObject[] calPersonArr = ApproveBillService.getCalPersonList(calPersonIds);
            if ("C".equals(billStatus)) {
                for (DynamicObject calPersonDy : calPersonArr) {
                    String errorMsg;
                    String payState = calPersonDy.getString("paystatus");
                    String salaryStatus = calPersonDy.getString("salarystatus");
                    Long calPersonId = calPersonDy.getLong("id");
                    String holdStatus = calPersonDy.getString("onholdstatus");
                    this.logger.info("disapproveValidate payState is: {}, salaryStatus is: {}, calPersonId is: {}, holdStatus is: {}", new Object[]{payState, salaryStatus, calPersonId, holdStatus});
                    if ("0".equals(payState) && !"4".equals(salaryStatus) && !"8".equals(salaryStatus) && !"3".equals(salaryStatus)) continue;
                    if ("2".equals(payState) || "3".equals(payState) || "4".equals(payState) && !String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()).equals(holdStatus) || "4".equals(salaryStatus) || "8".equals(salaryStatus) || "3".equals(salaryStatus)) {
                        errorMsg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u5931\u8d25\uff1a\u5b58\u5728\u53d1\u653e\u72b6\u6001\u548c\u5de5\u8d44\u6761\u72b6\u6001\u4e0d\u6ee1\u8db3\u6761\u4ef6\u7684\u85aa\u8d44\u6570\u636e\u3002\uff08\u53d1\u653e\u72b6\u6001\u4e3a\u201c\u4ed8\u6b3e\u51c6\u5907\u201d\u6216\u201c\u4ed8\u6b3e\u4e2d\u201d\u6216\u201c\u5df2\u4ed8\u6b3e\u201d\uff1b\u5de5\u8d44\u6761\u72b6\u6001\u4e3a\u201c\u56de\u6536\u4e2d\u201d\u6216\u201c\u53d1\u5e03\u4e2d\u201d\u6216\u201c\u5df2\u53d1\u5e03\u201d\uff09\u3002", (String)"CalApproveDisapproveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(this.approveBillMap.get(approveBillId), errorMsg);
                        continue block0;
                    }
                    if (!"2".equals(payState) && !"3".equals(payState) && !"4".equals(payState) && !"4".equals(salaryStatus) && !"8".equals(salaryStatus) && !"3".equals(salaryStatus) || !String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()).equals(holdStatus) || !bankOfferExportedIds.contains(calPersonId)) continue;
                    errorMsg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u5931\u8d25\uff1a\u5ba1\u6279\u5355\u4e2d\u5b58\u5728\u94f6\u884c\u62a5\u76d8\u72b6\u6001\u4e3a\u201c\u5bfc\u51fa\u4e2d\u201d\u3001\u201c\u5df2\u5bfc\u51fa\u201d\u7684\u53d1\u653e\u660e\u7ec6\u3002", (String)"CalApproveDisapproveValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(this.approveBillMap.get(approveBillId), errorMsg);
                    continue block0;
                }
                continue;
            }
            String errorMsg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u5931\u8d25\uff1a\u53ea\u80fd\u5bf9\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u901a\u8fc7\u201d\u7684\u5ba1\u6279\u5355\u64cd\u4f5c\u53cd\u5ba1\u6279\u3002", (String)"CalApproveDisapproveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(this.approveBillMap.get(approveBillId), errorMsg);
        }
    }
}

