/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.bankcardoperating;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class BankCardImportValidator
extends SWCDataBaseValidator {
    private static final String KEY_HRPI_PERBANKCARD = "hrpi_perbankcard";
    private static final String KEY_BANK_CARD_NUM = "bankcardnum";
    private static final String KEY_ACCOUNT_NAME = "accountname";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_ADMIN_ORG_ID = "adminorg.id";
    private static final String KEY_EMP_GROUP_ID = "empgroup.id";
    private static final String KEY_ORG_ID = "org.id";
    private static final String KEY_EMPLOYEE_ID = "employee.id";
    private static final String KEY_IS_DELETE = "isdelete";
    private static final String KEY_SWC_HSAS_OPPLUGIN = "swc-hsas-opplugin";
    private static final String KEY_BANK_CARD_IMPORT_VALIDATOR_0 = "BankCardImportValidator_0";
    private static final String KEY_BANK_CARD_IMPORT_VALIDATOR_1 = "BankCardImportValidator_1";
    private static final String KEY_BANK_CARD_IMPORT_VALIDATOR_2 = "BankCardImportValidator_2";
    private static final String KEY_BANK_CARD_IMPORT_VALIDATOR_3 = "BankCardImportValidator_3";
    private static final String KEY_BANK_CARD_IMPORT_VALIDATOR_4 = "BankCardImportValidator_4";
    private static final String KEY_BANK_CARD_IMPORT_VALIDATOR_5 = "BankCardImportValidator_5";
    private static Log LOGGER = LogFactory.getLog(BankCardImportValidator.class);
    private HasPermOrgResult hasPermOrgResult;
    private Set<Long> importPermissionEmpGroupIdList = new HashSet<Long>();
    private Set<Long> employeeIdSet = new HashSet<Long>(16);
    private Map<Long, Set<ExtendedDataEntity>> employeeEntitySetMap = new HashMap<Long, Set<ExtendedDataEntity>>(16);
    private Map<String, Set<Long>> exBankCardNumEmployeeSetMap = new HashMap<String, Set<Long>>(16);
    private static final String KEY_BANK_CARD_IMPORT_PERM_ID = "2=R54LBNB728";
    private String bankNumOverLengthMsg = ResManager.loadKDString((String)"\u201c\u94f6\u884c\u8d26\u53f7\u201d\u5b57\u6bb5\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\uff0c\u6700\u5927\u957f\u5ea6\u4e3a50\u3002\n", (String)"BankCardImportValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]).replaceAll("\\\\n", "\n");
    private String bankNameOverLengthMsg = ResManager.loadKDString((String)"\u201c\u8d26\u6237\u540d\u201d\u5b57\u6bb5\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\uff0c\u6700\u5927\u957f\u5ea6\u4e3a50\u3002\n", (String)"BankCardImportValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]).replaceAll("\\\\n", "\n");
    private String remarkOverLengthMsg = ResManager.loadKDString((String)"\u201c\u5907\u6ce8\u201d\u5b57\u6bb5\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\uff0c\u6700\u5927\u957f\u5ea6\u4e3a255\u3002\n", (String)"BankCardImportValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]).replaceAll("\\\\n", "\n");
    private String bankNumFormatErrorMsg = ResManager.loadKDString((String)"\u201c\u94f6\u884c\u8d26\u53f7\u201d\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\n", (String)"BankCardImportValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]).replaceAll("\\\\n", "\n");
    private String bankNumExistMsg = ResManager.loadKDString((String)"\u94f6\u884c\u5361\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002\n", (String)"BankCardImportValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]).replaceAll("\\\\n", "\n");
    private String notRelateFileMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5173\u8054\u7684\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7684\u6743\u9650\uff0c\u65e0\u6cd5\u5bfc\u5165\u8be5\u4eba\u5458\u7684\u94f6\u884c\u5361\u3002\n", (String)"BankCardImportValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]).replaceAll("\\\\n", "\n");

    public void initialize() {
        this.hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)KEY_BANK_CARD_IMPORT_PERM_ID);
        Long userId = RequestContext.get().getCurrUserId();
        this.importPermissionEmpGroupIdList = SWCPermissionServiceHelper.getEmpgrpSetByPermItem((Long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)KEY_BANK_CARD_IMPORT_PERM_ID);
    }

    public void validate() {
        this.lengthOutOfLimitValidator();
        this.bankCardNumFormatValidator();
        this.salaryFileValidate();
        this.bankCardRepeatValidate();
    }

    private void lengthOutOfLimitValidator() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            int bankCardNumLength = 0;
            int accountNameLength = 0;
            int descriptionLength = 0;
            if (dataEntity.getString(KEY_BANK_CARD_NUM) != null) {
                bankCardNumLength = dataEntity.getString(KEY_BANK_CARD_NUM).length();
            }
            if (dataEntity.getString(KEY_ACCOUNT_NAME) != null) {
                accountNameLength = dataEntity.getString(KEY_ACCOUNT_NAME).length();
            }
            if (dataEntity.getString(KEY_DESCRIPTION) != null) {
                descriptionLength = dataEntity.getString(KEY_DESCRIPTION).length();
            }
            if (bankCardNumLength > 50) {
                LOGGER.error("Length Out Of Limit Error");
                LOGGER.error("bankCardNumLength:{}", (Object)bankCardNumLength);
                this.addFatalErrorMessage(extendedDataEntity, this.bankNumOverLengthMsg);
            }
            if (accountNameLength > 50) {
                LOGGER.error("Length Out Of Limit Error");
                LOGGER.error("accountNameLength\uff1a{}", (Object)accountNameLength);
                this.addFatalErrorMessage(extendedDataEntity, this.bankNameOverLengthMsg);
            }
            if (descriptionLength <= 255) continue;
            LOGGER.error("Length Out Of Limit Error");
            LOGGER.error("descriptionLength:{}", (Object)descriptionLength);
            this.addFatalErrorMessage(extendedDataEntity, this.remarkOverLengthMsg);
        }
    }

    private void bankCardNumFormatValidator() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long employeeId = dataEntity.getLong(KEY_EMPLOYEE_ID);
            this.employeeIdSet.add(employeeId);
            if (!this.employeeEntitySetMap.containsKey(employeeId)) {
                HashSet<ExtendedDataEntity> extendedDataSet = new HashSet<ExtendedDataEntity>(16);
                extendedDataSet.add(extendedDataEntity);
                this.employeeEntitySetMap.put(employeeId, extendedDataSet);
            } else {
                this.employeeEntitySetMap.get(employeeId).add(extendedDataEntity);
            }
            String bankCardNum = dataEntity.getString(KEY_BANK_CARD_NUM);
            if (SWCStringUtils.isEmpty((String)bankCardNum)) continue;
            String regx = "[0-9]+";
            if (!bankCardNum.matches(regx)) {
                LOGGER.error("Bank Card Num Format Error");
                this.addFatalErrorMessage(extendedDataEntity, this.bankNumFormatErrorMsg);
            }
            Set<Object> employeeSet = null;
            if (!this.exBankCardNumEmployeeSetMap.containsKey(bankCardNum)) {
                employeeSet = new HashSet(16);
                this.exBankCardNumEmployeeSetMap.put(bankCardNum, employeeSet);
            } else {
                employeeSet = this.exBankCardNumEmployeeSetMap.get(bankCardNum);
            }
            if (employeeSet.contains(employeeId)) {
                this.bankCardRepeatMessage(extendedDataEntity);
                continue;
            }
            employeeSet.add(employeeId);
        }
    }

    private void bankCardRepeatMessage(ExtendedDataEntity extendedDataEntity) {
        LOGGER.error("Bank Card Repeat");
        this.addFatalErrorMessage(extendedDataEntity, this.bankNumExistMsg);
    }

    private void salaryFileValidate() {
        DynamicObject[] salaryFileResults;
        Boolean hasAll = this.hasPermOrgResult.hasAllOrgPerm();
        if (hasAll.booleanValue()) {
            return;
        }
        List resultFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)KEY_BANK_CARD_IMPORT_PERM_ID);
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter salaryFileFilter = new QFilter(KEY_EMPLOYEE_ID, "in", this.employeeIdSet);
        for (DynamicObject salaryFileResult : salaryFileResults = salaryFileHelper.query("employee.id,org.id,adminorg.id,empgroup.id", new QFilter[]{salaryFileFilter})) {
            HashSet hasPermOrgSets;
            Long empGroupId = salaryFileResult.getLong(KEY_EMP_GROUP_ID);
            Long orgId = salaryFileResult.getLong(KEY_ORG_ID);
            Long employeeId = salaryFileResult.getLong(KEY_EMPLOYEE_ID);
            Long adminOrgId = salaryFileResult.getLong(KEY_ADMIN_ORG_ID);
            ArrayList hasPermOrgs = this.hasPermOrgResult.getHasPermOrgs();
            if (hasPermOrgs == null) {
                hasPermOrgs = new ArrayList();
            }
            if (!(hasPermOrgSets = new HashSet(hasPermOrgs)).contains(orgId)) {
                LOGGER.error("NOT PermOrg");
                LOGGER.error("orgId :{}", (Object)orgId);
                this.addSalaryFileFatalError(employeeId);
            }
            if (this.importPermissionEmpGroupIdList != null && !this.importPermissionEmpGroupIdList.contains(empGroupId)) {
                LOGGER.error("verifyPermOrgs NOT EmpGroupIdPerm");
                LOGGER.error("verifyPermOrgs empGroupId :{}", (Object)empGroupId);
                LOGGER.error("verifyPermOrgs importPermissionEmpGroupIds :{}", this.importPermissionEmpGroupIdList);
                this.addSalaryFileFatalError(employeeId);
            }
            if (resultFilter != null) continue;
            LOGGER.error("verifyPermOrgs NOT adminOrgPerm");
            LOGGER.error("verifyPermOrgs adminorgId :{}", (Object)adminOrgId);
            LOGGER.error("verifyPermOrgs adminOrgPermIds :{}", (Object)resultFilter);
            this.addSalaryFileFatalError(employeeId);
        }
    }

    private void addSalaryFileFatalError(Long employeeId) {
        Set<ExtendedDataEntity> errorEntities = this.employeeEntitySetMap.get(employeeId);
        for (ExtendedDataEntity errorEntity : errorEntities) {
            this.addFatalErrorMessage(errorEntity, this.notRelateFileMsg);
        }
    }

    private void bankCardRepeatValidate() {
        DynamicObject[] perBankCardResults;
        SWCDataServiceHelper perBankCardHelper = new SWCDataServiceHelper(KEY_HRPI_PERBANKCARD);
        QFilter perBankCardFilter = new QFilter(KEY_IS_DELETE, "=", (Object)"0");
        perBankCardFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        perBankCardFilter.and(new QFilter(KEY_EMPLOYEE_ID, "in", this.employeeIdSet));
        for (DynamicObject perBankCardResult : perBankCardResults = perBankCardHelper.query("bankcardnum,employee.id", new QFilter[]{perBankCardFilter})) {
            String bankCardNum = perBankCardResult.getString(KEY_BANK_CARD_NUM);
            Long employeeId = perBankCardResult.getLong(KEY_EMPLOYEE_ID);
            Set<ExtendedDataEntity> extendedDataEntities = this.employeeEntitySetMap.get(employeeId);
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                String bankCardNumImport = extendedDataEntity.getDataEntity().getString(KEY_BANK_CARD_NUM);
                if (SWCStringUtils.isEmpty((String)bankCardNumImport) || !StringUtils.equals((CharSequence)bankCardNum, (CharSequence)bankCardNumImport)) continue;
                this.bankCardRepeatMessage(extendedDataEntity);
            }
        }
    }
}

