/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.bankoffer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BankOfferFetchConfigDeleteValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        ArrayList<String> idList = new ArrayList<String>(entities.length);
        for (ExtendedDataEntity entity : entities) {
            idList.add(entity.getDataEntity().getString("id"));
        }
        Set<String> usedIds = this.getUsedIds(idList);
        for (ExtendedDataEntity entity : entities) {
            this.checkDataIsUsed(entity, usedIds);
        }
    }

    private void checkDataIsUsed(ExtendedDataEntity entity, Set<String> ids) {
        DynamicObject dataEntity = entity.getDataEntity();
        if (ids.contains(dataEntity.getString("id"))) {
            String errorMsg = ResManager.loadKDString((String)"\u201c\u94f6\u884c\u62a5\u76d8\u6a21\u677f\u201d\u7684\u5b57\u6bb5\u201c\u5b57\u6bb5\u53d6\u503c\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"BankOfferFetchConfigDeleteValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
        }
    }

    private Set<String> getUsedIds(List<String> idList) {
        QFilter filter = new QFilter("detailent.fieldselect", "in", idList);
        HashSet<String> ids = new HashSet<String>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bankOfferUsed", (String)"hsas_bankoffertpl", (String)"detailent.fieldselect", (QFilter[])new QFilter[]{filter}, (String)"");
        dataSet.distinct().forEach(data -> ids.add(data.getString("detailent.fieldselect")));
        return ids;
    }
}

