/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.bankoffer;

import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class BankOfferLogInvalidValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities;
        String userId = RequestContext.get().getUserId();
        for (ExtendedDataEntity entity : entities = this.getDataEntities()) {
            this.checkDataIsInvalid(entity, userId);
        }
    }

    private void checkDataIsInvalid(ExtendedDataEntity entity, String userId) {
        DynamicObject dataEntity = entity.getDataEntity();
        boolean isFailure = dataEntity.getBoolean("isfailure");
        String number = dataEntity.getString("number");
        String creator = dataEntity.getString("creator.id");
        if (!userId.equals(creator)) {
            String errorMsg = ResManager.loadKDString((String)"%s: \u4e0d\u5141\u8bb8\u5bf9\u975e\u672c\u4eba\u64cd\u4f5c\u7684\u62a5\u76d8\u8bb0\u5f55\u8fdb\u884c\u62a5\u76d8\u5931\u6548\u3002", (String)"BankOfferLogInvalidValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = String.format(Locale.ROOT, errorMsg, number);
            this.addErrorMessage(entity, errorMsg);
            return;
        }
        if (isFailure) {
            String errorMsg = ResManager.loadKDString((String)"%s: \u62a5\u76d8\u8bb0\u5f55\u5df2\u5931\u6548\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\u3002", (String)"BankOfferLogInvalidValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = String.format(Locale.ROOT, errorMsg, number);
            this.addErrorMessage(entity, errorMsg);
        }
    }
}

