/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.basedata;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class CalRuleAuditValidator
extends SWCDataBaseValidator {
    public static final Log logger = LogFactory.getLog(CalRuleAuditValidator.class);
    private static final String TOTAL_SALARY = "totalsalary";
    private static final String NET_SALARY = "netsalary";
    public static final String CAL_RULE_ITEM_ENTRY = "calruleitementry";
    public static final String HSAS_OPP_PLUGIN_MODULE = "swc-hsas-opplugin";

    private void setConfirmNoFormulaMsg(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject totalSalaryItem = dataEntity.getDynamicObject(TOTAL_SALARY);
        DynamicObject netSalaryItem = dataEntity.getDynamicObject(NET_SALARY);
        if (totalSalaryItem == null || netSalaryItem == null) {
            return;
        }
        String totalSalaryItemNumber = totalSalaryItem.getString("number");
        String netSalaryItemNumber = netSalaryItem.getString("number");
        DynamicObjectCollection calruleitementry = dataEntity.getDynamicObjectCollection(CAL_RULE_ITEM_ENTRY);
        boolean hasSetupTotalSalary = false;
        boolean hasSetupNetSalary = false;
        for (DynamicObject dynamicObject : calruleitementry) {
            if (totalSalaryItemNumber.equals(dynamicObject.getString("salaryitem.number")) && dynamicObject.getString("formula.number") == null) {
                hasSetupTotalSalary = true;
            }
            if (!netSalaryItemNumber.equals(dynamicObject.getString("salaryitem.number")) || dynamicObject.getString("formula.number") != null) continue;
            hasSetupNetSalary = true;
        }
        if (hasSetupNetSalary && hasSetupTotalSalary) {
            this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u603b\u85aa\u8d44\u9879\u76ee\u201c{0}\u201d\u3001\u51c0\u85aa\u8d44\u9879\u76ee\u201c{1}\u201d\u672a\u8bbe\u7f6e\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u3002", (String)"CalRuleAuditValidator_6", (String)HSAS_OPP_PLUGIN_MODULE, (Object[])new Object[0]), totalSalaryItem.getString("name"), netSalaryItem.getString("name")));
        } else if (hasSetupTotalSalary) {
            this.addFatalErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u603b\u85aa\u8d44\u9879\u76ee\u201c%s\u201d\u672a\u8bbe\u7f6e\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u3002", (String)"CalRuleAuditValidator_3", (String)HSAS_OPP_PLUGIN_MODULE, (Object[])new Object[0]), totalSalaryItem.getString("name")));
        } else if (hasSetupNetSalary) {
            this.addFatalErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u51c0\u85aa\u8d44\u9879\u76ee\uff08%s\uff09\u672a\u8bbe\u7f6e\u8ba1\u7b97\u516c\u5f0f\u3002", (String)"CalRuleAuditValidator_4", (String)HSAS_OPP_PLUGIN_MODULE, (Object[])new Object[0]), netSalaryItem.getString("name")));
        }
    }

    public void validate() {
        super.validate();
        if ("save".equals(this.getOperateKey()) || "submit".equals(this.getOperateKey()) || "audit".equals(this.getOperateKey()) || "confirmchange".equals(this.getOperateKey())) {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                DynamicObjectCollection entryentityColl = (DynamicObjectCollection)dynamicObject.get(CAL_RULE_ITEM_ENTRY);
                if (CollectionUtils.isEmpty((Collection)entryentityColl)) continue;
                this.checkEntryData(dataEntity, entryentityColl, dynamicObject);
                this.setConfirmNoFormulaMsg(dataEntity);
            }
        }
    }

    private void checkEntryData(ExtendedDataEntity dataEntity, DynamicObjectCollection entryentityColl, DynamicObject calRuleObj) {
        String areaType;
        int index = 0;
        boolean haveNoItemForPreTax = false;
        boolean haveNoItemForAfterTax = false;
        boolean havaSourceItem = false;
        boolean havaResultItem = false;
        String openTaxCal = calRuleObj.getString("opentaxcal");
        for (DynamicObject entry : entryentityColl) {
            String dataSource;
            String errorMsg;
            ++index;
            String datatypeNumber = entry.getString("salaryitem.datatype.number");
            boolean ispayoutitem = entry.getBoolean("ispayoutitem");
            if (!"1".equals(entry.getString("datasource")) && "2".equals(entry.getString("isconvert"))) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u53ea\u6709\u6570\u636e\u6765\u6e90\u4e3a\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u5206\u6bb5\u6298\u7b97\u7b56\u7565\u624d\u80fd\u8bbe\u7f6e\u4e3a\u542f\u7528\u6298\u7b97\u89c4\u5219\u3002", (String)"CalRuleAuditValidator_2", (String)HSAS_OPP_PLUGIN_MODULE, (Object[])new Object[]{index});
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (SWCStringUtils.equals((String)entry.getString("isconvert"), (String)"2") && entry.getLong("customprorationrule.id") == 0L) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5206\u6bb5\u6298\u7b97\u7b56\u7565\u8bbe\u7f6e\u4e3a\u542f\u7528\u6298\u7b97\u89c4\u5219\uff0c\u5206\u6bb5\u6298\u7b97\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalRuleSaveValidator_5", (String)HSAS_OPP_PLUGIN_MODULE, (Object[])new Object[]{index});
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (SWCStringUtils.equals((String)entry.getString("salaryitem.taxtag"), (String)"1")) {
                havaSourceItem = true;
            } else if (SWCStringUtils.equals((String)entry.getString("salaryitem.taxtag"), (String)"2")) {
                havaResultItem = true;
            } else if (SWCStringUtils.equals((String)entry.getString("salaryitem.calblock"), (String)"0")) {
                haveNoItemForPreTax = true;
            } else {
                haveNoItemForAfterTax = true;
            }
            if (ispayoutitem && !"1020_S".equals(datatypeNumber)) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u53ea\u80fd\u5c06\u6570\u636e\u7c7b\u578b\u4e3a\u91d1\u989d\u7684\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e3a\u5b9e\u53d1\u9879\u76ee\u3002", (String)"CalRuleAuditValidator_5", (String)HSAS_OPP_PLUGIN_MODULE, (Object[])new Object[]{index});
                this.addErrorMessage(dataEntity, errorMsg);
                return;
            }
            Date bsed = dataEntity.getDataEntity().getDate("bsed");
            if (bsed == null) {
                return;
            }
            Date formulaBsed = entry.getDate("formula.firstbsed");
            if (formulaBsed != null && SWCDateTimeUtils.dayBefore((Date)bsed, (Date)formulaBsed)) {
                errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u89c4\u5219\u6a21\u677f\u5185\u5b58\u5728\u5c1a\u672a\u751f\u6548\u7684\u8ba1\u7b97\u516c\u5f0f\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u8ba1\u7b97\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u516c\u5f0f\u6216\u8c03\u6574\u516c\u5f0f\u7684\u6700\u521d\u751f\u6548\u65e5\u671f:\u7b2c{0}\u884c\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8ba1\u7b97\u516c\u5f0f\u3002", (String)"CalRuleSaveValidator_9", (String)HSAS_OPP_PLUGIN_MODULE, (Object[])new Object[]{index});
                this.addErrorMessage(dataEntity, errorMsg);
            }
            if (SWCStringUtils.equals((String)openTaxCal, (String)"0")) {
                String dataSource2 = entry.getString("datasource");
                if (!SWCStringUtils.equals((String)dataSource2, (String)"6")) continue;
                String salaryItemName = entry.getString("salaryitem.name");
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c{1}\uff0c\u4e2a\u7a0e\u8ba1\u7b97\u5f00\u5173\u672a\u5f00\u542f\u6570\u636e\u6765\u6e90\u8bf7\u9009\u62e9\u8ba1\u7b97\u516c\u5f0f/\u7ed3\u679c\u8986\u76d6\u3002", (String)"CalRuleSaveValidator_14", (String)HSAS_OPP_PLUGIN_MODULE, (Object[])new Object[]{index, salaryItemName});
                this.addErrorMessage(dataEntity, errorMsg);
                continue;
            }
            if (!SWCStringUtils.equals((String)openTaxCal, (String)"1")) continue;
            String taxTag = entry.getString("salaryitem.taxtag");
            if (SWCStringUtils.equals((String)taxTag, (String)"2")) {
                entry.set("datasource", (Object)"6");
                entry.set("allowresultcover", (Object)"0");
                continue;
            }
            if (!SWCStringUtils.equals((String)taxTag, (String)"0") && !SWCStringUtils.equals((String)taxTag, (String)"1") || !SWCStringUtils.equals((String)(dataSource = entry.getString("datasource")), (String)"6")) continue;
            errorMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u8ba1\u7b97\u5f00\u5173\u5f00\u542f\u65f6\uff0c\u5f53\u85aa\u916c\u9879\u76ee\u7684\u201c\u4e2a\u7a0e\u6807\u7b7e\u201d\u4e0d\u7b49\u4e8e\u201c\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u201d\u65f6\uff0c\u4e0d\u80fd\u9009\u62e9\u201c\u6570\u636e\u6765\u6e90\u201d\u7b49\u4e8e\u201c\u4e2a\u7a0e\u4e91\u670d\u52a1\u201d\u3002", (String)"CalRuleSaveValidator_15", (String)HSAS_OPP_PLUGIN_MODULE, (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
        }
        if (!(!SWCStringUtils.equals((String)openTaxCal, (String)"1") || !SWCStringUtils.equals((String)(areaType = calRuleObj.getString("areatype")), (String)"2") || havaResultItem && havaSourceItem && haveNoItemForAfterTax && haveNoItemForPreTax)) {
            String msg = ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u4e2d\uff0c\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u7a0e\u524d\u7684\u975e\u4e2a\u7a0e\u9879\u76ee\u3001\u7a0e\u524d\u7684\u4e2a\u7a0e\u6e90\u9879\u76ee\u3001\u7a0e\u540e\u7684\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u3001\u7a0e\u540e\u7684\u975e\u4e2a\u7a0e\u9879\u76ee\u3002", (String)"CalRuleSaveValidator_12", (String)HSAS_OPP_PLUGIN_MODULE, (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

