/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.bizdatatpl;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class BizDataRecordValidator
extends SWCDataBaseValidator {
    private static final String HSAS_BIZDATARECORD_CACHE_KEY = "hsas_bizdatarecord_cache_key";
    public static final Log log = LogFactory.getLog(BizDataRecordValidator.class);

    public void validate() {
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "donothing_reject": {
                this.checkRejectData(dataEntities);
                break;
            }
            case "donothing_updatebsed": {
                this.updateBsedValidator(dataEntities);
                break;
            }
        }
    }

    private void updateBsedValidator(ExtendedDataEntity[] dataEntities) {
        String updateBsed = this.getOption().getVariableValue("updatebsed");
        String errorMsg = null;
        Date formatDate = null;
        try {
            formatDate = SWCDateTimeUtils.parseDate((String)updateBsed);
        }
        catch (ParseException e) {
            log.info(e.toString());
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String identifyNumber = dynamicObject.getString("identifynumber");
            Date bsed = dynamicObject.getDate("bsed");
            if (!SWCObjectUtils.isEmpty((Object)formatDate) && !SWCObjectUtils.isEmpty((Object)bsed) && formatDate.compareTo(bsed) == 0) {
                errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u751f\u6548\u65e5\u671f\u65e0\u53d8\u5316\u3002", (String)"NonRecurBizDataValidator_20", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, MessageFormat.format(errorMsg, identifyNumber), ErrorLevel.FatalError);
            }
            String auditStatus = dynamicObject.getString("auditstatus");
            int usageCount = dynamicObject.getInt("usagecount");
            if (SWCStringUtils.equals((String)"C", (String)auditStatus) && usageCount <= 0) continue;
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u4ec5\u652f\u6301\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u4e14\u4f7f\u7528\u6b21\u6570=0\u7684\u6570\u636e\u66f4\u65b0\u751f\u6548\u65e5\u671f\u3002", (String)"NonRecurBizDataValidator_22", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, MessageFormat.format(errorMsg, identifyNumber), ErrorLevel.FatalError);
        }
    }

    private void checkRejectData(ExtendedDataEntity[] dataEntities) {
        String opReason = this.getOption().getVariableValue("opreason");
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            if (SWCStringUtils.isEmpty((String)opReason)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f02\u5e38\u8bf4\u660e\u3002", (String)"BizDataValidator_35", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                return;
            }
            if (opReason.length() <= 800) continue;
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f02\u5e38\u8bf4\u660e\u4e0d\u80fd\u8d85\u8fc7800\u5b57\u7b26\u3002", (String)"BizDataValidator_36", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

