/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.bizdatatpl;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.utils.GlobalParam;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class BizDataValidator
extends SWCDataBaseValidator {
    private static final String HSAS_BIZDATA_CACHE_KEY = "hsas_bizdata_cache_key";
    public static final Log log = LogFactory.getLog(BizDataValidator.class);

    public void validate() {
        long currentTime = System.currentTimeMillis();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        log.info("BizDataValidator batch size is:{}", (Object)dataEntities.length);
        switch (operateKey) {
            case "unaudit": {
                this.checkUnAuditData(dataEntities);
                break;
            }
            case "donothing_reject": {
                this.checkRejectData(dataEntities);
                break;
            }
            case "save": 
            case "submit": {
                long startTime = System.currentTimeMillis();
                this.permissionValidator(dataEntities);
                this.checkSaveData(dataEntities);
                log.info("BizDataValidator permissionValidator total use time:{}", (Object)(System.currentTimeMillis() - startTime));
                break;
            }
        }
        log.info("BizDataValidator total use time:{}", (Object)(System.currentTimeMillis() - currentTime));
    }

    private void checkSaveData(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String calssification;
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject bizItem = data.getDynamicObject("bizitem");
            if (ObjectUtils.isEmpty((Object)bizItem) || !SWCObjectUtils.equals((Object)"1", (Object)(calssification = bizItem.getString("classification")))) continue;
            String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u7f16\u7801\u201c{0}\u201d\u672a\u627e\u5230\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"BizDataValidator_43", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, bizItem.getString("number"));
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
    }

    private void permissionValidator(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long bizItemId;
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject bizItemObj = data.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemObj)) continue;
            Long useOrgId = data.getLong("salaryfile.org.id");
            Set<Long> bizItemIdSet = (Set<Long>)GlobalParam.get((String)("bizItemIdSet_" + String.valueOf(useOrgId)));
            if (bizItemIdSet == null || bizItemIdSet.size() == 0) {
                log.info("permissionValidator start get bizItemIdSet");
                bizItemIdSet = this.getPermBizItemIdSet(useOrgId);
                GlobalParam.set((String)("bizItemIdSet_" + String.valueOf(useOrgId)), bizItemIdSet);
            }
            if (bizItemIdSet == null || bizItemIdSet.size() == 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0b\uff0c\u8be5\u4e1a\u52a1\u9879\u76ee\u4e0d\u53ef\u4f7f\u7528\u3002", (String)"BizDataValidator_40", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
            }
            if (bizItemIdSet.contains(bizItemId = Long.valueOf(data.getLong("bizitem.id")))) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0b\uff0c\u8be5\u4e1a\u52a1\u9879\u76ee\u4e0d\u53ef\u4f7f\u7528\u3002", (String)"BizDataValidator_40", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        Integer dealNum = (Integer)appCache.get("dealNum", Integer.class);
        log.info("get bizDataClearId dealNum is:{}", (Object)dealNum);
        if (dealNum != null) {
            if (dealNum >= 50000) {
                LocalMemoryCache rootCache = CacheFactory.getCommonCacheFactory().$getLocalMemoryCache(RequestContext.get().getAccountId(), "bd");
                if (rootCache != null) {
                    rootCache.clear();
                    log.info("bizdata end clear bd cache");
                }
                appCache.put("dealNum", (Object)0);
            } else {
                dealNum = dealNum + dataEntities.length;
                appCache.put("dealNum", (Object)dealNum);
            }
        } else {
            appCache.put("dealNum", (Object)dataEntities.length);
        }
    }

    private Set<Long> getPermBizItemIdSet(Long useOrgId) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("status", "=", (Object)"C"));
        QFilter permFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (Long)useOrgId);
        filter.and(permFilter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        DynamicObjectCollection bizItemColl = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (bizItemColl == null || bizItemColl.size() == 0) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> bizItemIdSet = new HashSet<Long>(bizItemColl.size());
        for (DynamicObject bizItemObj : bizItemColl) {
            bizItemIdSet.add(bizItemObj.getLong("id"));
        }
        return bizItemIdSet;
    }

    private void checkRejectData(ExtendedDataEntity[] dataEntities) {
        String opReason = this.getOption().getVariableValue("opreason");
        String pageId = this.getOption().getVariableValue("pageId");
        long userId = RequestContext.get().getCurrUserId();
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        List rejectIdList = (List)appCache.get("rejectIdList_" + pageId, List.class);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            if (SWCStringUtils.isEmpty((String)opReason)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f02\u5e38\u8bf4\u660e\u3002", (String)"BizDataValidator_35", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                return;
            }
            if (opReason.length() > 800) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f02\u5e38\u8bf4\u660e\u4e0d\u80fd\u8d85\u8fc7800\u5b57\u7b26\u3002", (String)"BizDataValidator_36", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            int usagecount = dataEntity.getInt("usagecount");
            if (usagecount != 0) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u4f7f\u7528\uff0c\u9a73\u56de\u5931\u8d25\u3002", (String)"BizDataValidator_41", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                return;
            }
            if (!rejectIdList.contains(dataEntity.getLong("id"))) continue;
            dataEntity.set("auditstatus", (Object)"R");
            dataEntity.set("opreason", (Object)opReason);
            dataEntity.set("modifier", (Object)userId);
            dataEntity.set("modifytime", (Object)new Date());
        }
    }

    private void checkUnAuditData(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String auditstatus;
            DynamicObject data = dataEntity.getDataEntity();
            String personName = data.getString("salaryfile.person.name");
            String bizItemName = data.getString("bizitem.name");
            String dataSources = data.getString("datasources");
            String bizDataCode = data.getString("identifynumber");
            if (SWCStringUtils.equals((String)"2", (String)dataSources) || SWCStringUtils.equals((String)"3", (String)dataSources)) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u4ec5\u53ef\u5bf9\u6570\u636e\u6765\u6e90\u4e3a\u201c\u624b\u5de5\u65b0\u589e\u201d\u4e14\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\u7684\u6570\u636e\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"BizDataValidator_42", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, bizDataCode);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            }
            int usageCount = data.getInt("usagecount");
            int noCountTimes = data.getInt("nocounttimes");
            if (usageCount > 0 || noCountTimes > 0) {
                String errorMsg = ResManager.loadKDString((String)"{0}\u7684{1}\u7684\u4f7f\u7528\u6b21\u6570>=1\uff08\u542b\u975e\u85aa\u8d44\u53d1\u653e\u6d88\u8d39\uff09\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"BizDataValidator_28", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            }
            if (!"E".equals(auditstatus = data.getString("auditstatus"))) continue;
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u4ec5\u53ef\u5bf9\u6570\u636e\u6765\u6e90\u4e3a\u201c\u624b\u5de5\u65b0\u589e\u201d\u4e14\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\u7684\u6570\u636e\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"BizDataValidator_42", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, bizDataCode);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
    }
}

