/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.bizdatatpl;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.common.utils.GlobalParam;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class NonRecurBizDataValidator
extends SWCDataBaseValidator {
    private static final Log log = LogFactory.getLog(NonRecurBizDataValidator.class);

    public void validate() {
        long currentTime = System.currentTimeMillis();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        log.info("NonRecurBizDataValidator batch size is:{}", (Object)dataEntities.length);
        switch (operateKey) {
            case "save": 
            case "submit": {
                long startTime = System.currentTimeMillis();
                this.saveValidator(dataEntities);
                log.info("NonRecurBizDataValidator saveValidator total use time:{}", (Object)(System.currentTimeMillis() - startTime));
                break;
            }
            case "delete": {
                this.deleteValidator(dataEntities);
                break;
            }
            case "donothing_updatebsed": {
                this.updateBsedValidator(dataEntities);
                break;
            }
        }
        log.info("NonRecurBizDataValidator total use time:{}", (Object)(System.currentTimeMillis() - currentTime));
    }

    private void updateBsedValidator(ExtendedDataEntity[] dataEntities) {
        String updateBsed = this.getOption().getVariableValue("updatebsed");
        String errorMsg = null;
        Date formatDate = null;
        try {
            formatDate = SWCDateTimeUtils.parseDate((String)updateBsed);
        }
        catch (ParseException e) {
            log.info(e.toString());
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String identifyNumber = dynamicObject.getString("identifynumber");
            Date bsed = dynamicObject.getDate("bsed");
            if (!SWCObjectUtils.isEmpty((Object)formatDate) && !SWCObjectUtils.isEmpty((Object)bsed) && formatDate.compareTo(bsed) == 0) {
                errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u751f\u6548\u65e5\u671f\u65e0\u53d8\u5316\u3002", (String)"NonRecurBizDataValidator_20", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, MessageFormat.format(errorMsg, identifyNumber), ErrorLevel.FatalError);
            }
            String auditStatus = dynamicObject.getString("auditstatus");
            int usageCount = dynamicObject.getInt("usagecount");
            if (SWCStringUtils.equals((String)"C", (String)auditStatus) && usageCount <= 0) continue;
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u4ec5\u652f\u6301\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u4e14\u4f7f\u7528\u6b21\u6570=0\u7684\u6570\u636e\u66f4\u65b0\u751f\u6548\u65e5\u671f\u3002", (String)"NonRecurBizDataValidator_22", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, MessageFormat.format(errorMsg, identifyNumber), ErrorLevel.FatalError);
        }
    }

    private void saveValidator(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            salaryFileIdSet.add(data.getLong("salaryfile.id"));
        }
        Map variables = this.getOption().getVariables();
        if (!variables.containsKey("isImport")) {
            this.importValidator(salaryFileIdSet);
            return;
        }
        QFilter filter = new QFilter("id", "in", salaryFileIdSet);
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection salaryFiles = this.getSalaryFileObj(new QFilter[]{filter});
        HashMap<Long, DynamicObject> salaryFileMap = new HashMap<Long, DynamicObject>(salaryFiles.size());
        for (DynamicObject salaryFile : salaryFiles) {
            salaryFileMap.put(salaryFile.getLong("id"), salaryFile);
        }
        if (!variables.containsKey("isListOp")) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                String bizItemName;
                String personName;
                DynamicObject data = dataEntity.getDataEntity();
                if (this.checkSalaryFile(dataEntity, data, personName = data.getString("salaryfile.person.name"), bizItemName = data.getString("bizitem.name"), salaryFileMap)) continue;
            }
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String bizItemName;
            String personName;
            DynamicObject data = dataEntity.getDataEntity();
            if (this.checkSavaValue(dataEntity, data, personName = data.getString("salaryfile.person.name"), bizItemName = data.getString("bizitem.name")) && this.checkEffectiveDate(dataEntity, personName, bizItemName) && this.checkSalaryFile(dataEntity, data, personName, bizItemName, salaryFileMap)) continue;
        }
    }

    private boolean checkSalaryFile(ExtendedDataEntity dataEntity, DynamicObject data, String personName, String bizItemName, Map<Long, DynamicObject> salaryFileMap) {
        long salaryFileId = data.getLong("salaryfile.id");
        DynamicObject salaryFileObj = salaryFileMap.get(salaryFileId);
        String errorMsg = "";
        if (SWCObjectUtils.isEmpty((Object)salaryFileObj)) {
            if (SWCStringUtils.isEmpty((String)personName)) {
                return true;
            }
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u85aa\u8d44\u6863\u6848\u9700\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"NonRecurBizDataValidator_01", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkSalaryFileOrg(ExtendedDataEntity dataEntity, DynamicObject data, Set<Long> permOrgSet) {
        Long orgId = data.getLong("salaryfile.org.id");
        String errorMsg = "";
        if (!permOrgSet.contains(orgId)) {
            errorMsg = ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6863\u6848\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5728\u7528\u6237\u6743\u9650\u4e0b\u3002", (String)"NonRecurBizDataValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkSavaValue(ExtendedDataEntity dataEntity, DynamicObject data, String personName, String bizItemName) {
        String value;
        DynamicObject bizItem = data.getDynamicObject("bizitem");
        if (SWCObjectUtils.isEmpty((Object)bizItem)) {
            return true;
        }
        long dataTypeId = bizItem.getLong("datatype.id");
        return !(dataTypeId == 1030L ? !this.checkTextValue(dataEntity, value = data.getString("datavalue"), personName, bizItem) : (dataTypeId == 1010L ? !this.checkMaxValAndMinVal(dataEntity, personName, bizItem, bizItemName, value = data.getBigDecimal("decimalvalue")) : (dataTypeId == 1050L ? !this.checkDateValue(dataEntity, personName, data, bizItem, value = data.getDate("datevalue")) : dataTypeId == 1020L && !this.checkCurrency(dataEntity, personName, data, bizItem, bizItemName))));
    }

    private boolean checkCurrency(ExtendedDataEntity dataEntity, String personName, DynamicObject data, DynamicObject bizItem, String bizItemName) {
        boolean isMatch;
        DynamicObject usedCurrency = data.getDynamicObject("currency");
        if (usedCurrency == null) {
            String errorMsg = ResManager.loadKDString((String)"{0}\u7684{1}\u6570\u636e\u7c7b\u578b\u4e3a\u91d1\u989d\uff0c\u5fc5\u987b\u586b\u5199\u5e01\u79cd.\u8d27\u5e01\u4ee3\u7801\u3002", (String)"NonRecurBizDataValidator_23", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        DynamicObjectCollection currencys = bizItem.getDynamicObjectCollection("currency");
        HashMap<Long, DynamicObject> currencyMap = new HashMap<Long, DynamicObject>(currencys.size());
        for (DynamicObject currency : currencys) {
            currencyMap.put(currency.getDynamicObject("fbasedataid").getLong("id"), currency);
        }
        if (currencys.size() > 0 && !(isMatch = currencyMap.containsKey(usedCurrency.getLong("id")))) {
            String errorMsg = ResManager.loadKDString((String)"{0}\u7684{1}\u5e01\u79cd\u5fc5\u987b\u6839\u636e\u4e1a\u52a1\u9879\u76ee\u4e2d\u53ef\u8f93\u5165\u5e01\u79cd\u8fdb\u884c\u9009\u62e9\u3002", (String)"NonRecurBizDataValidator_24", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkAmountAccuracy(ExtendedDataEntity dataEntity, String personName, DynamicObject data, BigDecimal value) {
        DynamicObject usedCurrency = data.getDynamicObject("currency");
        int amtprecision = usedCurrency.getInt("amtprecision");
        int scale = value.scale();
        if (scale > amtprecision) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u503c\u9700\u5728\u6570\u636e\u7cbe\u5ea6\u8981\u6c42\u201c{1}\u4f4d\u5c0f\u6570\u201d\u5185\u3002", (String)"NonRecurBizDataValidator_04", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, amtprecision);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkMaxValAndMinVal(ExtendedDataEntity dataEntity, String personName, DynamicObject bizItem, String bizItemName, BigDecimal value) {
        boolean checkResult;
        BigDecimal minValue = bizItem.getBigDecimal("minvalue");
        BigDecimal maxValue = bizItem.getBigDecimal("maxvalue");
        Boolean isMinValNull = bizItem.getBoolean("isminvalnull");
        boolean isMaxValNull = bizItem.getBoolean("ismaxvalnull");
        String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u5728\u4e1a\u52a1\u9879\u76ee\u7684\u6700\u5927\u6700\u5c0f\u503c\u8303\u56f4\u5185\u3002", (String)"NonRecurBizDataValidator_05", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        if (isMinValNull.booleanValue() && isMaxValNull) {
            checkResult = true;
        } else if (isMinValNull.booleanValue()) {
            checkResult = maxValue.compareTo(value) >= 0;
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2264\u4e1a\u52a1\u9879\u76ee\u7684\u6700\u5927\u503c\u3002", (String)"NonRecurBizDataValidator_06", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else if (isMaxValNull) {
            checkResult = minValue.compareTo(value) <= 0;
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2265\u4e1a\u52a1\u9879\u76ee\u7684\u6700\u5c0f\u503c\u3002", (String)"NonRecurBizDataValidator_07", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else {
            boolean bl = checkResult = minValue.compareTo(value) <= 0 && maxValue.compareTo(value) >= 0;
        }
        if (!checkResult) {
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkDecimalAccuracy(ExtendedDataEntity dataEntity, String personName, DynamicObject bizItem, String bizItemName, BigDecimal value) {
        int scalelimit = bizItem.getInt("scalelimit");
        int scale = value.scale();
        if (scale > scalelimit) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u503c\u9700\u5728\u6570\u636e\u7cbe\u5ea6\u8981\u6c42\u201c{1}\u4f4d\u5c0f\u6570\u201d\u5185\u3002", (String)"NonRecurBizDataValidator_08", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, scalelimit);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkDateValue(ExtendedDataEntity dataEntity, String personName, DynamicObject data, DynamicObject bizItem, Date value) {
        String bizItemName = bizItem.getString("name");
        Date earliestDate = bizItem.getDate("earliestdate");
        Date lastDate = bizItem.getDate("lastdate");
        boolean checkResult = false;
        String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u5728\u4e1a\u52a1\u9879\u76ee\u7684\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"NonRecurBizDataValidator_09", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        if (earliestDate == null && lastDate == null) {
            checkResult = true;
        } else if (earliestDate == null) {
            checkResult = !lastDate.before(value);
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2264\u6700\u665a\u65e5\u671f\u3002", (String)"NonRecurBizDataValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else if (lastDate == null) {
            checkResult = !earliestDate.after(value);
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2265\u6700\u65e9\u65e5\u671f\u3002", (String)"NonRecurBizDataValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else {
            boolean bl = checkResult = !lastDate.before(value) && !earliestDate.after(value);
        }
        if (!checkResult) {
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkTextValue(ExtendedDataEntity dataEntity, String value, String personName, DynamicObject bizItem) {
        int dataLength = bizItem.getInt("datalength");
        if (value.length() > dataLength) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u4e1a\u52a1\u9879\u76ee\u7684\u6570\u636e\u957f\u5ea6\u3002", (String)"NonRecurBizDataValidator_12", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItem.getString("name"));
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private void importValidator(Set<Long> salaryFileIdSet) {
        List permOrgList;
        List permissionFilterList = (List)GlobalParam.get((String)"permissionFilterList");
        if (permissionFilterList == null || permissionFilterList.size() == 0) {
            log.info("importValidator start query permission");
            permissionFilterList = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47150e89000000ac");
            GlobalParam.set((String)"permissionFilterList", (Object)permissionFilterList);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (permissionFilterList == null) {
            filterList.add(new QFilter("1", "!=", (Object)1));
        } else if (permissionFilterList.size() > 0) {
            filterList.addAll(permissionFilterList);
        }
        filterList.add(new QFilter("id", "in", salaryFileIdSet).and("status", "=", (Object)"C"));
        QFilter[] filters = new QFilter[filterList.size()];
        filters = filterList.toArray(filters);
        DynamicObjectCollection salaryFiles = this.getSalaryFileObj(filters);
        HashSet<Long> validSalaryFileIdSet = new HashSet<Long>(0);
        HashMap<Long, DynamicObject> salaryFileMap = new HashMap<Long, DynamicObject>(salaryFiles.size());
        if (!CollectionUtils.isEmpty((Collection)salaryFiles)) {
            salaryFiles.forEach(salaryFile -> {
                validSalaryFileIdSet.add(salaryFile.getLong("id"));
                salaryFileMap.put(salaryFile.getLong("id"), (DynamicObject)salaryFile);
            });
        }
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_nonrecurbizdata", (String)"47150e89000000ac");
        HashSet<Long> permOrgSet = new HashSet(16);
        if (!hasPermOrgResult.hasAllOrgPerm() && (permOrgList = hasPermOrgResult.getHasPermOrgs()) != null && permOrgList.size() > 0) {
            permOrgSet = permOrgList.stream().collect(Collectors.toSet());
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject bizItem = data.getDynamicObject("bizitem");
            String bizItemName = data.getString("bizitem.name");
            String personName = data.getString("salaryfile.person.name");
            if (this.checkImportPermission(dataEntity, data, validSalaryFileIdSet) && this.checkBizItem(dataEntity, bizItem, personName, bizItemName) && this.checkImportValue(dataEntity, bizItem, personName, bizItemName) && this.checkEffectiveDate(dataEntity, personName, bizItemName) && this.checkSalaryFile(dataEntity, data, personName, bizItemName, salaryFileMap) && !hasPermOrgResult.hasAllOrgPerm() && this.checkSalaryFileOrg(dataEntity, data, permOrgSet)) continue;
        }
    }

    private boolean checkImportPermission(ExtendedDataEntity dataEntity, DynamicObject data, Set<Long> validSalaryFileIdSet) {
        long salaryFileId = data.getLong("salaryfile.id");
        if (!validSalaryFileIdSet.contains(salaryFileId)) {
            String errorMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u662f\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\uff0c\u6216\u60a8\u6ca1\u6709\u6743\u9650\uff0c\u65e0\u6cd5\u5bfc\u5165\u4e1a\u52a1\u6570\u636e\u3002", (String)"NonRecurBizDataValidator_13", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkBizItem(ExtendedDataEntity dataEntity, DynamicObject bizItem, String personName, String bizItemName) {
        String cycle = bizItem.getString("cycle");
        boolean isRecur = true;
        if (SWCStringUtils.isNotEmpty((String)cycle)) {
            boolean bl = isRecur = !cycle.equals("0");
        }
        if (isRecur) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u4e3a\u5faa\u73af\u4e1a\u52a1\u9879\u76ee\uff0c\u8bf7\u5728\u5faa\u73af\u4e1a\u52a1\u6570\u636e\u5217\u8868\u4e2d\u64cd\u4f5c\u5bfc\u5165\u3002", (String)"NonRecurBizDataValidator_14", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkImportValue(ExtendedDataEntity dataEntity, DynamicObject bizItem, String personName, String bizItemName) {
        DynamicObject data = dataEntity.getDataEntity();
        String strValue = data.getString("datavalue");
        if (SWCStringUtils.isEmpty((String)strValue)) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"NonRecurBizDataValidator_15", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        long dataTypeId = bizItem.getLong("datatype.id");
        if (dataTypeId == 1030L) {
            if (!this.checkTextValue(dataEntity, strValue, personName, bizItem)) {
                return false;
            }
        } else if (dataTypeId == 1010L || dataTypeId == 1020L) {
            BigDecimal value = null;
            try {
                value = new BigDecimal(strValue);
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"NonRecurBizDataValidator_16", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
            if (dataTypeId == 1020L) {
                if (!this.checkCurrency(dataEntity, personName, data, bizItem, bizItemName)) {
                    return false;
                }
                if (!this.checkAmountAccuracy(dataEntity, personName, data, value)) {
                    return false;
                }
            } else {
                return false;
            }
            if (!this.checkMaxValAndMinVal(dataEntity, personName, bizItem, bizItemName, value) && !this.checkDecimalAccuracy(dataEntity, personName, bizItem, bizItemName, value)) {
                return false;
            }
        } else if (dataTypeId == 1050L) {
            Date value = null;
            try {
                if (!SWCDateTimeUtils.validDateEffecitive((String)strValue)) {
                    String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"NonRecurBizDataValidator_16", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
                    this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                    return false;
                }
                value = SWCDateTimeUtils.parseDate((String)strValue);
                data.set("datavalue", (Object)SWCDateTimeUtils.format((Date)value, (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"NonRecurBizDataValidator_16", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
            if (!this.checkDateValue(dataEntity, personName, data, bizItem, value)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkEffectiveDate(ExtendedDataEntity dataEntity, String personName, String bizItemName) {
        DynamicObject data = dataEntity.getDataEntity();
        Date bsed = data.getDate("bsed");
        Date bsled = data.getDate("bsled");
        if (bsled != null && bsed.after(bsled)) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u5931\u6548\u65e5\u671f\u9700\u2265\u751f\u6548\u65e5\u671f\u3002", (String)"NonRecurBizDataValidator_17", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private void deleteValidator(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String identifyNumber = dynamicObject.getString("identifynumber");
            int updateTimes = dynamicObject.getInt("updatetimes");
            if (updateTimes <= 0) continue;
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u4e1a\u52a1\u6570\u636e\u5df2\u88ab\u624b\u52a8\u66f4\u65b0\uff0c\u4e0d\u53ef\u5220\u9664\uff0c\u60a8\u53ef\u4ee5\u5ba1\u6838\u540e\u5e9f\u5f03\u8be5\u6570\u636e\u3002", (String)"NonRecurBizDataValidator_18", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, MessageFormat.format(errorMsg, identifyNumber), ErrorLevel.FatalError);
        }
    }

    private DynamicObjectCollection getSalaryFileObj(QFilter[] filters) {
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        return salaryFileHelper.queryOriginalCollection("id, firstbsed, payrollgroup, status", filters);
    }
}

