/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.bizdatatpl;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.common.utils.GlobalParam;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class RecurBizDataValidator
extends SWCDataBaseValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": 
            case "submit": {
                this.saveValidator(dataEntities);
                break;
            }
            case "audit": {
                this.auditValidator(dataEntities);
                break;
            }
        }
    }

    private void auditValidator(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> salaryFileIds = new HashSet<Long>(dataEntities.length);
        HashSet<Long> bizItemIds = new HashSet<Long>(dataEntities.length);
        BizDataHelper helper = new BizDataHelper();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            Long salaryFileId = data.getLong("salaryfile.id");
            Long bizItemId = data.getLong("bizitem.id");
            salaryFileIds.add(salaryFileId);
            bizItemIds.add(bizItemId);
        }
        Table recurBizData = helper.getRecurBizData(salaryFileIds, bizItemIds);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            if (this.checkUpdateBsled(dataEntity, data, (Table<Long, Long, List<DynamicObject>>)recurBizData)) continue;
        }
    }

    private void saveValidator(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(dataEntities.length);
        HashSet<Long> bizItemIdSet = new HashSet<Long>(dataEntities.length);
        BizDataHelper helper = new BizDataHelper();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            salaryFileIdSet.add(data.getLong("salaryfile.id"));
            Long bizItemId = data.getLong("bizitem.id");
            bizItemIdSet.add(bizItemId);
        }
        Table recurBizData = helper.getRecurBizData(salaryFileIdSet, bizItemIdSet);
        Map variables = this.getOption().getVariables();
        if (!variables.containsKey("isImport")) {
            this.importValidator(salaryFileIdSet, (Table<Long, Long, List<DynamicObject>>)recurBizData);
            return;
        }
        QFilter filter = new QFilter("id", "in", salaryFileIdSet);
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection salaryFiles = this.getSalaryFileObj(new QFilter[]{filter});
        HashMap<Long, DynamicObject> salaryFileMap = new HashMap<Long, DynamicObject>(salaryFiles.size());
        for (DynamicObject salaryFile : salaryFiles) {
            salaryFileMap.put(salaryFile.getLong("id"), salaryFile);
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String bizItemName;
            String personName;
            DynamicObject data = dataEntity.getDataEntity();
            if (this.checkSavaValue(dataEntity, data, personName = data.getString("salaryfile.person.name"), bizItemName = data.getString("bizitem.name")) && (!variables.containsKey("checkProp") || this.checkPropSavaValue(dataEntity, data)) && this.checkEffectiveDate(dataEntity, personName, bizItemName) && this.checkSalaryFile(dataEntity, data, personName, bizItemName, salaryFileMap) && this.checkUpdateBsled(dataEntity, data, (Table<Long, Long, List<DynamicObject>>)recurBizData)) continue;
        }
    }

    private boolean checkSalaryFile(ExtendedDataEntity dataEntity, DynamicObject data, String personName, String bizItemName, Map<Long, DynamicObject> salaryFileMap) {
        long salaryFileId = data.getLong("salaryfile.id");
        DynamicObject salaryFileObj = salaryFileMap.get(salaryFileId);
        String errorMsg = "";
        if (SWCObjectUtils.isEmpty((Object)salaryFileObj)) {
            if (SWCStringUtils.isEmpty((String)personName)) {
                return true;
            }
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u85aa\u8d44\u6863\u6848\u9700\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"RecurBizDataValidator_13", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkUpdateBsled(ExtendedDataEntity dataEntity, DynamicObject data, Table<Long, Long, List<DynamicObject>> recurBizData) {
        BizDataHelper bizDataHelper;
        List errorIdentifyNumList;
        String identifyNumber = data.getString("identifynumber");
        Long salaryFileId = data.getLong("salaryfile.id");
        Long bizItemId = data.getLong("bizitem.id");
        Date newBsled = data.getDate("bsled");
        Date newBsed = data.getDate("bsed");
        List dynamicObjects = (List)recurBizData.get((Object)salaryFileId, (Object)bizItemId);
        String errorMsg = null;
        if (dynamicObjects != null && dynamicObjects.size() > 0 && (errorIdentifyNumList = (bizDataHelper = new BizDataHelper()).getUpdateBsledErrorList(newBsed, newBsled, dynamicObjects, identifyNumber)).size() > 0) {
            errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5faa\u73af\u9879\u4e1a\u52a1\u6570\u636e\u751f\u5931\u6548\u65e5\u671f\u4e0e\u8be5\u6863\u6848\u5df2\u6709\u6570\u636e{0}\u91cd\u53e0\u4e14\u4e0d\u652f\u6301\u81ea\u52a8\u5904\u7406\uff08\u4ec5\u652f\u6301\u65b0\u589e\u4e1a\u52a1\u6570\u636e\u751f\u6548\u65e5\u671f\uff1e\u6700\u65b0\u6570\u636e\u751f\u6548\u65e5\u671f\uff0c\u4e14\u5931\u6548\u65e5\u671f\u2265\u6700\u65b0\u6570\u636e\u7684\u5931\u6548\u65e5\u671f\u7684\u6570\u636e\uff09\u3002", (String)"RecurBizDataValidator_14", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, errorIdentifyNumList.toString());
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkSalaryFileOrg(ExtendedDataEntity dataEntity, DynamicObject data, Set<Long> permOrgSet) {
        Long orgId = data.getLong("salaryfile.org.id");
        String errorMsg = "";
        if (!permOrgSet.contains(orgId)) {
            errorMsg = ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6863\u6848\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5728\u7528\u6237\u6743\u9650\u4e0b\u3002", (String)"RecurBizDataValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkSavaValue(ExtendedDataEntity dataEntity, DynamicObject data, String personName, String bizItemName) {
        String value;
        DynamicObject bizItem = data.getDynamicObject("bizitem");
        if (SWCObjectUtils.isEmpty((Object)bizItem)) {
            return true;
        }
        long dataTypeId = bizItem.getLong("datatype.id");
        return !(dataTypeId == 1030L ? !this.checkTextValue(dataEntity, value = data.getString("datavalue"), personName, bizItem) : (dataTypeId == 1010L ? !this.checkMaxValAndMinVal(dataEntity, personName, data, bizItem, bizItemName, value = data.getBigDecimal("decimalvalue")) : (dataTypeId == 1050L ? !this.checkDateValue(dataEntity, personName, data, bizItem, value = data.getDate("datevalue")) : dataTypeId == 1020L && !this.checkCurrency(dataEntity, personName, data, bizItem, bizItemName))));
    }

    private boolean checkImprotPropValue(ExtendedDataEntity dataEntity, DynamicObject data) {
        DynamicObjectCollection entryColl = data.getDynamicObjectCollection("recurbizpropentry");
        if (entryColl == null || entryColl.size() == 0) {
            return true;
        }
        HashSet<Long> bizItemPropSet = new HashSet<Long>(16);
        DynamicObject bizItemObj = data.getDynamicObject("bizitem");
        DynamicObjectCollection bizItemEntryColl = bizItemObj.getDynamicObjectCollection("bizitempropentry");
        if (bizItemEntryColl != null && bizItemEntryColl.size() > 0) {
            for (Iterator bizItemEntryObj : bizItemEntryColl) {
                Long bizItemPropId = bizItemEntryObj.getLong("bizitemprop.id");
                bizItemPropSet.add(bizItemPropId);
            }
        }
        boolean checkStatus = true;
        for (Object entryObj : entryColl) {
            String errorMsg;
            String propDataValue = entryObj.getString("propdatavalue");
            if (SWCStringUtils.isEmpty((String)propDataValue) || SWCStringUtils.isEmpty((String)propDataValue.trim())) {
                String errorMsg2 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u53ca\u5c5e\u6027\u503c\u3002", (String)"RecurBizDataValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg2, ErrorLevel.FatalError);
                checkStatus = false;
                continue;
            }
            propDataValue = propDataValue.trim();
            DynamicObject bizItemPropObj = entryObj.getDynamicObject("bizitemprop");
            if (SWCObjectUtils.isEmpty((Object)bizItemPropObj)) {
                String errorMsg3 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u53ca\u5c5e\u6027\u503c\u3002", (String)"RecurBizDataValidator_8", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg3, ErrorLevel.FatalError);
                checkStatus = false;
                continue;
            }
            Long bizItemProp = bizItemPropObj.getLong("id");
            if (!bizItemPropSet.contains(bizItemProp)) {
                String errorMsg4 = ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u672a\u5173\u8054\u9879\u76ee\u6269\u5c55\u5c5e\u6027\u3002", (String)"RecurBizDataValidator_9", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg4, ErrorLevel.FatalError);
                checkStatus = false;
                continue;
            }
            long dataTypeId = bizItemPropObj.getLong("datatype.id");
            if (dataTypeId == 1030L) {
                if (this.checkPropTextValue(dataEntity, propDataValue, bizItemPropObj)) continue;
                checkStatus = false;
                continue;
            }
            if (dataTypeId == 1010L) {
                try {
                    BigDecimal propDataValueDecimal = new BigDecimal(propDataValue);
                    if (this.checkPropMaxValAndMinVal(dataEntity, bizItemPropObj, propDataValueDecimal, propDataValue)) continue;
                    checkStatus = false;
                }
                catch (Exception e) {
                    checkStatus = false;
                    errorMsg = ResManager.loadKDString((String)"\u9879\u76ee\u5c5e\u6027\u683c\u5f0f\u8981\u6c42\u4e3a\u201c\u6570\u503c\u201d\u683c\u5f0f\uff0c\u5c5e\u6027\u503c\u683c\u5f0f\u4e0d\u7b26\u5408\u683c\u5f0f\u8981\u6c42\u3002", (String)"RecurBizDataValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    errorMsg = MessageFormat.format(errorMsg, bizItemPropObj.getString("name"));
                    this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                }
                continue;
            }
            if (dataTypeId != 1050L) continue;
            try {
                boolean isMatch = SWCDateTimeUtils.validDateEffecitive((String)propDataValue);
                if (!isMatch) {
                    checkStatus = false;
                    errorMsg = ResManager.loadKDString((String)"\u9879\u76ee\u5c5e\u6027\u683c\u5f0f\u8981\u6c42\u4e3a\u201c\u65e5\u671f\u201d\u683c\u5f0f\uff0c\u5c5e\u6027\u503c\u683c\u5f0f\u4e0d\u7b26\u5408\u683c\u5f0f\u8981\u6c42\uff0c\u683c\u5f0f\u8981\u6c42\u793a\u4f8b\uff1a2022-12-31\u3002", (String)"RecurBizDataValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    errorMsg = MessageFormat.format(errorMsg, bizItemPropObj.getString("name"));
                    this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                    continue;
                }
                Date propDateVal = SWCDateTimeUtils.parseDate((String)propDataValue, (String)"yyyy-MM-dd");
                if (this.checkPropDateValue(dataEntity, bizItemPropObj, propDateVal)) continue;
                checkStatus = false;
            }
            catch (ParseException e) {
                checkStatus = false;
                errorMsg = ResManager.loadKDString((String)"\u9879\u76ee\u5c5e\u6027\u683c\u5f0f\u8981\u6c42\u4e3a\u201c\u65e5\u671f\u201d\u683c\u5f0f\uff0c\u5c5e\u6027\u503c\u683c\u5f0f\u4e0d\u7b26\u5408\u683c\u5f0f\u8981\u6c42\uff0c\u683c\u5f0f\u8981\u6c42\u793a\u4f8b\uff1a2022-12-31\u3002", (String)"RecurBizDataValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, bizItemPropObj.getString("name"));
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            }
        }
        HashSet<Long> cacheRecurBizItemPropIdSet = new HashSet<Long>(16);
        for (DynamicObject entryObj : entryColl) {
            Long bizItemProp = entryObj.getLong("bizitemprop.id");
            if (bizItemProp == null || bizItemProp == 0L) continue;
            cacheRecurBizItemPropIdSet.add(bizItemProp);
        }
        if (cacheRecurBizItemPropIdSet.size() > 0 && cacheRecurBizItemPropIdSet.size() != entryColl.size()) {
            String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u91cd\u590d\u3002", (String)"RecurBizDataValidator_12", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return checkStatus;
    }

    private boolean checkPropSavaValue(ExtendedDataEntity dataEntity, DynamicObject data) {
        DynamicObjectCollection entryColl = data.getDynamicObjectCollection("recurbizpropentry");
        if (entryColl == null || entryColl.size() == 0) {
            return true;
        }
        boolean checkStatus = true;
        for (DynamicObject entryObj : entryColl) {
            String errorMsg;
            String propDataValue = entryObj.getString("propdatavalue");
            if (SWCStringUtils.isEmpty((String)propDataValue) || SWCStringUtils.isEmpty((String)propDataValue.trim())) continue;
            propDataValue = propDataValue.trim();
            DynamicObject bizItemPropObj = entryObj.getDynamicObject("bizitemprop");
            long dataTypeId = bizItemPropObj.getLong("datatype.id");
            if (dataTypeId == 1030L) {
                if (this.checkPropTextValue(dataEntity, propDataValue, bizItemPropObj)) continue;
                checkStatus = false;
                continue;
            }
            if (dataTypeId == 1010L) {
                try {
                    BigDecimal propDataValueDecimal = new BigDecimal(propDataValue);
                    if (this.checkPropMaxValAndMinVal(dataEntity, bizItemPropObj, propDataValueDecimal, propDataValue)) continue;
                    checkStatus = false;
                }
                catch (Exception e) {
                    checkStatus = false;
                    errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u201c{0}\u201d\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"RecurBizDataValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    errorMsg = MessageFormat.format(errorMsg, bizItemPropObj.getString("name"));
                    this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                }
                continue;
            }
            if (dataTypeId != 1050L) continue;
            try {
                boolean isMatch = SWCDateTimeUtils.validDateEffecitive((String)propDataValue);
                if (!isMatch) {
                    checkStatus = false;
                    errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u201c{0}\u201d\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"RecurBizDataValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    errorMsg = MessageFormat.format(errorMsg, bizItemPropObj.getString("name"));
                    this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                    continue;
                }
                Date propDateVal = SWCDateTimeUtils.parseDate((String)propDataValue, (String)"yyyy-MM-dd");
                if (this.checkPropDateValue(dataEntity, bizItemPropObj, propDateVal)) continue;
                checkStatus = false;
            }
            catch (ParseException e) {
                checkStatus = false;
                errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u201c{0}\u201d\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"RecurBizDataValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, bizItemPropObj.getString("name"));
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            }
        }
        return checkStatus;
    }

    private boolean checkCurrency(ExtendedDataEntity dataEntity, String personName, DynamicObject data, DynamicObject bizItem, String bizItemName) {
        boolean isMatch;
        DynamicObject usedCurrency = data.getDynamicObject("currency");
        if (usedCurrency == null) {
            String errorMsg = ResManager.loadKDString((String)"{0}\u7684{1}\u6570\u636e\u7c7b\u578b\u4e3a\u91d1\u989d\uff0c\u5fc5\u987b\u586b\u5199\u5e01\u79cd\u3002", (String)"RecurBizDataValidator_20", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        DynamicObjectCollection currencys = bizItem.getDynamicObjectCollection("currency");
        HashMap<Long, DynamicObject> currencyMap = new HashMap<Long, DynamicObject>(currencys.size());
        for (DynamicObject currency : currencys) {
            currencyMap.put(currency.getDynamicObject("fbasedataid").getLong("id"), currency);
        }
        if (currencys.size() > 0 && !(isMatch = currencyMap.containsKey(usedCurrency.getLong("id")))) {
            String errorMsg = ResManager.loadKDString((String)"{0}\u7684{1}\u5e01\u79cd\u5fc5\u987b\u6839\u636e\u4e1a\u52a1\u9879\u76ee\u4e2d\u53ef\u8f93\u5165\u5e01\u79cd\u8fdb\u884c\u9009\u62e9\u3002", (String)"RecurBizDataValidator_21", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkPropMaxValAndMinVal(ExtendedDataEntity dataEntity, DynamicObject bizItemProp, BigDecimal value, String propDataValue) {
        String scaleLimit = bizItemProp.getString("scalelimit");
        String[] dataArray = propDataValue.split("\\.");
        String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u201c{0}\u201d\u7684\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u8d85\u8fc713\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u8d85\u8fc7{1}\u4f4d\u3002", (String)"RecurBizDataValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        errorMsg = MessageFormat.format(errorMsg, bizItemProp.getString("name"), scaleLimit);
        if (dataArray.length == 1) {
            if (dataArray[0].length() > 13) {
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
        } else if (dataArray.length == 2 && (dataArray[0].length() > 13 || dataArray[1].length() > Integer.parseInt(scaleLimit))) {
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        BigDecimal minValue = bizItemProp.getBigDecimal("minvalue");
        BigDecimal maxValue = bizItemProp.getBigDecimal("maxvalue");
        boolean isMinValNull = bizItemProp.getBoolean("isminvalnull");
        boolean isMaxValNull = bizItemProp.getBoolean("ismaxvalnull");
        errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u201c{0}\u201d\u7684\u503c\u9700\u5728\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u7684\u6700\u5927\u6700\u5c0f\u503c\u8303\u56f4\u5185\uff1a{1}\u81f3{2}\u3002", (String)"RecurBizDataValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        if (isMinValNull && !isMaxValNull) {
            boolean checkResult;
            boolean bl = checkResult = maxValue.compareTo(value) >= 0;
            if (!checkResult) {
                errorMsg = MessageFormat.format(errorMsg, bizItemProp.getString("name"), Character.valueOf(' '), maxValue);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
        } else if (isMaxValNull && !isMinValNull) {
            boolean checkResult;
            boolean bl = checkResult = minValue.compareTo(value) <= 0;
            if (!checkResult) {
                errorMsg = MessageFormat.format(errorMsg, bizItemProp.getString("name"), minValue, Character.valueOf(' '));
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
        } else if (!isMinValNull && !isMaxValNull) {
            boolean checkResult;
            boolean bl = checkResult = minValue.compareTo(value) <= 0 && maxValue.compareTo(value) >= 0;
            if (!checkResult) {
                errorMsg = MessageFormat.format(errorMsg, bizItemProp.getString("name"), minValue, maxValue);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
        }
        return true;
    }

    private boolean checkMaxValAndMinVal(ExtendedDataEntity dataEntity, String personName, DynamicObject data, DynamicObject bizItem, String bizItemName, BigDecimal value) {
        boolean checkResult;
        if (value == null || value == BigDecimal.ZERO) {
            String dataStr = data.getString("datavalue");
            try {
                value = new BigDecimal(dataStr);
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"BizDataValidator_01", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
        }
        BigDecimal minValue = bizItem.getBigDecimal("minvalue");
        BigDecimal maxValue = bizItem.getBigDecimal("maxvalue");
        Boolean isMinValNull = bizItem.getBoolean("isminvalnull");
        boolean isMaxValNull = bizItem.getBoolean("ismaxvalnull");
        String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u5728\u4e1a\u52a1\u9879\u76ee\u7684\u6700\u5927\u6700\u5c0f\u503c\u8303\u56f4\u5185\u3002", (String)"BizDataValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        if (isMinValNull.booleanValue() && isMaxValNull) {
            checkResult = true;
        } else if (isMinValNull.booleanValue()) {
            checkResult = maxValue.compareTo(value) >= 0;
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2264\u4e1a\u52a1\u9879\u76ee\u7684\u6700\u5927\u503c\u3002", (String)"BizDataValidator_22", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else if (isMaxValNull) {
            checkResult = minValue.compareTo(value) <= 0;
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2265\u4e1a\u52a1\u9879\u76ee\u7684\u6700\u5c0f\u503c\u3002", (String)"RecurBizDataValidator_16", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else {
            boolean bl = checkResult = minValue.compareTo(value) <= 0 && maxValue.compareTo(value) >= 0;
        }
        if (!checkResult) {
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkDateValue(ExtendedDataEntity dataEntity, String personName, DynamicObject data, DynamicObject bizItem, Date value) {
        String bizItemName = bizItem.getString("name");
        if (value == null) {
            String dataStr = data.getString("datavalue");
            try {
                value = SWCDateTimeUtils.parseDate((String)dataStr);
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"BizDataValidator_01", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
        }
        Date earliestDate = bizItem.getDate("earliestdate");
        Date lastDate = bizItem.getDate("lastdate");
        boolean checkResult = false;
        String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u5728\u4e1a\u52a1\u9879\u76ee\u7684\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"RecurBizDataValidator_17", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        if (earliestDate == null && lastDate == null) {
            checkResult = true;
        } else if (earliestDate == null) {
            checkResult = !lastDate.before(value);
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2264\u6700\u665a\u65e5\u671f\u3002", (String)"BizDataValidator_20", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else if (lastDate == null) {
            checkResult = !earliestDate.after(value);
            errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u9700\u2265\u6700\u65e9\u65e5\u671f\u3002", (String)"BizDataValidator_19", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        } else {
            boolean bl = checkResult = !lastDate.before(value) && !earliestDate.after(value);
        }
        if (!checkResult) {
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkPropDateValue(ExtendedDataEntity dataEntity, DynamicObject bizItemProp, Date value) {
        Date earliestDate = bizItemProp.getDate("earliestdate");
        Date lastDate = bizItemProp.getDate("lastdate");
        boolean checkResult = false;
        String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u201c{0}\u201d\u7684\u503c\u9700\u5728\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u7684\u65e5\u671f\u8303\u56f4\u5185\uff1a{1}\u81f3{2}\u3002", (String)"RecurBizDataValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        if (earliestDate == null && lastDate != null) {
            checkResult = !lastDate.before(value);
            String lastDateStr = HRInteDateTimeUtil.formatDate((String)"hsbs_bizitemprop", (String)"lastdate", (Date)lastDate);
            errorMsg = MessageFormat.format(errorMsg, bizItemProp.getString("name"), Character.valueOf(' '), lastDateStr);
        } else if (lastDate == null && earliestDate != null) {
            checkResult = !earliestDate.after(value);
            String earliestDateStr = HRInteDateTimeUtil.formatDate((String)"hsbs_bizitemprop", (String)"earliestdate", (Date)earliestDate);
            errorMsg = MessageFormat.format(errorMsg, bizItemProp.getString("name"), earliestDateStr, Character.valueOf(' '));
        } else if (lastDate != null && earliestDate != null) {
            checkResult = !lastDate.before(value) && !earliestDate.after(value);
            String earliestDateStr = HRInteDateTimeUtil.formatDate((String)"hsbs_bizitemprop", (String)"earliestdate", (Date)earliestDate);
            String lastDateStr = HRInteDateTimeUtil.formatDate((String)"hsbs_bizitemprop", (String)"lastdate", (Date)lastDate);
            errorMsg = MessageFormat.format(errorMsg, bizItemProp.getString("name"), earliestDateStr, lastDateStr);
        } else {
            checkResult = true;
        }
        if (!checkResult) {
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkTextValue(ExtendedDataEntity dataEntity, String value, String personName, DynamicObject bizItem) {
        int dataLength = bizItem.getInt("datalength");
        if (value.length() > dataLength) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u4e1a\u52a1\u9879\u76ee\u7684\u6570\u636e\u957f\u5ea6\u3002", (String)"BizDataValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItem.getString("name"));
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkPropTextValue(ExtendedDataEntity dataEntity, String value, DynamicObject bizItemProp) {
        int dataLength = bizItemProp.getInt("datalength");
        if (value.length() > dataLength) {
            String errorMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u6587\u672c\u957f\u5ea6\u8bbe\u7f6e\uff1a{0}\u3002", (String)"RecurBizDataValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, dataLength);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private void importValidator(Set<Long> salaryFileIdSet, Table<Long, Long, List<DynamicObject>> recurBizData) {
        List permOrgList;
        List permissionFilterList = (List)GlobalParam.get((String)"permissionFilterList");
        if (permissionFilterList == null || permissionFilterList.size() == 0) {
            permissionFilterList = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47150e89000000ac");
            GlobalParam.set((String)"permissionFilterList", (Object)permissionFilterList);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (permissionFilterList == null) {
            filterList.add(new QFilter("1", "!=", (Object)1));
        } else if (permissionFilterList.size() > 0) {
            filterList.addAll(permissionFilterList);
        }
        filterList.add(new QFilter("id", "in", salaryFileIdSet).and("status", "=", (Object)"C"));
        QFilter[] filters = new QFilter[filterList.size()];
        filters = filterList.toArray(filters);
        DynamicObjectCollection salaryFiles = this.getSalaryFileObj(filters);
        HashSet<Long> validSalaryFileIdSet = new HashSet<Long>(0);
        HashMap<Long, DynamicObject> salaryFileMap = new HashMap<Long, DynamicObject>(salaryFiles.size());
        if (!CollectionUtils.isEmpty((Collection)salaryFiles)) {
            salaryFiles.forEach(salaryFile -> {
                validSalaryFileIdSet.add(salaryFile.getLong("id"));
                salaryFileMap.put(salaryFile.getLong("id"), (DynamicObject)salaryFile);
            });
        }
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_recurbizdata", (String)"47150e89000000ac");
        HashSet<Long> permOrgSet = new HashSet(16);
        if (!hasPermOrgResult.hasAllOrgPerm() && (permOrgList = hasPermOrgResult.getHasPermOrgs()) != null && permOrgList.size() > 0) {
            permOrgSet = permOrgList.stream().collect(Collectors.toSet());
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject bizItem = data.getDynamicObject("bizitem");
            String bizItemName = data.getString("bizitem.name");
            String personName = data.getString("salaryfile.person.name");
            if (this.checkImportPermission(dataEntity, data, validSalaryFileIdSet) && this.checkBizItem(dataEntity, bizItem, personName, bizItemName) && this.checkImportValue(dataEntity, bizItem, personName, bizItemName) && this.checkImprotPropValue(dataEntity, data) && this.checkEffectiveDate(dataEntity, personName, bizItemName) && this.checkSalaryFile(dataEntity, data, personName, bizItemName, salaryFileMap) && this.checkUpdateBsled(dataEntity, data, recurBizData) && !hasPermOrgResult.hasAllOrgPerm() && this.checkSalaryFileOrg(dataEntity, data, permOrgSet)) continue;
        }
    }

    private DynamicObjectCollection getSalaryFileObj(QFilter[] filters) {
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        return salaryFileHelper.queryOriginalCollection("id, firstbsed, payrollgroup, status", filters);
    }

    private boolean checkImportPermission(ExtendedDataEntity dataEntity, DynamicObject data, Set<Long> validSalaryFileIdSet) {
        long salaryFileId = data.getLong("salaryfile.id");
        if (!validSalaryFileIdSet.contains(salaryFileId)) {
            String errorMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u662f\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\uff0c\u6216\u60a8\u6ca1\u6709\u6743\u9650\uff0c\u65e0\u6cd5\u5bfc\u5165\u4e1a\u52a1\u6570\u636e\u3002", (String)"BizDataValidator_34", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkBizItem(ExtendedDataEntity dataEntity, DynamicObject bizItem, String personName, String bizItemName) {
        String cycle = bizItem.getString("cycle");
        boolean isRecur = true;
        if (SWCStringUtils.isNotEmpty((String)cycle)) {
            boolean bl = isRecur = !cycle.equals("0");
        }
        if (!isRecur) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u4e3a\u975e\u5faa\u73af\u4e1a\u52a1\u9879\u76ee\uff0c\u8bf7\u5728\u975e\u5faa\u73af\u4e1a\u52a1\u6570\u636e\u5217\u8868\u4e2d\u64cd\u4f5c\u5bfc\u5165\u3002", (String)"BizDataValidator_30", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkImportValue(ExtendedDataEntity dataEntity, DynamicObject bizItem, String personName, String bizItemName) {
        DynamicObject data = dataEntity.getDataEntity();
        String strValue = data.getString("datavalue");
        if (SWCStringUtils.isEmpty((String)strValue)) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BizDataValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        long dataTypeId = bizItem.getLong("datatype.id");
        if (dataTypeId == 1030L) {
            if (!this.checkTextValue(dataEntity, strValue, personName, bizItem)) {
                return false;
            }
        } else if (dataTypeId == 1010L || dataTypeId == 1020L) {
            BigDecimal value = null;
            try {
                value = new BigDecimal(strValue);
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"BizDataValidator_01", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
            if (dataTypeId == 1020L) {
                if (!this.checkCurrency(dataEntity, personName, data, bizItem, bizItemName)) {
                    return false;
                }
                if (!this.checkAmountAccuracy(dataEntity, personName, data, value)) {
                    return false;
                }
            } else {
                if (!this.checkMaxValAndMinVal(dataEntity, personName, data, bizItem, bizItemName, value)) {
                    return false;
                }
                if (!this.checkDecimalAccuracy(dataEntity, personName, bizItem, bizItemName, value)) {
                    return false;
                }
            }
        } else if (dataTypeId == 1050L) {
            Date value = null;
            try {
                if (!SWCDateTimeUtils.validDateEffecitive((String)strValue)) {
                    String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"BizDataValidator_01", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                    errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
                    this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                    return false;
                }
                value = SWCDateTimeUtils.parseDate((String)strValue);
                data.set("datavalue", (Object)SWCDateTimeUtils.format((Date)value, (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u7684\u503c\u4e0d\u5408\u6cd5\u3002", (String)"BizDataValidator_01", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return false;
            }
            if (!this.checkDateValue(dataEntity, personName, data, bizItem, value)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkDecimalAccuracy(ExtendedDataEntity dataEntity, String personName, DynamicObject bizItem, String bizItemName, BigDecimal value) {
        int scalelimit = bizItem.getInt("scalelimit");
        int scale = value.scale();
        if (scale > scalelimit) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u503c\u9700\u5728\u6570\u636e\u7cbe\u5ea6\u8981\u6c42\u201c{1}\u4f4d\u5c0f\u6570\u201d\u5185\u3002", (String)"RecurBizDataValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, scalelimit);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkAmountAccuracy(ExtendedDataEntity dataEntity, String personName, DynamicObject data, BigDecimal value) {
        DynamicObject usedCurrency = data.getDynamicObject("currency");
        int amtprecision = usedCurrency.getInt("amtprecision");
        int scale = value.scale();
        if (scale > amtprecision) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u503c\u9700\u5728\u6570\u636e\u7cbe\u5ea6\u8981\u6c42\u201c{1}\u4f4d\u5c0f\u6570\u201d\u5185\u3002", (String)"RecurBizDataValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, amtprecision);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private boolean checkEffectiveDate(ExtendedDataEntity dataEntity, String personName, String bizItemName) {
        DynamicObject data = dataEntity.getDataEntity();
        Date bsed = data.getDate("bsed");
        Date bsled = data.getDate("bsled");
        if (bsled != null && bsed.after(bsled)) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u5931\u6548\u65e5\u671f\u9700\u2265\u751f\u6548\u65e5\u671f\u3002", (String)"RecurBizDataValidator_18", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsg, personName, bizItemName);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return false;
        }
        return true;
    }
}

